
package org.hisp.dhis.api.model.v2_35_13;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "assignedUser",
    "attributeOptionCombo",
    "attributeValues",
    "code",
    "comments",
    "completed",
    "completedBy",
    "completedDate",
    "creatableInSearchScope",
    "created",
    "createdAtClient",
    "createdByUserInfo",
    "deleted",
    "displayName",
    "dueDate",
    "eventDataValues",
    "eventDate",
    "externalAccess",
    "favorite",
    "favorites",
    "geometry",
    "href",
    "id",
    "lastUpdated",
    "lastUpdatedAtClient",
    "lastUpdatedBy",
    "lastUpdatedByUserInfo",
    "messageConversations",
    "name",
    "organisationUnit",
    "programInstance",
    "programStage",
    "publicAccess",
    "relationshipItems",
    "status",
    "storedBy",
    "translations",
    "user",
    "userAccesses",
    "userGroupAccesses"
})
@Generated("jsonschema2pojo")
public class ProgramStageInstance implements Serializable
{

    @JsonProperty("access")
    private Access access;
    @JsonProperty("assignedUser")
    private User assignedUser;
    @JsonProperty("attributeOptionCombo")
    private CategoryOptionCombo attributeOptionCombo;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues = null;
    @JsonProperty("code")
    private String code;
    @JsonProperty("comments")
    private List<TrackedEntityComment> comments = null;
    @JsonProperty("completed")
    private Boolean completed;
    @JsonProperty("completedBy")
    private String completedBy;
    @JsonProperty("completedDate")
    private Date completedDate;
    @JsonProperty("creatableInSearchScope")
    private Boolean creatableInSearchScope;
    @JsonProperty("created")
    private Date created;
    @JsonProperty("createdAtClient")
    private Date createdAtClient;
    @JsonProperty("createdByUserInfo")
    private UserInfoSnapshot createdByUserInfo;
    @JsonProperty("deleted")
    private Boolean deleted;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("dueDate")
    private Date dueDate;
    @JsonProperty("eventDataValues")
    private List<EventDataValue> eventDataValues = null;
    @JsonProperty("eventDate")
    private Date eventDate;
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites = null;
    /**
     * Undefined
     * 
     */
    @JsonProperty("geometry")
    private Object geometry;
    @JsonProperty("href")
    private String href;
    @JsonProperty("id")
    private String id;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    @JsonProperty("lastUpdatedAtClient")
    private Date lastUpdatedAtClient;
    @JsonProperty("lastUpdatedBy")
    private User lastUpdatedBy;
    @JsonProperty("lastUpdatedByUserInfo")
    private UserInfoSnapshot lastUpdatedByUserInfo;
    @JsonProperty("messageConversations")
    private List<MessageConversation> messageConversations = null;
    @JsonProperty("name")
    private String name;
    @JsonProperty("organisationUnit")
    private OrganisationUnit organisationUnit;
    @JsonProperty("programInstance")
    private ProgramInstance programInstance;
    @JsonProperty("programStage")
    private ProgramStage programStage;
    @JsonProperty("publicAccess")
    private String publicAccess;
    @JsonProperty("relationshipItems")
    private List<RelationshipItem__2> relationshipItems = null;
    @JsonProperty("status")
    private org.hisp.dhis.api.model.v2_35_13.EventChart.EventStatus status;
    @JsonProperty("storedBy")
    private String storedBy;
    @JsonProperty("translations")
    private List<Translation> translations = null;
    @JsonProperty("user")
    private User user;
    @JsonProperty("userAccesses")
    private List<UserAccess> userAccesses = null;
    @JsonProperty("userGroupAccesses")
    private List<UserGroupAccess> userGroupAccesses = null;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 9173072933715851630L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ProgramStageInstance() {
    }

    /**
     * 
     * @param source
     */
    public ProgramStageInstance(ProgramStageInstance source) {
        super();
        this.access = source.access;
        this.assignedUser = source.assignedUser;
        this.attributeOptionCombo = source.attributeOptionCombo;
        this.attributeValues = source.attributeValues;
        this.code = source.code;
        this.comments = source.comments;
        this.completed = source.completed;
        this.completedBy = source.completedBy;
        this.completedDate = source.completedDate;
        this.creatableInSearchScope = source.creatableInSearchScope;
        this.created = source.created;
        this.createdAtClient = source.createdAtClient;
        this.createdByUserInfo = source.createdByUserInfo;
        this.deleted = source.deleted;
        this.displayName = source.displayName;
        this.dueDate = source.dueDate;
        this.eventDataValues = source.eventDataValues;
        this.eventDate = source.eventDate;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.geometry = source.geometry;
        this.href = source.href;
        this.id = source.id;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedAtClient = source.lastUpdatedAtClient;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.lastUpdatedByUserInfo = source.lastUpdatedByUserInfo;
        this.messageConversations = source.messageConversations;
        this.name = source.name;
        this.organisationUnit = source.organisationUnit;
        this.programInstance = source.programInstance;
        this.programStage = source.programStage;
        this.publicAccess = source.publicAccess;
        this.relationshipItems = source.relationshipItems;
        this.status = source.status;
        this.storedBy = source.storedBy;
        this.translations = source.translations;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userGroupAccesses = source.userGroupAccesses;
    }

    /**
     * 
     * @param favorites
     * @param access
     * @param code
     * @param storedBy
     * @param organisationUnit
     * @param displayName
     * @param publicAccess
     * @param dueDate
     * @param createdAtClient
     * @param messageConversations
     * @param externalAccess
     * @param lastUpdatedByUserInfo
     * @param lastUpdated
     * @param eventDataValues
     * @param translations
     * @param relationshipItems
     * @param href
     * @param id
     * @param assignedUser
     * @param createdByUserInfo
     * @param lastUpdatedBy
     * @param programStage
     * @param comments
     * @param userGroupAccesses
     * @param created
     * @param creatableInSearchScope
     * @param attributeValues
     * @param completed
     * @param completedDate
     * @param programInstance
     * @param deleted
     * @param attributeOptionCombo
     * @param userAccesses
     * @param name
     * @param geometry
     * @param favorite
     * @param user
     * @param completedBy
     * @param eventDate
     * @param lastUpdatedAtClient
     * @param status
     */
    public ProgramStageInstance(Access access, User assignedUser, CategoryOptionCombo attributeOptionCombo, List<AttributeValue> attributeValues, String code, List<TrackedEntityComment> comments, Boolean completed, String completedBy, Date completedDate, Boolean creatableInSearchScope, Date created, Date createdAtClient, UserInfoSnapshot createdByUserInfo, Boolean deleted, String displayName, Date dueDate, List<EventDataValue> eventDataValues, Date eventDate, Boolean externalAccess, Boolean favorite, List<String> favorites, Object geometry, String href, String id, Date lastUpdated, Date lastUpdatedAtClient, User lastUpdatedBy, UserInfoSnapshot lastUpdatedByUserInfo, List<MessageConversation> messageConversations, String name, OrganisationUnit organisationUnit, ProgramInstance programInstance, ProgramStage programStage, String publicAccess, List<RelationshipItem__2> relationshipItems, org.hisp.dhis.api.model.v2_35_13.EventChart.EventStatus status, String storedBy, List<Translation> translations, User user, List<UserAccess> userAccesses, List<UserGroupAccess> userGroupAccesses) {
        super();
        this.access = access;
        this.assignedUser = assignedUser;
        this.attributeOptionCombo = attributeOptionCombo;
        this.attributeValues = attributeValues;
        this.code = code;
        this.comments = comments;
        this.completed = completed;
        this.completedBy = completedBy;
        this.completedDate = completedDate;
        this.creatableInSearchScope = creatableInSearchScope;
        this.created = created;
        this.createdAtClient = createdAtClient;
        this.createdByUserInfo = createdByUserInfo;
        this.deleted = deleted;
        this.displayName = displayName;
        this.dueDate = dueDate;
        this.eventDataValues = eventDataValues;
        this.eventDate = eventDate;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.geometry = geometry;
        this.href = href;
        this.id = id;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedAtClient = lastUpdatedAtClient;
        this.lastUpdatedBy = lastUpdatedBy;
        this.lastUpdatedByUserInfo = lastUpdatedByUserInfo;
        this.messageConversations = messageConversations;
        this.name = name;
        this.organisationUnit = organisationUnit;
        this.programInstance = programInstance;
        this.programStage = programStage;
        this.publicAccess = publicAccess;
        this.relationshipItems = relationshipItems;
        this.status = status;
        this.storedBy = storedBy;
        this.translations = translations;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userGroupAccesses = userGroupAccesses;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public ProgramStageInstance withAccess(Access access) {
        this.access = access;
        return this;
    }

    @JsonProperty("assignedUser")
    public Optional<User> getAssignedUser() {
        return Optional.ofNullable(assignedUser);
    }

    @JsonProperty("assignedUser")
    public void setAssignedUser(User assignedUser) {
        this.assignedUser = assignedUser;
    }

    public ProgramStageInstance withAssignedUser(User assignedUser) {
        this.assignedUser = assignedUser;
        return this;
    }

    @JsonProperty("attributeOptionCombo")
    public Optional<CategoryOptionCombo> getAttributeOptionCombo() {
        return Optional.ofNullable(attributeOptionCombo);
    }

    @JsonProperty("attributeOptionCombo")
    public void setAttributeOptionCombo(CategoryOptionCombo attributeOptionCombo) {
        this.attributeOptionCombo = attributeOptionCombo;
    }

    public ProgramStageInstance withAttributeOptionCombo(CategoryOptionCombo attributeOptionCombo) {
        this.attributeOptionCombo = attributeOptionCombo;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public ProgramStageInstance withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public ProgramStageInstance withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("comments")
    public Optional<List<TrackedEntityComment>> getComments() {
        return Optional.ofNullable(comments);
    }

    @JsonProperty("comments")
    public void setComments(List<TrackedEntityComment> comments) {
        this.comments = comments;
    }

    public ProgramStageInstance withComments(List<TrackedEntityComment> comments) {
        this.comments = comments;
        return this;
    }

    @JsonProperty("completed")
    public Optional<Boolean> getCompleted() {
        return Optional.ofNullable(completed);
    }

    @JsonProperty("completed")
    public void setCompleted(Boolean completed) {
        this.completed = completed;
    }

    public ProgramStageInstance withCompleted(Boolean completed) {
        this.completed = completed;
        return this;
    }

    @JsonProperty("completedBy")
    public Optional<String> getCompletedBy() {
        return Optional.ofNullable(completedBy);
    }

    @JsonProperty("completedBy")
    public void setCompletedBy(String completedBy) {
        this.completedBy = completedBy;
    }

    public ProgramStageInstance withCompletedBy(String completedBy) {
        this.completedBy = completedBy;
        return this;
    }

    @JsonProperty("completedDate")
    public Optional<Date> getCompletedDate() {
        return Optional.ofNullable(completedDate);
    }

    @JsonProperty("completedDate")
    public void setCompletedDate(Date completedDate) {
        this.completedDate = completedDate;
    }

    public ProgramStageInstance withCompletedDate(Date completedDate) {
        this.completedDate = completedDate;
        return this;
    }

    @JsonProperty("creatableInSearchScope")
    public Optional<Boolean> getCreatableInSearchScope() {
        return Optional.ofNullable(creatableInSearchScope);
    }

    @JsonProperty("creatableInSearchScope")
    public void setCreatableInSearchScope(Boolean creatableInSearchScope) {
        this.creatableInSearchScope = creatableInSearchScope;
    }

    public ProgramStageInstance withCreatableInSearchScope(Boolean creatableInSearchScope) {
        this.creatableInSearchScope = creatableInSearchScope;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public ProgramStageInstance withCreated(Date created) {
        this.created = created;
        return this;
    }

    @JsonProperty("createdAtClient")
    public Optional<Date> getCreatedAtClient() {
        return Optional.ofNullable(createdAtClient);
    }

    @JsonProperty("createdAtClient")
    public void setCreatedAtClient(Date createdAtClient) {
        this.createdAtClient = createdAtClient;
    }

    public ProgramStageInstance withCreatedAtClient(Date createdAtClient) {
        this.createdAtClient = createdAtClient;
        return this;
    }

    @JsonProperty("createdByUserInfo")
    public Optional<UserInfoSnapshot> getCreatedByUserInfo() {
        return Optional.ofNullable(createdByUserInfo);
    }

    @JsonProperty("createdByUserInfo")
    public void setCreatedByUserInfo(UserInfoSnapshot createdByUserInfo) {
        this.createdByUserInfo = createdByUserInfo;
    }

    public ProgramStageInstance withCreatedByUserInfo(UserInfoSnapshot createdByUserInfo) {
        this.createdByUserInfo = createdByUserInfo;
        return this;
    }

    @JsonProperty("deleted")
    public Optional<Boolean> getDeleted() {
        return Optional.ofNullable(deleted);
    }

    @JsonProperty("deleted")
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public ProgramStageInstance withDeleted(Boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ProgramStageInstance withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("dueDate")
    public Optional<Date> getDueDate() {
        return Optional.ofNullable(dueDate);
    }

    @JsonProperty("dueDate")
    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public ProgramStageInstance withDueDate(Date dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    @JsonProperty("eventDataValues")
    public Optional<List<EventDataValue>> getEventDataValues() {
        return Optional.ofNullable(eventDataValues);
    }

    @JsonProperty("eventDataValues")
    public void setEventDataValues(List<EventDataValue> eventDataValues) {
        this.eventDataValues = eventDataValues;
    }

    public ProgramStageInstance withEventDataValues(List<EventDataValue> eventDataValues) {
        this.eventDataValues = eventDataValues;
        return this;
    }

    @JsonProperty("eventDate")
    public Optional<Date> getEventDate() {
        return Optional.ofNullable(eventDate);
    }

    @JsonProperty("eventDate")
    public void setEventDate(Date eventDate) {
        this.eventDate = eventDate;
    }

    public ProgramStageInstance withEventDate(Date eventDate) {
        this.eventDate = eventDate;
        return this;
    }

    @JsonProperty("externalAccess")
    public Optional<Boolean> getExternalAccess() {
        return Optional.ofNullable(externalAccess);
    }

    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public ProgramStageInstance withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    @JsonProperty("favorite")
    public Optional<Boolean> getFavorite() {
        return Optional.ofNullable(favorite);
    }

    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public ProgramStageInstance withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public ProgramStageInstance withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("geometry")
    public Optional<Object> getGeometry() {
        return Optional.ofNullable(geometry);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("geometry")
    public void setGeometry(Object geometry) {
        this.geometry = geometry;
    }

    public ProgramStageInstance withGeometry(Object geometry) {
        this.geometry = geometry;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public ProgramStageInstance withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public ProgramStageInstance withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public ProgramStageInstance withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @JsonProperty("lastUpdatedAtClient")
    public Optional<Date> getLastUpdatedAtClient() {
        return Optional.ofNullable(lastUpdatedAtClient);
    }

    @JsonProperty("lastUpdatedAtClient")
    public void setLastUpdatedAtClient(Date lastUpdatedAtClient) {
        this.lastUpdatedAtClient = lastUpdatedAtClient;
    }

    public ProgramStageInstance withLastUpdatedAtClient(Date lastUpdatedAtClient) {
        this.lastUpdatedAtClient = lastUpdatedAtClient;
        return this;
    }

    @JsonProperty("lastUpdatedBy")
    public Optional<User> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public ProgramStageInstance withLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    @JsonProperty("lastUpdatedByUserInfo")
    public Optional<UserInfoSnapshot> getLastUpdatedByUserInfo() {
        return Optional.ofNullable(lastUpdatedByUserInfo);
    }

    @JsonProperty("lastUpdatedByUserInfo")
    public void setLastUpdatedByUserInfo(UserInfoSnapshot lastUpdatedByUserInfo) {
        this.lastUpdatedByUserInfo = lastUpdatedByUserInfo;
    }

    public ProgramStageInstance withLastUpdatedByUserInfo(UserInfoSnapshot lastUpdatedByUserInfo) {
        this.lastUpdatedByUserInfo = lastUpdatedByUserInfo;
        return this;
    }

    @JsonProperty("messageConversations")
    public Optional<List<MessageConversation>> getMessageConversations() {
        return Optional.ofNullable(messageConversations);
    }

    @JsonProperty("messageConversations")
    public void setMessageConversations(List<MessageConversation> messageConversations) {
        this.messageConversations = messageConversations;
    }

    public ProgramStageInstance withMessageConversations(List<MessageConversation> messageConversations) {
        this.messageConversations = messageConversations;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public ProgramStageInstance withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("organisationUnit")
    public Optional<OrganisationUnit> getOrganisationUnit() {
        return Optional.ofNullable(organisationUnit);
    }

    @JsonProperty("organisationUnit")
    public void setOrganisationUnit(OrganisationUnit organisationUnit) {
        this.organisationUnit = organisationUnit;
    }

    public ProgramStageInstance withOrganisationUnit(OrganisationUnit organisationUnit) {
        this.organisationUnit = organisationUnit;
        return this;
    }

    @JsonProperty("programInstance")
    public Optional<ProgramInstance> getProgramInstance() {
        return Optional.ofNullable(programInstance);
    }

    @JsonProperty("programInstance")
    public void setProgramInstance(ProgramInstance programInstance) {
        this.programInstance = programInstance;
    }

    public ProgramStageInstance withProgramInstance(ProgramInstance programInstance) {
        this.programInstance = programInstance;
        return this;
    }

    @JsonProperty("programStage")
    public Optional<ProgramStage> getProgramStage() {
        return Optional.ofNullable(programStage);
    }

    @JsonProperty("programStage")
    public void setProgramStage(ProgramStage programStage) {
        this.programStage = programStage;
    }

    public ProgramStageInstance withProgramStage(ProgramStage programStage) {
        this.programStage = programStage;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public ProgramStageInstance withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    @JsonProperty("relationshipItems")
    public Optional<List<RelationshipItem__2>> getRelationshipItems() {
        return Optional.ofNullable(relationshipItems);
    }

    @JsonProperty("relationshipItems")
    public void setRelationshipItems(List<RelationshipItem__2> relationshipItems) {
        this.relationshipItems = relationshipItems;
    }

    public ProgramStageInstance withRelationshipItems(List<RelationshipItem__2> relationshipItems) {
        this.relationshipItems = relationshipItems;
        return this;
    }

    @JsonProperty("status")
    public Optional<org.hisp.dhis.api.model.v2_35_13.EventChart.EventStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    @JsonProperty("status")
    public void setStatus(org.hisp.dhis.api.model.v2_35_13.EventChart.EventStatus status) {
        this.status = status;
    }

    public ProgramStageInstance withStatus(org.hisp.dhis.api.model.v2_35_13.EventChart.EventStatus status) {
        this.status = status;
        return this;
    }

    @JsonProperty("storedBy")
    public Optional<String> getStoredBy() {
        return Optional.ofNullable(storedBy);
    }

    @JsonProperty("storedBy")
    public void setStoredBy(String storedBy) {
        this.storedBy = storedBy;
    }

    public ProgramStageInstance withStoredBy(String storedBy) {
        this.storedBy = storedBy;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public ProgramStageInstance withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    @JsonProperty("user")
    public Optional<User> getUser() {
        return Optional.ofNullable(user);
    }

    @JsonProperty("user")
    public void setUser(User user) {
        this.user = user;
    }

    public ProgramStageInstance withUser(User user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<UserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public ProgramStageInstance withUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<UserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public ProgramStageInstance withUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ProgramStageInstance withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "access":
                if (value instanceof Access) {
                    setAccess(((Access) value));
                } else {
                    throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v2_35_13.Access\", but got "+ value.getClass().toString()));
                }
                return true;
            case "assignedUser":
                if (value instanceof User) {
                    setAssignedUser(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"assignedUser\" is of type \"org.hisp.dhis.api.model.v2_35_13.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "attributeOptionCombo":
                if (value instanceof CategoryOptionCombo) {
                    setAttributeOptionCombo(((CategoryOptionCombo) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeOptionCombo\" is of type \"org.hisp.dhis.api.model.v2_35_13.CategoryOptionCombo\", but got "+ value.getClass().toString()));
                }
                return true;
            case "attributeValues":
                if (value instanceof List) {
                    setAttributeValues(((List<AttributeValue> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.AttributeValue>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "code":
                if (value instanceof String) {
                    setCode(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "comments":
                if (value instanceof List) {
                    setComments(((List<TrackedEntityComment> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"comments\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.TrackedEntityComment>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "completed":
                if (value instanceof Boolean) {
                    setCompleted(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"completed\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "completedBy":
                if (value instanceof String) {
                    setCompletedBy(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"completedBy\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "completedDate":
                if (value instanceof Date) {
                    setCompletedDate(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"completedDate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "creatableInSearchScope":
                if (value instanceof Boolean) {
                    setCreatableInSearchScope(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"creatableInSearchScope\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "created":
                if (value instanceof Date) {
                    setCreated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "createdAtClient":
                if (value instanceof Date) {
                    setCreatedAtClient(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"createdAtClient\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "createdByUserInfo":
                if (value instanceof UserInfoSnapshot) {
                    setCreatedByUserInfo(((UserInfoSnapshot) value));
                } else {
                    throw new IllegalArgumentException(("property \"createdByUserInfo\" is of type \"org.hisp.dhis.api.model.v2_35_13.UserInfoSnapshot\", but got "+ value.getClass().toString()));
                }
                return true;
            case "deleted":
                if (value instanceof Boolean) {
                    setDeleted(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"deleted\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayName":
                if (value instanceof String) {
                    setDisplayName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dueDate":
                if (value instanceof Date) {
                    setDueDate(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"dueDate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "eventDataValues":
                if (value instanceof List) {
                    setEventDataValues(((List<EventDataValue> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"eventDataValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.EventDataValue>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "eventDate":
                if (value instanceof Date) {
                    setEventDate(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"eventDate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "externalAccess":
                if (value instanceof Boolean) {
                    setExternalAccess(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "favorite":
                if (value instanceof Boolean) {
                    setFavorite(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "favorites":
                if (value instanceof List) {
                    setFavorites(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "geometry":
                if (value instanceof Object) {
                    setGeometry(((Object) value));
                } else {
                    throw new IllegalArgumentException(("property \"geometry\" is of type \"java.lang.Object\", but got "+ value.getClass().toString()));
                }
                return true;
            case "href":
                if (value instanceof String) {
                    setHref(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "id":
                if (value instanceof String) {
                    setId(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdated":
                if (value instanceof Date) {
                    setLastUpdated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdatedAtClient":
                if (value instanceof Date) {
                    setLastUpdatedAtClient(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdatedAtClient\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdatedBy":
                if (value instanceof User) {
                    setLastUpdatedBy(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v2_35_13.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdatedByUserInfo":
                if (value instanceof UserInfoSnapshot) {
                    setLastUpdatedByUserInfo(((UserInfoSnapshot) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdatedByUserInfo\" is of type \"org.hisp.dhis.api.model.v2_35_13.UserInfoSnapshot\", but got "+ value.getClass().toString()));
                }
                return true;
            case "messageConversations":
                if (value instanceof List) {
                    setMessageConversations(((List<MessageConversation> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"messageConversations\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.MessageConversation>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "name":
                if (value instanceof String) {
                    setName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "organisationUnit":
                if (value instanceof OrganisationUnit) {
                    setOrganisationUnit(((OrganisationUnit) value));
                } else {
                    throw new IllegalArgumentException(("property \"organisationUnit\" is of type \"org.hisp.dhis.api.model.v2_35_13.OrganisationUnit\", but got "+ value.getClass().toString()));
                }
                return true;
            case "programInstance":
                if (value instanceof ProgramInstance) {
                    setProgramInstance(((ProgramInstance) value));
                } else {
                    throw new IllegalArgumentException(("property \"programInstance\" is of type \"org.hisp.dhis.api.model.v2_35_13.ProgramInstance\", but got "+ value.getClass().toString()));
                }
                return true;
            case "programStage":
                if (value instanceof ProgramStage) {
                    setProgramStage(((ProgramStage) value));
                } else {
                    throw new IllegalArgumentException(("property \"programStage\" is of type \"org.hisp.dhis.api.model.v2_35_13.ProgramStage\", but got "+ value.getClass().toString()));
                }
                return true;
            case "publicAccess":
                if (value instanceof String) {
                    setPublicAccess(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "relationshipItems":
                if (value instanceof List) {
                    setRelationshipItems(((List<RelationshipItem__2> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"relationshipItems\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.RelationshipItem__2>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "status":
                if (value instanceof org.hisp.dhis.api.model.v2_35_13.EventChart.EventStatus) {
                    setStatus(((org.hisp.dhis.api.model.v2_35_13.EventChart.EventStatus) value));
                } else {
                    throw new IllegalArgumentException(("property \"status\" is of type \"org.hisp.dhis.api.model.v2_35_13.EventChart.EventStatus\", but got "+ value.getClass().toString()));
                }
                return true;
            case "storedBy":
                if (value instanceof String) {
                    setStoredBy(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"storedBy\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "translations":
                if (value instanceof List) {
                    setTranslations(((List<Translation> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.Translation>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "user":
                if (value instanceof User) {
                    setUser(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v2_35_13.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userAccesses":
                if (value instanceof List) {
                    setUserAccesses(((List<UserAccess> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.UserAccess>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userGroupAccesses":
                if (value instanceof List) {
                    setUserGroupAccesses(((List<UserGroupAccess> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.UserGroupAccess>\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "access":
                return getAccess();
            case "assignedUser":
                return getAssignedUser();
            case "attributeOptionCombo":
                return getAttributeOptionCombo();
            case "attributeValues":
                return getAttributeValues();
            case "code":
                return getCode();
            case "comments":
                return getComments();
            case "completed":
                return getCompleted();
            case "completedBy":
                return getCompletedBy();
            case "completedDate":
                return getCompletedDate();
            case "creatableInSearchScope":
                return getCreatableInSearchScope();
            case "created":
                return getCreated();
            case "createdAtClient":
                return getCreatedAtClient();
            case "createdByUserInfo":
                return getCreatedByUserInfo();
            case "deleted":
                return getDeleted();
            case "displayName":
                return getDisplayName();
            case "dueDate":
                return getDueDate();
            case "eventDataValues":
                return getEventDataValues();
            case "eventDate":
                return getEventDate();
            case "externalAccess":
                return getExternalAccess();
            case "favorite":
                return getFavorite();
            case "favorites":
                return getFavorites();
            case "geometry":
                return getGeometry();
            case "href":
                return getHref();
            case "id":
                return getId();
            case "lastUpdated":
                return getLastUpdated();
            case "lastUpdatedAtClient":
                return getLastUpdatedAtClient();
            case "lastUpdatedBy":
                return getLastUpdatedBy();
            case "lastUpdatedByUserInfo":
                return getLastUpdatedByUserInfo();
            case "messageConversations":
                return getMessageConversations();
            case "name":
                return getName();
            case "organisationUnit":
                return getOrganisationUnit();
            case "programInstance":
                return getProgramInstance();
            case "programStage":
                return getProgramStage();
            case "publicAccess":
                return getPublicAccess();
            case "relationshipItems":
                return getRelationshipItems();
            case "status":
                return getStatus();
            case "storedBy":
                return getStoredBy();
            case "translations":
                return getTranslations();
            case "user":
                return getUser();
            case "userAccesses":
                return getUserAccesses();
            case "userGroupAccesses":
                return getUserGroupAccesses();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ProgramStageInstance.NOT_FOUND_VALUE);
        if (ProgramStageInstance.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ProgramStageInstance with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ProgramStageInstance.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("assignedUser");
        sb.append('=');
        sb.append(((this.assignedUser == null)?"<null>":this.assignedUser));
        sb.append(',');
        sb.append("attributeOptionCombo");
        sb.append('=');
        sb.append(((this.attributeOptionCombo == null)?"<null>":this.attributeOptionCombo));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("comments");
        sb.append('=');
        sb.append(((this.comments == null)?"<null>":this.comments));
        sb.append(',');
        sb.append("completed");
        sb.append('=');
        sb.append(((this.completed == null)?"<null>":this.completed));
        sb.append(',');
        sb.append("completedBy");
        sb.append('=');
        sb.append(((this.completedBy == null)?"<null>":this.completedBy));
        sb.append(',');
        sb.append("completedDate");
        sb.append('=');
        sb.append(((this.completedDate == null)?"<null>":this.completedDate));
        sb.append(',');
        sb.append("creatableInSearchScope");
        sb.append('=');
        sb.append(((this.creatableInSearchScope == null)?"<null>":this.creatableInSearchScope));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("createdAtClient");
        sb.append('=');
        sb.append(((this.createdAtClient == null)?"<null>":this.createdAtClient));
        sb.append(',');
        sb.append("createdByUserInfo");
        sb.append('=');
        sb.append(((this.createdByUserInfo == null)?"<null>":this.createdByUserInfo));
        sb.append(',');
        sb.append("deleted");
        sb.append('=');
        sb.append(((this.deleted == null)?"<null>":this.deleted));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("dueDate");
        sb.append('=');
        sb.append(((this.dueDate == null)?"<null>":this.dueDate));
        sb.append(',');
        sb.append("eventDataValues");
        sb.append('=');
        sb.append(((this.eventDataValues == null)?"<null>":this.eventDataValues));
        sb.append(',');
        sb.append("eventDate");
        sb.append('=');
        sb.append(((this.eventDate == null)?"<null>":this.eventDate));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("geometry");
        sb.append('=');
        sb.append(((this.geometry == null)?"<null>":this.geometry));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedAtClient");
        sb.append('=');
        sb.append(((this.lastUpdatedAtClient == null)?"<null>":this.lastUpdatedAtClient));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("lastUpdatedByUserInfo");
        sb.append('=');
        sb.append(((this.lastUpdatedByUserInfo == null)?"<null>":this.lastUpdatedByUserInfo));
        sb.append(',');
        sb.append("messageConversations");
        sb.append('=');
        sb.append(((this.messageConversations == null)?"<null>":this.messageConversations));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("organisationUnit");
        sb.append('=');
        sb.append(((this.organisationUnit == null)?"<null>":this.organisationUnit));
        sb.append(',');
        sb.append("programInstance");
        sb.append('=');
        sb.append(((this.programInstance == null)?"<null>":this.programInstance));
        sb.append(',');
        sb.append("programStage");
        sb.append('=');
        sb.append(((this.programStage == null)?"<null>":this.programStage));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("relationshipItems");
        sb.append('=');
        sb.append(((this.relationshipItems == null)?"<null>":this.relationshipItems));
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(((this.status == null)?"<null>":this.status));
        sb.append(',');
        sb.append("storedBy");
        sb.append('=');
        sb.append(((this.storedBy == null)?"<null>":this.storedBy));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.storedBy == null)? 0 :this.storedBy.hashCode()));
        result = ((result* 31)+((this.organisationUnit == null)? 0 :this.organisationUnit.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.dueDate == null)? 0 :this.dueDate.hashCode()));
        result = ((result* 31)+((this.createdAtClient == null)? 0 :this.createdAtClient.hashCode()));
        result = ((result* 31)+((this.messageConversations == null)? 0 :this.messageConversations.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.lastUpdatedByUserInfo == null)? 0 :this.lastUpdatedByUserInfo.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.eventDataValues == null)? 0 :this.eventDataValues.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.relationshipItems == null)? 0 :this.relationshipItems.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.assignedUser == null)? 0 :this.assignedUser.hashCode()));
        result = ((result* 31)+((this.createdByUserInfo == null)? 0 :this.createdByUserInfo.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.programStage == null)? 0 :this.programStage.hashCode()));
        result = ((result* 31)+((this.comments == null)? 0 :this.comments.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.creatableInSearchScope == null)? 0 :this.creatableInSearchScope.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.completed == null)? 0 :this.completed.hashCode()));
        result = ((result* 31)+((this.completedDate == null)? 0 :this.completedDate.hashCode()));
        result = ((result* 31)+((this.programInstance == null)? 0 :this.programInstance.hashCode()));
        result = ((result* 31)+((this.deleted == null)? 0 :this.deleted.hashCode()));
        result = ((result* 31)+((this.attributeOptionCombo == null)? 0 :this.attributeOptionCombo.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.geometry == null)? 0 :this.geometry.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        result = ((result* 31)+((this.completedBy == null)? 0 :this.completedBy.hashCode()));
        result = ((result* 31)+((this.eventDate == null)? 0 :this.eventDate.hashCode()));
        result = ((result* 31)+((this.lastUpdatedAtClient == null)? 0 :this.lastUpdatedAtClient.hashCode()));
        result = ((result* 31)+((this.status == null)? 0 :this.status.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ProgramStageInstance) == false) {
            return false;
        }
        ProgramStageInstance rhs = ((ProgramStageInstance) other);
        return (((((((((((((((((((((((((((((((((((((((((((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites)))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.storedBy == rhs.storedBy)||((this.storedBy!= null)&&this.storedBy.equals(rhs.storedBy))))&&((this.organisationUnit == rhs.organisationUnit)||((this.organisationUnit!= null)&&this.organisationUnit.equals(rhs.organisationUnit))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.dueDate == rhs.dueDate)||((this.dueDate!= null)&&this.dueDate.equals(rhs.dueDate))))&&((this.createdAtClient == rhs.createdAtClient)||((this.createdAtClient!= null)&&this.createdAtClient.equals(rhs.createdAtClient))))&&((this.messageConversations == rhs.messageConversations)||((this.messageConversations!= null)&&this.messageConversations.equals(rhs.messageConversations))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.lastUpdatedByUserInfo == rhs.lastUpdatedByUserInfo)||((this.lastUpdatedByUserInfo!= null)&&this.lastUpdatedByUserInfo.equals(rhs.lastUpdatedByUserInfo))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.eventDataValues == rhs.eventDataValues)||((this.eventDataValues!= null)&&this.eventDataValues.equals(rhs.eventDataValues))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.relationshipItems == rhs.relationshipItems)||((this.relationshipItems!= null)&&this.relationshipItems.equals(rhs.relationshipItems))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.assignedUser == rhs.assignedUser)||((this.assignedUser!= null)&&this.assignedUser.equals(rhs.assignedUser))))&&((this.createdByUserInfo == rhs.createdByUserInfo)||((this.createdByUserInfo!= null)&&this.createdByUserInfo.equals(rhs.createdByUserInfo))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.programStage == rhs.programStage)||((this.programStage!= null)&&this.programStage.equals(rhs.programStage))))&&((this.comments == rhs.comments)||((this.comments!= null)&&this.comments.equals(rhs.comments))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.creatableInSearchScope == rhs.creatableInSearchScope)||((this.creatableInSearchScope!= null)&&this.creatableInSearchScope.equals(rhs.creatableInSearchScope))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.completed == rhs.completed)||((this.completed!= null)&&this.completed.equals(rhs.completed))))&&((this.completedDate == rhs.completedDate)||((this.completedDate!= null)&&this.completedDate.equals(rhs.completedDate))))&&((this.programInstance == rhs.programInstance)||((this.programInstance!= null)&&this.programInstance.equals(rhs.programInstance))))&&((this.deleted == rhs.deleted)||((this.deleted!= null)&&this.deleted.equals(rhs.deleted))))&&((this.attributeOptionCombo == rhs.attributeOptionCombo)||((this.attributeOptionCombo!= null)&&this.attributeOptionCombo.equals(rhs.attributeOptionCombo))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.geometry == rhs.geometry)||((this.geometry!= null)&&this.geometry.equals(rhs.geometry))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))))&&((this.completedBy == rhs.completedBy)||((this.completedBy!= null)&&this.completedBy.equals(rhs.completedBy))))&&((this.eventDate == rhs.eventDate)||((this.eventDate!= null)&&this.eventDate.equals(rhs.eventDate))))&&((this.lastUpdatedAtClient == rhs.lastUpdatedAtClient)||((this.lastUpdatedAtClient!= null)&&this.lastUpdatedAtClient.equals(rhs.lastUpdatedAtClient))))&&((this.status == rhs.status)||((this.status!= null)&&this.status.equals(rhs.status))));
    }

}
