
package org.hisp.dhis.api.model.v2_35_13;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "grandParentOrganisationUnit",
    "organisationUnit",
    "parentOrganisationUnit",
    "reportingPeriod"
})
@Generated("jsonschema2pojo")
public class ReportingParams implements Serializable
{

    @JsonProperty("grandParentOrganisationUnit")
    private Boolean grandParentOrganisationUnit;
    @JsonProperty("organisationUnit")
    private Boolean organisationUnit;
    @JsonProperty("parentOrganisationUnit")
    private Boolean parentOrganisationUnit;
    @JsonProperty("reportingPeriod")
    private Boolean reportingPeriod;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 3020813325607765875L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ReportingParams() {
    }

    /**
     * 
     * @param source
     */
    public ReportingParams(ReportingParams source) {
        super();
        this.grandParentOrganisationUnit = source.grandParentOrganisationUnit;
        this.organisationUnit = source.organisationUnit;
        this.parentOrganisationUnit = source.parentOrganisationUnit;
        this.reportingPeriod = source.reportingPeriod;
    }

    /**
     * 
     * @param parentOrganisationUnit
     * @param reportingPeriod
     * @param organisationUnit
     * @param grandParentOrganisationUnit
     */
    public ReportingParams(Boolean grandParentOrganisationUnit, Boolean organisationUnit, Boolean parentOrganisationUnit, Boolean reportingPeriod) {
        super();
        this.grandParentOrganisationUnit = grandParentOrganisationUnit;
        this.organisationUnit = organisationUnit;
        this.parentOrganisationUnit = parentOrganisationUnit;
        this.reportingPeriod = reportingPeriod;
    }

    @JsonProperty("grandParentOrganisationUnit")
    public Optional<Boolean> getGrandParentOrganisationUnit() {
        return Optional.ofNullable(grandParentOrganisationUnit);
    }

    @JsonProperty("grandParentOrganisationUnit")
    public void setGrandParentOrganisationUnit(Boolean grandParentOrganisationUnit) {
        this.grandParentOrganisationUnit = grandParentOrganisationUnit;
    }

    public ReportingParams withGrandParentOrganisationUnit(Boolean grandParentOrganisationUnit) {
        this.grandParentOrganisationUnit = grandParentOrganisationUnit;
        return this;
    }

    @JsonProperty("organisationUnit")
    public Optional<Boolean> getOrganisationUnit() {
        return Optional.ofNullable(organisationUnit);
    }

    @JsonProperty("organisationUnit")
    public void setOrganisationUnit(Boolean organisationUnit) {
        this.organisationUnit = organisationUnit;
    }

    public ReportingParams withOrganisationUnit(Boolean organisationUnit) {
        this.organisationUnit = organisationUnit;
        return this;
    }

    @JsonProperty("parentOrganisationUnit")
    public Optional<Boolean> getParentOrganisationUnit() {
        return Optional.ofNullable(parentOrganisationUnit);
    }

    @JsonProperty("parentOrganisationUnit")
    public void setParentOrganisationUnit(Boolean parentOrganisationUnit) {
        this.parentOrganisationUnit = parentOrganisationUnit;
    }

    public ReportingParams withParentOrganisationUnit(Boolean parentOrganisationUnit) {
        this.parentOrganisationUnit = parentOrganisationUnit;
        return this;
    }

    @JsonProperty("reportingPeriod")
    public Optional<Boolean> getReportingPeriod() {
        return Optional.ofNullable(reportingPeriod);
    }

    @JsonProperty("reportingPeriod")
    public void setReportingPeriod(Boolean reportingPeriod) {
        this.reportingPeriod = reportingPeriod;
    }

    public ReportingParams withReportingPeriod(Boolean reportingPeriod) {
        this.reportingPeriod = reportingPeriod;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ReportingParams withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "grandParentOrganisationUnit":
                if (value instanceof Boolean) {
                    setGrandParentOrganisationUnit(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"grandParentOrganisationUnit\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "organisationUnit":
                if (value instanceof Boolean) {
                    setOrganisationUnit(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"organisationUnit\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "parentOrganisationUnit":
                if (value instanceof Boolean) {
                    setParentOrganisationUnit(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"parentOrganisationUnit\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "reportingPeriod":
                if (value instanceof Boolean) {
                    setReportingPeriod(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"reportingPeriod\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "grandParentOrganisationUnit":
                return getGrandParentOrganisationUnit();
            case "organisationUnit":
                return getOrganisationUnit();
            case "parentOrganisationUnit":
                return getParentOrganisationUnit();
            case "reportingPeriod":
                return getReportingPeriod();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ReportingParams.NOT_FOUND_VALUE);
        if (ReportingParams.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ReportingParams with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ReportingParams.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("grandParentOrganisationUnit");
        sb.append('=');
        sb.append(((this.grandParentOrganisationUnit == null)?"<null>":this.grandParentOrganisationUnit));
        sb.append(',');
        sb.append("organisationUnit");
        sb.append('=');
        sb.append(((this.organisationUnit == null)?"<null>":this.organisationUnit));
        sb.append(',');
        sb.append("parentOrganisationUnit");
        sb.append('=');
        sb.append(((this.parentOrganisationUnit == null)?"<null>":this.parentOrganisationUnit));
        sb.append(',');
        sb.append("reportingPeriod");
        sb.append('=');
        sb.append(((this.reportingPeriod == null)?"<null>":this.reportingPeriod));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.parentOrganisationUnit == null)? 0 :this.parentOrganisationUnit.hashCode()));
        result = ((result* 31)+((this.reportingPeriod == null)? 0 :this.reportingPeriod.hashCode()));
        result = ((result* 31)+((this.organisationUnit == null)? 0 :this.organisationUnit.hashCode()));
        result = ((result* 31)+((this.grandParentOrganisationUnit == null)? 0 :this.grandParentOrganisationUnit.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ReportingParams) == false) {
            return false;
        }
        ReportingParams rhs = ((ReportingParams) other);
        return ((((((this.parentOrganisationUnit == rhs.parentOrganisationUnit)||((this.parentOrganisationUnit!= null)&&this.parentOrganisationUnit.equals(rhs.parentOrganisationUnit)))&&((this.reportingPeriod == rhs.reportingPeriod)||((this.reportingPeriod!= null)&&this.reportingPeriod.equals(rhs.reportingPeriod))))&&((this.organisationUnit == rhs.organisationUnit)||((this.organisationUnit!= null)&&this.organisationUnit.equals(rhs.organisationUnit))))&&((this.grandParentOrganisationUnit == rhs.grandParentOrganisationUnit)||((this.grandParentOrganisationUnit!= null)&&this.grandParentOrganisationUnit.equals(rhs.grandParentOrganisationUnit))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))));
    }

}
