
package org.hisp.dhis.api.model.v2_35_13;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "ownerObject",
    "ownerUid",
    "segments"
})
@Generated("jsonschema2pojo")
public class TextPattern implements Serializable
{

    @JsonProperty("ownerObject")
    private Objects ownerObject;
    @JsonProperty("ownerUid")
    private String ownerUid;
    @JsonProperty("segments")
    private List<TextPatternSegment> segments = null;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 8087592541156173517L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TextPattern() {
    }

    /**
     * 
     * @param source
     */
    public TextPattern(TextPattern source) {
        super();
        this.ownerObject = source.ownerObject;
        this.ownerUid = source.ownerUid;
        this.segments = source.segments;
    }

    /**
     * 
     * @param ownerObject
     * @param ownerUid
     * @param segments
     */
    public TextPattern(Objects ownerObject, String ownerUid, List<TextPatternSegment> segments) {
        super();
        this.ownerObject = ownerObject;
        this.ownerUid = ownerUid;
        this.segments = segments;
    }

    @JsonProperty("ownerObject")
    public Optional<Objects> getOwnerObject() {
        return Optional.ofNullable(ownerObject);
    }

    @JsonProperty("ownerObject")
    public void setOwnerObject(Objects ownerObject) {
        this.ownerObject = ownerObject;
    }

    public TextPattern withOwnerObject(Objects ownerObject) {
        this.ownerObject = ownerObject;
        return this;
    }

    @JsonProperty("ownerUid")
    public Optional<String> getOwnerUid() {
        return Optional.ofNullable(ownerUid);
    }

    @JsonProperty("ownerUid")
    public void setOwnerUid(String ownerUid) {
        this.ownerUid = ownerUid;
    }

    public TextPattern withOwnerUid(String ownerUid) {
        this.ownerUid = ownerUid;
        return this;
    }

    @JsonProperty("segments")
    public Optional<List<TextPatternSegment>> getSegments() {
        return Optional.ofNullable(segments);
    }

    @JsonProperty("segments")
    public void setSegments(List<TextPatternSegment> segments) {
        this.segments = segments;
    }

    public TextPattern withSegments(List<TextPatternSegment> segments) {
        this.segments = segments;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public TextPattern withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "ownerObject":
                if (value instanceof Objects) {
                    setOwnerObject(((Objects) value));
                } else {
                    throw new IllegalArgumentException(("property \"ownerObject\" is of type \"org.hisp.dhis.api.model.v2_35_13.Objects\", but got "+ value.getClass().toString()));
                }
                return true;
            case "ownerUid":
                if (value instanceof String) {
                    setOwnerUid(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"ownerUid\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "segments":
                if (value instanceof List) {
                    setSegments(((List<TextPatternSegment> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"segments\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.TextPatternSegment>\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "ownerObject":
                return getOwnerObject();
            case "ownerUid":
                return getOwnerUid();
            case "segments":
                return getSegments();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, TextPattern.NOT_FOUND_VALUE);
        if (TextPattern.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public TextPattern with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TextPattern.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("ownerObject");
        sb.append('=');
        sb.append(((this.ownerObject == null)?"<null>":this.ownerObject));
        sb.append(',');
        sb.append("ownerUid");
        sb.append('=');
        sb.append(((this.ownerUid == null)?"<null>":this.ownerUid));
        sb.append(',');
        sb.append("segments");
        sb.append('=');
        sb.append(((this.segments == null)?"<null>":this.segments));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.ownerUid == null)? 0 :this.ownerUid.hashCode()));
        result = ((result* 31)+((this.ownerObject == null)? 0 :this.ownerObject.hashCode()));
        result = ((result* 31)+((this.segments == null)? 0 :this.segments.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TextPattern) == false) {
            return false;
        }
        TextPattern rhs = ((TextPattern) other);
        return (((((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties)))&&((this.ownerUid == rhs.ownerUid)||((this.ownerUid!= null)&&this.ownerUid.equals(rhs.ownerUid))))&&((this.ownerObject == rhs.ownerObject)||((this.ownerObject!= null)&&this.ownerObject.equals(rhs.ownerObject))))&&((this.segments == rhs.segments)||((this.segments!= null)&&this.segments.equals(rhs.segments))));
    }

}
