
package org.hisp.dhis.api.model.v2_35_13;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "errorCode",
    "errorKlass",
    "errorProperties",
    "mainId",
    "mainKlass",
    "message",
    "value"
})
@Generated("jsonschema2pojo")
public class TrackerErrorReport implements Serializable
{

    @JsonProperty("errorCode")
    private TrackerErrorReport.TrackerErrorCode errorCode;
    @JsonProperty("errorKlass")
    private String errorKlass;
    @JsonProperty("errorProperties")
    private List<String> errorProperties = null;
    @JsonProperty("mainId")
    private String mainId;
    @JsonProperty("mainKlass")
    private String mainKlass;
    @JsonProperty("message")
    private String message;
    /**
     * Undefined
     * 
     */
    @JsonProperty("value")
    private Object value;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -5063628695576636091L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TrackerErrorReport() {
    }

    /**
     * 
     * @param source
     */
    public TrackerErrorReport(TrackerErrorReport source) {
        super();
        this.errorCode = source.errorCode;
        this.errorKlass = source.errorKlass;
        this.errorProperties = source.errorProperties;
        this.mainId = source.mainId;
        this.mainKlass = source.mainKlass;
        this.message = source.message;
        this.value = source.value;
    }

    /**
     * 
     * @param errorKlass
     * @param errorProperties
     * @param errorCode
     * @param mainKlass
     * @param mainId
     * @param message
     * @param value
     */
    public TrackerErrorReport(TrackerErrorReport.TrackerErrorCode errorCode, String errorKlass, List<String> errorProperties, String mainId, String mainKlass, String message, Object value) {
        super();
        this.errorCode = errorCode;
        this.errorKlass = errorKlass;
        this.errorProperties = errorProperties;
        this.mainId = mainId;
        this.mainKlass = mainKlass;
        this.message = message;
        this.value = value;
    }

    @JsonProperty("errorCode")
    public Optional<TrackerErrorReport.TrackerErrorCode> getErrorCode() {
        return Optional.ofNullable(errorCode);
    }

    @JsonProperty("errorCode")
    public void setErrorCode(TrackerErrorReport.TrackerErrorCode errorCode) {
        this.errorCode = errorCode;
    }

    public TrackerErrorReport withErrorCode(TrackerErrorReport.TrackerErrorCode errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    @JsonProperty("errorKlass")
    public Optional<String> getErrorKlass() {
        return Optional.ofNullable(errorKlass);
    }

    @JsonProperty("errorKlass")
    public void setErrorKlass(String errorKlass) {
        this.errorKlass = errorKlass;
    }

    public TrackerErrorReport withErrorKlass(String errorKlass) {
        this.errorKlass = errorKlass;
        return this;
    }

    @JsonProperty("errorProperties")
    public Optional<List<String>> getErrorProperties() {
        return Optional.ofNullable(errorProperties);
    }

    @JsonProperty("errorProperties")
    public void setErrorProperties(List<String> errorProperties) {
        this.errorProperties = errorProperties;
    }

    public TrackerErrorReport withErrorProperties(List<String> errorProperties) {
        this.errorProperties = errorProperties;
        return this;
    }

    @JsonProperty("mainId")
    public Optional<String> getMainId() {
        return Optional.ofNullable(mainId);
    }

    @JsonProperty("mainId")
    public void setMainId(String mainId) {
        this.mainId = mainId;
    }

    public TrackerErrorReport withMainId(String mainId) {
        this.mainId = mainId;
        return this;
    }

    @JsonProperty("mainKlass")
    public Optional<String> getMainKlass() {
        return Optional.ofNullable(mainKlass);
    }

    @JsonProperty("mainKlass")
    public void setMainKlass(String mainKlass) {
        this.mainKlass = mainKlass;
    }

    public TrackerErrorReport withMainKlass(String mainKlass) {
        this.mainKlass = mainKlass;
        return this;
    }

    @JsonProperty("message")
    public Optional<String> getMessage() {
        return Optional.ofNullable(message);
    }

    @JsonProperty("message")
    public void setMessage(String message) {
        this.message = message;
    }

    public TrackerErrorReport withMessage(String message) {
        this.message = message;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("value")
    public Optional<Object> getValue() {
        return Optional.ofNullable(value);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("value")
    public void setValue(Object value) {
        this.value = value;
    }

    public TrackerErrorReport withValue(Object value) {
        this.value = value;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public TrackerErrorReport withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "errorCode":
                if (value instanceof TrackerErrorReport.TrackerErrorCode) {
                    setErrorCode(((TrackerErrorReport.TrackerErrorCode) value));
                } else {
                    throw new IllegalArgumentException(("property \"errorCode\" is of type \"org.hisp.dhis.api.model.v2_35_13.TrackerErrorReport.TrackerErrorCode\", but got "+ value.getClass().toString()));
                }
                return true;
            case "errorKlass":
                if (value instanceof String) {
                    setErrorKlass(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"errorKlass\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "errorProperties":
                if (value instanceof List) {
                    setErrorProperties(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"errorProperties\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "mainId":
                if (value instanceof String) {
                    setMainId(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"mainId\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "mainKlass":
                if (value instanceof String) {
                    setMainKlass(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"mainKlass\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "message":
                if (value instanceof String) {
                    setMessage(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"message\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "value":
                if (value instanceof Object) {
                    setValue(((Object) value));
                } else {
                    throw new IllegalArgumentException(("property \"value\" is of type \"java.lang.Object\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "errorCode":
                return getErrorCode();
            case "errorKlass":
                return getErrorKlass();
            case "errorProperties":
                return getErrorProperties();
            case "mainId":
                return getMainId();
            case "mainKlass":
                return getMainKlass();
            case "message":
                return getMessage();
            case "value":
                return getValue();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, TrackerErrorReport.NOT_FOUND_VALUE);
        if (TrackerErrorReport.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public TrackerErrorReport with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TrackerErrorReport.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("errorCode");
        sb.append('=');
        sb.append(((this.errorCode == null)?"<null>":this.errorCode));
        sb.append(',');
        sb.append("errorKlass");
        sb.append('=');
        sb.append(((this.errorKlass == null)?"<null>":this.errorKlass));
        sb.append(',');
        sb.append("errorProperties");
        sb.append('=');
        sb.append(((this.errorProperties == null)?"<null>":this.errorProperties));
        sb.append(',');
        sb.append("mainId");
        sb.append('=');
        sb.append(((this.mainId == null)?"<null>":this.mainId));
        sb.append(',');
        sb.append("mainKlass");
        sb.append('=');
        sb.append(((this.mainKlass == null)?"<null>":this.mainKlass));
        sb.append(',');
        sb.append("message");
        sb.append('=');
        sb.append(((this.message == null)?"<null>":this.message));
        sb.append(',');
        sb.append("value");
        sb.append('=');
        sb.append(((this.value == null)?"<null>":this.value));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.errorKlass == null)? 0 :this.errorKlass.hashCode()));
        result = ((result* 31)+((this.errorProperties == null)? 0 :this.errorProperties.hashCode()));
        result = ((result* 31)+((this.errorCode == null)? 0 :this.errorCode.hashCode()));
        result = ((result* 31)+((this.mainKlass == null)? 0 :this.mainKlass.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.mainId == null)? 0 :this.mainId.hashCode()));
        result = ((result* 31)+((this.message == null)? 0 :this.message.hashCode()));
        result = ((result* 31)+((this.value == null)? 0 :this.value.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TrackerErrorReport) == false) {
            return false;
        }
        TrackerErrorReport rhs = ((TrackerErrorReport) other);
        return (((((((((this.errorKlass == rhs.errorKlass)||((this.errorKlass!= null)&&this.errorKlass.equals(rhs.errorKlass)))&&((this.errorProperties == rhs.errorProperties)||((this.errorProperties!= null)&&this.errorProperties.equals(rhs.errorProperties))))&&((this.errorCode == rhs.errorCode)||((this.errorCode!= null)&&this.errorCode.equals(rhs.errorCode))))&&((this.mainKlass == rhs.mainKlass)||((this.mainKlass!= null)&&this.mainKlass.equals(rhs.mainKlass))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.mainId == rhs.mainId)||((this.mainId!= null)&&this.mainId.equals(rhs.mainId))))&&((this.message == rhs.message)||((this.message!= null)&&this.message.equals(rhs.message))))&&((this.value == rhs.value)||((this.value!= null)&&this.value.equals(rhs.value))));
    }

    @Generated("jsonschema2pojo")
    public enum TrackerErrorCode {

        NONE("NONE"),
        E_1016("E1016"),
        E_1038("E1038"),
        E_1037("E1037"),
        E_1002("E1002"),
        E_1064("E1064"),
        E_1074("E1074"),
        E_1031("E1031"),
        E_1036("E1036"),
        E_1042("E1042"),
        E_1056("E1056"),
        E_1057("E1057"),
        E_1051("E1051"),
        E_1052("E1052"),
        E_1019("E1019"),
        E_1008("E1008"),
        E_1007("E1007"),
        E_1018("E1018"),
        E_1075("E1075"),
        E_1076("E1076"),
        E_1077("E1077"),
        E_1085("E1085"),
        E_1083("E1083"),
        E_1009("E1009"),
        E_1084("E1084"),
        E_1015("E1015"),
        E_1022("E1022"),
        E_1063("E1063"),
        E_1005("E1005"),
        E_1006("E1006"),
        E_1011("E1011"),
        E_1012("E1012"),
        E_1014("E1014"),
        E_1020("E1020"),
        E_1021("E1021"),
        E_1023("E1023"),
        E_1025("E1025"),
        E_1041("E1041"),
        E_1068("E1068"),
        E_1069("E1069"),
        E_1070("E1070"),
        E_1080("E1080"),
        E_1081("E1081"),
        E_1030("E1030"),
        E_1032("E1032"),
        E_1035("E1035"),
        E_1086("E1086"),
        E_1087("E1087"),
        E_1088("E1088"),
        E_1089("E1089"),
        E_1000("E1000"),
        E_1001("E1001"),
        E_1091("E1091"),
        E_1095("E1095"),
        E_1096("E1096"),
        E_1100("E1100"),
        E_1102("E1102"),
        E_1103("E1103"),
        E_1104("E1104"),
        E_1112("E1112"),
        E_1055("E1055"),
        E_1115("E1115"),
        E_1116("E1116"),
        E_1117("E1117"),
        E_1099("E1099"),
        E_1039("E1039"),
        E_1048("E1048"),
        E_1049("E1049"),
        E_1082("E1082"),
        E_1113("E1113"),
        E_1114("E1114"),
        E_1118("E1118"),
        E_1017("E1017"),
        E_1093("E1093"),
        E_1094("E1094"),
        E_1110("E1110"),
        E_1111("E1111"),
        E_1040("E1040"),
        E_1045("E1045"),
        E_1043("E1043"),
        E_1044("E1044"),
        E_1046("E1046"),
        E_1047("E1047"),
        E_1200("E1200"),
        E_4000("E4000"),
        E_4001("E4001"),
        E_4002("E4002"),
        E_4003("E4003"),
        E_4004("E4004"),
        E_4005("E4005"),
        E_9999("E9999");
        private final String value;
        private final static Map<String, TrackerErrorReport.TrackerErrorCode> CONSTANTS = new HashMap<String, TrackerErrorReport.TrackerErrorCode>();

        static {
            for (TrackerErrorReport.TrackerErrorCode c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        TrackerErrorCode(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static TrackerErrorReport.TrackerErrorCode fromValue(String value) {
            TrackerErrorReport.TrackerErrorCode constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
