
package org.hisp.dhis.api.model.v2_35_13;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "followUp",
    "key",
    "read",
    "user"
})
@Generated("jsonschema2pojo")
public class UserMessage implements Serializable
{

    @JsonProperty("followUp")
    private Boolean followUp;
    @JsonProperty("key")
    private String key;
    @JsonProperty("read")
    private Boolean read;
    @JsonProperty("user")
    private User user;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 1577901810979279479L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public UserMessage() {
    }

    /**
     * 
     * @param source
     */
    public UserMessage(UserMessage source) {
        super();
        this.followUp = source.followUp;
        this.key = source.key;
        this.read = source.read;
        this.user = source.user;
    }

    /**
     * 
     * @param followUp
     * @param read
     * @param user
     * @param key
     */
    public UserMessage(Boolean followUp, String key, Boolean read, User user) {
        super();
        this.followUp = followUp;
        this.key = key;
        this.read = read;
        this.user = user;
    }

    @JsonProperty("followUp")
    public Optional<Boolean> getFollowUp() {
        return Optional.ofNullable(followUp);
    }

    @JsonProperty("followUp")
    public void setFollowUp(Boolean followUp) {
        this.followUp = followUp;
    }

    public UserMessage withFollowUp(Boolean followUp) {
        this.followUp = followUp;
        return this;
    }

    @JsonProperty("key")
    public Optional<String> getKey() {
        return Optional.ofNullable(key);
    }

    @JsonProperty("key")
    public void setKey(String key) {
        this.key = key;
    }

    public UserMessage withKey(String key) {
        this.key = key;
        return this;
    }

    @JsonProperty("read")
    public Optional<Boolean> getRead() {
        return Optional.ofNullable(read);
    }

    @JsonProperty("read")
    public void setRead(Boolean read) {
        this.read = read;
    }

    public UserMessage withRead(Boolean read) {
        this.read = read;
        return this;
    }

    @JsonProperty("user")
    public Optional<User> getUser() {
        return Optional.ofNullable(user);
    }

    @JsonProperty("user")
    public void setUser(User user) {
        this.user = user;
    }

    public UserMessage withUser(User user) {
        this.user = user;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public UserMessage withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "followUp":
                if (value instanceof Boolean) {
                    setFollowUp(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"followUp\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "key":
                if (value instanceof String) {
                    setKey(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"key\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "read":
                if (value instanceof Boolean) {
                    setRead(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"read\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "user":
                if (value instanceof User) {
                    setUser(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v2_35_13.User\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "followUp":
                return getFollowUp();
            case "key":
                return getKey();
            case "read":
                return getRead();
            case "user":
                return getUser();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, UserMessage.NOT_FOUND_VALUE);
        if (UserMessage.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public UserMessage with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(UserMessage.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("followUp");
        sb.append('=');
        sb.append(((this.followUp == null)?"<null>":this.followUp));
        sb.append(',');
        sb.append("key");
        sb.append('=');
        sb.append(((this.key == null)?"<null>":this.key));
        sb.append(',');
        sb.append("read");
        sb.append('=');
        sb.append(((this.read == null)?"<null>":this.read));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.followUp == null)? 0 :this.followUp.hashCode()));
        result = ((result* 31)+((this.read == null)? 0 :this.read.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        result = ((result* 31)+((this.key == null)? 0 :this.key.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof UserMessage) == false) {
            return false;
        }
        UserMessage rhs = ((UserMessage) other);
        return ((((((this.followUp == rhs.followUp)||((this.followUp!= null)&&this.followUp.equals(rhs.followUp)))&&((this.read == rhs.read)||((this.read!= null)&&this.read.equals(rhs.read))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))))&&((this.key == rhs.key)||((this.key!= null)&&this.key.equals(rhs.key))));
    }

}
