
package org.hisp.dhis.api.model.v2_36_11;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "attributes",
    "auditScope",
    "auditType",
    "code",
    "createdAt",
    "createdBy",
    "data",
    "klass",
    "messageType",
    "uid"
})
@Generated("jsonschema2pojo")
public class Audit implements Serializable
{

    /**
     * Undefined
     * 
     */
    @JsonProperty("attributes")
    private Attributes attributes;
    @JsonProperty("auditScope")
    private Audit.AuditScope auditScope;
    @JsonProperty("auditType")
    private Audit.AuditType auditType;
    @JsonProperty("code")
    private String code;
    /**
     * Undefined
     * 
     */
    @JsonProperty("createdAt")
    private Object createdAt;
    @JsonProperty("createdBy")
    private String createdBy;
    /**
     * Undefined
     * 
     */
    @JsonProperty("data")
    private Object data;
    @JsonProperty("klass")
    private String klass;
    @JsonProperty("messageType")
    private Audit.MessageType messageType;
    @JsonProperty("uid")
    private String uid;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 7042648196471611446L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Audit() {
    }

    /**
     * 
     * @param source
     */
    public Audit(Audit source) {
        super();
        this.attributes = source.attributes;
        this.auditScope = source.auditScope;
        this.auditType = source.auditType;
        this.code = source.code;
        this.createdAt = source.createdAt;
        this.createdBy = source.createdBy;
        this.data = source.data;
        this.klass = source.klass;
        this.messageType = source.messageType;
        this.uid = source.uid;
    }

    /**
     * 
     * @param createdAt
     * @param uid
     * @param code
     * @param data
     * @param messageType
     * @param createdBy
     * @param klass
     * @param auditScope
     * @param attributes
     * @param auditType
     */
    public Audit(Attributes attributes, Audit.AuditScope auditScope, Audit.AuditType auditType, String code, Object createdAt, String createdBy, Object data, String klass, Audit.MessageType messageType, String uid) {
        super();
        this.attributes = attributes;
        this.auditScope = auditScope;
        this.auditType = auditType;
        this.code = code;
        this.createdAt = createdAt;
        this.createdBy = createdBy;
        this.data = data;
        this.klass = klass;
        this.messageType = messageType;
        this.uid = uid;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("attributes")
    public Optional<Attributes> getAttributes() {
        return Optional.ofNullable(attributes);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("attributes")
    public void setAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    public Audit withAttributes(Attributes attributes) {
        this.attributes = attributes;
        return this;
    }

    @JsonProperty("auditScope")
    public Optional<Audit.AuditScope> getAuditScope() {
        return Optional.ofNullable(auditScope);
    }

    @JsonProperty("auditScope")
    public void setAuditScope(Audit.AuditScope auditScope) {
        this.auditScope = auditScope;
    }

    public Audit withAuditScope(Audit.AuditScope auditScope) {
        this.auditScope = auditScope;
        return this;
    }

    @JsonProperty("auditType")
    public Optional<Audit.AuditType> getAuditType() {
        return Optional.ofNullable(auditType);
    }

    @JsonProperty("auditType")
    public void setAuditType(Audit.AuditType auditType) {
        this.auditType = auditType;
    }

    public Audit withAuditType(Audit.AuditType auditType) {
        this.auditType = auditType;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public Audit withCode(String code) {
        this.code = code;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("createdAt")
    public Optional<Object> getCreatedAt() {
        return Optional.ofNullable(createdAt);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("createdAt")
    public void setCreatedAt(Object createdAt) {
        this.createdAt = createdAt;
    }

    public Audit withCreatedAt(Object createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @JsonProperty("createdBy")
    public Optional<String> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    @JsonProperty("createdBy")
    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Audit withCreatedBy(String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("data")
    public Optional<Object> getData() {
        return Optional.ofNullable(data);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("data")
    public void setData(Object data) {
        this.data = data;
    }

    public Audit withData(Object data) {
        this.data = data;
        return this;
    }

    @JsonProperty("klass")
    public Optional<String> getKlass() {
        return Optional.ofNullable(klass);
    }

    @JsonProperty("klass")
    public void setKlass(String klass) {
        this.klass = klass;
    }

    public Audit withKlass(String klass) {
        this.klass = klass;
        return this;
    }

    @JsonProperty("messageType")
    public Optional<Audit.MessageType> getMessageType() {
        return Optional.ofNullable(messageType);
    }

    @JsonProperty("messageType")
    public void setMessageType(Audit.MessageType messageType) {
        this.messageType = messageType;
    }

    public Audit withMessageType(Audit.MessageType messageType) {
        this.messageType = messageType;
        return this;
    }

    @JsonProperty("uid")
    public Optional<String> getUid() {
        return Optional.ofNullable(uid);
    }

    @JsonProperty("uid")
    public void setUid(String uid) {
        this.uid = uid;
    }

    public Audit withUid(String uid) {
        this.uid = uid;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Audit withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "attributes":
                if (value instanceof Attributes) {
                    setAttributes(((Attributes) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributes\" is of type \"org.hisp.dhis.api.model.v2_36_11.Attributes\", but got "+ value.getClass().toString()));
                }
                return true;
            case "auditScope":
                if (value instanceof Audit.AuditScope) {
                    setAuditScope(((Audit.AuditScope) value));
                } else {
                    throw new IllegalArgumentException(("property \"auditScope\" is of type \"org.hisp.dhis.api.model.v2_36_11.Audit.AuditScope\", but got "+ value.getClass().toString()));
                }
                return true;
            case "auditType":
                if (value instanceof Audit.AuditType) {
                    setAuditType(((Audit.AuditType) value));
                } else {
                    throw new IllegalArgumentException(("property \"auditType\" is of type \"org.hisp.dhis.api.model.v2_36_11.Audit.AuditType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "code":
                if (value instanceof String) {
                    setCode(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "createdAt":
                if (value instanceof Object) {
                    setCreatedAt(((Object) value));
                } else {
                    throw new IllegalArgumentException(("property \"createdAt\" is of type \"java.lang.Object\", but got "+ value.getClass().toString()));
                }
                return true;
            case "createdBy":
                if (value instanceof String) {
                    setCreatedBy(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"createdBy\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "data":
                if (value instanceof Object) {
                    setData(((Object) value));
                } else {
                    throw new IllegalArgumentException(("property \"data\" is of type \"java.lang.Object\", but got "+ value.getClass().toString()));
                }
                return true;
            case "klass":
                if (value instanceof String) {
                    setKlass(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"klass\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "messageType":
                if (value instanceof Audit.MessageType) {
                    setMessageType(((Audit.MessageType) value));
                } else {
                    throw new IllegalArgumentException(("property \"messageType\" is of type \"org.hisp.dhis.api.model.v2_36_11.Audit.MessageType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "uid":
                if (value instanceof String) {
                    setUid(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"uid\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "attributes":
                return getAttributes();
            case "auditScope":
                return getAuditScope();
            case "auditType":
                return getAuditType();
            case "code":
                return getCode();
            case "createdAt":
                return getCreatedAt();
            case "createdBy":
                return getCreatedBy();
            case "data":
                return getData();
            case "klass":
                return getKlass();
            case "messageType":
                return getMessageType();
            case "uid":
                return getUid();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, Audit.NOT_FOUND_VALUE);
        if (Audit.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public Audit with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Audit.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("attributes");
        sb.append('=');
        sb.append(((this.attributes == null)?"<null>":this.attributes));
        sb.append(',');
        sb.append("auditScope");
        sb.append('=');
        sb.append(((this.auditScope == null)?"<null>":this.auditScope));
        sb.append(',');
        sb.append("auditType");
        sb.append('=');
        sb.append(((this.auditType == null)?"<null>":this.auditType));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("createdAt");
        sb.append('=');
        sb.append(((this.createdAt == null)?"<null>":this.createdAt));
        sb.append(',');
        sb.append("createdBy");
        sb.append('=');
        sb.append(((this.createdBy == null)?"<null>":this.createdBy));
        sb.append(',');
        sb.append("data");
        sb.append('=');
        sb.append(((this.data == null)?"<null>":this.data));
        sb.append(',');
        sb.append("klass");
        sb.append('=');
        sb.append(((this.klass == null)?"<null>":this.klass));
        sb.append(',');
        sb.append("messageType");
        sb.append('=');
        sb.append(((this.messageType == null)?"<null>":this.messageType));
        sb.append(',');
        sb.append("uid");
        sb.append('=');
        sb.append(((this.uid == null)?"<null>":this.uid));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.data == null)? 0 :this.data.hashCode()));
        result = ((result* 31)+((this.auditScope == null)? 0 :this.auditScope.hashCode()));
        result = ((result* 31)+((this.auditType == null)? 0 :this.auditType.hashCode()));
        result = ((result* 31)+((this.createdAt == null)? 0 :this.createdAt.hashCode()));
        result = ((result* 31)+((this.uid == null)? 0 :this.uid.hashCode()));
        result = ((result* 31)+((this.messageType == null)? 0 :this.messageType.hashCode()));
        result = ((result* 31)+((this.createdBy == null)? 0 :this.createdBy.hashCode()));
        result = ((result* 31)+((this.klass == null)? 0 :this.klass.hashCode()));
        result = ((result* 31)+((this.attributes == null)? 0 :this.attributes.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Audit) == false) {
            return false;
        }
        Audit rhs = ((Audit) other);
        return ((((((((((((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code)))&&((this.data == rhs.data)||((this.data!= null)&&this.data.equals(rhs.data))))&&((this.auditScope == rhs.auditScope)||((this.auditScope!= null)&&this.auditScope.equals(rhs.auditScope))))&&((this.auditType == rhs.auditType)||((this.auditType!= null)&&this.auditType.equals(rhs.auditType))))&&((this.createdAt == rhs.createdAt)||((this.createdAt!= null)&&this.createdAt.equals(rhs.createdAt))))&&((this.uid == rhs.uid)||((this.uid!= null)&&this.uid.equals(rhs.uid))))&&((this.messageType == rhs.messageType)||((this.messageType!= null)&&this.messageType.equals(rhs.messageType))))&&((this.createdBy == rhs.createdBy)||((this.createdBy!= null)&&this.createdBy.equals(rhs.createdBy))))&&((this.klass == rhs.klass)||((this.klass!= null)&&this.klass.equals(rhs.klass))))&&((this.attributes == rhs.attributes)||((this.attributes!= null)&&this.attributes.equals(rhs.attributes))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))));
    }

    @Generated("jsonschema2pojo")
    public enum AuditScope {

        METADATA("METADATA"),
        AGGREGATE("AGGREGATE"),
        TRACKER("TRACKER");
        private final String value;
        private final static Map<String, Audit.AuditScope> CONSTANTS = new HashMap<String, Audit.AuditScope>();

        static {
            for (Audit.AuditScope c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        AuditScope(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Audit.AuditScope fromValue(String value) {
            Audit.AuditScope constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum AuditType {

        CREATE("CREATE"),
        READ("READ"),
        UPDATE("UPDATE"),
        DELETE("DELETE"),
        SEARCH("SEARCH"),
        SECURITY("SECURITY");
        private final String value;
        private final static Map<String, Audit.AuditType> CONSTANTS = new HashMap<String, Audit.AuditType>();

        static {
            for (Audit.AuditType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        AuditType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Audit.AuditType fromValue(String value) {
            Audit.AuditType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum MessageType {

        AUDIT("AUDIT"),
        TRACKER_JOB("TRACKER_JOB"),
        TRACKER_SIDE_EFFECT("TRACKER_SIDE_EFFECT");
        private final String value;
        private final static Map<String, Audit.MessageType> CONSTANTS = new HashMap<String, Audit.MessageType>();

        static {
            for (Audit.MessageType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        MessageType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Audit.MessageType fromValue(String value) {
            Audit.MessageType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
