
package org.hisp.dhis.api.model.v2_36_11;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "bold",
    "font",
    "fontSize",
    "italic",
    "textAlign",
    "textColor",
    "underline"
})
@Generated("jsonschema2pojo")
public class FontStyle implements Serializable
{

    @JsonProperty("bold")
    private Boolean bold;
    @JsonProperty("font")
    private FontStyle.Font font;
    @JsonProperty("fontSize")
    private Integer fontSize;
    @JsonProperty("italic")
    private Boolean italic;
    @JsonProperty("textAlign")
    private FontStyle.TextAlign textAlign;
    @JsonProperty("textColor")
    private String textColor;
    @JsonProperty("underline")
    private Boolean underline;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -3262024601941846718L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public FontStyle() {
    }

    /**
     * 
     * @param source
     */
    public FontStyle(FontStyle source) {
        super();
        this.bold = source.bold;
        this.font = source.font;
        this.fontSize = source.fontSize;
        this.italic = source.italic;
        this.textAlign = source.textAlign;
        this.textColor = source.textColor;
        this.underline = source.underline;
    }

    /**
     * 
     * @param textAlign
     * @param underline
     * @param fontSize
     * @param bold
     * @param italic
     * @param textColor
     * @param font
     */
    public FontStyle(Boolean bold, FontStyle.Font font, Integer fontSize, Boolean italic, FontStyle.TextAlign textAlign, String textColor, Boolean underline) {
        super();
        this.bold = bold;
        this.font = font;
        this.fontSize = fontSize;
        this.italic = italic;
        this.textAlign = textAlign;
        this.textColor = textColor;
        this.underline = underline;
    }

    @JsonProperty("bold")
    public Optional<Boolean> getBold() {
        return Optional.ofNullable(bold);
    }

    @JsonProperty("bold")
    public void setBold(Boolean bold) {
        this.bold = bold;
    }

    public FontStyle withBold(Boolean bold) {
        this.bold = bold;
        return this;
    }

    @JsonProperty("font")
    public Optional<FontStyle.Font> getFont() {
        return Optional.ofNullable(font);
    }

    @JsonProperty("font")
    public void setFont(FontStyle.Font font) {
        this.font = font;
    }

    public FontStyle withFont(FontStyle.Font font) {
        this.font = font;
        return this;
    }

    @JsonProperty("fontSize")
    public Optional<Integer> getFontSize() {
        return Optional.ofNullable(fontSize);
    }

    @JsonProperty("fontSize")
    public void setFontSize(Integer fontSize) {
        this.fontSize = fontSize;
    }

    public FontStyle withFontSize(Integer fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    @JsonProperty("italic")
    public Optional<Boolean> getItalic() {
        return Optional.ofNullable(italic);
    }

    @JsonProperty("italic")
    public void setItalic(Boolean italic) {
        this.italic = italic;
    }

    public FontStyle withItalic(Boolean italic) {
        this.italic = italic;
        return this;
    }

    @JsonProperty("textAlign")
    public Optional<FontStyle.TextAlign> getTextAlign() {
        return Optional.ofNullable(textAlign);
    }

    @JsonProperty("textAlign")
    public void setTextAlign(FontStyle.TextAlign textAlign) {
        this.textAlign = textAlign;
    }

    public FontStyle withTextAlign(FontStyle.TextAlign textAlign) {
        this.textAlign = textAlign;
        return this;
    }

    @JsonProperty("textColor")
    public Optional<String> getTextColor() {
        return Optional.ofNullable(textColor);
    }

    @JsonProperty("textColor")
    public void setTextColor(String textColor) {
        this.textColor = textColor;
    }

    public FontStyle withTextColor(String textColor) {
        this.textColor = textColor;
        return this;
    }

    @JsonProperty("underline")
    public Optional<Boolean> getUnderline() {
        return Optional.ofNullable(underline);
    }

    @JsonProperty("underline")
    public void setUnderline(Boolean underline) {
        this.underline = underline;
    }

    public FontStyle withUnderline(Boolean underline) {
        this.underline = underline;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public FontStyle withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "bold":
                if (value instanceof Boolean) {
                    setBold(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"bold\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "font":
                if (value instanceof FontStyle.Font) {
                    setFont(((FontStyle.Font) value));
                } else {
                    throw new IllegalArgumentException(("property \"font\" is of type \"org.hisp.dhis.api.model.v2_36_11.FontStyle.Font\", but got "+ value.getClass().toString()));
                }
                return true;
            case "fontSize":
                if (value instanceof Integer) {
                    setFontSize(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"fontSize\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "italic":
                if (value instanceof Boolean) {
                    setItalic(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"italic\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "textAlign":
                if (value instanceof FontStyle.TextAlign) {
                    setTextAlign(((FontStyle.TextAlign) value));
                } else {
                    throw new IllegalArgumentException(("property \"textAlign\" is of type \"org.hisp.dhis.api.model.v2_36_11.FontStyle.TextAlign\", but got "+ value.getClass().toString()));
                }
                return true;
            case "textColor":
                if (value instanceof String) {
                    setTextColor(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"textColor\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "underline":
                if (value instanceof Boolean) {
                    setUnderline(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"underline\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "bold":
                return getBold();
            case "font":
                return getFont();
            case "fontSize":
                return getFontSize();
            case "italic":
                return getItalic();
            case "textAlign":
                return getTextAlign();
            case "textColor":
                return getTextColor();
            case "underline":
                return getUnderline();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, FontStyle.NOT_FOUND_VALUE);
        if (FontStyle.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public FontStyle with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(FontStyle.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("bold");
        sb.append('=');
        sb.append(((this.bold == null)?"<null>":this.bold));
        sb.append(',');
        sb.append("font");
        sb.append('=');
        sb.append(((this.font == null)?"<null>":this.font));
        sb.append(',');
        sb.append("fontSize");
        sb.append('=');
        sb.append(((this.fontSize == null)?"<null>":this.fontSize));
        sb.append(',');
        sb.append("italic");
        sb.append('=');
        sb.append(((this.italic == null)?"<null>":this.italic));
        sb.append(',');
        sb.append("textAlign");
        sb.append('=');
        sb.append(((this.textAlign == null)?"<null>":this.textAlign));
        sb.append(',');
        sb.append("textColor");
        sb.append('=');
        sb.append(((this.textColor == null)?"<null>":this.textColor));
        sb.append(',');
        sb.append("underline");
        sb.append('=');
        sb.append(((this.underline == null)?"<null>":this.underline));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.textAlign == null)? 0 :this.textAlign.hashCode()));
        result = ((result* 31)+((this.underline == null)? 0 :this.underline.hashCode()));
        result = ((result* 31)+((this.fontSize == null)? 0 :this.fontSize.hashCode()));
        result = ((result* 31)+((this.bold == null)? 0 :this.bold.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.italic == null)? 0 :this.italic.hashCode()));
        result = ((result* 31)+((this.textColor == null)? 0 :this.textColor.hashCode()));
        result = ((result* 31)+((this.font == null)? 0 :this.font.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof FontStyle) == false) {
            return false;
        }
        FontStyle rhs = ((FontStyle) other);
        return (((((((((this.textAlign == rhs.textAlign)||((this.textAlign!= null)&&this.textAlign.equals(rhs.textAlign)))&&((this.underline == rhs.underline)||((this.underline!= null)&&this.underline.equals(rhs.underline))))&&((this.fontSize == rhs.fontSize)||((this.fontSize!= null)&&this.fontSize.equals(rhs.fontSize))))&&((this.bold == rhs.bold)||((this.bold!= null)&&this.bold.equals(rhs.bold))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.italic == rhs.italic)||((this.italic!= null)&&this.italic.equals(rhs.italic))))&&((this.textColor == rhs.textColor)||((this.textColor!= null)&&this.textColor.equals(rhs.textColor))))&&((this.font == rhs.font)||((this.font!= null)&&this.font.equals(rhs.font))));
    }

    @Generated("jsonschema2pojo")
    public enum Font {

        ARIAL("ARIAL"),
        SANS_SERIF("SANS_SERIF"),
        VERDANA("VERDANA"),
        ROBOTO("ROBOTO");
        private final String value;
        private final static Map<String, FontStyle.Font> CONSTANTS = new HashMap<String, FontStyle.Font>();

        static {
            for (FontStyle.Font c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        Font(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static FontStyle.Font fromValue(String value) {
            FontStyle.Font constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum TextAlign {

        LEFT("LEFT"),
        CENTER("CENTER"),
        RIGHT("RIGHT");
        private final String value;
        private final static Map<String, FontStyle.TextAlign> CONSTANTS = new HashMap<String, FontStyle.TextAlign>();

        static {
            for (FontStyle.TextAlign c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        TextAlign(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static FontStyle.TextAlign fromValue(String value) {
            FontStyle.TextAlign constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
