
package org.hisp.dhis.api.model.v2_36_11;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "jobParameters",
    "jobType",
    "key",
    "name",
    "schedulingType"
})
@Generated("jsonschema2pojo")
public class JobTypeInfo implements Serializable
{

    @JsonProperty("jobParameters")
    private List<Property> jobParameters = null;
    @JsonProperty("jobType")
    private org.hisp.dhis.api.model.v2_36_11.JobConfiguration.JobType jobType;
    @JsonProperty("key")
    private String key;
    @JsonProperty("name")
    private String name;
    @JsonProperty("schedulingType")
    private org.hisp.dhis.api.model.v2_36_11.JobConfiguration.SchedulingType schedulingType;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 8052126549416245522L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public JobTypeInfo() {
    }

    /**
     * 
     * @param source
     */
    public JobTypeInfo(JobTypeInfo source) {
        super();
        this.jobParameters = source.jobParameters;
        this.jobType = source.jobType;
        this.key = source.key;
        this.name = source.name;
        this.schedulingType = source.schedulingType;
    }

    /**
     * 
     * @param schedulingType
     * @param name
     * @param jobParameters
     * @param jobType
     * @param key
     */
    public JobTypeInfo(List<Property> jobParameters, org.hisp.dhis.api.model.v2_36_11.JobConfiguration.JobType jobType, String key, String name, org.hisp.dhis.api.model.v2_36_11.JobConfiguration.SchedulingType schedulingType) {
        super();
        this.jobParameters = jobParameters;
        this.jobType = jobType;
        this.key = key;
        this.name = name;
        this.schedulingType = schedulingType;
    }

    @JsonProperty("jobParameters")
    public Optional<List<Property>> getJobParameters() {
        return Optional.ofNullable(jobParameters);
    }

    @JsonProperty("jobParameters")
    public void setJobParameters(List<Property> jobParameters) {
        this.jobParameters = jobParameters;
    }

    public JobTypeInfo withJobParameters(List<Property> jobParameters) {
        this.jobParameters = jobParameters;
        return this;
    }

    @JsonProperty("jobType")
    public Optional<org.hisp.dhis.api.model.v2_36_11.JobConfiguration.JobType> getJobType() {
        return Optional.ofNullable(jobType);
    }

    @JsonProperty("jobType")
    public void setJobType(org.hisp.dhis.api.model.v2_36_11.JobConfiguration.JobType jobType) {
        this.jobType = jobType;
    }

    public JobTypeInfo withJobType(org.hisp.dhis.api.model.v2_36_11.JobConfiguration.JobType jobType) {
        this.jobType = jobType;
        return this;
    }

    @JsonProperty("key")
    public Optional<String> getKey() {
        return Optional.ofNullable(key);
    }

    @JsonProperty("key")
    public void setKey(String key) {
        this.key = key;
    }

    public JobTypeInfo withKey(String key) {
        this.key = key;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public JobTypeInfo withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("schedulingType")
    public Optional<org.hisp.dhis.api.model.v2_36_11.JobConfiguration.SchedulingType> getSchedulingType() {
        return Optional.ofNullable(schedulingType);
    }

    @JsonProperty("schedulingType")
    public void setSchedulingType(org.hisp.dhis.api.model.v2_36_11.JobConfiguration.SchedulingType schedulingType) {
        this.schedulingType = schedulingType;
    }

    public JobTypeInfo withSchedulingType(org.hisp.dhis.api.model.v2_36_11.JobConfiguration.SchedulingType schedulingType) {
        this.schedulingType = schedulingType;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public JobTypeInfo withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "jobParameters":
                if (value instanceof List) {
                    setJobParameters(((List<Property> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"jobParameters\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_36_11.Property>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "jobType":
                if (value instanceof org.hisp.dhis.api.model.v2_36_11.JobConfiguration.JobType) {
                    setJobType(((org.hisp.dhis.api.model.v2_36_11.JobConfiguration.JobType) value));
                } else {
                    throw new IllegalArgumentException(("property \"jobType\" is of type \"org.hisp.dhis.api.model.v2_36_11.JobConfiguration.JobType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "key":
                if (value instanceof String) {
                    setKey(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"key\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "name":
                if (value instanceof String) {
                    setName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "schedulingType":
                if (value instanceof org.hisp.dhis.api.model.v2_36_11.JobConfiguration.SchedulingType) {
                    setSchedulingType(((org.hisp.dhis.api.model.v2_36_11.JobConfiguration.SchedulingType) value));
                } else {
                    throw new IllegalArgumentException(("property \"schedulingType\" is of type \"org.hisp.dhis.api.model.v2_36_11.JobConfiguration.SchedulingType\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "jobParameters":
                return getJobParameters();
            case "jobType":
                return getJobType();
            case "key":
                return getKey();
            case "name":
                return getName();
            case "schedulingType":
                return getSchedulingType();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, JobTypeInfo.NOT_FOUND_VALUE);
        if (JobTypeInfo.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public JobTypeInfo with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(JobTypeInfo.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("jobParameters");
        sb.append('=');
        sb.append(((this.jobParameters == null)?"<null>":this.jobParameters));
        sb.append(',');
        sb.append("jobType");
        sb.append('=');
        sb.append(((this.jobType == null)?"<null>":this.jobType));
        sb.append(',');
        sb.append("key");
        sb.append('=');
        sb.append(((this.key == null)?"<null>":this.key));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("schedulingType");
        sb.append('=');
        sb.append(((this.schedulingType == null)?"<null>":this.schedulingType));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.schedulingType == null)? 0 :this.schedulingType.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.jobParameters == null)? 0 :this.jobParameters.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.jobType == null)? 0 :this.jobType.hashCode()));
        result = ((result* 31)+((this.key == null)? 0 :this.key.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof JobTypeInfo) == false) {
            return false;
        }
        JobTypeInfo rhs = ((JobTypeInfo) other);
        return (((((((this.schedulingType == rhs.schedulingType)||((this.schedulingType!= null)&&this.schedulingType.equals(rhs.schedulingType)))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.jobParameters == rhs.jobParameters)||((this.jobParameters!= null)&&this.jobParameters.equals(rhs.jobParameters))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.jobType == rhs.jobType)||((this.jobType!= null)&&this.jobType.equals(rhs.jobType))))&&((this.key == rhs.key)||((this.key!= null)&&this.key.equals(rhs.key))));
    }

}
