
package org.hisp.dhis.api.model.v2_36_11;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "challenge_ts",
    "error-codes",
    "hostname",
    "success"
})
@Generated("jsonschema2pojo")
public class RecaptchaResponse implements Serializable
{

    @JsonProperty("challenge_ts")
    private String challengeTs;
    @JsonProperty("error-codes")
    private List<String> errorCodes = null;
    @JsonProperty("hostname")
    private String hostname;
    @JsonProperty("success")
    private Boolean success;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -1094777069388754086L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public RecaptchaResponse() {
    }

    /**
     * 
     * @param source
     */
    public RecaptchaResponse(RecaptchaResponse source) {
        super();
        this.challengeTs = source.challengeTs;
        this.errorCodes = source.errorCodes;
        this.hostname = source.hostname;
        this.success = source.success;
    }

    /**
     * 
     * @param hostname
     * @param success
     * @param errorCodes
     * @param challengeTs
     */
    public RecaptchaResponse(String challengeTs, List<String> errorCodes, String hostname, Boolean success) {
        super();
        this.challengeTs = challengeTs;
        this.errorCodes = errorCodes;
        this.hostname = hostname;
        this.success = success;
    }

    @JsonProperty("challenge_ts")
    public Optional<String> getChallengeTs() {
        return Optional.ofNullable(challengeTs);
    }

    @JsonProperty("challenge_ts")
    public void setChallengeTs(String challengeTs) {
        this.challengeTs = challengeTs;
    }

    public RecaptchaResponse withChallengeTs(String challengeTs) {
        this.challengeTs = challengeTs;
        return this;
    }

    @JsonProperty("error-codes")
    public Optional<List<String>> getErrorCodes() {
        return Optional.ofNullable(errorCodes);
    }

    @JsonProperty("error-codes")
    public void setErrorCodes(List<String> errorCodes) {
        this.errorCodes = errorCodes;
    }

    public RecaptchaResponse withErrorCodes(List<String> errorCodes) {
        this.errorCodes = errorCodes;
        return this;
    }

    @JsonProperty("hostname")
    public Optional<String> getHostname() {
        return Optional.ofNullable(hostname);
    }

    @JsonProperty("hostname")
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public RecaptchaResponse withHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    @JsonProperty("success")
    public Optional<Boolean> getSuccess() {
        return Optional.ofNullable(success);
    }

    @JsonProperty("success")
    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public RecaptchaResponse withSuccess(Boolean success) {
        this.success = success;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public RecaptchaResponse withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "challenge_ts":
                if (value instanceof String) {
                    setChallengeTs(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"challenge_ts\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "error-codes":
                if (value instanceof List) {
                    setErrorCodes(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"error-codes\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "hostname":
                if (value instanceof String) {
                    setHostname(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"hostname\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "success":
                if (value instanceof Boolean) {
                    setSuccess(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"success\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "challenge_ts":
                return getChallengeTs();
            case "error-codes":
                return getErrorCodes();
            case "hostname":
                return getHostname();
            case "success":
                return getSuccess();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, RecaptchaResponse.NOT_FOUND_VALUE);
        if (RecaptchaResponse.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public RecaptchaResponse with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(RecaptchaResponse.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("challengeTs");
        sb.append('=');
        sb.append(((this.challengeTs == null)?"<null>":this.challengeTs));
        sb.append(',');
        sb.append("errorCodes");
        sb.append('=');
        sb.append(((this.errorCodes == null)?"<null>":this.errorCodes));
        sb.append(',');
        sb.append("hostname");
        sb.append('=');
        sb.append(((this.hostname == null)?"<null>":this.hostname));
        sb.append(',');
        sb.append("success");
        sb.append('=');
        sb.append(((this.success == null)?"<null>":this.success));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.hostname == null)? 0 :this.hostname.hashCode()));
        result = ((result* 31)+((this.success == null)? 0 :this.success.hashCode()));
        result = ((result* 31)+((this.errorCodes == null)? 0 :this.errorCodes.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.challengeTs == null)? 0 :this.challengeTs.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof RecaptchaResponse) == false) {
            return false;
        }
        RecaptchaResponse rhs = ((RecaptchaResponse) other);
        return ((((((this.hostname == rhs.hostname)||((this.hostname!= null)&&this.hostname.equals(rhs.hostname)))&&((this.success == rhs.success)||((this.success!= null)&&this.success.equals(rhs.success))))&&((this.errorCodes == rhs.errorCodes)||((this.errorCodes!= null)&&this.errorCodes.equals(rhs.errorCodes))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.challengeTs == rhs.challengeTs)||((this.challengeTs!= null)&&this.challengeTs.equals(rhs.challengeTs))));
    }

}
