
package org.hisp.dhis.api.model.v2_36_11;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "auditType",
    "created",
    "dataElement",
    "modifiedBy",
    "programStageInstance",
    "providedElsewhere",
    "value"
})
@Generated("jsonschema2pojo")
public class TrackedEntityDataValueAudit implements Serializable
{

    @JsonProperty("auditType")
    private AuditType auditType;
    @JsonProperty("created")
    private Date created;
    @JsonProperty("dataElement")
    private DataElement dataElement;
    @JsonProperty("modifiedBy")
    private String modifiedBy;
    @JsonProperty("programStageInstance")
    private ProgramStageInstance programStageInstance;
    @JsonProperty("providedElsewhere")
    private Boolean providedElsewhere;
    @JsonProperty("value")
    private String value;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 3325395791916519674L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TrackedEntityDataValueAudit() {
    }

    /**
     * 
     * @param source
     */
    public TrackedEntityDataValueAudit(TrackedEntityDataValueAudit source) {
        super();
        this.auditType = source.auditType;
        this.created = source.created;
        this.dataElement = source.dataElement;
        this.modifiedBy = source.modifiedBy;
        this.programStageInstance = source.programStageInstance;
        this.providedElsewhere = source.providedElsewhere;
        this.value = source.value;
    }

    /**
     * 
     * @param programStageInstance
     * @param created
     * @param modifiedBy
     * @param auditType
     * @param dataElement
     * @param value
     * @param providedElsewhere
     */
    public TrackedEntityDataValueAudit(AuditType auditType, Date created, DataElement dataElement, String modifiedBy, ProgramStageInstance programStageInstance, Boolean providedElsewhere, String value) {
        super();
        this.auditType = auditType;
        this.created = created;
        this.dataElement = dataElement;
        this.modifiedBy = modifiedBy;
        this.programStageInstance = programStageInstance;
        this.providedElsewhere = providedElsewhere;
        this.value = value;
    }

    @JsonProperty("auditType")
    public Optional<AuditType> getAuditType() {
        return Optional.ofNullable(auditType);
    }

    @JsonProperty("auditType")
    public void setAuditType(AuditType auditType) {
        this.auditType = auditType;
    }

    public TrackedEntityDataValueAudit withAuditType(AuditType auditType) {
        this.auditType = auditType;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public TrackedEntityDataValueAudit withCreated(Date created) {
        this.created = created;
        return this;
    }

    @JsonProperty("dataElement")
    public Optional<DataElement> getDataElement() {
        return Optional.ofNullable(dataElement);
    }

    @JsonProperty("dataElement")
    public void setDataElement(DataElement dataElement) {
        this.dataElement = dataElement;
    }

    public TrackedEntityDataValueAudit withDataElement(DataElement dataElement) {
        this.dataElement = dataElement;
        return this;
    }

    @JsonProperty("modifiedBy")
    public Optional<String> getModifiedBy() {
        return Optional.ofNullable(modifiedBy);
    }

    @JsonProperty("modifiedBy")
    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public TrackedEntityDataValueAudit withModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
        return this;
    }

    @JsonProperty("programStageInstance")
    public Optional<ProgramStageInstance> getProgramStageInstance() {
        return Optional.ofNullable(programStageInstance);
    }

    @JsonProperty("programStageInstance")
    public void setProgramStageInstance(ProgramStageInstance programStageInstance) {
        this.programStageInstance = programStageInstance;
    }

    public TrackedEntityDataValueAudit withProgramStageInstance(ProgramStageInstance programStageInstance) {
        this.programStageInstance = programStageInstance;
        return this;
    }

    @JsonProperty("providedElsewhere")
    public Optional<Boolean> getProvidedElsewhere() {
        return Optional.ofNullable(providedElsewhere);
    }

    @JsonProperty("providedElsewhere")
    public void setProvidedElsewhere(Boolean providedElsewhere) {
        this.providedElsewhere = providedElsewhere;
    }

    public TrackedEntityDataValueAudit withProvidedElsewhere(Boolean providedElsewhere) {
        this.providedElsewhere = providedElsewhere;
        return this;
    }

    @JsonProperty("value")
    public Optional<String> getValue() {
        return Optional.ofNullable(value);
    }

    @JsonProperty("value")
    public void setValue(String value) {
        this.value = value;
    }

    public TrackedEntityDataValueAudit withValue(String value) {
        this.value = value;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public TrackedEntityDataValueAudit withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "auditType":
                if (value instanceof AuditType) {
                    setAuditType(((AuditType) value));
                } else {
                    throw new IllegalArgumentException(("property \"auditType\" is of type \"org.hisp.dhis.api.model.v2_36_11.AuditType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "created":
                if (value instanceof Date) {
                    setCreated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataElement":
                if (value instanceof DataElement) {
                    setDataElement(((DataElement) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataElement\" is of type \"org.hisp.dhis.api.model.v2_36_11.DataElement\", but got "+ value.getClass().toString()));
                }
                return true;
            case "modifiedBy":
                if (value instanceof String) {
                    setModifiedBy(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"modifiedBy\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "programStageInstance":
                if (value instanceof ProgramStageInstance) {
                    setProgramStageInstance(((ProgramStageInstance) value));
                } else {
                    throw new IllegalArgumentException(("property \"programStageInstance\" is of type \"org.hisp.dhis.api.model.v2_36_11.ProgramStageInstance\", but got "+ value.getClass().toString()));
                }
                return true;
            case "providedElsewhere":
                if (value instanceof Boolean) {
                    setProvidedElsewhere(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"providedElsewhere\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "value":
                if (value instanceof String) {
                    setValue(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"value\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "auditType":
                return getAuditType();
            case "created":
                return getCreated();
            case "dataElement":
                return getDataElement();
            case "modifiedBy":
                return getModifiedBy();
            case "programStageInstance":
                return getProgramStageInstance();
            case "providedElsewhere":
                return getProvidedElsewhere();
            case "value":
                return getValue();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, TrackedEntityDataValueAudit.NOT_FOUND_VALUE);
        if (TrackedEntityDataValueAudit.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public TrackedEntityDataValueAudit with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TrackedEntityDataValueAudit.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("auditType");
        sb.append('=');
        sb.append(((this.auditType == null)?"<null>":this.auditType));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("dataElement");
        sb.append('=');
        sb.append(((this.dataElement == null)?"<null>":this.dataElement));
        sb.append(',');
        sb.append("modifiedBy");
        sb.append('=');
        sb.append(((this.modifiedBy == null)?"<null>":this.modifiedBy));
        sb.append(',');
        sb.append("programStageInstance");
        sb.append('=');
        sb.append(((this.programStageInstance == null)?"<null>":this.programStageInstance));
        sb.append(',');
        sb.append("providedElsewhere");
        sb.append('=');
        sb.append(((this.providedElsewhere == null)?"<null>":this.providedElsewhere));
        sb.append(',');
        sb.append("value");
        sb.append('=');
        sb.append(((this.value == null)?"<null>":this.value));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.programStageInstance == null)? 0 :this.programStageInstance.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.modifiedBy == null)? 0 :this.modifiedBy.hashCode()));
        result = ((result* 31)+((this.auditType == null)? 0 :this.auditType.hashCode()));
        result = ((result* 31)+((this.dataElement == null)? 0 :this.dataElement.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.value == null)? 0 :this.value.hashCode()));
        result = ((result* 31)+((this.providedElsewhere == null)? 0 :this.providedElsewhere.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TrackedEntityDataValueAudit) == false) {
            return false;
        }
        TrackedEntityDataValueAudit rhs = ((TrackedEntityDataValueAudit) other);
        return (((((((((this.programStageInstance == rhs.programStageInstance)||((this.programStageInstance!= null)&&this.programStageInstance.equals(rhs.programStageInstance)))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.modifiedBy == rhs.modifiedBy)||((this.modifiedBy!= null)&&this.modifiedBy.equals(rhs.modifiedBy))))&&((this.auditType == rhs.auditType)||((this.auditType!= null)&&this.auditType.equals(rhs.auditType))))&&((this.dataElement == rhs.dataElement)||((this.dataElement!= null)&&this.dataElement.equals(rhs.dataElement))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.value == rhs.value)||((this.value!= null)&&this.value.equals(rhs.value))))&&((this.providedElsewhere == rhs.providedElsewhere)||((this.providedElsewhere!= null)&&this.providedElsewhere.equals(rhs.providedElsewhere))));
    }

}
