
package org.hisp.dhis.api.model.v2_37_7;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "content",
    "to"
})
@Generated("jsonschema2pojo")
public class ClickatellRequestEntity implements Serializable
{

    @JsonProperty("content")
    private String content;
    @JsonProperty("to")
    private List<String> to = null;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 3571451515153018725L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ClickatellRequestEntity() {
    }

    /**
     * 
     * @param source
     */
    public ClickatellRequestEntity(ClickatellRequestEntity source) {
        super();
        this.content = source.content;
        this.to = source.to;
    }

    /**
     * 
     * @param to
     * @param content
     */
    public ClickatellRequestEntity(String content, List<String> to) {
        super();
        this.content = content;
        this.to = to;
    }

    @JsonProperty("content")
    public Optional<String> getContent() {
        return Optional.ofNullable(content);
    }

    @JsonProperty("content")
    public void setContent(String content) {
        this.content = content;
    }

    public ClickatellRequestEntity withContent(String content) {
        this.content = content;
        return this;
    }

    @JsonProperty("to")
    public Optional<List<String>> getTo() {
        return Optional.ofNullable(to);
    }

    @JsonProperty("to")
    public void setTo(List<String> to) {
        this.to = to;
    }

    public ClickatellRequestEntity withTo(List<String> to) {
        this.to = to;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ClickatellRequestEntity withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "content":
                if (value instanceof String) {
                    setContent(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"content\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "to":
                if (value instanceof List) {
                    setTo(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"to\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "content":
                return getContent();
            case "to":
                return getTo();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ClickatellRequestEntity.NOT_FOUND_VALUE);
        if (ClickatellRequestEntity.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ClickatellRequestEntity with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ClickatellRequestEntity.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("content");
        sb.append('=');
        sb.append(((this.content == null)?"<null>":this.content));
        sb.append(',');
        sb.append("to");
        sb.append('=');
        sb.append(((this.to == null)?"<null>":this.to));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.to == null)? 0 :this.to.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.content == null)? 0 :this.content.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ClickatellRequestEntity) == false) {
            return false;
        }
        ClickatellRequestEntity rhs = ((ClickatellRequestEntity) other);
        return ((((this.to == rhs.to)||((this.to!= null)&&this.to.equals(rhs.to)))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.content == rhs.content)||((this.content!= null)&&this.content.equals(rhs.content))));
    }

}
