
package org.hisp.dhis.api.model.v2_37_7;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "aggregationType",
    "attributeValues",
    "categoryCombo",
    "code",
    "compulsoryDataElementOperands",
    "compulsoryFieldsCompleteOnly",
    "created",
    "createdBy",
    "dataElementDecoration",
    "dataEntryForm",
    "dataInputPeriods",
    "dataSetElements",
    "description",
    "dimensionItem",
    "dimensionItemType",
    "displayDescription",
    "displayFormName",
    "displayName",
    "displayShortName",
    "expiryDays",
    "externalAccess",
    "favorite",
    "favorites",
    "fieldCombinationRequired",
    "formName",
    "formType",
    "href",
    "id",
    "indicators",
    "interpretations",
    "lastUpdated",
    "lastUpdatedBy",
    "legendSet",
    "legendSets",
    "mobile",
    "name",
    "noValueRequiresComment",
    "notificationRecipients",
    "notifyCompletingUser",
    "openFuturePeriods",
    "openPeriodsAfterCoEndDate",
    "organisationUnits",
    "periodOffset",
    "periodType",
    "publicAccess",
    "renderAsTabs",
    "renderHorizontally",
    "sections",
    "sharing",
    "shortName",
    "skipOffline",
    "style",
    "timelyDays",
    "translations",
    "user",
    "userAccesses",
    "userGroupAccesses",
    "validCompleteOnly",
    "version",
    "workflow"
})
@Generated("jsonschema2pojo")
public class DataSet implements Serializable
{

    @JsonProperty("access")
    private Access access;
    @JsonProperty("aggregationType")
    private AggregationType aggregationType;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues = null;
    @JsonProperty("categoryCombo")
    private CategoryCombo categoryCombo;
    @JsonProperty("code")
    private String code;
    @JsonProperty("compulsoryDataElementOperands")
    private List<DataElementOperand> compulsoryDataElementOperands = null;
    @JsonProperty("compulsoryFieldsCompleteOnly")
    private Boolean compulsoryFieldsCompleteOnly;
    @JsonProperty("created")
    private Date created;
    @JsonProperty("createdBy")
    private User createdBy;
    @JsonProperty("dataElementDecoration")
    private Boolean dataElementDecoration;
    @JsonProperty("dataEntryForm")
    private DataEntryForm dataEntryForm;
    @JsonProperty("dataInputPeriods")
    private List<DataInputPeriod> dataInputPeriods = null;
    @JsonProperty("dataSetElements")
    private List<DataSetElement> dataSetElements = null;
    @JsonProperty("description")
    private String description;
    @JsonProperty("dimensionItem")
    private String dimensionItem;
    @JsonProperty("dimensionItemType")
    private org.hisp.dhis.api.model.v2_37_7.CategoryOptionCombo.DimensionItemType dimensionItemType;
    @JsonProperty("displayDescription")
    private String displayDescription;
    @JsonProperty("displayFormName")
    private String displayFormName;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("displayShortName")
    private String displayShortName;
    @JsonProperty("expiryDays")
    private Integer expiryDays;
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites = null;
    @JsonProperty("fieldCombinationRequired")
    private Boolean fieldCombinationRequired;
    @JsonProperty("formName")
    private String formName;
    @JsonProperty("formType")
    private org.hisp.dhis.api.model.v2_37_7.ProgramStage.FormType formType;
    @JsonProperty("href")
    private String href;
    @JsonProperty("id")
    private String id;
    @JsonProperty("indicators")
    private List<Indicator> indicators = null;
    @JsonProperty("interpretations")
    private List<Interpretation> interpretations = null;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    @JsonProperty("lastUpdatedBy")
    private User lastUpdatedBy;
    @JsonProperty("legendSet")
    private LegendSet legendSet;
    @JsonProperty("legendSets")
    private List<LegendSet> legendSets = null;
    @JsonProperty("mobile")
    private Boolean mobile;
    @JsonProperty("name")
    private String name;
    @JsonProperty("noValueRequiresComment")
    private Boolean noValueRequiresComment;
    @JsonProperty("notificationRecipients")
    private UserGroup notificationRecipients;
    @JsonProperty("notifyCompletingUser")
    private Boolean notifyCompletingUser;
    @JsonProperty("openFuturePeriods")
    private Integer openFuturePeriods;
    @JsonProperty("openPeriodsAfterCoEndDate")
    private Integer openPeriodsAfterCoEndDate;
    @JsonProperty("organisationUnits")
    private List<OrganisationUnit> organisationUnits = null;
    @JsonProperty("periodOffset")
    private Integer periodOffset;
    /**
     * Undefined
     * 
     */
    @JsonProperty("periodType")
    private Object periodType;
    @JsonProperty("publicAccess")
    private String publicAccess;
    @JsonProperty("renderAsTabs")
    private Boolean renderAsTabs;
    @JsonProperty("renderHorizontally")
    private Boolean renderHorizontally;
    @JsonProperty("sections")
    private List<Section> sections = null;
    @JsonProperty("sharing")
    private Sharing sharing;
    @JsonProperty("shortName")
    private String shortName;
    @JsonProperty("skipOffline")
    private Boolean skipOffline;
    @JsonProperty("style")
    private ObjectStyle style;
    @JsonProperty("timelyDays")
    private Integer timelyDays;
    @JsonProperty("translations")
    private List<Translation> translations = null;
    @JsonProperty("user")
    private User user;
    @JsonProperty("userAccesses")
    private List<UserAccess> userAccesses = null;
    @JsonProperty("userGroupAccesses")
    private List<UserGroupAccess> userGroupAccesses = null;
    @JsonProperty("validCompleteOnly")
    private Boolean validCompleteOnly;
    @JsonProperty("version")
    private Integer version;
    @JsonProperty("workflow")
    private DataApprovalWorkflow workflow;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 938478187520571568L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DataSet() {
    }

    /**
     * 
     * @param source
     */
    public DataSet(DataSet source) {
        super();
        this.access = source.access;
        this.aggregationType = source.aggregationType;
        this.attributeValues = source.attributeValues;
        this.categoryCombo = source.categoryCombo;
        this.code = source.code;
        this.compulsoryDataElementOperands = source.compulsoryDataElementOperands;
        this.compulsoryFieldsCompleteOnly = source.compulsoryFieldsCompleteOnly;
        this.created = source.created;
        this.createdBy = source.createdBy;
        this.dataElementDecoration = source.dataElementDecoration;
        this.dataEntryForm = source.dataEntryForm;
        this.dataInputPeriods = source.dataInputPeriods;
        this.dataSetElements = source.dataSetElements;
        this.description = source.description;
        this.dimensionItem = source.dimensionItem;
        this.dimensionItemType = source.dimensionItemType;
        this.displayDescription = source.displayDescription;
        this.displayFormName = source.displayFormName;
        this.displayName = source.displayName;
        this.displayShortName = source.displayShortName;
        this.expiryDays = source.expiryDays;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.fieldCombinationRequired = source.fieldCombinationRequired;
        this.formName = source.formName;
        this.formType = source.formType;
        this.href = source.href;
        this.id = source.id;
        this.indicators = source.indicators;
        this.interpretations = source.interpretations;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.legendSet = source.legendSet;
        this.legendSets = source.legendSets;
        this.mobile = source.mobile;
        this.name = source.name;
        this.noValueRequiresComment = source.noValueRequiresComment;
        this.notificationRecipients = source.notificationRecipients;
        this.notifyCompletingUser = source.notifyCompletingUser;
        this.openFuturePeriods = source.openFuturePeriods;
        this.openPeriodsAfterCoEndDate = source.openPeriodsAfterCoEndDate;
        this.organisationUnits = source.organisationUnits;
        this.periodOffset = source.periodOffset;
        this.periodType = source.periodType;
        this.publicAccess = source.publicAccess;
        this.renderAsTabs = source.renderAsTabs;
        this.renderHorizontally = source.renderHorizontally;
        this.sections = source.sections;
        this.sharing = source.sharing;
        this.shortName = source.shortName;
        this.skipOffline = source.skipOffline;
        this.style = source.style;
        this.timelyDays = source.timelyDays;
        this.translations = source.translations;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userGroupAccesses = source.userGroupAccesses;
        this.validCompleteOnly = source.validCompleteOnly;
        this.version = source.version;
        this.workflow = source.workflow;
    }

    /**
     * 
     * @param dataEntryForm
     * @param validCompleteOnly
     * @param dataSetElements
     * @param publicAccess
     * @param skipOffline
     * @param compulsoryFieldsCompleteOnly
     * @param lastUpdated
     * @param categoryCombo
     * @param dataInputPeriods
     * @param translations
     * @param href
     * @param id
     * @param interpretations
     * @param displayDescription
     * @param lastUpdatedBy
     * @param formType
     * @param userGroupAccesses
     * @param workflow
     * @param created
     * @param attributeValues
     * @param indicators
     * @param sharing
     * @param displayFormName
     * @param version
     * @param sections
     * @param timelyDays
     * @param userAccesses
     * @param name
     * @param legendSets
     * @param notificationRecipients
     * @param style
     * @param shortName
     * @param favorite
     * @param dimensionItemType
     * @param favorites
     * @param aggregationType
     * @param access
     * @param code
     * @param dataElementDecoration
     * @param displayName
     * @param notifyCompletingUser
     * @param noValueRequiresComment
     * @param compulsoryDataElementOperands
     * @param description
     * @param displayShortName
     * @param externalAccess
     * @param fieldCombinationRequired
     * @param periodOffset
     * @param formName
     * @param organisationUnits
     * @param renderHorizontally
     * @param renderAsTabs
     * @param dimensionItem
     * @param mobile
     * @param openPeriodsAfterCoEndDate
     * @param periodType
     * @param createdBy
     * @param legendSet
     * @param openFuturePeriods
     * @param expiryDays
     * @param user
     */
    public DataSet(Access access, AggregationType aggregationType, List<AttributeValue> attributeValues, CategoryCombo categoryCombo, String code, List<DataElementOperand> compulsoryDataElementOperands, Boolean compulsoryFieldsCompleteOnly, Date created, User createdBy, Boolean dataElementDecoration, DataEntryForm dataEntryForm, List<DataInputPeriod> dataInputPeriods, List<DataSetElement> dataSetElements, String description, String dimensionItem, org.hisp.dhis.api.model.v2_37_7.CategoryOptionCombo.DimensionItemType dimensionItemType, String displayDescription, String displayFormName, String displayName, String displayShortName, Integer expiryDays, Boolean externalAccess, Boolean favorite, List<String> favorites, Boolean fieldCombinationRequired, String formName, org.hisp.dhis.api.model.v2_37_7.ProgramStage.FormType formType, String href, String id, List<Indicator> indicators, List<Interpretation> interpretations, Date lastUpdated, User lastUpdatedBy, LegendSet legendSet, List<LegendSet> legendSets, Boolean mobile, String name, Boolean noValueRequiresComment, UserGroup notificationRecipients, Boolean notifyCompletingUser, Integer openFuturePeriods, Integer openPeriodsAfterCoEndDate, List<OrganisationUnit> organisationUnits, Integer periodOffset, Object periodType, String publicAccess, Boolean renderAsTabs, Boolean renderHorizontally, List<Section> sections, Sharing sharing, String shortName, Boolean skipOffline, ObjectStyle style, Integer timelyDays, List<Translation> translations, User user, List<UserAccess> userAccesses, List<UserGroupAccess> userGroupAccesses, Boolean validCompleteOnly, Integer version, DataApprovalWorkflow workflow) {
        super();
        this.access = access;
        this.aggregationType = aggregationType;
        this.attributeValues = attributeValues;
        this.categoryCombo = categoryCombo;
        this.code = code;
        this.compulsoryDataElementOperands = compulsoryDataElementOperands;
        this.compulsoryFieldsCompleteOnly = compulsoryFieldsCompleteOnly;
        this.created = created;
        this.createdBy = createdBy;
        this.dataElementDecoration = dataElementDecoration;
        this.dataEntryForm = dataEntryForm;
        this.dataInputPeriods = dataInputPeriods;
        this.dataSetElements = dataSetElements;
        this.description = description;
        this.dimensionItem = dimensionItem;
        this.dimensionItemType = dimensionItemType;
        this.displayDescription = displayDescription;
        this.displayFormName = displayFormName;
        this.displayName = displayName;
        this.displayShortName = displayShortName;
        this.expiryDays = expiryDays;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.fieldCombinationRequired = fieldCombinationRequired;
        this.formName = formName;
        this.formType = formType;
        this.href = href;
        this.id = id;
        this.indicators = indicators;
        this.interpretations = interpretations;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.legendSet = legendSet;
        this.legendSets = legendSets;
        this.mobile = mobile;
        this.name = name;
        this.noValueRequiresComment = noValueRequiresComment;
        this.notificationRecipients = notificationRecipients;
        this.notifyCompletingUser = notifyCompletingUser;
        this.openFuturePeriods = openFuturePeriods;
        this.openPeriodsAfterCoEndDate = openPeriodsAfterCoEndDate;
        this.organisationUnits = organisationUnits;
        this.periodOffset = periodOffset;
        this.periodType = periodType;
        this.publicAccess = publicAccess;
        this.renderAsTabs = renderAsTabs;
        this.renderHorizontally = renderHorizontally;
        this.sections = sections;
        this.sharing = sharing;
        this.shortName = shortName;
        this.skipOffline = skipOffline;
        this.style = style;
        this.timelyDays = timelyDays;
        this.translations = translations;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userGroupAccesses = userGroupAccesses;
        this.validCompleteOnly = validCompleteOnly;
        this.version = version;
        this.workflow = workflow;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public DataSet withAccess(Access access) {
        this.access = access;
        return this;
    }

    @JsonProperty("aggregationType")
    public Optional<AggregationType> getAggregationType() {
        return Optional.ofNullable(aggregationType);
    }

    @JsonProperty("aggregationType")
    public void setAggregationType(AggregationType aggregationType) {
        this.aggregationType = aggregationType;
    }

    public DataSet withAggregationType(AggregationType aggregationType) {
        this.aggregationType = aggregationType;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public DataSet withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    @JsonProperty("categoryCombo")
    public Optional<CategoryCombo> getCategoryCombo() {
        return Optional.ofNullable(categoryCombo);
    }

    @JsonProperty("categoryCombo")
    public void setCategoryCombo(CategoryCombo categoryCombo) {
        this.categoryCombo = categoryCombo;
    }

    public DataSet withCategoryCombo(CategoryCombo categoryCombo) {
        this.categoryCombo = categoryCombo;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public DataSet withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("compulsoryDataElementOperands")
    public Optional<List<DataElementOperand>> getCompulsoryDataElementOperands() {
        return Optional.ofNullable(compulsoryDataElementOperands);
    }

    @JsonProperty("compulsoryDataElementOperands")
    public void setCompulsoryDataElementOperands(List<DataElementOperand> compulsoryDataElementOperands) {
        this.compulsoryDataElementOperands = compulsoryDataElementOperands;
    }

    public DataSet withCompulsoryDataElementOperands(List<DataElementOperand> compulsoryDataElementOperands) {
        this.compulsoryDataElementOperands = compulsoryDataElementOperands;
        return this;
    }

    @JsonProperty("compulsoryFieldsCompleteOnly")
    public Optional<Boolean> getCompulsoryFieldsCompleteOnly() {
        return Optional.ofNullable(compulsoryFieldsCompleteOnly);
    }

    @JsonProperty("compulsoryFieldsCompleteOnly")
    public void setCompulsoryFieldsCompleteOnly(Boolean compulsoryFieldsCompleteOnly) {
        this.compulsoryFieldsCompleteOnly = compulsoryFieldsCompleteOnly;
    }

    public DataSet withCompulsoryFieldsCompleteOnly(Boolean compulsoryFieldsCompleteOnly) {
        this.compulsoryFieldsCompleteOnly = compulsoryFieldsCompleteOnly;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public DataSet withCreated(Date created) {
        this.created = created;
        return this;
    }

    @JsonProperty("createdBy")
    public Optional<User> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    @JsonProperty("createdBy")
    public void setCreatedBy(User createdBy) {
        this.createdBy = createdBy;
    }

    public DataSet withCreatedBy(User createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @JsonProperty("dataElementDecoration")
    public Optional<Boolean> getDataElementDecoration() {
        return Optional.ofNullable(dataElementDecoration);
    }

    @JsonProperty("dataElementDecoration")
    public void setDataElementDecoration(Boolean dataElementDecoration) {
        this.dataElementDecoration = dataElementDecoration;
    }

    public DataSet withDataElementDecoration(Boolean dataElementDecoration) {
        this.dataElementDecoration = dataElementDecoration;
        return this;
    }

    @JsonProperty("dataEntryForm")
    public Optional<DataEntryForm> getDataEntryForm() {
        return Optional.ofNullable(dataEntryForm);
    }

    @JsonProperty("dataEntryForm")
    public void setDataEntryForm(DataEntryForm dataEntryForm) {
        this.dataEntryForm = dataEntryForm;
    }

    public DataSet withDataEntryForm(DataEntryForm dataEntryForm) {
        this.dataEntryForm = dataEntryForm;
        return this;
    }

    @JsonProperty("dataInputPeriods")
    public Optional<List<DataInputPeriod>> getDataInputPeriods() {
        return Optional.ofNullable(dataInputPeriods);
    }

    @JsonProperty("dataInputPeriods")
    public void setDataInputPeriods(List<DataInputPeriod> dataInputPeriods) {
        this.dataInputPeriods = dataInputPeriods;
    }

    public DataSet withDataInputPeriods(List<DataInputPeriod> dataInputPeriods) {
        this.dataInputPeriods = dataInputPeriods;
        return this;
    }

    @JsonProperty("dataSetElements")
    public Optional<List<DataSetElement>> getDataSetElements() {
        return Optional.ofNullable(dataSetElements);
    }

    @JsonProperty("dataSetElements")
    public void setDataSetElements(List<DataSetElement> dataSetElements) {
        this.dataSetElements = dataSetElements;
    }

    public DataSet withDataSetElements(List<DataSetElement> dataSetElements) {
        this.dataSetElements = dataSetElements;
        return this;
    }

    @JsonProperty("description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    public DataSet withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty("dimensionItem")
    public Optional<String> getDimensionItem() {
        return Optional.ofNullable(dimensionItem);
    }

    @JsonProperty("dimensionItem")
    public void setDimensionItem(String dimensionItem) {
        this.dimensionItem = dimensionItem;
    }

    public DataSet withDimensionItem(String dimensionItem) {
        this.dimensionItem = dimensionItem;
        return this;
    }

    @JsonProperty("dimensionItemType")
    public Optional<org.hisp.dhis.api.model.v2_37_7.CategoryOptionCombo.DimensionItemType> getDimensionItemType() {
        return Optional.ofNullable(dimensionItemType);
    }

    @JsonProperty("dimensionItemType")
    public void setDimensionItemType(org.hisp.dhis.api.model.v2_37_7.CategoryOptionCombo.DimensionItemType dimensionItemType) {
        this.dimensionItemType = dimensionItemType;
    }

    public DataSet withDimensionItemType(org.hisp.dhis.api.model.v2_37_7.CategoryOptionCombo.DimensionItemType dimensionItemType) {
        this.dimensionItemType = dimensionItemType;
        return this;
    }

    @JsonProperty("displayDescription")
    public Optional<String> getDisplayDescription() {
        return Optional.ofNullable(displayDescription);
    }

    @JsonProperty("displayDescription")
    public void setDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
    }

    public DataSet withDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
        return this;
    }

    @JsonProperty("displayFormName")
    public Optional<String> getDisplayFormName() {
        return Optional.ofNullable(displayFormName);
    }

    @JsonProperty("displayFormName")
    public void setDisplayFormName(String displayFormName) {
        this.displayFormName = displayFormName;
    }

    public DataSet withDisplayFormName(String displayFormName) {
        this.displayFormName = displayFormName;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public DataSet withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("displayShortName")
    public Optional<String> getDisplayShortName() {
        return Optional.ofNullable(displayShortName);
    }

    @JsonProperty("displayShortName")
    public void setDisplayShortName(String displayShortName) {
        this.displayShortName = displayShortName;
    }

    public DataSet withDisplayShortName(String displayShortName) {
        this.displayShortName = displayShortName;
        return this;
    }

    @JsonProperty("expiryDays")
    public Optional<Integer> getExpiryDays() {
        return Optional.ofNullable(expiryDays);
    }

    @JsonProperty("expiryDays")
    public void setExpiryDays(Integer expiryDays) {
        this.expiryDays = expiryDays;
    }

    public DataSet withExpiryDays(Integer expiryDays) {
        this.expiryDays = expiryDays;
        return this;
    }

    @JsonProperty("externalAccess")
    public Optional<Boolean> getExternalAccess() {
        return Optional.ofNullable(externalAccess);
    }

    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public DataSet withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    @JsonProperty("favorite")
    public Optional<Boolean> getFavorite() {
        return Optional.ofNullable(favorite);
    }

    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public DataSet withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public DataSet withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @JsonProperty("fieldCombinationRequired")
    public Optional<Boolean> getFieldCombinationRequired() {
        return Optional.ofNullable(fieldCombinationRequired);
    }

    @JsonProperty("fieldCombinationRequired")
    public void setFieldCombinationRequired(Boolean fieldCombinationRequired) {
        this.fieldCombinationRequired = fieldCombinationRequired;
    }

    public DataSet withFieldCombinationRequired(Boolean fieldCombinationRequired) {
        this.fieldCombinationRequired = fieldCombinationRequired;
        return this;
    }

    @JsonProperty("formName")
    public Optional<String> getFormName() {
        return Optional.ofNullable(formName);
    }

    @JsonProperty("formName")
    public void setFormName(String formName) {
        this.formName = formName;
    }

    public DataSet withFormName(String formName) {
        this.formName = formName;
        return this;
    }

    @JsonProperty("formType")
    public Optional<org.hisp.dhis.api.model.v2_37_7.ProgramStage.FormType> getFormType() {
        return Optional.ofNullable(formType);
    }

    @JsonProperty("formType")
    public void setFormType(org.hisp.dhis.api.model.v2_37_7.ProgramStage.FormType formType) {
        this.formType = formType;
    }

    public DataSet withFormType(org.hisp.dhis.api.model.v2_37_7.ProgramStage.FormType formType) {
        this.formType = formType;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public DataSet withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public DataSet withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("indicators")
    public Optional<List<Indicator>> getIndicators() {
        return Optional.ofNullable(indicators);
    }

    @JsonProperty("indicators")
    public void setIndicators(List<Indicator> indicators) {
        this.indicators = indicators;
    }

    public DataSet withIndicators(List<Indicator> indicators) {
        this.indicators = indicators;
        return this;
    }

    @JsonProperty("interpretations")
    public Optional<List<Interpretation>> getInterpretations() {
        return Optional.ofNullable(interpretations);
    }

    @JsonProperty("interpretations")
    public void setInterpretations(List<Interpretation> interpretations) {
        this.interpretations = interpretations;
    }

    public DataSet withInterpretations(List<Interpretation> interpretations) {
        this.interpretations = interpretations;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public DataSet withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @JsonProperty("lastUpdatedBy")
    public Optional<User> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public DataSet withLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    @JsonProperty("legendSet")
    public Optional<LegendSet> getLegendSet() {
        return Optional.ofNullable(legendSet);
    }

    @JsonProperty("legendSet")
    public void setLegendSet(LegendSet legendSet) {
        this.legendSet = legendSet;
    }

    public DataSet withLegendSet(LegendSet legendSet) {
        this.legendSet = legendSet;
        return this;
    }

    @JsonProperty("legendSets")
    public Optional<List<LegendSet>> getLegendSets() {
        return Optional.ofNullable(legendSets);
    }

    @JsonProperty("legendSets")
    public void setLegendSets(List<LegendSet> legendSets) {
        this.legendSets = legendSets;
    }

    public DataSet withLegendSets(List<LegendSet> legendSets) {
        this.legendSets = legendSets;
        return this;
    }

    @JsonProperty("mobile")
    public Optional<Boolean> getMobile() {
        return Optional.ofNullable(mobile);
    }

    @JsonProperty("mobile")
    public void setMobile(Boolean mobile) {
        this.mobile = mobile;
    }

    public DataSet withMobile(Boolean mobile) {
        this.mobile = mobile;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public DataSet withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("noValueRequiresComment")
    public Optional<Boolean> getNoValueRequiresComment() {
        return Optional.ofNullable(noValueRequiresComment);
    }

    @JsonProperty("noValueRequiresComment")
    public void setNoValueRequiresComment(Boolean noValueRequiresComment) {
        this.noValueRequiresComment = noValueRequiresComment;
    }

    public DataSet withNoValueRequiresComment(Boolean noValueRequiresComment) {
        this.noValueRequiresComment = noValueRequiresComment;
        return this;
    }

    @JsonProperty("notificationRecipients")
    public Optional<UserGroup> getNotificationRecipients() {
        return Optional.ofNullable(notificationRecipients);
    }

    @JsonProperty("notificationRecipients")
    public void setNotificationRecipients(UserGroup notificationRecipients) {
        this.notificationRecipients = notificationRecipients;
    }

    public DataSet withNotificationRecipients(UserGroup notificationRecipients) {
        this.notificationRecipients = notificationRecipients;
        return this;
    }

    @JsonProperty("notifyCompletingUser")
    public Optional<Boolean> getNotifyCompletingUser() {
        return Optional.ofNullable(notifyCompletingUser);
    }

    @JsonProperty("notifyCompletingUser")
    public void setNotifyCompletingUser(Boolean notifyCompletingUser) {
        this.notifyCompletingUser = notifyCompletingUser;
    }

    public DataSet withNotifyCompletingUser(Boolean notifyCompletingUser) {
        this.notifyCompletingUser = notifyCompletingUser;
        return this;
    }

    @JsonProperty("openFuturePeriods")
    public Optional<Integer> getOpenFuturePeriods() {
        return Optional.ofNullable(openFuturePeriods);
    }

    @JsonProperty("openFuturePeriods")
    public void setOpenFuturePeriods(Integer openFuturePeriods) {
        this.openFuturePeriods = openFuturePeriods;
    }

    public DataSet withOpenFuturePeriods(Integer openFuturePeriods) {
        this.openFuturePeriods = openFuturePeriods;
        return this;
    }

    @JsonProperty("openPeriodsAfterCoEndDate")
    public Optional<Integer> getOpenPeriodsAfterCoEndDate() {
        return Optional.ofNullable(openPeriodsAfterCoEndDate);
    }

    @JsonProperty("openPeriodsAfterCoEndDate")
    public void setOpenPeriodsAfterCoEndDate(Integer openPeriodsAfterCoEndDate) {
        this.openPeriodsAfterCoEndDate = openPeriodsAfterCoEndDate;
    }

    public DataSet withOpenPeriodsAfterCoEndDate(Integer openPeriodsAfterCoEndDate) {
        this.openPeriodsAfterCoEndDate = openPeriodsAfterCoEndDate;
        return this;
    }

    @JsonProperty("organisationUnits")
    public Optional<List<OrganisationUnit>> getOrganisationUnits() {
        return Optional.ofNullable(organisationUnits);
    }

    @JsonProperty("organisationUnits")
    public void setOrganisationUnits(List<OrganisationUnit> organisationUnits) {
        this.organisationUnits = organisationUnits;
    }

    public DataSet withOrganisationUnits(List<OrganisationUnit> organisationUnits) {
        this.organisationUnits = organisationUnits;
        return this;
    }

    @JsonProperty("periodOffset")
    public Optional<Integer> getPeriodOffset() {
        return Optional.ofNullable(periodOffset);
    }

    @JsonProperty("periodOffset")
    public void setPeriodOffset(Integer periodOffset) {
        this.periodOffset = periodOffset;
    }

    public DataSet withPeriodOffset(Integer periodOffset) {
        this.periodOffset = periodOffset;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("periodType")
    public Optional<Object> getPeriodType() {
        return Optional.ofNullable(periodType);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("periodType")
    public void setPeriodType(Object periodType) {
        this.periodType = periodType;
    }

    public DataSet withPeriodType(Object periodType) {
        this.periodType = periodType;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public DataSet withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    @JsonProperty("renderAsTabs")
    public Optional<Boolean> getRenderAsTabs() {
        return Optional.ofNullable(renderAsTabs);
    }

    @JsonProperty("renderAsTabs")
    public void setRenderAsTabs(Boolean renderAsTabs) {
        this.renderAsTabs = renderAsTabs;
    }

    public DataSet withRenderAsTabs(Boolean renderAsTabs) {
        this.renderAsTabs = renderAsTabs;
        return this;
    }

    @JsonProperty("renderHorizontally")
    public Optional<Boolean> getRenderHorizontally() {
        return Optional.ofNullable(renderHorizontally);
    }

    @JsonProperty("renderHorizontally")
    public void setRenderHorizontally(Boolean renderHorizontally) {
        this.renderHorizontally = renderHorizontally;
    }

    public DataSet withRenderHorizontally(Boolean renderHorizontally) {
        this.renderHorizontally = renderHorizontally;
        return this;
    }

    @JsonProperty("sections")
    public Optional<List<Section>> getSections() {
        return Optional.ofNullable(sections);
    }

    @JsonProperty("sections")
    public void setSections(List<Section> sections) {
        this.sections = sections;
    }

    public DataSet withSections(List<Section> sections) {
        this.sections = sections;
        return this;
    }

    @JsonProperty("sharing")
    public Optional<Sharing> getSharing() {
        return Optional.ofNullable(sharing);
    }

    @JsonProperty("sharing")
    public void setSharing(Sharing sharing) {
        this.sharing = sharing;
    }

    public DataSet withSharing(Sharing sharing) {
        this.sharing = sharing;
        return this;
    }

    @JsonProperty("shortName")
    public Optional<String> getShortName() {
        return Optional.ofNullable(shortName);
    }

    @JsonProperty("shortName")
    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public DataSet withShortName(String shortName) {
        this.shortName = shortName;
        return this;
    }

    @JsonProperty("skipOffline")
    public Optional<Boolean> getSkipOffline() {
        return Optional.ofNullable(skipOffline);
    }

    @JsonProperty("skipOffline")
    public void setSkipOffline(Boolean skipOffline) {
        this.skipOffline = skipOffline;
    }

    public DataSet withSkipOffline(Boolean skipOffline) {
        this.skipOffline = skipOffline;
        return this;
    }

    @JsonProperty("style")
    public Optional<ObjectStyle> getStyle() {
        return Optional.ofNullable(style);
    }

    @JsonProperty("style")
    public void setStyle(ObjectStyle style) {
        this.style = style;
    }

    public DataSet withStyle(ObjectStyle style) {
        this.style = style;
        return this;
    }

    @JsonProperty("timelyDays")
    public Optional<Integer> getTimelyDays() {
        return Optional.ofNullable(timelyDays);
    }

    @JsonProperty("timelyDays")
    public void setTimelyDays(Integer timelyDays) {
        this.timelyDays = timelyDays;
    }

    public DataSet withTimelyDays(Integer timelyDays) {
        this.timelyDays = timelyDays;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public DataSet withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    @JsonProperty("user")
    public Optional<User> getUser() {
        return Optional.ofNullable(user);
    }

    @JsonProperty("user")
    public void setUser(User user) {
        this.user = user;
    }

    public DataSet withUser(User user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<UserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public DataSet withUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<UserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public DataSet withUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    @JsonProperty("validCompleteOnly")
    public Optional<Boolean> getValidCompleteOnly() {
        return Optional.ofNullable(validCompleteOnly);
    }

    @JsonProperty("validCompleteOnly")
    public void setValidCompleteOnly(Boolean validCompleteOnly) {
        this.validCompleteOnly = validCompleteOnly;
    }

    public DataSet withValidCompleteOnly(Boolean validCompleteOnly) {
        this.validCompleteOnly = validCompleteOnly;
        return this;
    }

    @JsonProperty("version")
    public Optional<Integer> getVersion() {
        return Optional.ofNullable(version);
    }

    @JsonProperty("version")
    public void setVersion(Integer version) {
        this.version = version;
    }

    public DataSet withVersion(Integer version) {
        this.version = version;
        return this;
    }

    @JsonProperty("workflow")
    public Optional<DataApprovalWorkflow> getWorkflow() {
        return Optional.ofNullable(workflow);
    }

    @JsonProperty("workflow")
    public void setWorkflow(DataApprovalWorkflow workflow) {
        this.workflow = workflow;
    }

    public DataSet withWorkflow(DataApprovalWorkflow workflow) {
        this.workflow = workflow;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public DataSet withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "access":
                if (value instanceof Access) {
                    setAccess(((Access) value));
                } else {
                    throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v2_37_7.Access\", but got "+ value.getClass().toString()));
                }
                return true;
            case "aggregationType":
                if (value instanceof AggregationType) {
                    setAggregationType(((AggregationType) value));
                } else {
                    throw new IllegalArgumentException(("property \"aggregationType\" is of type \"org.hisp.dhis.api.model.v2_37_7.AggregationType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "attributeValues":
                if (value instanceof List) {
                    setAttributeValues(((List<AttributeValue> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.AttributeValue>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "categoryCombo":
                if (value instanceof CategoryCombo) {
                    setCategoryCombo(((CategoryCombo) value));
                } else {
                    throw new IllegalArgumentException(("property \"categoryCombo\" is of type \"org.hisp.dhis.api.model.v2_37_7.CategoryCombo\", but got "+ value.getClass().toString()));
                }
                return true;
            case "code":
                if (value instanceof String) {
                    setCode(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "compulsoryDataElementOperands":
                if (value instanceof List) {
                    setCompulsoryDataElementOperands(((List<DataElementOperand> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"compulsoryDataElementOperands\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.DataElementOperand>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "compulsoryFieldsCompleteOnly":
                if (value instanceof Boolean) {
                    setCompulsoryFieldsCompleteOnly(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"compulsoryFieldsCompleteOnly\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "created":
                if (value instanceof Date) {
                    setCreated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "createdBy":
                if (value instanceof User) {
                    setCreatedBy(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"createdBy\" is of type \"org.hisp.dhis.api.model.v2_37_7.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataElementDecoration":
                if (value instanceof Boolean) {
                    setDataElementDecoration(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataElementDecoration\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataEntryForm":
                if (value instanceof DataEntryForm) {
                    setDataEntryForm(((DataEntryForm) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataEntryForm\" is of type \"org.hisp.dhis.api.model.v2_37_7.DataEntryForm\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataInputPeriods":
                if (value instanceof List) {
                    setDataInputPeriods(((List<DataInputPeriod> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataInputPeriods\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.DataInputPeriod>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataSetElements":
                if (value instanceof List) {
                    setDataSetElements(((List<DataSetElement> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataSetElements\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.DataSetElement>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "description":
                if (value instanceof String) {
                    setDescription(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"description\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dimensionItem":
                if (value instanceof String) {
                    setDimensionItem(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"dimensionItem\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dimensionItemType":
                if (value instanceof org.hisp.dhis.api.model.v2_37_7.CategoryOptionCombo.DimensionItemType) {
                    setDimensionItemType(((org.hisp.dhis.api.model.v2_37_7.CategoryOptionCombo.DimensionItemType) value));
                } else {
                    throw new IllegalArgumentException(("property \"dimensionItemType\" is of type \"org.hisp.dhis.api.model.v2_37_7.CategoryOptionCombo.DimensionItemType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayDescription":
                if (value instanceof String) {
                    setDisplayDescription(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayDescription\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayFormName":
                if (value instanceof String) {
                    setDisplayFormName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayFormName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayName":
                if (value instanceof String) {
                    setDisplayName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayShortName":
                if (value instanceof String) {
                    setDisplayShortName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayShortName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "expiryDays":
                if (value instanceof Integer) {
                    setExpiryDays(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"expiryDays\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "externalAccess":
                if (value instanceof Boolean) {
                    setExternalAccess(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "favorite":
                if (value instanceof Boolean) {
                    setFavorite(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "favorites":
                if (value instanceof List) {
                    setFavorites(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "fieldCombinationRequired":
                if (value instanceof Boolean) {
                    setFieldCombinationRequired(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"fieldCombinationRequired\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "formName":
                if (value instanceof String) {
                    setFormName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"formName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "formType":
                if (value instanceof org.hisp.dhis.api.model.v2_37_7.ProgramStage.FormType) {
                    setFormType(((org.hisp.dhis.api.model.v2_37_7.ProgramStage.FormType) value));
                } else {
                    throw new IllegalArgumentException(("property \"formType\" is of type \"org.hisp.dhis.api.model.v2_37_7.ProgramStage.FormType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "href":
                if (value instanceof String) {
                    setHref(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "id":
                if (value instanceof String) {
                    setId(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "indicators":
                if (value instanceof List) {
                    setIndicators(((List<Indicator> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"indicators\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.Indicator>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "interpretations":
                if (value instanceof List) {
                    setInterpretations(((List<Interpretation> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"interpretations\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.Interpretation>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdated":
                if (value instanceof Date) {
                    setLastUpdated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdatedBy":
                if (value instanceof User) {
                    setLastUpdatedBy(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v2_37_7.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "legendSet":
                if (value instanceof LegendSet) {
                    setLegendSet(((LegendSet) value));
                } else {
                    throw new IllegalArgumentException(("property \"legendSet\" is of type \"org.hisp.dhis.api.model.v2_37_7.LegendSet\", but got "+ value.getClass().toString()));
                }
                return true;
            case "legendSets":
                if (value instanceof List) {
                    setLegendSets(((List<LegendSet> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"legendSets\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.LegendSet>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "mobile":
                if (value instanceof Boolean) {
                    setMobile(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"mobile\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "name":
                if (value instanceof String) {
                    setName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "noValueRequiresComment":
                if (value instanceof Boolean) {
                    setNoValueRequiresComment(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"noValueRequiresComment\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "notificationRecipients":
                if (value instanceof UserGroup) {
                    setNotificationRecipients(((UserGroup) value));
                } else {
                    throw new IllegalArgumentException(("property \"notificationRecipients\" is of type \"org.hisp.dhis.api.model.v2_37_7.UserGroup\", but got "+ value.getClass().toString()));
                }
                return true;
            case "notifyCompletingUser":
                if (value instanceof Boolean) {
                    setNotifyCompletingUser(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"notifyCompletingUser\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "openFuturePeriods":
                if (value instanceof Integer) {
                    setOpenFuturePeriods(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"openFuturePeriods\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "openPeriodsAfterCoEndDate":
                if (value instanceof Integer) {
                    setOpenPeriodsAfterCoEndDate(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"openPeriodsAfterCoEndDate\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "organisationUnits":
                if (value instanceof List) {
                    setOrganisationUnits(((List<OrganisationUnit> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"organisationUnits\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.OrganisationUnit>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "periodOffset":
                if (value instanceof Integer) {
                    setPeriodOffset(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"periodOffset\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "periodType":
                if (value instanceof Object) {
                    setPeriodType(((Object) value));
                } else {
                    throw new IllegalArgumentException(("property \"periodType\" is of type \"java.lang.Object\", but got "+ value.getClass().toString()));
                }
                return true;
            case "publicAccess":
                if (value instanceof String) {
                    setPublicAccess(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "renderAsTabs":
                if (value instanceof Boolean) {
                    setRenderAsTabs(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"renderAsTabs\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "renderHorizontally":
                if (value instanceof Boolean) {
                    setRenderHorizontally(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"renderHorizontally\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "sections":
                if (value instanceof List) {
                    setSections(((List<Section> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"sections\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.Section>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "sharing":
                if (value instanceof Sharing) {
                    setSharing(((Sharing) value));
                } else {
                    throw new IllegalArgumentException(("property \"sharing\" is of type \"org.hisp.dhis.api.model.v2_37_7.Sharing\", but got "+ value.getClass().toString()));
                }
                return true;
            case "shortName":
                if (value instanceof String) {
                    setShortName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"shortName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "skipOffline":
                if (value instanceof Boolean) {
                    setSkipOffline(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"skipOffline\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "style":
                if (value instanceof ObjectStyle) {
                    setStyle(((ObjectStyle) value));
                } else {
                    throw new IllegalArgumentException(("property \"style\" is of type \"org.hisp.dhis.api.model.v2_37_7.ObjectStyle\", but got "+ value.getClass().toString()));
                }
                return true;
            case "timelyDays":
                if (value instanceof Integer) {
                    setTimelyDays(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"timelyDays\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "translations":
                if (value instanceof List) {
                    setTranslations(((List<Translation> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.Translation>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "user":
                if (value instanceof User) {
                    setUser(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v2_37_7.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userAccesses":
                if (value instanceof List) {
                    setUserAccesses(((List<UserAccess> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.UserAccess>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userGroupAccesses":
                if (value instanceof List) {
                    setUserGroupAccesses(((List<UserGroupAccess> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.UserGroupAccess>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "validCompleteOnly":
                if (value instanceof Boolean) {
                    setValidCompleteOnly(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"validCompleteOnly\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "version":
                if (value instanceof Integer) {
                    setVersion(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"version\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "workflow":
                if (value instanceof DataApprovalWorkflow) {
                    setWorkflow(((DataApprovalWorkflow) value));
                } else {
                    throw new IllegalArgumentException(("property \"workflow\" is of type \"org.hisp.dhis.api.model.v2_37_7.DataApprovalWorkflow\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "access":
                return getAccess();
            case "aggregationType":
                return getAggregationType();
            case "attributeValues":
                return getAttributeValues();
            case "categoryCombo":
                return getCategoryCombo();
            case "code":
                return getCode();
            case "compulsoryDataElementOperands":
                return getCompulsoryDataElementOperands();
            case "compulsoryFieldsCompleteOnly":
                return getCompulsoryFieldsCompleteOnly();
            case "created":
                return getCreated();
            case "createdBy":
                return getCreatedBy();
            case "dataElementDecoration":
                return getDataElementDecoration();
            case "dataEntryForm":
                return getDataEntryForm();
            case "dataInputPeriods":
                return getDataInputPeriods();
            case "dataSetElements":
                return getDataSetElements();
            case "description":
                return getDescription();
            case "dimensionItem":
                return getDimensionItem();
            case "dimensionItemType":
                return getDimensionItemType();
            case "displayDescription":
                return getDisplayDescription();
            case "displayFormName":
                return getDisplayFormName();
            case "displayName":
                return getDisplayName();
            case "displayShortName":
                return getDisplayShortName();
            case "expiryDays":
                return getExpiryDays();
            case "externalAccess":
                return getExternalAccess();
            case "favorite":
                return getFavorite();
            case "favorites":
                return getFavorites();
            case "fieldCombinationRequired":
                return getFieldCombinationRequired();
            case "formName":
                return getFormName();
            case "formType":
                return getFormType();
            case "href":
                return getHref();
            case "id":
                return getId();
            case "indicators":
                return getIndicators();
            case "interpretations":
                return getInterpretations();
            case "lastUpdated":
                return getLastUpdated();
            case "lastUpdatedBy":
                return getLastUpdatedBy();
            case "legendSet":
                return getLegendSet();
            case "legendSets":
                return getLegendSets();
            case "mobile":
                return getMobile();
            case "name":
                return getName();
            case "noValueRequiresComment":
                return getNoValueRequiresComment();
            case "notificationRecipients":
                return getNotificationRecipients();
            case "notifyCompletingUser":
                return getNotifyCompletingUser();
            case "openFuturePeriods":
                return getOpenFuturePeriods();
            case "openPeriodsAfterCoEndDate":
                return getOpenPeriodsAfterCoEndDate();
            case "organisationUnits":
                return getOrganisationUnits();
            case "periodOffset":
                return getPeriodOffset();
            case "periodType":
                return getPeriodType();
            case "publicAccess":
                return getPublicAccess();
            case "renderAsTabs":
                return getRenderAsTabs();
            case "renderHorizontally":
                return getRenderHorizontally();
            case "sections":
                return getSections();
            case "sharing":
                return getSharing();
            case "shortName":
                return getShortName();
            case "skipOffline":
                return getSkipOffline();
            case "style":
                return getStyle();
            case "timelyDays":
                return getTimelyDays();
            case "translations":
                return getTranslations();
            case "user":
                return getUser();
            case "userAccesses":
                return getUserAccesses();
            case "userGroupAccesses":
                return getUserGroupAccesses();
            case "validCompleteOnly":
                return getValidCompleteOnly();
            case "version":
                return getVersion();
            case "workflow":
                return getWorkflow();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, DataSet.NOT_FOUND_VALUE);
        if (DataSet.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public DataSet with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DataSet.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("aggregationType");
        sb.append('=');
        sb.append(((this.aggregationType == null)?"<null>":this.aggregationType));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("categoryCombo");
        sb.append('=');
        sb.append(((this.categoryCombo == null)?"<null>":this.categoryCombo));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("compulsoryDataElementOperands");
        sb.append('=');
        sb.append(((this.compulsoryDataElementOperands == null)?"<null>":this.compulsoryDataElementOperands));
        sb.append(',');
        sb.append("compulsoryFieldsCompleteOnly");
        sb.append('=');
        sb.append(((this.compulsoryFieldsCompleteOnly == null)?"<null>":this.compulsoryFieldsCompleteOnly));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("createdBy");
        sb.append('=');
        sb.append(((this.createdBy == null)?"<null>":this.createdBy));
        sb.append(',');
        sb.append("dataElementDecoration");
        sb.append('=');
        sb.append(((this.dataElementDecoration == null)?"<null>":this.dataElementDecoration));
        sb.append(',');
        sb.append("dataEntryForm");
        sb.append('=');
        sb.append(((this.dataEntryForm == null)?"<null>":this.dataEntryForm));
        sb.append(',');
        sb.append("dataInputPeriods");
        sb.append('=');
        sb.append(((this.dataInputPeriods == null)?"<null>":this.dataInputPeriods));
        sb.append(',');
        sb.append("dataSetElements");
        sb.append('=');
        sb.append(((this.dataSetElements == null)?"<null>":this.dataSetElements));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("dimensionItem");
        sb.append('=');
        sb.append(((this.dimensionItem == null)?"<null>":this.dimensionItem));
        sb.append(',');
        sb.append("dimensionItemType");
        sb.append('=');
        sb.append(((this.dimensionItemType == null)?"<null>":this.dimensionItemType));
        sb.append(',');
        sb.append("displayDescription");
        sb.append('=');
        sb.append(((this.displayDescription == null)?"<null>":this.displayDescription));
        sb.append(',');
        sb.append("displayFormName");
        sb.append('=');
        sb.append(((this.displayFormName == null)?"<null>":this.displayFormName));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("displayShortName");
        sb.append('=');
        sb.append(((this.displayShortName == null)?"<null>":this.displayShortName));
        sb.append(',');
        sb.append("expiryDays");
        sb.append('=');
        sb.append(((this.expiryDays == null)?"<null>":this.expiryDays));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("fieldCombinationRequired");
        sb.append('=');
        sb.append(((this.fieldCombinationRequired == null)?"<null>":this.fieldCombinationRequired));
        sb.append(',');
        sb.append("formName");
        sb.append('=');
        sb.append(((this.formName == null)?"<null>":this.formName));
        sb.append(',');
        sb.append("formType");
        sb.append('=');
        sb.append(((this.formType == null)?"<null>":this.formType));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("indicators");
        sb.append('=');
        sb.append(((this.indicators == null)?"<null>":this.indicators));
        sb.append(',');
        sb.append("interpretations");
        sb.append('=');
        sb.append(((this.interpretations == null)?"<null>":this.interpretations));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("legendSet");
        sb.append('=');
        sb.append(((this.legendSet == null)?"<null>":this.legendSet));
        sb.append(',');
        sb.append("legendSets");
        sb.append('=');
        sb.append(((this.legendSets == null)?"<null>":this.legendSets));
        sb.append(',');
        sb.append("mobile");
        sb.append('=');
        sb.append(((this.mobile == null)?"<null>":this.mobile));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("noValueRequiresComment");
        sb.append('=');
        sb.append(((this.noValueRequiresComment == null)?"<null>":this.noValueRequiresComment));
        sb.append(',');
        sb.append("notificationRecipients");
        sb.append('=');
        sb.append(((this.notificationRecipients == null)?"<null>":this.notificationRecipients));
        sb.append(',');
        sb.append("notifyCompletingUser");
        sb.append('=');
        sb.append(((this.notifyCompletingUser == null)?"<null>":this.notifyCompletingUser));
        sb.append(',');
        sb.append("openFuturePeriods");
        sb.append('=');
        sb.append(((this.openFuturePeriods == null)?"<null>":this.openFuturePeriods));
        sb.append(',');
        sb.append("openPeriodsAfterCoEndDate");
        sb.append('=');
        sb.append(((this.openPeriodsAfterCoEndDate == null)?"<null>":this.openPeriodsAfterCoEndDate));
        sb.append(',');
        sb.append("organisationUnits");
        sb.append('=');
        sb.append(((this.organisationUnits == null)?"<null>":this.organisationUnits));
        sb.append(',');
        sb.append("periodOffset");
        sb.append('=');
        sb.append(((this.periodOffset == null)?"<null>":this.periodOffset));
        sb.append(',');
        sb.append("periodType");
        sb.append('=');
        sb.append(((this.periodType == null)?"<null>":this.periodType));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("renderAsTabs");
        sb.append('=');
        sb.append(((this.renderAsTabs == null)?"<null>":this.renderAsTabs));
        sb.append(',');
        sb.append("renderHorizontally");
        sb.append('=');
        sb.append(((this.renderHorizontally == null)?"<null>":this.renderHorizontally));
        sb.append(',');
        sb.append("sections");
        sb.append('=');
        sb.append(((this.sections == null)?"<null>":this.sections));
        sb.append(',');
        sb.append("sharing");
        sb.append('=');
        sb.append(((this.sharing == null)?"<null>":this.sharing));
        sb.append(',');
        sb.append("shortName");
        sb.append('=');
        sb.append(((this.shortName == null)?"<null>":this.shortName));
        sb.append(',');
        sb.append("skipOffline");
        sb.append('=');
        sb.append(((this.skipOffline == null)?"<null>":this.skipOffline));
        sb.append(',');
        sb.append("style");
        sb.append('=');
        sb.append(((this.style == null)?"<null>":this.style));
        sb.append(',');
        sb.append("timelyDays");
        sb.append('=');
        sb.append(((this.timelyDays == null)?"<null>":this.timelyDays));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("validCompleteOnly");
        sb.append('=');
        sb.append(((this.validCompleteOnly == null)?"<null>":this.validCompleteOnly));
        sb.append(',');
        sb.append("version");
        sb.append('=');
        sb.append(((this.version == null)?"<null>":this.version));
        sb.append(',');
        sb.append("workflow");
        sb.append('=');
        sb.append(((this.workflow == null)?"<null>":this.workflow));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.dataEntryForm == null)? 0 :this.dataEntryForm.hashCode()));
        result = ((result* 31)+((this.validCompleteOnly == null)? 0 :this.validCompleteOnly.hashCode()));
        result = ((result* 31)+((this.dataSetElements == null)? 0 :this.dataSetElements.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.skipOffline == null)? 0 :this.skipOffline.hashCode()));
        result = ((result* 31)+((this.compulsoryFieldsCompleteOnly == null)? 0 :this.compulsoryFieldsCompleteOnly.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.categoryCombo == null)? 0 :this.categoryCombo.hashCode()));
        result = ((result* 31)+((this.dataInputPeriods == null)? 0 :this.dataInputPeriods.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.interpretations == null)? 0 :this.interpretations.hashCode()));
        result = ((result* 31)+((this.displayDescription == null)? 0 :this.displayDescription.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.formType == null)? 0 :this.formType.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.workflow == null)? 0 :this.workflow.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.indicators == null)? 0 :this.indicators.hashCode()));
        result = ((result* 31)+((this.sharing == null)? 0 :this.sharing.hashCode()));
        result = ((result* 31)+((this.displayFormName == null)? 0 :this.displayFormName.hashCode()));
        result = ((result* 31)+((this.version == null)? 0 :this.version.hashCode()));
        result = ((result* 31)+((this.sections == null)? 0 :this.sections.hashCode()));
        result = ((result* 31)+((this.timelyDays == null)? 0 :this.timelyDays.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.legendSets == null)? 0 :this.legendSets.hashCode()));
        result = ((result* 31)+((this.notificationRecipients == null)? 0 :this.notificationRecipients.hashCode()));
        result = ((result* 31)+((this.style == null)? 0 :this.style.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.shortName == null)? 0 :this.shortName.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.dimensionItemType == null)? 0 :this.dimensionItemType.hashCode()));
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.aggregationType == null)? 0 :this.aggregationType.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.dataElementDecoration == null)? 0 :this.dataElementDecoration.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.notifyCompletingUser == null)? 0 :this.notifyCompletingUser.hashCode()));
        result = ((result* 31)+((this.noValueRequiresComment == null)? 0 :this.noValueRequiresComment.hashCode()));
        result = ((result* 31)+((this.compulsoryDataElementOperands == null)? 0 :this.compulsoryDataElementOperands.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.displayShortName == null)? 0 :this.displayShortName.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.fieldCombinationRequired == null)? 0 :this.fieldCombinationRequired.hashCode()));
        result = ((result* 31)+((this.periodOffset == null)? 0 :this.periodOffset.hashCode()));
        result = ((result* 31)+((this.formName == null)? 0 :this.formName.hashCode()));
        result = ((result* 31)+((this.organisationUnits == null)? 0 :this.organisationUnits.hashCode()));
        result = ((result* 31)+((this.renderHorizontally == null)? 0 :this.renderHorizontally.hashCode()));
        result = ((result* 31)+((this.renderAsTabs == null)? 0 :this.renderAsTabs.hashCode()));
        result = ((result* 31)+((this.dimensionItem == null)? 0 :this.dimensionItem.hashCode()));
        result = ((result* 31)+((this.mobile == null)? 0 :this.mobile.hashCode()));
        result = ((result* 31)+((this.openPeriodsAfterCoEndDate == null)? 0 :this.openPeriodsAfterCoEndDate.hashCode()));
        result = ((result* 31)+((this.periodType == null)? 0 :this.periodType.hashCode()));
        result = ((result* 31)+((this.createdBy == null)? 0 :this.createdBy.hashCode()));
        result = ((result* 31)+((this.legendSet == null)? 0 :this.legendSet.hashCode()));
        result = ((result* 31)+((this.openFuturePeriods == null)? 0 :this.openFuturePeriods.hashCode()));
        result = ((result* 31)+((this.expiryDays == null)? 0 :this.expiryDays.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof DataSet) == false) {
            return false;
        }
        DataSet rhs = ((DataSet) other);
        return (((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((this.dataEntryForm == rhs.dataEntryForm)||((this.dataEntryForm!= null)&&this.dataEntryForm.equals(rhs.dataEntryForm)))&&((this.validCompleteOnly == rhs.validCompleteOnly)||((this.validCompleteOnly!= null)&&this.validCompleteOnly.equals(rhs.validCompleteOnly))))&&((this.dataSetElements == rhs.dataSetElements)||((this.dataSetElements!= null)&&this.dataSetElements.equals(rhs.dataSetElements))))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.skipOffline == rhs.skipOffline)||((this.skipOffline!= null)&&this.skipOffline.equals(rhs.skipOffline))))&&((this.compulsoryFieldsCompleteOnly == rhs.compulsoryFieldsCompleteOnly)||((this.compulsoryFieldsCompleteOnly!= null)&&this.compulsoryFieldsCompleteOnly.equals(rhs.compulsoryFieldsCompleteOnly))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.categoryCombo == rhs.categoryCombo)||((this.categoryCombo!= null)&&this.categoryCombo.equals(rhs.categoryCombo))))&&((this.dataInputPeriods == rhs.dataInputPeriods)||((this.dataInputPeriods!= null)&&this.dataInputPeriods.equals(rhs.dataInputPeriods))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.interpretations == rhs.interpretations)||((this.interpretations!= null)&&this.interpretations.equals(rhs.interpretations))))&&((this.displayDescription == rhs.displayDescription)||((this.displayDescription!= null)&&this.displayDescription.equals(rhs.displayDescription))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.formType == rhs.formType)||((this.formType!= null)&&this.formType.equals(rhs.formType))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.workflow == rhs.workflow)||((this.workflow!= null)&&this.workflow.equals(rhs.workflow))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.indicators == rhs.indicators)||((this.indicators!= null)&&this.indicators.equals(rhs.indicators))))&&((this.sharing == rhs.sharing)||((this.sharing!= null)&&this.sharing.equals(rhs.sharing))))&&((this.displayFormName == rhs.displayFormName)||((this.displayFormName!= null)&&this.displayFormName.equals(rhs.displayFormName))))&&((this.version == rhs.version)||((this.version!= null)&&this.version.equals(rhs.version))))&&((this.sections == rhs.sections)||((this.sections!= null)&&this.sections.equals(rhs.sections))))&&((this.timelyDays == rhs.timelyDays)||((this.timelyDays!= null)&&this.timelyDays.equals(rhs.timelyDays))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.legendSets == rhs.legendSets)||((this.legendSets!= null)&&this.legendSets.equals(rhs.legendSets))))&&((this.notificationRecipients == rhs.notificationRecipients)||((this.notificationRecipients!= null)&&this.notificationRecipients.equals(rhs.notificationRecipients))))&&((this.style == rhs.style)||((this.style!= null)&&this.style.equals(rhs.style))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.shortName == rhs.shortName)||((this.shortName!= null)&&this.shortName.equals(rhs.shortName))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.dimensionItemType == rhs.dimensionItemType)||((this.dimensionItemType!= null)&&this.dimensionItemType.equals(rhs.dimensionItemType))))&&((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites))))&&((this.aggregationType == rhs.aggregationType)||((this.aggregationType!= null)&&this.aggregationType.equals(rhs.aggregationType))))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.dataElementDecoration == rhs.dataElementDecoration)||((this.dataElementDecoration!= null)&&this.dataElementDecoration.equals(rhs.dataElementDecoration))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.notifyCompletingUser == rhs.notifyCompletingUser)||((this.notifyCompletingUser!= null)&&this.notifyCompletingUser.equals(rhs.notifyCompletingUser))))&&((this.noValueRequiresComment == rhs.noValueRequiresComment)||((this.noValueRequiresComment!= null)&&this.noValueRequiresComment.equals(rhs.noValueRequiresComment))))&&((this.compulsoryDataElementOperands == rhs.compulsoryDataElementOperands)||((this.compulsoryDataElementOperands!= null)&&this.compulsoryDataElementOperands.equals(rhs.compulsoryDataElementOperands))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.displayShortName == rhs.displayShortName)||((this.displayShortName!= null)&&this.displayShortName.equals(rhs.displayShortName))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.fieldCombinationRequired == rhs.fieldCombinationRequired)||((this.fieldCombinationRequired!= null)&&this.fieldCombinationRequired.equals(rhs.fieldCombinationRequired))))&&((this.periodOffset == rhs.periodOffset)||((this.periodOffset!= null)&&this.periodOffset.equals(rhs.periodOffset))))&&((this.formName == rhs.formName)||((this.formName!= null)&&this.formName.equals(rhs.formName))))&&((this.organisationUnits == rhs.organisationUnits)||((this.organisationUnits!= null)&&this.organisationUnits.equals(rhs.organisationUnits))))&&((this.renderHorizontally == rhs.renderHorizontally)||((this.renderHorizontally!= null)&&this.renderHorizontally.equals(rhs.renderHorizontally))))&&((this.renderAsTabs == rhs.renderAsTabs)||((this.renderAsTabs!= null)&&this.renderAsTabs.equals(rhs.renderAsTabs))))&&((this.dimensionItem == rhs.dimensionItem)||((this.dimensionItem!= null)&&this.dimensionItem.equals(rhs.dimensionItem))))&&((this.mobile == rhs.mobile)||((this.mobile!= null)&&this.mobile.equals(rhs.mobile))))&&((this.openPeriodsAfterCoEndDate == rhs.openPeriodsAfterCoEndDate)||((this.openPeriodsAfterCoEndDate!= null)&&this.openPeriodsAfterCoEndDate.equals(rhs.openPeriodsAfterCoEndDate))))&&((this.periodType == rhs.periodType)||((this.periodType!= null)&&this.periodType.equals(rhs.periodType))))&&((this.createdBy == rhs.createdBy)||((this.createdBy!= null)&&this.createdBy.equals(rhs.createdBy))))&&((this.legendSet == rhs.legendSet)||((this.legendSet!= null)&&this.legendSet.equals(rhs.legendSet))))&&((this.openFuturePeriods == rhs.openFuturePeriods)||((this.openFuturePeriods!= null)&&this.openFuturePeriods.equals(rhs.openFuturePeriods))))&&((this.expiryDays == rhs.expiryDays)||((this.expiryDays!= null)&&this.expiryDays.equals(rhs.expiryDays))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))));
    }

}
