
package org.hisp.dhis.api.model.v2_37_7;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "categoryCombo",
    "dataElement",
    "dataSet"
})
@Generated("jsonschema2pojo")
public class DataSetElement implements Serializable
{

    @JsonProperty("categoryCombo")
    private CategoryCombo categoryCombo;
    @JsonProperty("dataElement")
    private DataElement dataElement;
    @JsonProperty("dataSet")
    private DataSet dataSet;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -1364334207123347312L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DataSetElement() {
    }

    /**
     * 
     * @param source
     */
    public DataSetElement(DataSetElement source) {
        super();
        this.categoryCombo = source.categoryCombo;
        this.dataElement = source.dataElement;
        this.dataSet = source.dataSet;
    }

    /**
     * 
     * @param categoryCombo
     * @param dataElement
     * @param dataSet
     */
    public DataSetElement(CategoryCombo categoryCombo, DataElement dataElement, DataSet dataSet) {
        super();
        this.categoryCombo = categoryCombo;
        this.dataElement = dataElement;
        this.dataSet = dataSet;
    }

    @JsonProperty("categoryCombo")
    public Optional<CategoryCombo> getCategoryCombo() {
        return Optional.ofNullable(categoryCombo);
    }

    @JsonProperty("categoryCombo")
    public void setCategoryCombo(CategoryCombo categoryCombo) {
        this.categoryCombo = categoryCombo;
    }

    public DataSetElement withCategoryCombo(CategoryCombo categoryCombo) {
        this.categoryCombo = categoryCombo;
        return this;
    }

    @JsonProperty("dataElement")
    public Optional<DataElement> getDataElement() {
        return Optional.ofNullable(dataElement);
    }

    @JsonProperty("dataElement")
    public void setDataElement(DataElement dataElement) {
        this.dataElement = dataElement;
    }

    public DataSetElement withDataElement(DataElement dataElement) {
        this.dataElement = dataElement;
        return this;
    }

    @JsonProperty("dataSet")
    public Optional<DataSet> getDataSet() {
        return Optional.ofNullable(dataSet);
    }

    @JsonProperty("dataSet")
    public void setDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
    }

    public DataSetElement withDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public DataSetElement withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "categoryCombo":
                if (value instanceof CategoryCombo) {
                    setCategoryCombo(((CategoryCombo) value));
                } else {
                    throw new IllegalArgumentException(("property \"categoryCombo\" is of type \"org.hisp.dhis.api.model.v2_37_7.CategoryCombo\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataElement":
                if (value instanceof DataElement) {
                    setDataElement(((DataElement) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataElement\" is of type \"org.hisp.dhis.api.model.v2_37_7.DataElement\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataSet":
                if (value instanceof DataSet) {
                    setDataSet(((DataSet) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataSet\" is of type \"org.hisp.dhis.api.model.v2_37_7.DataSet\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "categoryCombo":
                return getCategoryCombo();
            case "dataElement":
                return getDataElement();
            case "dataSet":
                return getDataSet();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, DataSetElement.NOT_FOUND_VALUE);
        if (DataSetElement.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public DataSetElement with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DataSetElement.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("categoryCombo");
        sb.append('=');
        sb.append(((this.categoryCombo == null)?"<null>":this.categoryCombo));
        sb.append(',');
        sb.append("dataElement");
        sb.append('=');
        sb.append(((this.dataElement == null)?"<null>":this.dataElement));
        sb.append(',');
        sb.append("dataSet");
        sb.append('=');
        sb.append(((this.dataSet == null)?"<null>":this.dataSet));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.dataElement == null)? 0 :this.dataElement.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.categoryCombo == null)? 0 :this.categoryCombo.hashCode()));
        result = ((result* 31)+((this.dataSet == null)? 0 :this.dataSet.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof DataSetElement) == false) {
            return false;
        }
        DataSetElement rhs = ((DataSetElement) other);
        return (((((this.dataElement == rhs.dataElement)||((this.dataElement!= null)&&this.dataElement.equals(rhs.dataElement)))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.categoryCombo == rhs.categoryCombo)||((this.categoryCombo!= null)&&this.categoryCombo.equals(rhs.categoryCombo))))&&((this.dataSet == rhs.dataSet)||((this.dataSet!= null)&&this.dataSet.equals(rhs.dataSet))));
    }

}
