
package org.hisp.dhis.api.model.v2_37_7;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "endBuffer",
    "endDate",
    "period",
    "startBuffer",
    "startDate",
    "type"
})
@Generated("jsonschema2pojo")
public class DateFilterPeriod implements Serializable
{

    @JsonProperty("endBuffer")
    private Integer endBuffer;
    @JsonProperty("endDate")
    private Date endDate;
    @JsonProperty("period")
    private DateFilterPeriod.RelativePeriodEnum period;
    @JsonProperty("startBuffer")
    private Integer startBuffer;
    @JsonProperty("startDate")
    private Date startDate;
    @JsonProperty("type")
    private DateFilterPeriod.DatePeriodType type;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 7202518740155421965L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DateFilterPeriod() {
    }

    /**
     * 
     * @param source
     */
    public DateFilterPeriod(DateFilterPeriod source) {
        super();
        this.endBuffer = source.endBuffer;
        this.endDate = source.endDate;
        this.period = source.period;
        this.startBuffer = source.startBuffer;
        this.startDate = source.startDate;
        this.type = source.type;
    }

    /**
     * 
     * @param period
     * @param endDate
     * @param startBuffer
     * @param endBuffer
     * @param type
     * @param startDate
     */
    public DateFilterPeriod(Integer endBuffer, Date endDate, DateFilterPeriod.RelativePeriodEnum period, Integer startBuffer, Date startDate, DateFilterPeriod.DatePeriodType type) {
        super();
        this.endBuffer = endBuffer;
        this.endDate = endDate;
        this.period = period;
        this.startBuffer = startBuffer;
        this.startDate = startDate;
        this.type = type;
    }

    @JsonProperty("endBuffer")
    public Optional<Integer> getEndBuffer() {
        return Optional.ofNullable(endBuffer);
    }

    @JsonProperty("endBuffer")
    public void setEndBuffer(Integer endBuffer) {
        this.endBuffer = endBuffer;
    }

    public DateFilterPeriod withEndBuffer(Integer endBuffer) {
        this.endBuffer = endBuffer;
        return this;
    }

    @JsonProperty("endDate")
    public Optional<Date> getEndDate() {
        return Optional.ofNullable(endDate);
    }

    @JsonProperty("endDate")
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public DateFilterPeriod withEndDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    @JsonProperty("period")
    public Optional<DateFilterPeriod.RelativePeriodEnum> getPeriod() {
        return Optional.ofNullable(period);
    }

    @JsonProperty("period")
    public void setPeriod(DateFilterPeriod.RelativePeriodEnum period) {
        this.period = period;
    }

    public DateFilterPeriod withPeriod(DateFilterPeriod.RelativePeriodEnum period) {
        this.period = period;
        return this;
    }

    @JsonProperty("startBuffer")
    public Optional<Integer> getStartBuffer() {
        return Optional.ofNullable(startBuffer);
    }

    @JsonProperty("startBuffer")
    public void setStartBuffer(Integer startBuffer) {
        this.startBuffer = startBuffer;
    }

    public DateFilterPeriod withStartBuffer(Integer startBuffer) {
        this.startBuffer = startBuffer;
        return this;
    }

    @JsonProperty("startDate")
    public Optional<Date> getStartDate() {
        return Optional.ofNullable(startDate);
    }

    @JsonProperty("startDate")
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public DateFilterPeriod withStartDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    @JsonProperty("type")
    public Optional<DateFilterPeriod.DatePeriodType> getType() {
        return Optional.ofNullable(type);
    }

    @JsonProperty("type")
    public void setType(DateFilterPeriod.DatePeriodType type) {
        this.type = type;
    }

    public DateFilterPeriod withType(DateFilterPeriod.DatePeriodType type) {
        this.type = type;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public DateFilterPeriod withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "endBuffer":
                if (value instanceof Integer) {
                    setEndBuffer(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"endBuffer\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "endDate":
                if (value instanceof Date) {
                    setEndDate(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"endDate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "period":
                if (value instanceof DateFilterPeriod.RelativePeriodEnum) {
                    setPeriod(((DateFilterPeriod.RelativePeriodEnum) value));
                } else {
                    throw new IllegalArgumentException(("property \"period\" is of type \"org.hisp.dhis.api.model.v2_37_7.DateFilterPeriod.RelativePeriodEnum\", but got "+ value.getClass().toString()));
                }
                return true;
            case "startBuffer":
                if (value instanceof Integer) {
                    setStartBuffer(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"startBuffer\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "startDate":
                if (value instanceof Date) {
                    setStartDate(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"startDate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "type":
                if (value instanceof DateFilterPeriod.DatePeriodType) {
                    setType(((DateFilterPeriod.DatePeriodType) value));
                } else {
                    throw new IllegalArgumentException(("property \"type\" is of type \"org.hisp.dhis.api.model.v2_37_7.DateFilterPeriod.DatePeriodType\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "endBuffer":
                return getEndBuffer();
            case "endDate":
                return getEndDate();
            case "period":
                return getPeriod();
            case "startBuffer":
                return getStartBuffer();
            case "startDate":
                return getStartDate();
            case "type":
                return getType();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, DateFilterPeriod.NOT_FOUND_VALUE);
        if (DateFilterPeriod.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public DateFilterPeriod with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DateFilterPeriod.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("endBuffer");
        sb.append('=');
        sb.append(((this.endBuffer == null)?"<null>":this.endBuffer));
        sb.append(',');
        sb.append("endDate");
        sb.append('=');
        sb.append(((this.endDate == null)?"<null>":this.endDate));
        sb.append(',');
        sb.append("period");
        sb.append('=');
        sb.append(((this.period == null)?"<null>":this.period));
        sb.append(',');
        sb.append("startBuffer");
        sb.append('=');
        sb.append(((this.startBuffer == null)?"<null>":this.startBuffer));
        sb.append(',');
        sb.append("startDate");
        sb.append('=');
        sb.append(((this.startDate == null)?"<null>":this.startDate));
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(((this.type == null)?"<null>":this.type));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.period == null)? 0 :this.period.hashCode()));
        result = ((result* 31)+((this.endDate == null)? 0 :this.endDate.hashCode()));
        result = ((result* 31)+((this.startBuffer == null)? 0 :this.startBuffer.hashCode()));
        result = ((result* 31)+((this.endBuffer == null)? 0 :this.endBuffer.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.type == null)? 0 :this.type.hashCode()));
        result = ((result* 31)+((this.startDate == null)? 0 :this.startDate.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof DateFilterPeriod) == false) {
            return false;
        }
        DateFilterPeriod rhs = ((DateFilterPeriod) other);
        return ((((((((this.period == rhs.period)||((this.period!= null)&&this.period.equals(rhs.period)))&&((this.endDate == rhs.endDate)||((this.endDate!= null)&&this.endDate.equals(rhs.endDate))))&&((this.startBuffer == rhs.startBuffer)||((this.startBuffer!= null)&&this.startBuffer.equals(rhs.startBuffer))))&&((this.endBuffer == rhs.endBuffer)||((this.endBuffer!= null)&&this.endBuffer.equals(rhs.endBuffer))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.type == rhs.type)||((this.type!= null)&&this.type.equals(rhs.type))))&&((this.startDate == rhs.startDate)||((this.startDate!= null)&&this.startDate.equals(rhs.startDate))));
    }

    @Generated("jsonschema2pojo")
    public enum DatePeriodType {

        RELATIVE("RELATIVE"),
        ABSOLUTE("ABSOLUTE");
        private final String value;
        private final static Map<String, DateFilterPeriod.DatePeriodType> CONSTANTS = new HashMap<String, DateFilterPeriod.DatePeriodType>();

        static {
            for (DateFilterPeriod.DatePeriodType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        DatePeriodType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DateFilterPeriod.DatePeriodType fromValue(String value) {
            DateFilterPeriod.DatePeriodType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum RelativePeriodEnum {

        TODAY("TODAY"),
        YESTERDAY("YESTERDAY"),
        LAST_3_DAYS("LAST_3_DAYS"),
        LAST_7_DAYS("LAST_7_DAYS"),
        LAST_14_DAYS("LAST_14_DAYS"),
        LAST_30_DAYS("LAST_30_DAYS"),
        LAST_60_DAYS("LAST_60_DAYS"),
        LAST_90_DAYS("LAST_90_DAYS"),
        LAST_180_DAYS("LAST_180_DAYS"),
        THIS_MONTH("THIS_MONTH"),
        LAST_MONTH("LAST_MONTH"),
        THIS_BIMONTH("THIS_BIMONTH"),
        LAST_BIMONTH("LAST_BIMONTH"),
        THIS_QUARTER("THIS_QUARTER"),
        LAST_QUARTER("LAST_QUARTER"),
        THIS_SIX_MONTH("THIS_SIX_MONTH"),
        LAST_SIX_MONTH("LAST_SIX_MONTH"),
        WEEKS_THIS_YEAR("WEEKS_THIS_YEAR"),
        MONTHS_THIS_YEAR("MONTHS_THIS_YEAR"),
        BIMONTHS_THIS_YEAR("BIMONTHS_THIS_YEAR"),
        QUARTERS_THIS_YEAR("QUARTERS_THIS_YEAR"),
        THIS_YEAR("THIS_YEAR"),
        MONTHS_LAST_YEAR("MONTHS_LAST_YEAR"),
        QUARTERS_LAST_YEAR("QUARTERS_LAST_YEAR"),
        LAST_YEAR("LAST_YEAR"),
        LAST_5_YEARS("LAST_5_YEARS"),
        LAST_10_YEARS("LAST_10_YEARS"),
        LAST_12_MONTHS("LAST_12_MONTHS"),
        LAST_6_MONTHS("LAST_6_MONTHS"),
        LAST_3_MONTHS("LAST_3_MONTHS"),
        LAST_6_BIMONTHS("LAST_6_BIMONTHS"),
        LAST_4_QUARTERS("LAST_4_QUARTERS"),
        LAST_2_SIXMONTHS("LAST_2_SIXMONTHS"),
        THIS_FINANCIAL_YEAR("THIS_FINANCIAL_YEAR"),
        LAST_FINANCIAL_YEAR("LAST_FINANCIAL_YEAR"),
        LAST_5_FINANCIAL_YEARS("LAST_5_FINANCIAL_YEARS"),
        LAST_10_FINANCIAL_YEARS("LAST_10_FINANCIAL_YEARS"),
        THIS_WEEK("THIS_WEEK"),
        LAST_WEEK("LAST_WEEK"),
        THIS_BIWEEK("THIS_BIWEEK"),
        LAST_BIWEEK("LAST_BIWEEK"),
        LAST_4_WEEKS("LAST_4_WEEKS"),
        LAST_4_BIWEEKS("LAST_4_BIWEEKS"),
        LAST_12_WEEKS("LAST_12_WEEKS"),
        LAST_52_WEEKS("LAST_52_WEEKS");
        private final String value;
        private final static Map<String, DateFilterPeriod.RelativePeriodEnum> CONSTANTS = new HashMap<String, DateFilterPeriod.RelativePeriodEnum>();

        static {
            for (DateFilterPeriod.RelativePeriodEnum c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        RelativePeriodEnum(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DateFilterPeriod.RelativePeriodEnum fromValue(String value) {
            DateFilterPeriod.RelativePeriodEnum constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
