
package org.hisp.dhis.api.model.v2_37_7;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "async",
    "datasetAllowsPeriods",
    "dryRun",
    "filename",
    "firstRowIsHeader",
    "force",
    "idSchemes",
    "ignoreEmptyCollection",
    "importStrategy",
    "mergeDataValues",
    "mergeMode",
    "notificationLevel",
    "preheatCache",
    "reportMode",
    "requireAttributeOptionCombo",
    "requireCategoryOptionCombo",
    "sharing",
    "skipAudit",
    "skipCache",
    "skipExistingCheck",
    "skipLastUpdated",
    "skipNotifications",
    "skipPatternValidation",
    "strictAttributeOptionCombos",
    "strictCategoryOptionCombos",
    "strictDataElements",
    "strictOrganisationUnits",
    "strictPeriods"
})
@Generated("jsonschema2pojo")
public class ImportOptions implements Serializable
{

    @JsonProperty("async")
    private Boolean async;
    @JsonProperty("datasetAllowsPeriods")
    private Boolean datasetAllowsPeriods;
    @JsonProperty("dryRun")
    private Boolean dryRun;
    @JsonProperty("filename")
    private String filename;
    @JsonProperty("firstRowIsHeader")
    private Boolean firstRowIsHeader;
    @JsonProperty("force")
    private Boolean force;
    /**
     * Undefined
     * 
     */
    @JsonProperty("idSchemes")
    private Object idSchemes;
    @JsonProperty("ignoreEmptyCollection")
    private Boolean ignoreEmptyCollection;
    @JsonProperty("importStrategy")
    private ImportOptions.ImportStrategy importStrategy;
    @JsonProperty("mergeDataValues")
    private Boolean mergeDataValues;
    @JsonProperty("mergeMode")
    private ImportOptions.MergeMode mergeMode;
    @JsonProperty("notificationLevel")
    private ImportOptions.NotificationLevel notificationLevel;
    @JsonProperty("preheatCache")
    private Boolean preheatCache;
    @JsonProperty("reportMode")
    private ImportOptions.ImportReportMode reportMode;
    @JsonProperty("requireAttributeOptionCombo")
    private Boolean requireAttributeOptionCombo;
    @JsonProperty("requireCategoryOptionCombo")
    private Boolean requireCategoryOptionCombo;
    @JsonProperty("sharing")
    private Boolean sharing;
    @JsonProperty("skipAudit")
    private Boolean skipAudit;
    @JsonProperty("skipCache")
    private Boolean skipCache;
    @JsonProperty("skipExistingCheck")
    private Boolean skipExistingCheck;
    @JsonProperty("skipLastUpdated")
    private Boolean skipLastUpdated;
    @JsonProperty("skipNotifications")
    private Boolean skipNotifications;
    @JsonProperty("skipPatternValidation")
    private Boolean skipPatternValidation;
    @JsonProperty("strictAttributeOptionCombos")
    private Boolean strictAttributeOptionCombos;
    @JsonProperty("strictCategoryOptionCombos")
    private Boolean strictCategoryOptionCombos;
    @JsonProperty("strictDataElements")
    private Boolean strictDataElements;
    @JsonProperty("strictOrganisationUnits")
    private Boolean strictOrganisationUnits;
    @JsonProperty("strictPeriods")
    private Boolean strictPeriods;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 8391803112173778746L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ImportOptions() {
    }

    /**
     * 
     * @param source
     */
    public ImportOptions(ImportOptions source) {
        super();
        this.async = source.async;
        this.datasetAllowsPeriods = source.datasetAllowsPeriods;
        this.dryRun = source.dryRun;
        this.filename = source.filename;
        this.firstRowIsHeader = source.firstRowIsHeader;
        this.force = source.force;
        this.idSchemes = source.idSchemes;
        this.ignoreEmptyCollection = source.ignoreEmptyCollection;
        this.importStrategy = source.importStrategy;
        this.mergeDataValues = source.mergeDataValues;
        this.mergeMode = source.mergeMode;
        this.notificationLevel = source.notificationLevel;
        this.preheatCache = source.preheatCache;
        this.reportMode = source.reportMode;
        this.requireAttributeOptionCombo = source.requireAttributeOptionCombo;
        this.requireCategoryOptionCombo = source.requireCategoryOptionCombo;
        this.sharing = source.sharing;
        this.skipAudit = source.skipAudit;
        this.skipCache = source.skipCache;
        this.skipExistingCheck = source.skipExistingCheck;
        this.skipLastUpdated = source.skipLastUpdated;
        this.skipNotifications = source.skipNotifications;
        this.skipPatternValidation = source.skipPatternValidation;
        this.strictAttributeOptionCombos = source.strictAttributeOptionCombos;
        this.strictCategoryOptionCombos = source.strictCategoryOptionCombos;
        this.strictDataElements = source.strictDataElements;
        this.strictOrganisationUnits = source.strictOrganisationUnits;
        this.strictPeriods = source.strictPeriods;
    }

    /**
     * 
     * @param dryRun
     * @param skipCache
     * @param datasetAllowsPeriods
     * @param skipPatternValidation
     * @param mergeMode
     * @param strictCategoryOptionCombos
     * @param idSchemes
     * @param preheatCache
     * @param strictPeriods
     * @param ignoreEmptyCollection
     * @param firstRowIsHeader
     * @param notificationLevel
     * @param strictAttributeOptionCombos
     * @param skipExistingCheck
     * @param skipNotifications
     * @param strictDataElements
     * @param reportMode
     * @param sharing
     * @param requireAttributeOptionCombo
     * @param skipAudit
     * @param async
     * @param filename
     * @param requireCategoryOptionCombo
     * @param force
     * @param importStrategy
     * @param strictOrganisationUnits
     * @param mergeDataValues
     * @param skipLastUpdated
     */
    public ImportOptions(Boolean async, Boolean datasetAllowsPeriods, Boolean dryRun, String filename, Boolean firstRowIsHeader, Boolean force, Object idSchemes, Boolean ignoreEmptyCollection, ImportOptions.ImportStrategy importStrategy, Boolean mergeDataValues, ImportOptions.MergeMode mergeMode, ImportOptions.NotificationLevel notificationLevel, Boolean preheatCache, ImportOptions.ImportReportMode reportMode, Boolean requireAttributeOptionCombo, Boolean requireCategoryOptionCombo, Boolean sharing, Boolean skipAudit, Boolean skipCache, Boolean skipExistingCheck, Boolean skipLastUpdated, Boolean skipNotifications, Boolean skipPatternValidation, Boolean strictAttributeOptionCombos, Boolean strictCategoryOptionCombos, Boolean strictDataElements, Boolean strictOrganisationUnits, Boolean strictPeriods) {
        super();
        this.async = async;
        this.datasetAllowsPeriods = datasetAllowsPeriods;
        this.dryRun = dryRun;
        this.filename = filename;
        this.firstRowIsHeader = firstRowIsHeader;
        this.force = force;
        this.idSchemes = idSchemes;
        this.ignoreEmptyCollection = ignoreEmptyCollection;
        this.importStrategy = importStrategy;
        this.mergeDataValues = mergeDataValues;
        this.mergeMode = mergeMode;
        this.notificationLevel = notificationLevel;
        this.preheatCache = preheatCache;
        this.reportMode = reportMode;
        this.requireAttributeOptionCombo = requireAttributeOptionCombo;
        this.requireCategoryOptionCombo = requireCategoryOptionCombo;
        this.sharing = sharing;
        this.skipAudit = skipAudit;
        this.skipCache = skipCache;
        this.skipExistingCheck = skipExistingCheck;
        this.skipLastUpdated = skipLastUpdated;
        this.skipNotifications = skipNotifications;
        this.skipPatternValidation = skipPatternValidation;
        this.strictAttributeOptionCombos = strictAttributeOptionCombos;
        this.strictCategoryOptionCombos = strictCategoryOptionCombos;
        this.strictDataElements = strictDataElements;
        this.strictOrganisationUnits = strictOrganisationUnits;
        this.strictPeriods = strictPeriods;
    }

    @JsonProperty("async")
    public Optional<Boolean> getAsync() {
        return Optional.ofNullable(async);
    }

    @JsonProperty("async")
    public void setAsync(Boolean async) {
        this.async = async;
    }

    public ImportOptions withAsync(Boolean async) {
        this.async = async;
        return this;
    }

    @JsonProperty("datasetAllowsPeriods")
    public Optional<Boolean> getDatasetAllowsPeriods() {
        return Optional.ofNullable(datasetAllowsPeriods);
    }

    @JsonProperty("datasetAllowsPeriods")
    public void setDatasetAllowsPeriods(Boolean datasetAllowsPeriods) {
        this.datasetAllowsPeriods = datasetAllowsPeriods;
    }

    public ImportOptions withDatasetAllowsPeriods(Boolean datasetAllowsPeriods) {
        this.datasetAllowsPeriods = datasetAllowsPeriods;
        return this;
    }

    @JsonProperty("dryRun")
    public Optional<Boolean> getDryRun() {
        return Optional.ofNullable(dryRun);
    }

    @JsonProperty("dryRun")
    public void setDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
    }

    public ImportOptions withDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    @JsonProperty("filename")
    public Optional<String> getFilename() {
        return Optional.ofNullable(filename);
    }

    @JsonProperty("filename")
    public void setFilename(String filename) {
        this.filename = filename;
    }

    public ImportOptions withFilename(String filename) {
        this.filename = filename;
        return this;
    }

    @JsonProperty("firstRowIsHeader")
    public Optional<Boolean> getFirstRowIsHeader() {
        return Optional.ofNullable(firstRowIsHeader);
    }

    @JsonProperty("firstRowIsHeader")
    public void setFirstRowIsHeader(Boolean firstRowIsHeader) {
        this.firstRowIsHeader = firstRowIsHeader;
    }

    public ImportOptions withFirstRowIsHeader(Boolean firstRowIsHeader) {
        this.firstRowIsHeader = firstRowIsHeader;
        return this;
    }

    @JsonProperty("force")
    public Optional<Boolean> getForce() {
        return Optional.ofNullable(force);
    }

    @JsonProperty("force")
    public void setForce(Boolean force) {
        this.force = force;
    }

    public ImportOptions withForce(Boolean force) {
        this.force = force;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("idSchemes")
    public Optional<Object> getIdSchemes() {
        return Optional.ofNullable(idSchemes);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("idSchemes")
    public void setIdSchemes(Object idSchemes) {
        this.idSchemes = idSchemes;
    }

    public ImportOptions withIdSchemes(Object idSchemes) {
        this.idSchemes = idSchemes;
        return this;
    }

    @JsonProperty("ignoreEmptyCollection")
    public Optional<Boolean> getIgnoreEmptyCollection() {
        return Optional.ofNullable(ignoreEmptyCollection);
    }

    @JsonProperty("ignoreEmptyCollection")
    public void setIgnoreEmptyCollection(Boolean ignoreEmptyCollection) {
        this.ignoreEmptyCollection = ignoreEmptyCollection;
    }

    public ImportOptions withIgnoreEmptyCollection(Boolean ignoreEmptyCollection) {
        this.ignoreEmptyCollection = ignoreEmptyCollection;
        return this;
    }

    @JsonProperty("importStrategy")
    public Optional<ImportOptions.ImportStrategy> getImportStrategy() {
        return Optional.ofNullable(importStrategy);
    }

    @JsonProperty("importStrategy")
    public void setImportStrategy(ImportOptions.ImportStrategy importStrategy) {
        this.importStrategy = importStrategy;
    }

    public ImportOptions withImportStrategy(ImportOptions.ImportStrategy importStrategy) {
        this.importStrategy = importStrategy;
        return this;
    }

    @JsonProperty("mergeDataValues")
    public Optional<Boolean> getMergeDataValues() {
        return Optional.ofNullable(mergeDataValues);
    }

    @JsonProperty("mergeDataValues")
    public void setMergeDataValues(Boolean mergeDataValues) {
        this.mergeDataValues = mergeDataValues;
    }

    public ImportOptions withMergeDataValues(Boolean mergeDataValues) {
        this.mergeDataValues = mergeDataValues;
        return this;
    }

    @JsonProperty("mergeMode")
    public Optional<ImportOptions.MergeMode> getMergeMode() {
        return Optional.ofNullable(mergeMode);
    }

    @JsonProperty("mergeMode")
    public void setMergeMode(ImportOptions.MergeMode mergeMode) {
        this.mergeMode = mergeMode;
    }

    public ImportOptions withMergeMode(ImportOptions.MergeMode mergeMode) {
        this.mergeMode = mergeMode;
        return this;
    }

    @JsonProperty("notificationLevel")
    public Optional<ImportOptions.NotificationLevel> getNotificationLevel() {
        return Optional.ofNullable(notificationLevel);
    }

    @JsonProperty("notificationLevel")
    public void setNotificationLevel(ImportOptions.NotificationLevel notificationLevel) {
        this.notificationLevel = notificationLevel;
    }

    public ImportOptions withNotificationLevel(ImportOptions.NotificationLevel notificationLevel) {
        this.notificationLevel = notificationLevel;
        return this;
    }

    @JsonProperty("preheatCache")
    public Optional<Boolean> getPreheatCache() {
        return Optional.ofNullable(preheatCache);
    }

    @JsonProperty("preheatCache")
    public void setPreheatCache(Boolean preheatCache) {
        this.preheatCache = preheatCache;
    }

    public ImportOptions withPreheatCache(Boolean preheatCache) {
        this.preheatCache = preheatCache;
        return this;
    }

    @JsonProperty("reportMode")
    public Optional<ImportOptions.ImportReportMode> getReportMode() {
        return Optional.ofNullable(reportMode);
    }

    @JsonProperty("reportMode")
    public void setReportMode(ImportOptions.ImportReportMode reportMode) {
        this.reportMode = reportMode;
    }

    public ImportOptions withReportMode(ImportOptions.ImportReportMode reportMode) {
        this.reportMode = reportMode;
        return this;
    }

    @JsonProperty("requireAttributeOptionCombo")
    public Optional<Boolean> getRequireAttributeOptionCombo() {
        return Optional.ofNullable(requireAttributeOptionCombo);
    }

    @JsonProperty("requireAttributeOptionCombo")
    public void setRequireAttributeOptionCombo(Boolean requireAttributeOptionCombo) {
        this.requireAttributeOptionCombo = requireAttributeOptionCombo;
    }

    public ImportOptions withRequireAttributeOptionCombo(Boolean requireAttributeOptionCombo) {
        this.requireAttributeOptionCombo = requireAttributeOptionCombo;
        return this;
    }

    @JsonProperty("requireCategoryOptionCombo")
    public Optional<Boolean> getRequireCategoryOptionCombo() {
        return Optional.ofNullable(requireCategoryOptionCombo);
    }

    @JsonProperty("requireCategoryOptionCombo")
    public void setRequireCategoryOptionCombo(Boolean requireCategoryOptionCombo) {
        this.requireCategoryOptionCombo = requireCategoryOptionCombo;
    }

    public ImportOptions withRequireCategoryOptionCombo(Boolean requireCategoryOptionCombo) {
        this.requireCategoryOptionCombo = requireCategoryOptionCombo;
        return this;
    }

    @JsonProperty("sharing")
    public Optional<Boolean> getSharing() {
        return Optional.ofNullable(sharing);
    }

    @JsonProperty("sharing")
    public void setSharing(Boolean sharing) {
        this.sharing = sharing;
    }

    public ImportOptions withSharing(Boolean sharing) {
        this.sharing = sharing;
        return this;
    }

    @JsonProperty("skipAudit")
    public Optional<Boolean> getSkipAudit() {
        return Optional.ofNullable(skipAudit);
    }

    @JsonProperty("skipAudit")
    public void setSkipAudit(Boolean skipAudit) {
        this.skipAudit = skipAudit;
    }

    public ImportOptions withSkipAudit(Boolean skipAudit) {
        this.skipAudit = skipAudit;
        return this;
    }

    @JsonProperty("skipCache")
    public Optional<Boolean> getSkipCache() {
        return Optional.ofNullable(skipCache);
    }

    @JsonProperty("skipCache")
    public void setSkipCache(Boolean skipCache) {
        this.skipCache = skipCache;
    }

    public ImportOptions withSkipCache(Boolean skipCache) {
        this.skipCache = skipCache;
        return this;
    }

    @JsonProperty("skipExistingCheck")
    public Optional<Boolean> getSkipExistingCheck() {
        return Optional.ofNullable(skipExistingCheck);
    }

    @JsonProperty("skipExistingCheck")
    public void setSkipExistingCheck(Boolean skipExistingCheck) {
        this.skipExistingCheck = skipExistingCheck;
    }

    public ImportOptions withSkipExistingCheck(Boolean skipExistingCheck) {
        this.skipExistingCheck = skipExistingCheck;
        return this;
    }

    @JsonProperty("skipLastUpdated")
    public Optional<Boolean> getSkipLastUpdated() {
        return Optional.ofNullable(skipLastUpdated);
    }

    @JsonProperty("skipLastUpdated")
    public void setSkipLastUpdated(Boolean skipLastUpdated) {
        this.skipLastUpdated = skipLastUpdated;
    }

    public ImportOptions withSkipLastUpdated(Boolean skipLastUpdated) {
        this.skipLastUpdated = skipLastUpdated;
        return this;
    }

    @JsonProperty("skipNotifications")
    public Optional<Boolean> getSkipNotifications() {
        return Optional.ofNullable(skipNotifications);
    }

    @JsonProperty("skipNotifications")
    public void setSkipNotifications(Boolean skipNotifications) {
        this.skipNotifications = skipNotifications;
    }

    public ImportOptions withSkipNotifications(Boolean skipNotifications) {
        this.skipNotifications = skipNotifications;
        return this;
    }

    @JsonProperty("skipPatternValidation")
    public Optional<Boolean> getSkipPatternValidation() {
        return Optional.ofNullable(skipPatternValidation);
    }

    @JsonProperty("skipPatternValidation")
    public void setSkipPatternValidation(Boolean skipPatternValidation) {
        this.skipPatternValidation = skipPatternValidation;
    }

    public ImportOptions withSkipPatternValidation(Boolean skipPatternValidation) {
        this.skipPatternValidation = skipPatternValidation;
        return this;
    }

    @JsonProperty("strictAttributeOptionCombos")
    public Optional<Boolean> getStrictAttributeOptionCombos() {
        return Optional.ofNullable(strictAttributeOptionCombos);
    }

    @JsonProperty("strictAttributeOptionCombos")
    public void setStrictAttributeOptionCombos(Boolean strictAttributeOptionCombos) {
        this.strictAttributeOptionCombos = strictAttributeOptionCombos;
    }

    public ImportOptions withStrictAttributeOptionCombos(Boolean strictAttributeOptionCombos) {
        this.strictAttributeOptionCombos = strictAttributeOptionCombos;
        return this;
    }

    @JsonProperty("strictCategoryOptionCombos")
    public Optional<Boolean> getStrictCategoryOptionCombos() {
        return Optional.ofNullable(strictCategoryOptionCombos);
    }

    @JsonProperty("strictCategoryOptionCombos")
    public void setStrictCategoryOptionCombos(Boolean strictCategoryOptionCombos) {
        this.strictCategoryOptionCombos = strictCategoryOptionCombos;
    }

    public ImportOptions withStrictCategoryOptionCombos(Boolean strictCategoryOptionCombos) {
        this.strictCategoryOptionCombos = strictCategoryOptionCombos;
        return this;
    }

    @JsonProperty("strictDataElements")
    public Optional<Boolean> getStrictDataElements() {
        return Optional.ofNullable(strictDataElements);
    }

    @JsonProperty("strictDataElements")
    public void setStrictDataElements(Boolean strictDataElements) {
        this.strictDataElements = strictDataElements;
    }

    public ImportOptions withStrictDataElements(Boolean strictDataElements) {
        this.strictDataElements = strictDataElements;
        return this;
    }

    @JsonProperty("strictOrganisationUnits")
    public Optional<Boolean> getStrictOrganisationUnits() {
        return Optional.ofNullable(strictOrganisationUnits);
    }

    @JsonProperty("strictOrganisationUnits")
    public void setStrictOrganisationUnits(Boolean strictOrganisationUnits) {
        this.strictOrganisationUnits = strictOrganisationUnits;
    }

    public ImportOptions withStrictOrganisationUnits(Boolean strictOrganisationUnits) {
        this.strictOrganisationUnits = strictOrganisationUnits;
        return this;
    }

    @JsonProperty("strictPeriods")
    public Optional<Boolean> getStrictPeriods() {
        return Optional.ofNullable(strictPeriods);
    }

    @JsonProperty("strictPeriods")
    public void setStrictPeriods(Boolean strictPeriods) {
        this.strictPeriods = strictPeriods;
    }

    public ImportOptions withStrictPeriods(Boolean strictPeriods) {
        this.strictPeriods = strictPeriods;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ImportOptions withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "async":
                if (value instanceof Boolean) {
                    setAsync(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"async\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "datasetAllowsPeriods":
                if (value instanceof Boolean) {
                    setDatasetAllowsPeriods(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"datasetAllowsPeriods\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dryRun":
                if (value instanceof Boolean) {
                    setDryRun(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"dryRun\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "filename":
                if (value instanceof String) {
                    setFilename(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"filename\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "firstRowIsHeader":
                if (value instanceof Boolean) {
                    setFirstRowIsHeader(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"firstRowIsHeader\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "force":
                if (value instanceof Boolean) {
                    setForce(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"force\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "idSchemes":
                if (value instanceof Object) {
                    setIdSchemes(((Object) value));
                } else {
                    throw new IllegalArgumentException(("property \"idSchemes\" is of type \"java.lang.Object\", but got "+ value.getClass().toString()));
                }
                return true;
            case "ignoreEmptyCollection":
                if (value instanceof Boolean) {
                    setIgnoreEmptyCollection(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"ignoreEmptyCollection\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "importStrategy":
                if (value instanceof ImportOptions.ImportStrategy) {
                    setImportStrategy(((ImportOptions.ImportStrategy) value));
                } else {
                    throw new IllegalArgumentException(("property \"importStrategy\" is of type \"org.hisp.dhis.api.model.v2_37_7.ImportOptions.ImportStrategy\", but got "+ value.getClass().toString()));
                }
                return true;
            case "mergeDataValues":
                if (value instanceof Boolean) {
                    setMergeDataValues(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"mergeDataValues\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "mergeMode":
                if (value instanceof ImportOptions.MergeMode) {
                    setMergeMode(((ImportOptions.MergeMode) value));
                } else {
                    throw new IllegalArgumentException(("property \"mergeMode\" is of type \"org.hisp.dhis.api.model.v2_37_7.ImportOptions.MergeMode\", but got "+ value.getClass().toString()));
                }
                return true;
            case "notificationLevel":
                if (value instanceof ImportOptions.NotificationLevel) {
                    setNotificationLevel(((ImportOptions.NotificationLevel) value));
                } else {
                    throw new IllegalArgumentException(("property \"notificationLevel\" is of type \"org.hisp.dhis.api.model.v2_37_7.ImportOptions.NotificationLevel\", but got "+ value.getClass().toString()));
                }
                return true;
            case "preheatCache":
                if (value instanceof Boolean) {
                    setPreheatCache(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"preheatCache\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "reportMode":
                if (value instanceof ImportOptions.ImportReportMode) {
                    setReportMode(((ImportOptions.ImportReportMode) value));
                } else {
                    throw new IllegalArgumentException(("property \"reportMode\" is of type \"org.hisp.dhis.api.model.v2_37_7.ImportOptions.ImportReportMode\", but got "+ value.getClass().toString()));
                }
                return true;
            case "requireAttributeOptionCombo":
                if (value instanceof Boolean) {
                    setRequireAttributeOptionCombo(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"requireAttributeOptionCombo\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "requireCategoryOptionCombo":
                if (value instanceof Boolean) {
                    setRequireCategoryOptionCombo(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"requireCategoryOptionCombo\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "sharing":
                if (value instanceof Boolean) {
                    setSharing(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"sharing\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "skipAudit":
                if (value instanceof Boolean) {
                    setSkipAudit(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"skipAudit\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "skipCache":
                if (value instanceof Boolean) {
                    setSkipCache(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"skipCache\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "skipExistingCheck":
                if (value instanceof Boolean) {
                    setSkipExistingCheck(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"skipExistingCheck\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "skipLastUpdated":
                if (value instanceof Boolean) {
                    setSkipLastUpdated(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"skipLastUpdated\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "skipNotifications":
                if (value instanceof Boolean) {
                    setSkipNotifications(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"skipNotifications\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "skipPatternValidation":
                if (value instanceof Boolean) {
                    setSkipPatternValidation(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"skipPatternValidation\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "strictAttributeOptionCombos":
                if (value instanceof Boolean) {
                    setStrictAttributeOptionCombos(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"strictAttributeOptionCombos\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "strictCategoryOptionCombos":
                if (value instanceof Boolean) {
                    setStrictCategoryOptionCombos(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"strictCategoryOptionCombos\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "strictDataElements":
                if (value instanceof Boolean) {
                    setStrictDataElements(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"strictDataElements\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "strictOrganisationUnits":
                if (value instanceof Boolean) {
                    setStrictOrganisationUnits(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"strictOrganisationUnits\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "strictPeriods":
                if (value instanceof Boolean) {
                    setStrictPeriods(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"strictPeriods\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "async":
                return getAsync();
            case "datasetAllowsPeriods":
                return getDatasetAllowsPeriods();
            case "dryRun":
                return getDryRun();
            case "filename":
                return getFilename();
            case "firstRowIsHeader":
                return getFirstRowIsHeader();
            case "force":
                return getForce();
            case "idSchemes":
                return getIdSchemes();
            case "ignoreEmptyCollection":
                return getIgnoreEmptyCollection();
            case "importStrategy":
                return getImportStrategy();
            case "mergeDataValues":
                return getMergeDataValues();
            case "mergeMode":
                return getMergeMode();
            case "notificationLevel":
                return getNotificationLevel();
            case "preheatCache":
                return getPreheatCache();
            case "reportMode":
                return getReportMode();
            case "requireAttributeOptionCombo":
                return getRequireAttributeOptionCombo();
            case "requireCategoryOptionCombo":
                return getRequireCategoryOptionCombo();
            case "sharing":
                return getSharing();
            case "skipAudit":
                return getSkipAudit();
            case "skipCache":
                return getSkipCache();
            case "skipExistingCheck":
                return getSkipExistingCheck();
            case "skipLastUpdated":
                return getSkipLastUpdated();
            case "skipNotifications":
                return getSkipNotifications();
            case "skipPatternValidation":
                return getSkipPatternValidation();
            case "strictAttributeOptionCombos":
                return getStrictAttributeOptionCombos();
            case "strictCategoryOptionCombos":
                return getStrictCategoryOptionCombos();
            case "strictDataElements":
                return getStrictDataElements();
            case "strictOrganisationUnits":
                return getStrictOrganisationUnits();
            case "strictPeriods":
                return getStrictPeriods();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ImportOptions.NOT_FOUND_VALUE);
        if (ImportOptions.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ImportOptions with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ImportOptions.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("async");
        sb.append('=');
        sb.append(((this.async == null)?"<null>":this.async));
        sb.append(',');
        sb.append("datasetAllowsPeriods");
        sb.append('=');
        sb.append(((this.datasetAllowsPeriods == null)?"<null>":this.datasetAllowsPeriods));
        sb.append(',');
        sb.append("dryRun");
        sb.append('=');
        sb.append(((this.dryRun == null)?"<null>":this.dryRun));
        sb.append(',');
        sb.append("filename");
        sb.append('=');
        sb.append(((this.filename == null)?"<null>":this.filename));
        sb.append(',');
        sb.append("firstRowIsHeader");
        sb.append('=');
        sb.append(((this.firstRowIsHeader == null)?"<null>":this.firstRowIsHeader));
        sb.append(',');
        sb.append("force");
        sb.append('=');
        sb.append(((this.force == null)?"<null>":this.force));
        sb.append(',');
        sb.append("idSchemes");
        sb.append('=');
        sb.append(((this.idSchemes == null)?"<null>":this.idSchemes));
        sb.append(',');
        sb.append("ignoreEmptyCollection");
        sb.append('=');
        sb.append(((this.ignoreEmptyCollection == null)?"<null>":this.ignoreEmptyCollection));
        sb.append(',');
        sb.append("importStrategy");
        sb.append('=');
        sb.append(((this.importStrategy == null)?"<null>":this.importStrategy));
        sb.append(',');
        sb.append("mergeDataValues");
        sb.append('=');
        sb.append(((this.mergeDataValues == null)?"<null>":this.mergeDataValues));
        sb.append(',');
        sb.append("mergeMode");
        sb.append('=');
        sb.append(((this.mergeMode == null)?"<null>":this.mergeMode));
        sb.append(',');
        sb.append("notificationLevel");
        sb.append('=');
        sb.append(((this.notificationLevel == null)?"<null>":this.notificationLevel));
        sb.append(',');
        sb.append("preheatCache");
        sb.append('=');
        sb.append(((this.preheatCache == null)?"<null>":this.preheatCache));
        sb.append(',');
        sb.append("reportMode");
        sb.append('=');
        sb.append(((this.reportMode == null)?"<null>":this.reportMode));
        sb.append(',');
        sb.append("requireAttributeOptionCombo");
        sb.append('=');
        sb.append(((this.requireAttributeOptionCombo == null)?"<null>":this.requireAttributeOptionCombo));
        sb.append(',');
        sb.append("requireCategoryOptionCombo");
        sb.append('=');
        sb.append(((this.requireCategoryOptionCombo == null)?"<null>":this.requireCategoryOptionCombo));
        sb.append(',');
        sb.append("sharing");
        sb.append('=');
        sb.append(((this.sharing == null)?"<null>":this.sharing));
        sb.append(',');
        sb.append("skipAudit");
        sb.append('=');
        sb.append(((this.skipAudit == null)?"<null>":this.skipAudit));
        sb.append(',');
        sb.append("skipCache");
        sb.append('=');
        sb.append(((this.skipCache == null)?"<null>":this.skipCache));
        sb.append(',');
        sb.append("skipExistingCheck");
        sb.append('=');
        sb.append(((this.skipExistingCheck == null)?"<null>":this.skipExistingCheck));
        sb.append(',');
        sb.append("skipLastUpdated");
        sb.append('=');
        sb.append(((this.skipLastUpdated == null)?"<null>":this.skipLastUpdated));
        sb.append(',');
        sb.append("skipNotifications");
        sb.append('=');
        sb.append(((this.skipNotifications == null)?"<null>":this.skipNotifications));
        sb.append(',');
        sb.append("skipPatternValidation");
        sb.append('=');
        sb.append(((this.skipPatternValidation == null)?"<null>":this.skipPatternValidation));
        sb.append(',');
        sb.append("strictAttributeOptionCombos");
        sb.append('=');
        sb.append(((this.strictAttributeOptionCombos == null)?"<null>":this.strictAttributeOptionCombos));
        sb.append(',');
        sb.append("strictCategoryOptionCombos");
        sb.append('=');
        sb.append(((this.strictCategoryOptionCombos == null)?"<null>":this.strictCategoryOptionCombos));
        sb.append(',');
        sb.append("strictDataElements");
        sb.append('=');
        sb.append(((this.strictDataElements == null)?"<null>":this.strictDataElements));
        sb.append(',');
        sb.append("strictOrganisationUnits");
        sb.append('=');
        sb.append(((this.strictOrganisationUnits == null)?"<null>":this.strictOrganisationUnits));
        sb.append(',');
        sb.append("strictPeriods");
        sb.append('=');
        sb.append(((this.strictPeriods == null)?"<null>":this.strictPeriods));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.dryRun == null)? 0 :this.dryRun.hashCode()));
        result = ((result* 31)+((this.skipCache == null)? 0 :this.skipCache.hashCode()));
        result = ((result* 31)+((this.datasetAllowsPeriods == null)? 0 :this.datasetAllowsPeriods.hashCode()));
        result = ((result* 31)+((this.skipPatternValidation == null)? 0 :this.skipPatternValidation.hashCode()));
        result = ((result* 31)+((this.mergeMode == null)? 0 :this.mergeMode.hashCode()));
        result = ((result* 31)+((this.strictCategoryOptionCombos == null)? 0 :this.strictCategoryOptionCombos.hashCode()));
        result = ((result* 31)+((this.idSchemes == null)? 0 :this.idSchemes.hashCode()));
        result = ((result* 31)+((this.preheatCache == null)? 0 :this.preheatCache.hashCode()));
        result = ((result* 31)+((this.strictPeriods == null)? 0 :this.strictPeriods.hashCode()));
        result = ((result* 31)+((this.ignoreEmptyCollection == null)? 0 :this.ignoreEmptyCollection.hashCode()));
        result = ((result* 31)+((this.firstRowIsHeader == null)? 0 :this.firstRowIsHeader.hashCode()));
        result = ((result* 31)+((this.notificationLevel == null)? 0 :this.notificationLevel.hashCode()));
        result = ((result* 31)+((this.strictAttributeOptionCombos == null)? 0 :this.strictAttributeOptionCombos.hashCode()));
        result = ((result* 31)+((this.skipExistingCheck == null)? 0 :this.skipExistingCheck.hashCode()));
        result = ((result* 31)+((this.skipNotifications == null)? 0 :this.skipNotifications.hashCode()));
        result = ((result* 31)+((this.strictDataElements == null)? 0 :this.strictDataElements.hashCode()));
        result = ((result* 31)+((this.reportMode == null)? 0 :this.reportMode.hashCode()));
        result = ((result* 31)+((this.sharing == null)? 0 :this.sharing.hashCode()));
        result = ((result* 31)+((this.requireAttributeOptionCombo == null)? 0 :this.requireAttributeOptionCombo.hashCode()));
        result = ((result* 31)+((this.skipAudit == null)? 0 :this.skipAudit.hashCode()));
        result = ((result* 31)+((this.async == null)? 0 :this.async.hashCode()));
        result = ((result* 31)+((this.filename == null)? 0 :this.filename.hashCode()));
        result = ((result* 31)+((this.requireCategoryOptionCombo == null)? 0 :this.requireCategoryOptionCombo.hashCode()));
        result = ((result* 31)+((this.force == null)? 0 :this.force.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.importStrategy == null)? 0 :this.importStrategy.hashCode()));
        result = ((result* 31)+((this.strictOrganisationUnits == null)? 0 :this.strictOrganisationUnits.hashCode()));
        result = ((result* 31)+((this.mergeDataValues == null)? 0 :this.mergeDataValues.hashCode()));
        result = ((result* 31)+((this.skipLastUpdated == null)? 0 :this.skipLastUpdated.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ImportOptions) == false) {
            return false;
        }
        ImportOptions rhs = ((ImportOptions) other);
        return ((((((((((((((((((((((((((((((this.dryRun == rhs.dryRun)||((this.dryRun!= null)&&this.dryRun.equals(rhs.dryRun)))&&((this.skipCache == rhs.skipCache)||((this.skipCache!= null)&&this.skipCache.equals(rhs.skipCache))))&&((this.datasetAllowsPeriods == rhs.datasetAllowsPeriods)||((this.datasetAllowsPeriods!= null)&&this.datasetAllowsPeriods.equals(rhs.datasetAllowsPeriods))))&&((this.skipPatternValidation == rhs.skipPatternValidation)||((this.skipPatternValidation!= null)&&this.skipPatternValidation.equals(rhs.skipPatternValidation))))&&((this.mergeMode == rhs.mergeMode)||((this.mergeMode!= null)&&this.mergeMode.equals(rhs.mergeMode))))&&((this.strictCategoryOptionCombos == rhs.strictCategoryOptionCombos)||((this.strictCategoryOptionCombos!= null)&&this.strictCategoryOptionCombos.equals(rhs.strictCategoryOptionCombos))))&&((this.idSchemes == rhs.idSchemes)||((this.idSchemes!= null)&&this.idSchemes.equals(rhs.idSchemes))))&&((this.preheatCache == rhs.preheatCache)||((this.preheatCache!= null)&&this.preheatCache.equals(rhs.preheatCache))))&&((this.strictPeriods == rhs.strictPeriods)||((this.strictPeriods!= null)&&this.strictPeriods.equals(rhs.strictPeriods))))&&((this.ignoreEmptyCollection == rhs.ignoreEmptyCollection)||((this.ignoreEmptyCollection!= null)&&this.ignoreEmptyCollection.equals(rhs.ignoreEmptyCollection))))&&((this.firstRowIsHeader == rhs.firstRowIsHeader)||((this.firstRowIsHeader!= null)&&this.firstRowIsHeader.equals(rhs.firstRowIsHeader))))&&((this.notificationLevel == rhs.notificationLevel)||((this.notificationLevel!= null)&&this.notificationLevel.equals(rhs.notificationLevel))))&&((this.strictAttributeOptionCombos == rhs.strictAttributeOptionCombos)||((this.strictAttributeOptionCombos!= null)&&this.strictAttributeOptionCombos.equals(rhs.strictAttributeOptionCombos))))&&((this.skipExistingCheck == rhs.skipExistingCheck)||((this.skipExistingCheck!= null)&&this.skipExistingCheck.equals(rhs.skipExistingCheck))))&&((this.skipNotifications == rhs.skipNotifications)||((this.skipNotifications!= null)&&this.skipNotifications.equals(rhs.skipNotifications))))&&((this.strictDataElements == rhs.strictDataElements)||((this.strictDataElements!= null)&&this.strictDataElements.equals(rhs.strictDataElements))))&&((this.reportMode == rhs.reportMode)||((this.reportMode!= null)&&this.reportMode.equals(rhs.reportMode))))&&((this.sharing == rhs.sharing)||((this.sharing!= null)&&this.sharing.equals(rhs.sharing))))&&((this.requireAttributeOptionCombo == rhs.requireAttributeOptionCombo)||((this.requireAttributeOptionCombo!= null)&&this.requireAttributeOptionCombo.equals(rhs.requireAttributeOptionCombo))))&&((this.skipAudit == rhs.skipAudit)||((this.skipAudit!= null)&&this.skipAudit.equals(rhs.skipAudit))))&&((this.async == rhs.async)||((this.async!= null)&&this.async.equals(rhs.async))))&&((this.filename == rhs.filename)||((this.filename!= null)&&this.filename.equals(rhs.filename))))&&((this.requireCategoryOptionCombo == rhs.requireCategoryOptionCombo)||((this.requireCategoryOptionCombo!= null)&&this.requireCategoryOptionCombo.equals(rhs.requireCategoryOptionCombo))))&&((this.force == rhs.force)||((this.force!= null)&&this.force.equals(rhs.force))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.importStrategy == rhs.importStrategy)||((this.importStrategy!= null)&&this.importStrategy.equals(rhs.importStrategy))))&&((this.strictOrganisationUnits == rhs.strictOrganisationUnits)||((this.strictOrganisationUnits!= null)&&this.strictOrganisationUnits.equals(rhs.strictOrganisationUnits))))&&((this.mergeDataValues == rhs.mergeDataValues)||((this.mergeDataValues!= null)&&this.mergeDataValues.equals(rhs.mergeDataValues))))&&((this.skipLastUpdated == rhs.skipLastUpdated)||((this.skipLastUpdated!= null)&&this.skipLastUpdated.equals(rhs.skipLastUpdated))));
    }

    @Generated("jsonschema2pojo")
    public enum ImportReportMode {

        FULL("FULL"),
        ERRORS("ERRORS"),
        ERRORS_NOT_OWNER("ERRORS_NOT_OWNER"),
        DEBUG("DEBUG");
        private final String value;
        private final static Map<String, ImportOptions.ImportReportMode> CONSTANTS = new HashMap<String, ImportOptions.ImportReportMode>();

        static {
            for (ImportOptions.ImportReportMode c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ImportReportMode(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ImportOptions.ImportReportMode fromValue(String value) {
            ImportOptions.ImportReportMode constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum ImportStrategy {

        CREATE("CREATE"),
        UPDATE("UPDATE"),
        CREATE_AND_UPDATE("CREATE_AND_UPDATE"),
        DELETE("DELETE"),
        SYNC("SYNC"),
        NEW_AND_UPDATES("NEW_AND_UPDATES"),
        NEW("NEW"),
        UPDATES("UPDATES"),
        DELETES("DELETES");
        private final String value;
        private final static Map<String, ImportOptions.ImportStrategy> CONSTANTS = new HashMap<String, ImportOptions.ImportStrategy>();

        static {
            for (ImportOptions.ImportStrategy c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ImportStrategy(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ImportOptions.ImportStrategy fromValue(String value) {
            ImportOptions.ImportStrategy constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum MergeMode {

        MERGE_ALWAYS("MERGE_ALWAYS"),
        MERGE_IF_NOT_NULL("MERGE_IF_NOT_NULL"),
        MERGE("MERGE"),
        REPLACE("REPLACE"),
        NONE("NONE");
        private final String value;
        private final static Map<String, ImportOptions.MergeMode> CONSTANTS = new HashMap<String, ImportOptions.MergeMode>();

        static {
            for (ImportOptions.MergeMode c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        MergeMode(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ImportOptions.MergeMode fromValue(String value) {
            ImportOptions.MergeMode constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum NotificationLevel {

        OFF("OFF"),
        DEBUG("DEBUG"),
        LOOP("LOOP"),
        INFO("INFO"),
        WARN("WARN"),
        ERROR("ERROR");
        private final String value;
        private final static Map<String, ImportOptions.NotificationLevel> CONSTANTS = new HashMap<String, ImportOptions.NotificationLevel>();

        static {
            for (ImportOptions.NotificationLevel c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        NotificationLevel(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ImportOptions.NotificationLevel fromValue(String value) {
            ImportOptions.NotificationLevel constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
