
package org.hisp.dhis.api.model.v2_37_7;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "importParams",
    "stats",
    "status",
    "typeReports"
})
@Generated("jsonschema2pojo")
public class ImportReport implements Serializable
{

    @JsonProperty("importParams")
    private MetadataImportParams importParams;
    @JsonProperty("stats")
    private Stats stats;
    @JsonProperty("status")
    private org.hisp.dhis.api.model.v2_37_7.DescriptiveWebMessage.Status status;
    @JsonProperty("typeReports")
    private List<TypeReport> typeReports = null;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 1119252848648008973L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ImportReport() {
    }

    /**
     * 
     * @param source
     */
    public ImportReport(ImportReport source) {
        super();
        this.importParams = source.importParams;
        this.stats = source.stats;
        this.status = source.status;
        this.typeReports = source.typeReports;
    }

    /**
     * 
     * @param typeReports
     * @param stats
     * @param importParams
     * @param status
     */
    public ImportReport(MetadataImportParams importParams, Stats stats, org.hisp.dhis.api.model.v2_37_7.DescriptiveWebMessage.Status status, List<TypeReport> typeReports) {
        super();
        this.importParams = importParams;
        this.stats = stats;
        this.status = status;
        this.typeReports = typeReports;
    }

    @JsonProperty("importParams")
    public Optional<MetadataImportParams> getImportParams() {
        return Optional.ofNullable(importParams);
    }

    @JsonProperty("importParams")
    public void setImportParams(MetadataImportParams importParams) {
        this.importParams = importParams;
    }

    public ImportReport withImportParams(MetadataImportParams importParams) {
        this.importParams = importParams;
        return this;
    }

    @JsonProperty("stats")
    public Optional<Stats> getStats() {
        return Optional.ofNullable(stats);
    }

    @JsonProperty("stats")
    public void setStats(Stats stats) {
        this.stats = stats;
    }

    public ImportReport withStats(Stats stats) {
        this.stats = stats;
        return this;
    }

    @JsonProperty("status")
    public Optional<org.hisp.dhis.api.model.v2_37_7.DescriptiveWebMessage.Status> getStatus() {
        return Optional.ofNullable(status);
    }

    @JsonProperty("status")
    public void setStatus(org.hisp.dhis.api.model.v2_37_7.DescriptiveWebMessage.Status status) {
        this.status = status;
    }

    public ImportReport withStatus(org.hisp.dhis.api.model.v2_37_7.DescriptiveWebMessage.Status status) {
        this.status = status;
        return this;
    }

    @JsonProperty("typeReports")
    public Optional<List<TypeReport>> getTypeReports() {
        return Optional.ofNullable(typeReports);
    }

    @JsonProperty("typeReports")
    public void setTypeReports(List<TypeReport> typeReports) {
        this.typeReports = typeReports;
    }

    public ImportReport withTypeReports(List<TypeReport> typeReports) {
        this.typeReports = typeReports;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ImportReport withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "importParams":
                if (value instanceof MetadataImportParams) {
                    setImportParams(((MetadataImportParams) value));
                } else {
                    throw new IllegalArgumentException(("property \"importParams\" is of type \"org.hisp.dhis.api.model.v2_37_7.MetadataImportParams\", but got "+ value.getClass().toString()));
                }
                return true;
            case "stats":
                if (value instanceof Stats) {
                    setStats(((Stats) value));
                } else {
                    throw new IllegalArgumentException(("property \"stats\" is of type \"org.hisp.dhis.api.model.v2_37_7.Stats\", but got "+ value.getClass().toString()));
                }
                return true;
            case "status":
                if (value instanceof org.hisp.dhis.api.model.v2_37_7.DescriptiveWebMessage.Status) {
                    setStatus(((org.hisp.dhis.api.model.v2_37_7.DescriptiveWebMessage.Status) value));
                } else {
                    throw new IllegalArgumentException(("property \"status\" is of type \"org.hisp.dhis.api.model.v2_37_7.DescriptiveWebMessage.Status\", but got "+ value.getClass().toString()));
                }
                return true;
            case "typeReports":
                if (value instanceof List) {
                    setTypeReports(((List<TypeReport> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"typeReports\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.TypeReport>\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "importParams":
                return getImportParams();
            case "stats":
                return getStats();
            case "status":
                return getStatus();
            case "typeReports":
                return getTypeReports();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ImportReport.NOT_FOUND_VALUE);
        if (ImportReport.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ImportReport with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ImportReport.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("importParams");
        sb.append('=');
        sb.append(((this.importParams == null)?"<null>":this.importParams));
        sb.append(',');
        sb.append("stats");
        sb.append('=');
        sb.append(((this.stats == null)?"<null>":this.stats));
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(((this.status == null)?"<null>":this.status));
        sb.append(',');
        sb.append("typeReports");
        sb.append('=');
        sb.append(((this.typeReports == null)?"<null>":this.typeReports));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.typeReports == null)? 0 :this.typeReports.hashCode()));
        result = ((result* 31)+((this.stats == null)? 0 :this.stats.hashCode()));
        result = ((result* 31)+((this.importParams == null)? 0 :this.importParams.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.status == null)? 0 :this.status.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ImportReport) == false) {
            return false;
        }
        ImportReport rhs = ((ImportReport) other);
        return ((((((this.typeReports == rhs.typeReports)||((this.typeReports!= null)&&this.typeReports.equals(rhs.typeReports)))&&((this.stats == rhs.stats)||((this.stats!= null)&&this.stats.equals(rhs.stats))))&&((this.importParams == rhs.importParams)||((this.importParams!= null)&&this.importParams.equals(rhs.importParams))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.status == rhs.status)||((this.status!= null)&&this.status.equals(rhs.status))));
    }

}
