
package org.hisp.dhis.api.model.v2_37_7;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "algorithm",
    "dataEndDate",
    "dataStartDate",
    "de",
    "ds",
    "endDate",
    "maxResults",
    "orderBy",
    "ou",
    "startDate",
    "threshold"
})
@Generated("jsonschema2pojo")
public class OutlierDetectionQuery implements Serializable
{

    @JsonProperty("algorithm")
    private OutlierDetectionAlgorithm algorithm;
    @JsonProperty("dataEndDate")
    private Date dataEndDate;
    @JsonProperty("dataStartDate")
    private Date dataStartDate;
    @JsonProperty("de")
    private List<String> de = null;
    @JsonProperty("ds")
    private List<String> ds = null;
    @JsonProperty("endDate")
    private Date endDate;
    @JsonProperty("maxResults")
    private Integer maxResults;
    @JsonProperty("orderBy")
    private Order_ orderBy;
    @JsonProperty("ou")
    private List<String> ou = null;
    @JsonProperty("startDate")
    private Date startDate;
    @JsonProperty("threshold")
    private Double threshold;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -8385964876838151890L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public OutlierDetectionQuery() {
    }

    /**
     * 
     * @param source
     */
    public OutlierDetectionQuery(OutlierDetectionQuery source) {
        super();
        this.algorithm = source.algorithm;
        this.dataEndDate = source.dataEndDate;
        this.dataStartDate = source.dataStartDate;
        this.de = source.de;
        this.ds = source.ds;
        this.endDate = source.endDate;
        this.maxResults = source.maxResults;
        this.orderBy = source.orderBy;
        this.ou = source.ou;
        this.startDate = source.startDate;
        this.threshold = source.threshold;
    }

    /**
     * 
     * @param de
     * @param dataStartDate
     * @param endDate
     * @param maxResults
     * @param ou
     * @param orderBy
     * @param threshold
     * @param dataEndDate
     * @param startDate
     * @param algorithm
     * @param ds
     */
    public OutlierDetectionQuery(OutlierDetectionAlgorithm algorithm, Date dataEndDate, Date dataStartDate, List<String> de, List<String> ds, Date endDate, Integer maxResults, Order_ orderBy, List<String> ou, Date startDate, Double threshold) {
        super();
        this.algorithm = algorithm;
        this.dataEndDate = dataEndDate;
        this.dataStartDate = dataStartDate;
        this.de = de;
        this.ds = ds;
        this.endDate = endDate;
        this.maxResults = maxResults;
        this.orderBy = orderBy;
        this.ou = ou;
        this.startDate = startDate;
        this.threshold = threshold;
    }

    @JsonProperty("algorithm")
    public Optional<OutlierDetectionAlgorithm> getAlgorithm() {
        return Optional.ofNullable(algorithm);
    }

    @JsonProperty("algorithm")
    public void setAlgorithm(OutlierDetectionAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    public OutlierDetectionQuery withAlgorithm(OutlierDetectionAlgorithm algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    @JsonProperty("dataEndDate")
    public Optional<Date> getDataEndDate() {
        return Optional.ofNullable(dataEndDate);
    }

    @JsonProperty("dataEndDate")
    public void setDataEndDate(Date dataEndDate) {
        this.dataEndDate = dataEndDate;
    }

    public OutlierDetectionQuery withDataEndDate(Date dataEndDate) {
        this.dataEndDate = dataEndDate;
        return this;
    }

    @JsonProperty("dataStartDate")
    public Optional<Date> getDataStartDate() {
        return Optional.ofNullable(dataStartDate);
    }

    @JsonProperty("dataStartDate")
    public void setDataStartDate(Date dataStartDate) {
        this.dataStartDate = dataStartDate;
    }

    public OutlierDetectionQuery withDataStartDate(Date dataStartDate) {
        this.dataStartDate = dataStartDate;
        return this;
    }

    @JsonProperty("de")
    public Optional<List<String>> getDe() {
        return Optional.ofNullable(de);
    }

    @JsonProperty("de")
    public void setDe(List<String> de) {
        this.de = de;
    }

    public OutlierDetectionQuery withDe(List<String> de) {
        this.de = de;
        return this;
    }

    @JsonProperty("ds")
    public Optional<List<String>> getDs() {
        return Optional.ofNullable(ds);
    }

    @JsonProperty("ds")
    public void setDs(List<String> ds) {
        this.ds = ds;
    }

    public OutlierDetectionQuery withDs(List<String> ds) {
        this.ds = ds;
        return this;
    }

    @JsonProperty("endDate")
    public Optional<Date> getEndDate() {
        return Optional.ofNullable(endDate);
    }

    @JsonProperty("endDate")
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public OutlierDetectionQuery withEndDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    @JsonProperty("maxResults")
    public Optional<Integer> getMaxResults() {
        return Optional.ofNullable(maxResults);
    }

    @JsonProperty("maxResults")
    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public OutlierDetectionQuery withMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    @JsonProperty("orderBy")
    public Optional<Order_> getOrderBy() {
        return Optional.ofNullable(orderBy);
    }

    @JsonProperty("orderBy")
    public void setOrderBy(Order_ orderBy) {
        this.orderBy = orderBy;
    }

    public OutlierDetectionQuery withOrderBy(Order_ orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    @JsonProperty("ou")
    public Optional<List<String>> getOu() {
        return Optional.ofNullable(ou);
    }

    @JsonProperty("ou")
    public void setOu(List<String> ou) {
        this.ou = ou;
    }

    public OutlierDetectionQuery withOu(List<String> ou) {
        this.ou = ou;
        return this;
    }

    @JsonProperty("startDate")
    public Optional<Date> getStartDate() {
        return Optional.ofNullable(startDate);
    }

    @JsonProperty("startDate")
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public OutlierDetectionQuery withStartDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    @JsonProperty("threshold")
    public Optional<Double> getThreshold() {
        return Optional.ofNullable(threshold);
    }

    @JsonProperty("threshold")
    public void setThreshold(Double threshold) {
        this.threshold = threshold;
    }

    public OutlierDetectionQuery withThreshold(Double threshold) {
        this.threshold = threshold;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public OutlierDetectionQuery withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "algorithm":
                if (value instanceof OutlierDetectionAlgorithm) {
                    setAlgorithm(((OutlierDetectionAlgorithm) value));
                } else {
                    throw new IllegalArgumentException(("property \"algorithm\" is of type \"org.hisp.dhis.api.model.v2_37_7.OutlierDetectionAlgorithm\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataEndDate":
                if (value instanceof Date) {
                    setDataEndDate(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataEndDate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataStartDate":
                if (value instanceof Date) {
                    setDataStartDate(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataStartDate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "de":
                if (value instanceof List) {
                    setDe(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"de\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "ds":
                if (value instanceof List) {
                    setDs(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"ds\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "endDate":
                if (value instanceof Date) {
                    setEndDate(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"endDate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "maxResults":
                if (value instanceof Integer) {
                    setMaxResults(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"maxResults\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "orderBy":
                if (value instanceof Order_) {
                    setOrderBy(((Order_) value));
                } else {
                    throw new IllegalArgumentException(("property \"orderBy\" is of type \"org.hisp.dhis.api.model.v2_37_7.Order_\", but got "+ value.getClass().toString()));
                }
                return true;
            case "ou":
                if (value instanceof List) {
                    setOu(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"ou\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "startDate":
                if (value instanceof Date) {
                    setStartDate(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"startDate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "threshold":
                if (value instanceof Double) {
                    setThreshold(((Double) value));
                } else {
                    throw new IllegalArgumentException(("property \"threshold\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "algorithm":
                return getAlgorithm();
            case "dataEndDate":
                return getDataEndDate();
            case "dataStartDate":
                return getDataStartDate();
            case "de":
                return getDe();
            case "ds":
                return getDs();
            case "endDate":
                return getEndDate();
            case "maxResults":
                return getMaxResults();
            case "orderBy":
                return getOrderBy();
            case "ou":
                return getOu();
            case "startDate":
                return getStartDate();
            case "threshold":
                return getThreshold();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, OutlierDetectionQuery.NOT_FOUND_VALUE);
        if (OutlierDetectionQuery.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public OutlierDetectionQuery with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OutlierDetectionQuery.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("algorithm");
        sb.append('=');
        sb.append(((this.algorithm == null)?"<null>":this.algorithm));
        sb.append(',');
        sb.append("dataEndDate");
        sb.append('=');
        sb.append(((this.dataEndDate == null)?"<null>":this.dataEndDate));
        sb.append(',');
        sb.append("dataStartDate");
        sb.append('=');
        sb.append(((this.dataStartDate == null)?"<null>":this.dataStartDate));
        sb.append(',');
        sb.append("de");
        sb.append('=');
        sb.append(((this.de == null)?"<null>":this.de));
        sb.append(',');
        sb.append("ds");
        sb.append('=');
        sb.append(((this.ds == null)?"<null>":this.ds));
        sb.append(',');
        sb.append("endDate");
        sb.append('=');
        sb.append(((this.endDate == null)?"<null>":this.endDate));
        sb.append(',');
        sb.append("maxResults");
        sb.append('=');
        sb.append(((this.maxResults == null)?"<null>":this.maxResults));
        sb.append(',');
        sb.append("orderBy");
        sb.append('=');
        sb.append(((this.orderBy == null)?"<null>":this.orderBy));
        sb.append(',');
        sb.append("ou");
        sb.append('=');
        sb.append(((this.ou == null)?"<null>":this.ou));
        sb.append(',');
        sb.append("startDate");
        sb.append('=');
        sb.append(((this.startDate == null)?"<null>":this.startDate));
        sb.append(',');
        sb.append("threshold");
        sb.append('=');
        sb.append(((this.threshold == null)?"<null>":this.threshold));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.de == null)? 0 :this.de.hashCode()));
        result = ((result* 31)+((this.endDate == null)? 0 :this.endDate.hashCode()));
        result = ((result* 31)+((this.ou == null)? 0 :this.ou.hashCode()));
        result = ((result* 31)+((this.orderBy == null)? 0 :this.orderBy.hashCode()));
        result = ((result* 31)+((this.threshold == null)? 0 :this.threshold.hashCode()));
        result = ((result* 31)+((this.ds == null)? 0 :this.ds.hashCode()));
        result = ((result* 31)+((this.dataStartDate == null)? 0 :this.dataStartDate.hashCode()));
        result = ((result* 31)+((this.maxResults == null)? 0 :this.maxResults.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.dataEndDate == null)? 0 :this.dataEndDate.hashCode()));
        result = ((result* 31)+((this.startDate == null)? 0 :this.startDate.hashCode()));
        result = ((result* 31)+((this.algorithm == null)? 0 :this.algorithm.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OutlierDetectionQuery) == false) {
            return false;
        }
        OutlierDetectionQuery rhs = ((OutlierDetectionQuery) other);
        return (((((((((((((this.de == rhs.de)||((this.de!= null)&&this.de.equals(rhs.de)))&&((this.endDate == rhs.endDate)||((this.endDate!= null)&&this.endDate.equals(rhs.endDate))))&&((this.ou == rhs.ou)||((this.ou!= null)&&this.ou.equals(rhs.ou))))&&((this.orderBy == rhs.orderBy)||((this.orderBy!= null)&&this.orderBy.equals(rhs.orderBy))))&&((this.threshold == rhs.threshold)||((this.threshold!= null)&&this.threshold.equals(rhs.threshold))))&&((this.ds == rhs.ds)||((this.ds!= null)&&this.ds.equals(rhs.ds))))&&((this.dataStartDate == rhs.dataStartDate)||((this.dataStartDate!= null)&&this.dataStartDate.equals(rhs.dataStartDate))))&&((this.maxResults == rhs.maxResults)||((this.maxResults!= null)&&this.maxResults.equals(rhs.maxResults))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.dataEndDate == rhs.dataEndDate)||((this.dataEndDate!= null)&&this.dataEndDate.equals(rhs.dataEndDate))))&&((this.startDate == rhs.startDate)||((this.startDate!= null)&&this.startDate.equals(rhs.startDate))))&&((this.algorithm == rhs.algorithm)||((this.algorithm!= null)&&this.algorithm.equals(rhs.algorithm))));
    }

}
