
package org.hisp.dhis.api.model.v2_37_7;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "nextPage",
    "page",
    "pageCount",
    "pageSize",
    "prevPage",
    "total"
})
@Generated("jsonschema2pojo")
public class Pager implements Serializable
{

    @JsonProperty("nextPage")
    private String nextPage;
    @JsonProperty("page")
    private Integer page;
    @JsonProperty("pageCount")
    private Integer pageCount;
    @JsonProperty("pageSize")
    private Integer pageSize;
    @JsonProperty("prevPage")
    private String prevPage;
    @JsonProperty("total")
    private Integer total;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -7352223074447243285L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Pager() {
    }

    /**
     * 
     * @param source
     */
    public Pager(Pager source) {
        super();
        this.nextPage = source.nextPage;
        this.page = source.page;
        this.pageCount = source.pageCount;
        this.pageSize = source.pageSize;
        this.prevPage = source.prevPage;
        this.total = source.total;
    }

    /**
     * 
     * @param pageCount
     * @param total
     * @param nextPage
     * @param pageSize
     * @param prevPage
     * @param page
     */
    public Pager(String nextPage, Integer page, Integer pageCount, Integer pageSize, String prevPage, Integer total) {
        super();
        this.nextPage = nextPage;
        this.page = page;
        this.pageCount = pageCount;
        this.pageSize = pageSize;
        this.prevPage = prevPage;
        this.total = total;
    }

    @JsonProperty("nextPage")
    public Optional<String> getNextPage() {
        return Optional.ofNullable(nextPage);
    }

    @JsonProperty("nextPage")
    public void setNextPage(String nextPage) {
        this.nextPage = nextPage;
    }

    public Pager withNextPage(String nextPage) {
        this.nextPage = nextPage;
        return this;
    }

    @JsonProperty("page")
    public Optional<Integer> getPage() {
        return Optional.ofNullable(page);
    }

    @JsonProperty("page")
    public void setPage(Integer page) {
        this.page = page;
    }

    public Pager withPage(Integer page) {
        this.page = page;
        return this;
    }

    @JsonProperty("pageCount")
    public Optional<Integer> getPageCount() {
        return Optional.ofNullable(pageCount);
    }

    @JsonProperty("pageCount")
    public void setPageCount(Integer pageCount) {
        this.pageCount = pageCount;
    }

    public Pager withPageCount(Integer pageCount) {
        this.pageCount = pageCount;
        return this;
    }

    @JsonProperty("pageSize")
    public Optional<Integer> getPageSize() {
        return Optional.ofNullable(pageSize);
    }

    @JsonProperty("pageSize")
    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Pager withPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @JsonProperty("prevPage")
    public Optional<String> getPrevPage() {
        return Optional.ofNullable(prevPage);
    }

    @JsonProperty("prevPage")
    public void setPrevPage(String prevPage) {
        this.prevPage = prevPage;
    }

    public Pager withPrevPage(String prevPage) {
        this.prevPage = prevPage;
        return this;
    }

    @JsonProperty("total")
    public Optional<Integer> getTotal() {
        return Optional.ofNullable(total);
    }

    @JsonProperty("total")
    public void setTotal(Integer total) {
        this.total = total;
    }

    public Pager withTotal(Integer total) {
        this.total = total;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Pager withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "nextPage":
                if (value instanceof String) {
                    setNextPage(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"nextPage\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "page":
                if (value instanceof Integer) {
                    setPage(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"page\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "pageCount":
                if (value instanceof Integer) {
                    setPageCount(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"pageCount\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "pageSize":
                if (value instanceof Integer) {
                    setPageSize(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"pageSize\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "prevPage":
                if (value instanceof String) {
                    setPrevPage(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"prevPage\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "total":
                if (value instanceof Integer) {
                    setTotal(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"total\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "nextPage":
                return getNextPage();
            case "page":
                return getPage();
            case "pageCount":
                return getPageCount();
            case "pageSize":
                return getPageSize();
            case "prevPage":
                return getPrevPage();
            case "total":
                return getTotal();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, Pager.NOT_FOUND_VALUE);
        if (Pager.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public Pager with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Pager.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("nextPage");
        sb.append('=');
        sb.append(((this.nextPage == null)?"<null>":this.nextPage));
        sb.append(',');
        sb.append("page");
        sb.append('=');
        sb.append(((this.page == null)?"<null>":this.page));
        sb.append(',');
        sb.append("pageCount");
        sb.append('=');
        sb.append(((this.pageCount == null)?"<null>":this.pageCount));
        sb.append(',');
        sb.append("pageSize");
        sb.append('=');
        sb.append(((this.pageSize == null)?"<null>":this.pageSize));
        sb.append(',');
        sb.append("prevPage");
        sb.append('=');
        sb.append(((this.prevPage == null)?"<null>":this.prevPage));
        sb.append(',');
        sb.append("total");
        sb.append('=');
        sb.append(((this.total == null)?"<null>":this.total));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.pageCount == null)? 0 :this.pageCount.hashCode()));
        result = ((result* 31)+((this.total == null)? 0 :this.total.hashCode()));
        result = ((result* 31)+((this.nextPage == null)? 0 :this.nextPage.hashCode()));
        result = ((result* 31)+((this.pageSize == null)? 0 :this.pageSize.hashCode()));
        result = ((result* 31)+((this.prevPage == null)? 0 :this.prevPage.hashCode()));
        result = ((result* 31)+((this.page == null)? 0 :this.page.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Pager) == false) {
            return false;
        }
        Pager rhs = ((Pager) other);
        return ((((((((this.pageCount == rhs.pageCount)||((this.pageCount!= null)&&this.pageCount.equals(rhs.pageCount)))&&((this.total == rhs.total)||((this.total!= null)&&this.total.equals(rhs.total))))&&((this.nextPage == rhs.nextPage)||((this.nextPage!= null)&&this.nextPage.equals(rhs.nextPage))))&&((this.pageSize == rhs.pageSize)||((this.pageSize!= null)&&this.pageSize.equals(rhs.pageSize))))&&((this.prevPage == rhs.prevPage)||((this.prevPage!= null)&&this.prevPage.equals(rhs.prevPage))))&&((this.page == rhs.page)||((this.page!= null)&&this.page.equals(rhs.page))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))));
    }

}
