
package org.hisp.dhis.api.model.v2_37_7;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "program",
    "programStage",
    "relationshipEntity",
    "trackedEntityType"
})
@Generated("jsonschema2pojo")
public class RelationshipConstraint implements Serializable
{

    @JsonProperty("program")
    private Program program;
    @JsonProperty("programStage")
    private ProgramStage programStage;
    @JsonProperty("relationshipEntity")
    private RelationshipConstraint.RelationshipEntity relationshipEntity;
    @JsonProperty("trackedEntityType")
    private TrackedEntityType trackedEntityType;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 6557726244136538982L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public RelationshipConstraint() {
    }

    /**
     * 
     * @param source
     */
    public RelationshipConstraint(RelationshipConstraint source) {
        super();
        this.program = source.program;
        this.programStage = source.programStage;
        this.relationshipEntity = source.relationshipEntity;
        this.trackedEntityType = source.trackedEntityType;
    }

    /**
     * 
     * @param programStage
     * @param trackedEntityType
     * @param relationshipEntity
     * @param program
     */
    public RelationshipConstraint(Program program, ProgramStage programStage, RelationshipConstraint.RelationshipEntity relationshipEntity, TrackedEntityType trackedEntityType) {
        super();
        this.program = program;
        this.programStage = programStage;
        this.relationshipEntity = relationshipEntity;
        this.trackedEntityType = trackedEntityType;
    }

    @JsonProperty("program")
    public Optional<Program> getProgram() {
        return Optional.ofNullable(program);
    }

    @JsonProperty("program")
    public void setProgram(Program program) {
        this.program = program;
    }

    public RelationshipConstraint withProgram(Program program) {
        this.program = program;
        return this;
    }

    @JsonProperty("programStage")
    public Optional<ProgramStage> getProgramStage() {
        return Optional.ofNullable(programStage);
    }

    @JsonProperty("programStage")
    public void setProgramStage(ProgramStage programStage) {
        this.programStage = programStage;
    }

    public RelationshipConstraint withProgramStage(ProgramStage programStage) {
        this.programStage = programStage;
        return this;
    }

    @JsonProperty("relationshipEntity")
    public Optional<RelationshipConstraint.RelationshipEntity> getRelationshipEntity() {
        return Optional.ofNullable(relationshipEntity);
    }

    @JsonProperty("relationshipEntity")
    public void setRelationshipEntity(RelationshipConstraint.RelationshipEntity relationshipEntity) {
        this.relationshipEntity = relationshipEntity;
    }

    public RelationshipConstraint withRelationshipEntity(RelationshipConstraint.RelationshipEntity relationshipEntity) {
        this.relationshipEntity = relationshipEntity;
        return this;
    }

    @JsonProperty("trackedEntityType")
    public Optional<TrackedEntityType> getTrackedEntityType() {
        return Optional.ofNullable(trackedEntityType);
    }

    @JsonProperty("trackedEntityType")
    public void setTrackedEntityType(TrackedEntityType trackedEntityType) {
        this.trackedEntityType = trackedEntityType;
    }

    public RelationshipConstraint withTrackedEntityType(TrackedEntityType trackedEntityType) {
        this.trackedEntityType = trackedEntityType;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public RelationshipConstraint withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "program":
                if (value instanceof Program) {
                    setProgram(((Program) value));
                } else {
                    throw new IllegalArgumentException(("property \"program\" is of type \"org.hisp.dhis.api.model.v2_37_7.Program\", but got "+ value.getClass().toString()));
                }
                return true;
            case "programStage":
                if (value instanceof ProgramStage) {
                    setProgramStage(((ProgramStage) value));
                } else {
                    throw new IllegalArgumentException(("property \"programStage\" is of type \"org.hisp.dhis.api.model.v2_37_7.ProgramStage\", but got "+ value.getClass().toString()));
                }
                return true;
            case "relationshipEntity":
                if (value instanceof RelationshipConstraint.RelationshipEntity) {
                    setRelationshipEntity(((RelationshipConstraint.RelationshipEntity) value));
                } else {
                    throw new IllegalArgumentException(("property \"relationshipEntity\" is of type \"org.hisp.dhis.api.model.v2_37_7.RelationshipConstraint.RelationshipEntity\", but got "+ value.getClass().toString()));
                }
                return true;
            case "trackedEntityType":
                if (value instanceof TrackedEntityType) {
                    setTrackedEntityType(((TrackedEntityType) value));
                } else {
                    throw new IllegalArgumentException(("property \"trackedEntityType\" is of type \"org.hisp.dhis.api.model.v2_37_7.TrackedEntityType\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "program":
                return getProgram();
            case "programStage":
                return getProgramStage();
            case "relationshipEntity":
                return getRelationshipEntity();
            case "trackedEntityType":
                return getTrackedEntityType();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, RelationshipConstraint.NOT_FOUND_VALUE);
        if (RelationshipConstraint.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public RelationshipConstraint with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(RelationshipConstraint.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("program");
        sb.append('=');
        sb.append(((this.program == null)?"<null>":this.program));
        sb.append(',');
        sb.append("programStage");
        sb.append('=');
        sb.append(((this.programStage == null)?"<null>":this.programStage));
        sb.append(',');
        sb.append("relationshipEntity");
        sb.append('=');
        sb.append(((this.relationshipEntity == null)?"<null>":this.relationshipEntity));
        sb.append(',');
        sb.append("trackedEntityType");
        sb.append('=');
        sb.append(((this.trackedEntityType == null)?"<null>":this.trackedEntityType));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.programStage == null)? 0 :this.programStage.hashCode()));
        result = ((result* 31)+((this.trackedEntityType == null)? 0 :this.trackedEntityType.hashCode()));
        result = ((result* 31)+((this.relationshipEntity == null)? 0 :this.relationshipEntity.hashCode()));
        result = ((result* 31)+((this.program == null)? 0 :this.program.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof RelationshipConstraint) == false) {
            return false;
        }
        RelationshipConstraint rhs = ((RelationshipConstraint) other);
        return ((((((this.programStage == rhs.programStage)||((this.programStage!= null)&&this.programStage.equals(rhs.programStage)))&&((this.trackedEntityType == rhs.trackedEntityType)||((this.trackedEntityType!= null)&&this.trackedEntityType.equals(rhs.trackedEntityType))))&&((this.relationshipEntity == rhs.relationshipEntity)||((this.relationshipEntity!= null)&&this.relationshipEntity.equals(rhs.relationshipEntity))))&&((this.program == rhs.program)||((this.program!= null)&&this.program.equals(rhs.program))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))));
    }

    @Generated("jsonschema2pojo")
    public enum RelationshipEntity {

        TRACKED_ENTITY_INSTANCE("TRACKED_ENTITY_INSTANCE"),
        PROGRAM_INSTANCE("PROGRAM_INSTANCE"),
        PROGRAM_STAGE_INSTANCE("PROGRAM_STAGE_INSTANCE");
        private final String value;
        private final static Map<String, RelationshipConstraint.RelationshipEntity> CONSTANTS = new HashMap<String, RelationshipConstraint.RelationshipEntity>();

        static {
            for (RelationshipConstraint.RelationshipEntity c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        RelationshipEntity(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static RelationshipConstraint.RelationshipEntity fromValue(String value) {
            RelationshipConstraint.RelationshipEntity constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
