
package org.hisp.dhis.api.model.v2_37_7;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "organisationUnit",
    "program",
    "trackedEntityInstance"
})
@Generated("jsonschema2pojo")
public class TrackedEntityProgramOwner implements Serializable
{

    @JsonProperty("organisationUnit")
    private OrganisationUnit organisationUnit;
    @JsonProperty("program")
    private Program program;
    @JsonProperty("trackedEntityInstance")
    private TrackedEntityInstance__1 trackedEntityInstance;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 3193847026005229421L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TrackedEntityProgramOwner() {
    }

    /**
     * 
     * @param source
     */
    public TrackedEntityProgramOwner(TrackedEntityProgramOwner source) {
        super();
        this.organisationUnit = source.organisationUnit;
        this.program = source.program;
        this.trackedEntityInstance = source.trackedEntityInstance;
    }

    /**
     * 
     * @param organisationUnit
     * @param program
     * @param trackedEntityInstance
     */
    public TrackedEntityProgramOwner(OrganisationUnit organisationUnit, Program program, TrackedEntityInstance__1 trackedEntityInstance) {
        super();
        this.organisationUnit = organisationUnit;
        this.program = program;
        this.trackedEntityInstance = trackedEntityInstance;
    }

    @JsonProperty("organisationUnit")
    public Optional<OrganisationUnit> getOrganisationUnit() {
        return Optional.ofNullable(organisationUnit);
    }

    @JsonProperty("organisationUnit")
    public void setOrganisationUnit(OrganisationUnit organisationUnit) {
        this.organisationUnit = organisationUnit;
    }

    public TrackedEntityProgramOwner withOrganisationUnit(OrganisationUnit organisationUnit) {
        this.organisationUnit = organisationUnit;
        return this;
    }

    @JsonProperty("program")
    public Optional<Program> getProgram() {
        return Optional.ofNullable(program);
    }

    @JsonProperty("program")
    public void setProgram(Program program) {
        this.program = program;
    }

    public TrackedEntityProgramOwner withProgram(Program program) {
        this.program = program;
        return this;
    }

    @JsonProperty("trackedEntityInstance")
    public Optional<TrackedEntityInstance__1> getTrackedEntityInstance() {
        return Optional.ofNullable(trackedEntityInstance);
    }

    @JsonProperty("trackedEntityInstance")
    public void setTrackedEntityInstance(TrackedEntityInstance__1 trackedEntityInstance) {
        this.trackedEntityInstance = trackedEntityInstance;
    }

    public TrackedEntityProgramOwner withTrackedEntityInstance(TrackedEntityInstance__1 trackedEntityInstance) {
        this.trackedEntityInstance = trackedEntityInstance;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public TrackedEntityProgramOwner withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "organisationUnit":
                if (value instanceof OrganisationUnit) {
                    setOrganisationUnit(((OrganisationUnit) value));
                } else {
                    throw new IllegalArgumentException(("property \"organisationUnit\" is of type \"org.hisp.dhis.api.model.v2_37_7.OrganisationUnit\", but got "+ value.getClass().toString()));
                }
                return true;
            case "program":
                if (value instanceof Program) {
                    setProgram(((Program) value));
                } else {
                    throw new IllegalArgumentException(("property \"program\" is of type \"org.hisp.dhis.api.model.v2_37_7.Program\", but got "+ value.getClass().toString()));
                }
                return true;
            case "trackedEntityInstance":
                if (value instanceof TrackedEntityInstance__1) {
                    setTrackedEntityInstance(((TrackedEntityInstance__1) value));
                } else {
                    throw new IllegalArgumentException(("property \"trackedEntityInstance\" is of type \"org.hisp.dhis.api.model.v2_37_7.TrackedEntityInstance__1\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "organisationUnit":
                return getOrganisationUnit();
            case "program":
                return getProgram();
            case "trackedEntityInstance":
                return getTrackedEntityInstance();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, TrackedEntityProgramOwner.NOT_FOUND_VALUE);
        if (TrackedEntityProgramOwner.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public TrackedEntityProgramOwner with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TrackedEntityProgramOwner.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("organisationUnit");
        sb.append('=');
        sb.append(((this.organisationUnit == null)?"<null>":this.organisationUnit));
        sb.append(',');
        sb.append("program");
        sb.append('=');
        sb.append(((this.program == null)?"<null>":this.program));
        sb.append(',');
        sb.append("trackedEntityInstance");
        sb.append('=');
        sb.append(((this.trackedEntityInstance == null)?"<null>":this.trackedEntityInstance));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.program == null)? 0 :this.program.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.organisationUnit == null)? 0 :this.organisationUnit.hashCode()));
        result = ((result* 31)+((this.trackedEntityInstance == null)? 0 :this.trackedEntityInstance.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TrackedEntityProgramOwner) == false) {
            return false;
        }
        TrackedEntityProgramOwner rhs = ((TrackedEntityProgramOwner) other);
        return (((((this.program == rhs.program)||((this.program!= null)&&this.program.equals(rhs.program)))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.organisationUnit == rhs.organisationUnit)||((this.organisationUnit!= null)&&this.organisationUnit.equals(rhs.organisationUnit))))&&((this.trackedEntityInstance == rhs.trackedEntityInstance)||((this.trackedEntityInstance!= null)&&this.trackedEntityInstance.equals(rhs.trackedEntityInstance))));
    }

}
