
package org.hisp.dhis.api.model.v2_37_7;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "aggregateExportAttributeOptionCombo",
    "aggregateExportCategoryOptionCombo",
    "aggregationType",
    "attributeValues",
    "code",
    "created",
    "createdBy",
    "description",
    "dimensionItem",
    "dimensionItemType",
    "displayDescription",
    "displayFormName",
    "displayInstruction",
    "displayName",
    "displayShortName",
    "externalAccess",
    "favorite",
    "favorites",
    "formName",
    "href",
    "id",
    "importance",
    "instruction",
    "lastUpdated",
    "lastUpdatedBy",
    "leftSide",
    "legendSet",
    "legendSets",
    "name",
    "notificationTemplates",
    "operator",
    "organisationUnitLevels",
    "periodOffset",
    "periodType",
    "publicAccess",
    "rightSide",
    "sharing",
    "shortName",
    "skipFormValidation",
    "translations",
    "user",
    "userAccesses",
    "userGroupAccesses",
    "validationRuleGroups"
})
@Generated("jsonschema2pojo")
public class ValidationRule implements Serializable
{

    @JsonProperty("access")
    private Access access;
    @JsonProperty("aggregateExportAttributeOptionCombo")
    private String aggregateExportAttributeOptionCombo;
    @JsonProperty("aggregateExportCategoryOptionCombo")
    private String aggregateExportCategoryOptionCombo;
    @JsonProperty("aggregationType")
    private AggregationType aggregationType;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues = null;
    @JsonProperty("code")
    private String code;
    @JsonProperty("created")
    private Date created;
    @JsonProperty("createdBy")
    private User createdBy;
    @JsonProperty("description")
    private String description;
    @JsonProperty("dimensionItem")
    private String dimensionItem;
    @JsonProperty("dimensionItemType")
    private org.hisp.dhis.api.model.v2_37_7.CategoryOptionCombo.DimensionItemType dimensionItemType;
    @JsonProperty("displayDescription")
    private String displayDescription;
    @JsonProperty("displayFormName")
    private String displayFormName;
    @JsonProperty("displayInstruction")
    private String displayInstruction;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("displayShortName")
    private String displayShortName;
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites = null;
    @JsonProperty("formName")
    private String formName;
    @JsonProperty("href")
    private String href;
    @JsonProperty("id")
    private String id;
    @JsonProperty("importance")
    private Importance importance;
    @JsonProperty("instruction")
    private String instruction;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    @JsonProperty("lastUpdatedBy")
    private User lastUpdatedBy;
    @JsonProperty("leftSide")
    private Expression leftSide;
    @JsonProperty("legendSet")
    private LegendSet legendSet;
    @JsonProperty("legendSets")
    private List<LegendSet> legendSets = null;
    @JsonProperty("name")
    private String name;
    @JsonProperty("notificationTemplates")
    private List<ValidationNotificationTemplate> notificationTemplates = null;
    @JsonProperty("operator")
    private ValidationRule.Operator operator;
    @JsonProperty("organisationUnitLevels")
    private List<Integer> organisationUnitLevels = null;
    @JsonProperty("periodOffset")
    private Integer periodOffset;
    /**
     * Undefined
     * 
     */
    @JsonProperty("periodType")
    private Object periodType;
    @JsonProperty("publicAccess")
    private String publicAccess;
    @JsonProperty("rightSide")
    private Expression rightSide;
    @JsonProperty("sharing")
    private Sharing sharing;
    @JsonProperty("shortName")
    private String shortName;
    @JsonProperty("skipFormValidation")
    private Boolean skipFormValidation;
    @JsonProperty("translations")
    private List<Translation> translations = null;
    @JsonProperty("user")
    private User user;
    @JsonProperty("userAccesses")
    private List<UserAccess> userAccesses = null;
    @JsonProperty("userGroupAccesses")
    private List<UserGroupAccess> userGroupAccesses = null;
    @JsonProperty("validationRuleGroups")
    private List<ValidationRuleGroup> validationRuleGroups = null;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -4237762064834202661L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ValidationRule() {
    }

    /**
     * 
     * @param source
     */
    public ValidationRule(ValidationRule source) {
        super();
        this.access = source.access;
        this.aggregateExportAttributeOptionCombo = source.aggregateExportAttributeOptionCombo;
        this.aggregateExportCategoryOptionCombo = source.aggregateExportCategoryOptionCombo;
        this.aggregationType = source.aggregationType;
        this.attributeValues = source.attributeValues;
        this.code = source.code;
        this.created = source.created;
        this.createdBy = source.createdBy;
        this.description = source.description;
        this.dimensionItem = source.dimensionItem;
        this.dimensionItemType = source.dimensionItemType;
        this.displayDescription = source.displayDescription;
        this.displayFormName = source.displayFormName;
        this.displayInstruction = source.displayInstruction;
        this.displayName = source.displayName;
        this.displayShortName = source.displayShortName;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.formName = source.formName;
        this.href = source.href;
        this.id = source.id;
        this.importance = source.importance;
        this.instruction = source.instruction;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.leftSide = source.leftSide;
        this.legendSet = source.legendSet;
        this.legendSets = source.legendSets;
        this.name = source.name;
        this.notificationTemplates = source.notificationTemplates;
        this.operator = source.operator;
        this.organisationUnitLevels = source.organisationUnitLevels;
        this.periodOffset = source.periodOffset;
        this.periodType = source.periodType;
        this.publicAccess = source.publicAccess;
        this.rightSide = source.rightSide;
        this.sharing = source.sharing;
        this.shortName = source.shortName;
        this.skipFormValidation = source.skipFormValidation;
        this.translations = source.translations;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userGroupAccesses = source.userGroupAccesses;
        this.validationRuleGroups = source.validationRuleGroups;
    }

    /**
     * 
     * @param favorites
     * @param validationRuleGroups
     * @param aggregationType
     * @param access
     * @param code
     * @param displayName
     * @param importance
     * @param publicAccess
     * @param aggregateExportCategoryOptionCombo
     * @param description
     * @param displayShortName
     * @param operator
     * @param externalAccess
     * @param organisationUnitLevels
     * @param displayInstruction
     * @param lastUpdated
     * @param leftSide
     * @param periodOffset
     * @param notificationTemplates
     * @param translations
     * @param formName
     * @param href
     * @param id
     * @param displayDescription
     * @param lastUpdatedBy
     * @param userGroupAccesses
     * @param dimensionItem
     * @param created
     * @param attributeValues
     * @param rightSide
     * @param sharing
     * @param displayFormName
     * @param periodType
     * @param createdBy
     * @param instruction
     * @param userAccesses
     * @param legendSet
     * @param name
     * @param skipFormValidation
     * @param legendSets
     * @param shortName
     * @param aggregateExportAttributeOptionCombo
     * @param favorite
     * @param user
     * @param dimensionItemType
     */
    public ValidationRule(Access access, String aggregateExportAttributeOptionCombo, String aggregateExportCategoryOptionCombo, AggregationType aggregationType, List<AttributeValue> attributeValues, String code, Date created, User createdBy, String description, String dimensionItem, org.hisp.dhis.api.model.v2_37_7.CategoryOptionCombo.DimensionItemType dimensionItemType, String displayDescription, String displayFormName, String displayInstruction, String displayName, String displayShortName, Boolean externalAccess, Boolean favorite, List<String> favorites, String formName, String href, String id, Importance importance, String instruction, Date lastUpdated, User lastUpdatedBy, Expression leftSide, LegendSet legendSet, List<LegendSet> legendSets, String name, List<ValidationNotificationTemplate> notificationTemplates, ValidationRule.Operator operator, List<Integer> organisationUnitLevels, Integer periodOffset, Object periodType, String publicAccess, Expression rightSide, Sharing sharing, String shortName, Boolean skipFormValidation, List<Translation> translations, User user, List<UserAccess> userAccesses, List<UserGroupAccess> userGroupAccesses, List<ValidationRuleGroup> validationRuleGroups) {
        super();
        this.access = access;
        this.aggregateExportAttributeOptionCombo = aggregateExportAttributeOptionCombo;
        this.aggregateExportCategoryOptionCombo = aggregateExportCategoryOptionCombo;
        this.aggregationType = aggregationType;
        this.attributeValues = attributeValues;
        this.code = code;
        this.created = created;
        this.createdBy = createdBy;
        this.description = description;
        this.dimensionItem = dimensionItem;
        this.dimensionItemType = dimensionItemType;
        this.displayDescription = displayDescription;
        this.displayFormName = displayFormName;
        this.displayInstruction = displayInstruction;
        this.displayName = displayName;
        this.displayShortName = displayShortName;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.formName = formName;
        this.href = href;
        this.id = id;
        this.importance = importance;
        this.instruction = instruction;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.leftSide = leftSide;
        this.legendSet = legendSet;
        this.legendSets = legendSets;
        this.name = name;
        this.notificationTemplates = notificationTemplates;
        this.operator = operator;
        this.organisationUnitLevels = organisationUnitLevels;
        this.periodOffset = periodOffset;
        this.periodType = periodType;
        this.publicAccess = publicAccess;
        this.rightSide = rightSide;
        this.sharing = sharing;
        this.shortName = shortName;
        this.skipFormValidation = skipFormValidation;
        this.translations = translations;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userGroupAccesses = userGroupAccesses;
        this.validationRuleGroups = validationRuleGroups;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public ValidationRule withAccess(Access access) {
        this.access = access;
        return this;
    }

    @JsonProperty("aggregateExportAttributeOptionCombo")
    public Optional<String> getAggregateExportAttributeOptionCombo() {
        return Optional.ofNullable(aggregateExportAttributeOptionCombo);
    }

    @JsonProperty("aggregateExportAttributeOptionCombo")
    public void setAggregateExportAttributeOptionCombo(String aggregateExportAttributeOptionCombo) {
        this.aggregateExportAttributeOptionCombo = aggregateExportAttributeOptionCombo;
    }

    public ValidationRule withAggregateExportAttributeOptionCombo(String aggregateExportAttributeOptionCombo) {
        this.aggregateExportAttributeOptionCombo = aggregateExportAttributeOptionCombo;
        return this;
    }

    @JsonProperty("aggregateExportCategoryOptionCombo")
    public Optional<String> getAggregateExportCategoryOptionCombo() {
        return Optional.ofNullable(aggregateExportCategoryOptionCombo);
    }

    @JsonProperty("aggregateExportCategoryOptionCombo")
    public void setAggregateExportCategoryOptionCombo(String aggregateExportCategoryOptionCombo) {
        this.aggregateExportCategoryOptionCombo = aggregateExportCategoryOptionCombo;
    }

    public ValidationRule withAggregateExportCategoryOptionCombo(String aggregateExportCategoryOptionCombo) {
        this.aggregateExportCategoryOptionCombo = aggregateExportCategoryOptionCombo;
        return this;
    }

    @JsonProperty("aggregationType")
    public Optional<AggregationType> getAggregationType() {
        return Optional.ofNullable(aggregationType);
    }

    @JsonProperty("aggregationType")
    public void setAggregationType(AggregationType aggregationType) {
        this.aggregationType = aggregationType;
    }

    public ValidationRule withAggregationType(AggregationType aggregationType) {
        this.aggregationType = aggregationType;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public ValidationRule withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public ValidationRule withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public ValidationRule withCreated(Date created) {
        this.created = created;
        return this;
    }

    @JsonProperty("createdBy")
    public Optional<User> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    @JsonProperty("createdBy")
    public void setCreatedBy(User createdBy) {
        this.createdBy = createdBy;
    }

    public ValidationRule withCreatedBy(User createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @JsonProperty("description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    public ValidationRule withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty("dimensionItem")
    public Optional<String> getDimensionItem() {
        return Optional.ofNullable(dimensionItem);
    }

    @JsonProperty("dimensionItem")
    public void setDimensionItem(String dimensionItem) {
        this.dimensionItem = dimensionItem;
    }

    public ValidationRule withDimensionItem(String dimensionItem) {
        this.dimensionItem = dimensionItem;
        return this;
    }

    @JsonProperty("dimensionItemType")
    public Optional<org.hisp.dhis.api.model.v2_37_7.CategoryOptionCombo.DimensionItemType> getDimensionItemType() {
        return Optional.ofNullable(dimensionItemType);
    }

    @JsonProperty("dimensionItemType")
    public void setDimensionItemType(org.hisp.dhis.api.model.v2_37_7.CategoryOptionCombo.DimensionItemType dimensionItemType) {
        this.dimensionItemType = dimensionItemType;
    }

    public ValidationRule withDimensionItemType(org.hisp.dhis.api.model.v2_37_7.CategoryOptionCombo.DimensionItemType dimensionItemType) {
        this.dimensionItemType = dimensionItemType;
        return this;
    }

    @JsonProperty("displayDescription")
    public Optional<String> getDisplayDescription() {
        return Optional.ofNullable(displayDescription);
    }

    @JsonProperty("displayDescription")
    public void setDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
    }

    public ValidationRule withDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
        return this;
    }

    @JsonProperty("displayFormName")
    public Optional<String> getDisplayFormName() {
        return Optional.ofNullable(displayFormName);
    }

    @JsonProperty("displayFormName")
    public void setDisplayFormName(String displayFormName) {
        this.displayFormName = displayFormName;
    }

    public ValidationRule withDisplayFormName(String displayFormName) {
        this.displayFormName = displayFormName;
        return this;
    }

    @JsonProperty("displayInstruction")
    public Optional<String> getDisplayInstruction() {
        return Optional.ofNullable(displayInstruction);
    }

    @JsonProperty("displayInstruction")
    public void setDisplayInstruction(String displayInstruction) {
        this.displayInstruction = displayInstruction;
    }

    public ValidationRule withDisplayInstruction(String displayInstruction) {
        this.displayInstruction = displayInstruction;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ValidationRule withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("displayShortName")
    public Optional<String> getDisplayShortName() {
        return Optional.ofNullable(displayShortName);
    }

    @JsonProperty("displayShortName")
    public void setDisplayShortName(String displayShortName) {
        this.displayShortName = displayShortName;
    }

    public ValidationRule withDisplayShortName(String displayShortName) {
        this.displayShortName = displayShortName;
        return this;
    }

    @JsonProperty("externalAccess")
    public Optional<Boolean> getExternalAccess() {
        return Optional.ofNullable(externalAccess);
    }

    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public ValidationRule withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    @JsonProperty("favorite")
    public Optional<Boolean> getFavorite() {
        return Optional.ofNullable(favorite);
    }

    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public ValidationRule withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public ValidationRule withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @JsonProperty("formName")
    public Optional<String> getFormName() {
        return Optional.ofNullable(formName);
    }

    @JsonProperty("formName")
    public void setFormName(String formName) {
        this.formName = formName;
    }

    public ValidationRule withFormName(String formName) {
        this.formName = formName;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public ValidationRule withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public ValidationRule withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("importance")
    public Optional<Importance> getImportance() {
        return Optional.ofNullable(importance);
    }

    @JsonProperty("importance")
    public void setImportance(Importance importance) {
        this.importance = importance;
    }

    public ValidationRule withImportance(Importance importance) {
        this.importance = importance;
        return this;
    }

    @JsonProperty("instruction")
    public Optional<String> getInstruction() {
        return Optional.ofNullable(instruction);
    }

    @JsonProperty("instruction")
    public void setInstruction(String instruction) {
        this.instruction = instruction;
    }

    public ValidationRule withInstruction(String instruction) {
        this.instruction = instruction;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public ValidationRule withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @JsonProperty("lastUpdatedBy")
    public Optional<User> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public ValidationRule withLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    @JsonProperty("leftSide")
    public Optional<Expression> getLeftSide() {
        return Optional.ofNullable(leftSide);
    }

    @JsonProperty("leftSide")
    public void setLeftSide(Expression leftSide) {
        this.leftSide = leftSide;
    }

    public ValidationRule withLeftSide(Expression leftSide) {
        this.leftSide = leftSide;
        return this;
    }

    @JsonProperty("legendSet")
    public Optional<LegendSet> getLegendSet() {
        return Optional.ofNullable(legendSet);
    }

    @JsonProperty("legendSet")
    public void setLegendSet(LegendSet legendSet) {
        this.legendSet = legendSet;
    }

    public ValidationRule withLegendSet(LegendSet legendSet) {
        this.legendSet = legendSet;
        return this;
    }

    @JsonProperty("legendSets")
    public Optional<List<LegendSet>> getLegendSets() {
        return Optional.ofNullable(legendSets);
    }

    @JsonProperty("legendSets")
    public void setLegendSets(List<LegendSet> legendSets) {
        this.legendSets = legendSets;
    }

    public ValidationRule withLegendSets(List<LegendSet> legendSets) {
        this.legendSets = legendSets;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public ValidationRule withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("notificationTemplates")
    public Optional<List<ValidationNotificationTemplate>> getNotificationTemplates() {
        return Optional.ofNullable(notificationTemplates);
    }

    @JsonProperty("notificationTemplates")
    public void setNotificationTemplates(List<ValidationNotificationTemplate> notificationTemplates) {
        this.notificationTemplates = notificationTemplates;
    }

    public ValidationRule withNotificationTemplates(List<ValidationNotificationTemplate> notificationTemplates) {
        this.notificationTemplates = notificationTemplates;
        return this;
    }

    @JsonProperty("operator")
    public Optional<ValidationRule.Operator> getOperator() {
        return Optional.ofNullable(operator);
    }

    @JsonProperty("operator")
    public void setOperator(ValidationRule.Operator operator) {
        this.operator = operator;
    }

    public ValidationRule withOperator(ValidationRule.Operator operator) {
        this.operator = operator;
        return this;
    }

    @JsonProperty("organisationUnitLevels")
    public Optional<List<Integer>> getOrganisationUnitLevels() {
        return Optional.ofNullable(organisationUnitLevels);
    }

    @JsonProperty("organisationUnitLevels")
    public void setOrganisationUnitLevels(List<Integer> organisationUnitLevels) {
        this.organisationUnitLevels = organisationUnitLevels;
    }

    public ValidationRule withOrganisationUnitLevels(List<Integer> organisationUnitLevels) {
        this.organisationUnitLevels = organisationUnitLevels;
        return this;
    }

    @JsonProperty("periodOffset")
    public Optional<Integer> getPeriodOffset() {
        return Optional.ofNullable(periodOffset);
    }

    @JsonProperty("periodOffset")
    public void setPeriodOffset(Integer periodOffset) {
        this.periodOffset = periodOffset;
    }

    public ValidationRule withPeriodOffset(Integer periodOffset) {
        this.periodOffset = periodOffset;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("periodType")
    public Optional<Object> getPeriodType() {
        return Optional.ofNullable(periodType);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("periodType")
    public void setPeriodType(Object periodType) {
        this.periodType = periodType;
    }

    public ValidationRule withPeriodType(Object periodType) {
        this.periodType = periodType;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public ValidationRule withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    @JsonProperty("rightSide")
    public Optional<Expression> getRightSide() {
        return Optional.ofNullable(rightSide);
    }

    @JsonProperty("rightSide")
    public void setRightSide(Expression rightSide) {
        this.rightSide = rightSide;
    }

    public ValidationRule withRightSide(Expression rightSide) {
        this.rightSide = rightSide;
        return this;
    }

    @JsonProperty("sharing")
    public Optional<Sharing> getSharing() {
        return Optional.ofNullable(sharing);
    }

    @JsonProperty("sharing")
    public void setSharing(Sharing sharing) {
        this.sharing = sharing;
    }

    public ValidationRule withSharing(Sharing sharing) {
        this.sharing = sharing;
        return this;
    }

    @JsonProperty("shortName")
    public Optional<String> getShortName() {
        return Optional.ofNullable(shortName);
    }

    @JsonProperty("shortName")
    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public ValidationRule withShortName(String shortName) {
        this.shortName = shortName;
        return this;
    }

    @JsonProperty("skipFormValidation")
    public Optional<Boolean> getSkipFormValidation() {
        return Optional.ofNullable(skipFormValidation);
    }

    @JsonProperty("skipFormValidation")
    public void setSkipFormValidation(Boolean skipFormValidation) {
        this.skipFormValidation = skipFormValidation;
    }

    public ValidationRule withSkipFormValidation(Boolean skipFormValidation) {
        this.skipFormValidation = skipFormValidation;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public ValidationRule withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    @JsonProperty("user")
    public Optional<User> getUser() {
        return Optional.ofNullable(user);
    }

    @JsonProperty("user")
    public void setUser(User user) {
        this.user = user;
    }

    public ValidationRule withUser(User user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<UserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public ValidationRule withUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<UserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public ValidationRule withUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    @JsonProperty("validationRuleGroups")
    public Optional<List<ValidationRuleGroup>> getValidationRuleGroups() {
        return Optional.ofNullable(validationRuleGroups);
    }

    @JsonProperty("validationRuleGroups")
    public void setValidationRuleGroups(List<ValidationRuleGroup> validationRuleGroups) {
        this.validationRuleGroups = validationRuleGroups;
    }

    public ValidationRule withValidationRuleGroups(List<ValidationRuleGroup> validationRuleGroups) {
        this.validationRuleGroups = validationRuleGroups;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ValidationRule withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "access":
                if (value instanceof Access) {
                    setAccess(((Access) value));
                } else {
                    throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v2_37_7.Access\", but got "+ value.getClass().toString()));
                }
                return true;
            case "aggregateExportAttributeOptionCombo":
                if (value instanceof String) {
                    setAggregateExportAttributeOptionCombo(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"aggregateExportAttributeOptionCombo\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "aggregateExportCategoryOptionCombo":
                if (value instanceof String) {
                    setAggregateExportCategoryOptionCombo(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"aggregateExportCategoryOptionCombo\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "aggregationType":
                if (value instanceof AggregationType) {
                    setAggregationType(((AggregationType) value));
                } else {
                    throw new IllegalArgumentException(("property \"aggregationType\" is of type \"org.hisp.dhis.api.model.v2_37_7.AggregationType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "attributeValues":
                if (value instanceof List) {
                    setAttributeValues(((List<AttributeValue> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.AttributeValue>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "code":
                if (value instanceof String) {
                    setCode(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "created":
                if (value instanceof Date) {
                    setCreated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "createdBy":
                if (value instanceof User) {
                    setCreatedBy(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"createdBy\" is of type \"org.hisp.dhis.api.model.v2_37_7.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "description":
                if (value instanceof String) {
                    setDescription(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"description\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dimensionItem":
                if (value instanceof String) {
                    setDimensionItem(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"dimensionItem\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dimensionItemType":
                if (value instanceof org.hisp.dhis.api.model.v2_37_7.CategoryOptionCombo.DimensionItemType) {
                    setDimensionItemType(((org.hisp.dhis.api.model.v2_37_7.CategoryOptionCombo.DimensionItemType) value));
                } else {
                    throw new IllegalArgumentException(("property \"dimensionItemType\" is of type \"org.hisp.dhis.api.model.v2_37_7.CategoryOptionCombo.DimensionItemType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayDescription":
                if (value instanceof String) {
                    setDisplayDescription(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayDescription\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayFormName":
                if (value instanceof String) {
                    setDisplayFormName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayFormName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayInstruction":
                if (value instanceof String) {
                    setDisplayInstruction(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayInstruction\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayName":
                if (value instanceof String) {
                    setDisplayName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayShortName":
                if (value instanceof String) {
                    setDisplayShortName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayShortName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "externalAccess":
                if (value instanceof Boolean) {
                    setExternalAccess(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "favorite":
                if (value instanceof Boolean) {
                    setFavorite(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "favorites":
                if (value instanceof List) {
                    setFavorites(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "formName":
                if (value instanceof String) {
                    setFormName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"formName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "href":
                if (value instanceof String) {
                    setHref(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "id":
                if (value instanceof String) {
                    setId(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "importance":
                if (value instanceof Importance) {
                    setImportance(((Importance) value));
                } else {
                    throw new IllegalArgumentException(("property \"importance\" is of type \"org.hisp.dhis.api.model.v2_37_7.Importance\", but got "+ value.getClass().toString()));
                }
                return true;
            case "instruction":
                if (value instanceof String) {
                    setInstruction(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"instruction\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdated":
                if (value instanceof Date) {
                    setLastUpdated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdatedBy":
                if (value instanceof User) {
                    setLastUpdatedBy(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v2_37_7.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "leftSide":
                if (value instanceof Expression) {
                    setLeftSide(((Expression) value));
                } else {
                    throw new IllegalArgumentException(("property \"leftSide\" is of type \"org.hisp.dhis.api.model.v2_37_7.Expression\", but got "+ value.getClass().toString()));
                }
                return true;
            case "legendSet":
                if (value instanceof LegendSet) {
                    setLegendSet(((LegendSet) value));
                } else {
                    throw new IllegalArgumentException(("property \"legendSet\" is of type \"org.hisp.dhis.api.model.v2_37_7.LegendSet\", but got "+ value.getClass().toString()));
                }
                return true;
            case "legendSets":
                if (value instanceof List) {
                    setLegendSets(((List<LegendSet> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"legendSets\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.LegendSet>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "name":
                if (value instanceof String) {
                    setName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "notificationTemplates":
                if (value instanceof List) {
                    setNotificationTemplates(((List<ValidationNotificationTemplate> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"notificationTemplates\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.ValidationNotificationTemplate>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "operator":
                if (value instanceof ValidationRule.Operator) {
                    setOperator(((ValidationRule.Operator) value));
                } else {
                    throw new IllegalArgumentException(("property \"operator\" is of type \"org.hisp.dhis.api.model.v2_37_7.ValidationRule.Operator\", but got "+ value.getClass().toString()));
                }
                return true;
            case "organisationUnitLevels":
                if (value instanceof List) {
                    setOrganisationUnitLevels(((List<Integer> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"organisationUnitLevels\" is of type \"java.util.List<java.lang.Integer>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "periodOffset":
                if (value instanceof Integer) {
                    setPeriodOffset(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"periodOffset\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "periodType":
                if (value instanceof Object) {
                    setPeriodType(((Object) value));
                } else {
                    throw new IllegalArgumentException(("property \"periodType\" is of type \"java.lang.Object\", but got "+ value.getClass().toString()));
                }
                return true;
            case "publicAccess":
                if (value instanceof String) {
                    setPublicAccess(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "rightSide":
                if (value instanceof Expression) {
                    setRightSide(((Expression) value));
                } else {
                    throw new IllegalArgumentException(("property \"rightSide\" is of type \"org.hisp.dhis.api.model.v2_37_7.Expression\", but got "+ value.getClass().toString()));
                }
                return true;
            case "sharing":
                if (value instanceof Sharing) {
                    setSharing(((Sharing) value));
                } else {
                    throw new IllegalArgumentException(("property \"sharing\" is of type \"org.hisp.dhis.api.model.v2_37_7.Sharing\", but got "+ value.getClass().toString()));
                }
                return true;
            case "shortName":
                if (value instanceof String) {
                    setShortName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"shortName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "skipFormValidation":
                if (value instanceof Boolean) {
                    setSkipFormValidation(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"skipFormValidation\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "translations":
                if (value instanceof List) {
                    setTranslations(((List<Translation> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.Translation>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "user":
                if (value instanceof User) {
                    setUser(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v2_37_7.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userAccesses":
                if (value instanceof List) {
                    setUserAccesses(((List<UserAccess> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.UserAccess>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userGroupAccesses":
                if (value instanceof List) {
                    setUserGroupAccesses(((List<UserGroupAccess> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.UserGroupAccess>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "validationRuleGroups":
                if (value instanceof List) {
                    setValidationRuleGroups(((List<ValidationRuleGroup> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"validationRuleGroups\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.ValidationRuleGroup>\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "access":
                return getAccess();
            case "aggregateExportAttributeOptionCombo":
                return getAggregateExportAttributeOptionCombo();
            case "aggregateExportCategoryOptionCombo":
                return getAggregateExportCategoryOptionCombo();
            case "aggregationType":
                return getAggregationType();
            case "attributeValues":
                return getAttributeValues();
            case "code":
                return getCode();
            case "created":
                return getCreated();
            case "createdBy":
                return getCreatedBy();
            case "description":
                return getDescription();
            case "dimensionItem":
                return getDimensionItem();
            case "dimensionItemType":
                return getDimensionItemType();
            case "displayDescription":
                return getDisplayDescription();
            case "displayFormName":
                return getDisplayFormName();
            case "displayInstruction":
                return getDisplayInstruction();
            case "displayName":
                return getDisplayName();
            case "displayShortName":
                return getDisplayShortName();
            case "externalAccess":
                return getExternalAccess();
            case "favorite":
                return getFavorite();
            case "favorites":
                return getFavorites();
            case "formName":
                return getFormName();
            case "href":
                return getHref();
            case "id":
                return getId();
            case "importance":
                return getImportance();
            case "instruction":
                return getInstruction();
            case "lastUpdated":
                return getLastUpdated();
            case "lastUpdatedBy":
                return getLastUpdatedBy();
            case "leftSide":
                return getLeftSide();
            case "legendSet":
                return getLegendSet();
            case "legendSets":
                return getLegendSets();
            case "name":
                return getName();
            case "notificationTemplates":
                return getNotificationTemplates();
            case "operator":
                return getOperator();
            case "organisationUnitLevels":
                return getOrganisationUnitLevels();
            case "periodOffset":
                return getPeriodOffset();
            case "periodType":
                return getPeriodType();
            case "publicAccess":
                return getPublicAccess();
            case "rightSide":
                return getRightSide();
            case "sharing":
                return getSharing();
            case "shortName":
                return getShortName();
            case "skipFormValidation":
                return getSkipFormValidation();
            case "translations":
                return getTranslations();
            case "user":
                return getUser();
            case "userAccesses":
                return getUserAccesses();
            case "userGroupAccesses":
                return getUserGroupAccesses();
            case "validationRuleGroups":
                return getValidationRuleGroups();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ValidationRule.NOT_FOUND_VALUE);
        if (ValidationRule.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ValidationRule with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ValidationRule.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("aggregateExportAttributeOptionCombo");
        sb.append('=');
        sb.append(((this.aggregateExportAttributeOptionCombo == null)?"<null>":this.aggregateExportAttributeOptionCombo));
        sb.append(',');
        sb.append("aggregateExportCategoryOptionCombo");
        sb.append('=');
        sb.append(((this.aggregateExportCategoryOptionCombo == null)?"<null>":this.aggregateExportCategoryOptionCombo));
        sb.append(',');
        sb.append("aggregationType");
        sb.append('=');
        sb.append(((this.aggregationType == null)?"<null>":this.aggregationType));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("createdBy");
        sb.append('=');
        sb.append(((this.createdBy == null)?"<null>":this.createdBy));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("dimensionItem");
        sb.append('=');
        sb.append(((this.dimensionItem == null)?"<null>":this.dimensionItem));
        sb.append(',');
        sb.append("dimensionItemType");
        sb.append('=');
        sb.append(((this.dimensionItemType == null)?"<null>":this.dimensionItemType));
        sb.append(',');
        sb.append("displayDescription");
        sb.append('=');
        sb.append(((this.displayDescription == null)?"<null>":this.displayDescription));
        sb.append(',');
        sb.append("displayFormName");
        sb.append('=');
        sb.append(((this.displayFormName == null)?"<null>":this.displayFormName));
        sb.append(',');
        sb.append("displayInstruction");
        sb.append('=');
        sb.append(((this.displayInstruction == null)?"<null>":this.displayInstruction));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("displayShortName");
        sb.append('=');
        sb.append(((this.displayShortName == null)?"<null>":this.displayShortName));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("formName");
        sb.append('=');
        sb.append(((this.formName == null)?"<null>":this.formName));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("importance");
        sb.append('=');
        sb.append(((this.importance == null)?"<null>":this.importance));
        sb.append(',');
        sb.append("instruction");
        sb.append('=');
        sb.append(((this.instruction == null)?"<null>":this.instruction));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("leftSide");
        sb.append('=');
        sb.append(((this.leftSide == null)?"<null>":this.leftSide));
        sb.append(',');
        sb.append("legendSet");
        sb.append('=');
        sb.append(((this.legendSet == null)?"<null>":this.legendSet));
        sb.append(',');
        sb.append("legendSets");
        sb.append('=');
        sb.append(((this.legendSets == null)?"<null>":this.legendSets));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("notificationTemplates");
        sb.append('=');
        sb.append(((this.notificationTemplates == null)?"<null>":this.notificationTemplates));
        sb.append(',');
        sb.append("operator");
        sb.append('=');
        sb.append(((this.operator == null)?"<null>":this.operator));
        sb.append(',');
        sb.append("organisationUnitLevels");
        sb.append('=');
        sb.append(((this.organisationUnitLevels == null)?"<null>":this.organisationUnitLevels));
        sb.append(',');
        sb.append("periodOffset");
        sb.append('=');
        sb.append(((this.periodOffset == null)?"<null>":this.periodOffset));
        sb.append(',');
        sb.append("periodType");
        sb.append('=');
        sb.append(((this.periodType == null)?"<null>":this.periodType));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("rightSide");
        sb.append('=');
        sb.append(((this.rightSide == null)?"<null>":this.rightSide));
        sb.append(',');
        sb.append("sharing");
        sb.append('=');
        sb.append(((this.sharing == null)?"<null>":this.sharing));
        sb.append(',');
        sb.append("shortName");
        sb.append('=');
        sb.append(((this.shortName == null)?"<null>":this.shortName));
        sb.append(',');
        sb.append("skipFormValidation");
        sb.append('=');
        sb.append(((this.skipFormValidation == null)?"<null>":this.skipFormValidation));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("validationRuleGroups");
        sb.append('=');
        sb.append(((this.validationRuleGroups == null)?"<null>":this.validationRuleGroups));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.validationRuleGroups == null)? 0 :this.validationRuleGroups.hashCode()));
        result = ((result* 31)+((this.aggregationType == null)? 0 :this.aggregationType.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.importance == null)? 0 :this.importance.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.aggregateExportCategoryOptionCombo == null)? 0 :this.aggregateExportCategoryOptionCombo.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.displayShortName == null)? 0 :this.displayShortName.hashCode()));
        result = ((result* 31)+((this.operator == null)? 0 :this.operator.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.organisationUnitLevels == null)? 0 :this.organisationUnitLevels.hashCode()));
        result = ((result* 31)+((this.displayInstruction == null)? 0 :this.displayInstruction.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.leftSide == null)? 0 :this.leftSide.hashCode()));
        result = ((result* 31)+((this.periodOffset == null)? 0 :this.periodOffset.hashCode()));
        result = ((result* 31)+((this.notificationTemplates == null)? 0 :this.notificationTemplates.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.formName == null)? 0 :this.formName.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.displayDescription == null)? 0 :this.displayDescription.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.dimensionItem == null)? 0 :this.dimensionItem.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.rightSide == null)? 0 :this.rightSide.hashCode()));
        result = ((result* 31)+((this.sharing == null)? 0 :this.sharing.hashCode()));
        result = ((result* 31)+((this.displayFormName == null)? 0 :this.displayFormName.hashCode()));
        result = ((result* 31)+((this.periodType == null)? 0 :this.periodType.hashCode()));
        result = ((result* 31)+((this.createdBy == null)? 0 :this.createdBy.hashCode()));
        result = ((result* 31)+((this.instruction == null)? 0 :this.instruction.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.legendSet == null)? 0 :this.legendSet.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.skipFormValidation == null)? 0 :this.skipFormValidation.hashCode()));
        result = ((result* 31)+((this.legendSets == null)? 0 :this.legendSets.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.shortName == null)? 0 :this.shortName.hashCode()));
        result = ((result* 31)+((this.aggregateExportAttributeOptionCombo == null)? 0 :this.aggregateExportAttributeOptionCombo.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        result = ((result* 31)+((this.dimensionItemType == null)? 0 :this.dimensionItemType.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ValidationRule) == false) {
            return false;
        }
        ValidationRule rhs = ((ValidationRule) other);
        return (((((((((((((((((((((((((((((((((((((((((((((((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites)))&&((this.validationRuleGroups == rhs.validationRuleGroups)||((this.validationRuleGroups!= null)&&this.validationRuleGroups.equals(rhs.validationRuleGroups))))&&((this.aggregationType == rhs.aggregationType)||((this.aggregationType!= null)&&this.aggregationType.equals(rhs.aggregationType))))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.importance == rhs.importance)||((this.importance!= null)&&this.importance.equals(rhs.importance))))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.aggregateExportCategoryOptionCombo == rhs.aggregateExportCategoryOptionCombo)||((this.aggregateExportCategoryOptionCombo!= null)&&this.aggregateExportCategoryOptionCombo.equals(rhs.aggregateExportCategoryOptionCombo))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.displayShortName == rhs.displayShortName)||((this.displayShortName!= null)&&this.displayShortName.equals(rhs.displayShortName))))&&((this.operator == rhs.operator)||((this.operator!= null)&&this.operator.equals(rhs.operator))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.organisationUnitLevels == rhs.organisationUnitLevels)||((this.organisationUnitLevels!= null)&&this.organisationUnitLevels.equals(rhs.organisationUnitLevels))))&&((this.displayInstruction == rhs.displayInstruction)||((this.displayInstruction!= null)&&this.displayInstruction.equals(rhs.displayInstruction))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.leftSide == rhs.leftSide)||((this.leftSide!= null)&&this.leftSide.equals(rhs.leftSide))))&&((this.periodOffset == rhs.periodOffset)||((this.periodOffset!= null)&&this.periodOffset.equals(rhs.periodOffset))))&&((this.notificationTemplates == rhs.notificationTemplates)||((this.notificationTemplates!= null)&&this.notificationTemplates.equals(rhs.notificationTemplates))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.formName == rhs.formName)||((this.formName!= null)&&this.formName.equals(rhs.formName))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.displayDescription == rhs.displayDescription)||((this.displayDescription!= null)&&this.displayDescription.equals(rhs.displayDescription))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.dimensionItem == rhs.dimensionItem)||((this.dimensionItem!= null)&&this.dimensionItem.equals(rhs.dimensionItem))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.rightSide == rhs.rightSide)||((this.rightSide!= null)&&this.rightSide.equals(rhs.rightSide))))&&((this.sharing == rhs.sharing)||((this.sharing!= null)&&this.sharing.equals(rhs.sharing))))&&((this.displayFormName == rhs.displayFormName)||((this.displayFormName!= null)&&this.displayFormName.equals(rhs.displayFormName))))&&((this.periodType == rhs.periodType)||((this.periodType!= null)&&this.periodType.equals(rhs.periodType))))&&((this.createdBy == rhs.createdBy)||((this.createdBy!= null)&&this.createdBy.equals(rhs.createdBy))))&&((this.instruction == rhs.instruction)||((this.instruction!= null)&&this.instruction.equals(rhs.instruction))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.legendSet == rhs.legendSet)||((this.legendSet!= null)&&this.legendSet.equals(rhs.legendSet))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.skipFormValidation == rhs.skipFormValidation)||((this.skipFormValidation!= null)&&this.skipFormValidation.equals(rhs.skipFormValidation))))&&((this.legendSets == rhs.legendSets)||((this.legendSets!= null)&&this.legendSets.equals(rhs.legendSets))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.shortName == rhs.shortName)||((this.shortName!= null)&&this.shortName.equals(rhs.shortName))))&&((this.aggregateExportAttributeOptionCombo == rhs.aggregateExportAttributeOptionCombo)||((this.aggregateExportAttributeOptionCombo!= null)&&this.aggregateExportAttributeOptionCombo.equals(rhs.aggregateExportAttributeOptionCombo))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))))&&((this.dimensionItemType == rhs.dimensionItemType)||((this.dimensionItemType!= null)&&this.dimensionItemType.equals(rhs.dimensionItemType))));
    }

    @Generated("jsonschema2pojo")
    public enum Operator {

        EQUAL_TO("equal_to"),
        NOT_EQUAL_TO("not_equal_to"),
        GREATER_THAN("greater_than"),
        GREATER_THAN_OR_EQUAL_TO("greater_than_or_equal_to"),
        LESS_THAN("less_than"),
        LESS_THAN_OR_EQUAL_TO("less_than_or_equal_to"),
        COMPULSORY_PAIR("compulsory_pair"),
        EXCLUSIVE_PAIR("exclusive_pair");
        private final String value;
        private final static Map<String, ValidationRule.Operator> CONSTANTS = new HashMap<String, ValidationRule.Operator>();

        static {
            for (ValidationRule.Operator c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        Operator(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ValidationRule.Operator fromValue(String value) {
            ValidationRule.Operator constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
