
package org.hisp.dhis.api.model.v2_38_1;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "analyticsTableType",
    "attributeValues",
    "code",
    "created",
    "createdBy",
    "displayName",
    "externalAccess",
    "favorite",
    "favorites",
    "href",
    "id",
    "lastUpdated",
    "lastUpdatedBy",
    "name",
    "phase",
    "publicAccess",
    "resourceTableType",
    "sharing",
    "sql",
    "translations",
    "user",
    "userAccesses",
    "userGroupAccesses"
})
@Generated("jsonschema2pojo")
public class AnalyticsTableHook implements Serializable
{

    @JsonProperty("access")
    private Access access;
    @JsonProperty("analyticsTableType")
    private AnalyticsTableType analyticsTableType;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues = null;
    @JsonProperty("code")
    private String code;
    @JsonProperty("created")
    private Date created;
    @JsonProperty("createdBy")
    private User createdBy;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites = null;
    @JsonProperty("href")
    private String href;
    @JsonProperty("id")
    private String id;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    @JsonProperty("lastUpdatedBy")
    private User lastUpdatedBy;
    @JsonProperty("name")
    private String name;
    @JsonProperty("phase")
    private AnalyticsTableHook.AnalyticsTablePhase phase;
    @JsonProperty("publicAccess")
    private String publicAccess;
    @JsonProperty("resourceTableType")
    private AnalyticsTableHook.ResourceTableType resourceTableType;
    @JsonProperty("sharing")
    private Sharing sharing;
    @JsonProperty("sql")
    private String sql;
    @JsonProperty("translations")
    private List<Translation> translations = null;
    @JsonProperty("user")
    private User user;
    @JsonProperty("userAccesses")
    private List<UserAccess> userAccesses = null;
    @JsonProperty("userGroupAccesses")
    private List<UserGroupAccess> userGroupAccesses = null;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 9182791075242788031L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public AnalyticsTableHook() {
    }

    /**
     * 
     * @param source
     */
    public AnalyticsTableHook(AnalyticsTableHook source) {
        super();
        this.access = source.access;
        this.analyticsTableType = source.analyticsTableType;
        this.attributeValues = source.attributeValues;
        this.code = source.code;
        this.created = source.created;
        this.createdBy = source.createdBy;
        this.displayName = source.displayName;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.href = source.href;
        this.id = source.id;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.name = source.name;
        this.phase = source.phase;
        this.publicAccess = source.publicAccess;
        this.resourceTableType = source.resourceTableType;
        this.sharing = source.sharing;
        this.sql = source.sql;
        this.translations = source.translations;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userGroupAccesses = source.userGroupAccesses;
    }

    /**
     * 
     * @param favorites
     * @param phase
     * @param lastUpdatedBy
     * @param access
     * @param code
     * @param userGroupAccesses
     * @param analyticsTableType
     * @param created
     * @param displayName
     * @param publicAccess
     * @param attributeValues
     * @param sharing
     * @param externalAccess
     * @param sql
     * @param lastUpdated
     * @param createdBy
     * @param translations
     * @param userAccesses
     * @param name
     * @param resourceTableType
     * @param href
     * @param id
     * @param favorite
     * @param user
     */
    public AnalyticsTableHook(Access access, AnalyticsTableType analyticsTableType, List<AttributeValue> attributeValues, String code, Date created, User createdBy, String displayName, Boolean externalAccess, Boolean favorite, List<String> favorites, String href, String id, Date lastUpdated, User lastUpdatedBy, String name, AnalyticsTableHook.AnalyticsTablePhase phase, String publicAccess, AnalyticsTableHook.ResourceTableType resourceTableType, Sharing sharing, String sql, List<Translation> translations, User user, List<UserAccess> userAccesses, List<UserGroupAccess> userGroupAccesses) {
        super();
        this.access = access;
        this.analyticsTableType = analyticsTableType;
        this.attributeValues = attributeValues;
        this.code = code;
        this.created = created;
        this.createdBy = createdBy;
        this.displayName = displayName;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.href = href;
        this.id = id;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.name = name;
        this.phase = phase;
        this.publicAccess = publicAccess;
        this.resourceTableType = resourceTableType;
        this.sharing = sharing;
        this.sql = sql;
        this.translations = translations;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userGroupAccesses = userGroupAccesses;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public AnalyticsTableHook withAccess(Access access) {
        this.access = access;
        return this;
    }

    @JsonProperty("analyticsTableType")
    public Optional<AnalyticsTableType> getAnalyticsTableType() {
        return Optional.ofNullable(analyticsTableType);
    }

    @JsonProperty("analyticsTableType")
    public void setAnalyticsTableType(AnalyticsTableType analyticsTableType) {
        this.analyticsTableType = analyticsTableType;
    }

    public AnalyticsTableHook withAnalyticsTableType(AnalyticsTableType analyticsTableType) {
        this.analyticsTableType = analyticsTableType;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public AnalyticsTableHook withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public AnalyticsTableHook withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public AnalyticsTableHook withCreated(Date created) {
        this.created = created;
        return this;
    }

    @JsonProperty("createdBy")
    public Optional<User> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    @JsonProperty("createdBy")
    public void setCreatedBy(User createdBy) {
        this.createdBy = createdBy;
    }

    public AnalyticsTableHook withCreatedBy(User createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public AnalyticsTableHook withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("externalAccess")
    public Optional<Boolean> getExternalAccess() {
        return Optional.ofNullable(externalAccess);
    }

    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public AnalyticsTableHook withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    @JsonProperty("favorite")
    public Optional<Boolean> getFavorite() {
        return Optional.ofNullable(favorite);
    }

    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public AnalyticsTableHook withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public AnalyticsTableHook withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public AnalyticsTableHook withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public AnalyticsTableHook withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public AnalyticsTableHook withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @JsonProperty("lastUpdatedBy")
    public Optional<User> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public AnalyticsTableHook withLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public AnalyticsTableHook withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("phase")
    public Optional<AnalyticsTableHook.AnalyticsTablePhase> getPhase() {
        return Optional.ofNullable(phase);
    }

    @JsonProperty("phase")
    public void setPhase(AnalyticsTableHook.AnalyticsTablePhase phase) {
        this.phase = phase;
    }

    public AnalyticsTableHook withPhase(AnalyticsTableHook.AnalyticsTablePhase phase) {
        this.phase = phase;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public AnalyticsTableHook withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    @JsonProperty("resourceTableType")
    public Optional<AnalyticsTableHook.ResourceTableType> getResourceTableType() {
        return Optional.ofNullable(resourceTableType);
    }

    @JsonProperty("resourceTableType")
    public void setResourceTableType(AnalyticsTableHook.ResourceTableType resourceTableType) {
        this.resourceTableType = resourceTableType;
    }

    public AnalyticsTableHook withResourceTableType(AnalyticsTableHook.ResourceTableType resourceTableType) {
        this.resourceTableType = resourceTableType;
        return this;
    }

    @JsonProperty("sharing")
    public Optional<Sharing> getSharing() {
        return Optional.ofNullable(sharing);
    }

    @JsonProperty("sharing")
    public void setSharing(Sharing sharing) {
        this.sharing = sharing;
    }

    public AnalyticsTableHook withSharing(Sharing sharing) {
        this.sharing = sharing;
        return this;
    }

    @JsonProperty("sql")
    public Optional<String> getSql() {
        return Optional.ofNullable(sql);
    }

    @JsonProperty("sql")
    public void setSql(String sql) {
        this.sql = sql;
    }

    public AnalyticsTableHook withSql(String sql) {
        this.sql = sql;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public AnalyticsTableHook withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    @JsonProperty("user")
    public Optional<User> getUser() {
        return Optional.ofNullable(user);
    }

    @JsonProperty("user")
    public void setUser(User user) {
        this.user = user;
    }

    public AnalyticsTableHook withUser(User user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<UserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public AnalyticsTableHook withUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<UserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public AnalyticsTableHook withUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public AnalyticsTableHook withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "access":
                if (value instanceof Access) {
                    setAccess(((Access) value));
                } else {
                    throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v2_38_1.Access\", but got "+ value.getClass().toString()));
                }
                return true;
            case "analyticsTableType":
                if (value instanceof AnalyticsTableType) {
                    setAnalyticsTableType(((AnalyticsTableType) value));
                } else {
                    throw new IllegalArgumentException(("property \"analyticsTableType\" is of type \"org.hisp.dhis.api.model.v2_38_1.AnalyticsTableType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "attributeValues":
                if (value instanceof List) {
                    setAttributeValues(((List<AttributeValue> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.AttributeValue>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "code":
                if (value instanceof String) {
                    setCode(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "created":
                if (value instanceof Date) {
                    setCreated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "createdBy":
                if (value instanceof User) {
                    setCreatedBy(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"createdBy\" is of type \"org.hisp.dhis.api.model.v2_38_1.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayName":
                if (value instanceof String) {
                    setDisplayName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "externalAccess":
                if (value instanceof Boolean) {
                    setExternalAccess(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "favorite":
                if (value instanceof Boolean) {
                    setFavorite(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "favorites":
                if (value instanceof List) {
                    setFavorites(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "href":
                if (value instanceof String) {
                    setHref(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "id":
                if (value instanceof String) {
                    setId(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdated":
                if (value instanceof Date) {
                    setLastUpdated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdatedBy":
                if (value instanceof User) {
                    setLastUpdatedBy(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v2_38_1.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "name":
                if (value instanceof String) {
                    setName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "phase":
                if (value instanceof AnalyticsTableHook.AnalyticsTablePhase) {
                    setPhase(((AnalyticsTableHook.AnalyticsTablePhase) value));
                } else {
                    throw new IllegalArgumentException(("property \"phase\" is of type \"org.hisp.dhis.api.model.v2_38_1.AnalyticsTableHook.AnalyticsTablePhase\", but got "+ value.getClass().toString()));
                }
                return true;
            case "publicAccess":
                if (value instanceof String) {
                    setPublicAccess(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "resourceTableType":
                if (value instanceof AnalyticsTableHook.ResourceTableType) {
                    setResourceTableType(((AnalyticsTableHook.ResourceTableType) value));
                } else {
                    throw new IllegalArgumentException(("property \"resourceTableType\" is of type \"org.hisp.dhis.api.model.v2_38_1.AnalyticsTableHook.ResourceTableType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "sharing":
                if (value instanceof Sharing) {
                    setSharing(((Sharing) value));
                } else {
                    throw new IllegalArgumentException(("property \"sharing\" is of type \"org.hisp.dhis.api.model.v2_38_1.Sharing\", but got "+ value.getClass().toString()));
                }
                return true;
            case "sql":
                if (value instanceof String) {
                    setSql(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"sql\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "translations":
                if (value instanceof List) {
                    setTranslations(((List<Translation> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.Translation>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "user":
                if (value instanceof User) {
                    setUser(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v2_38_1.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userAccesses":
                if (value instanceof List) {
                    setUserAccesses(((List<UserAccess> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.UserAccess>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userGroupAccesses":
                if (value instanceof List) {
                    setUserGroupAccesses(((List<UserGroupAccess> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.UserGroupAccess>\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "access":
                return getAccess();
            case "analyticsTableType":
                return getAnalyticsTableType();
            case "attributeValues":
                return getAttributeValues();
            case "code":
                return getCode();
            case "created":
                return getCreated();
            case "createdBy":
                return getCreatedBy();
            case "displayName":
                return getDisplayName();
            case "externalAccess":
                return getExternalAccess();
            case "favorite":
                return getFavorite();
            case "favorites":
                return getFavorites();
            case "href":
                return getHref();
            case "id":
                return getId();
            case "lastUpdated":
                return getLastUpdated();
            case "lastUpdatedBy":
                return getLastUpdatedBy();
            case "name":
                return getName();
            case "phase":
                return getPhase();
            case "publicAccess":
                return getPublicAccess();
            case "resourceTableType":
                return getResourceTableType();
            case "sharing":
                return getSharing();
            case "sql":
                return getSql();
            case "translations":
                return getTranslations();
            case "user":
                return getUser();
            case "userAccesses":
                return getUserAccesses();
            case "userGroupAccesses":
                return getUserGroupAccesses();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, AnalyticsTableHook.NOT_FOUND_VALUE);
        if (AnalyticsTableHook.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public AnalyticsTableHook with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(AnalyticsTableHook.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("analyticsTableType");
        sb.append('=');
        sb.append(((this.analyticsTableType == null)?"<null>":this.analyticsTableType));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("createdBy");
        sb.append('=');
        sb.append(((this.createdBy == null)?"<null>":this.createdBy));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("phase");
        sb.append('=');
        sb.append(((this.phase == null)?"<null>":this.phase));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("resourceTableType");
        sb.append('=');
        sb.append(((this.resourceTableType == null)?"<null>":this.resourceTableType));
        sb.append(',');
        sb.append("sharing");
        sb.append('=');
        sb.append(((this.sharing == null)?"<null>":this.sharing));
        sb.append(',');
        sb.append("sql");
        sb.append('=');
        sb.append(((this.sql == null)?"<null>":this.sql));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.analyticsTableType == null)? 0 :this.analyticsTableType.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.sql == null)? 0 :this.sql.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.phase == null)? 0 :this.phase.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.sharing == null)? 0 :this.sharing.hashCode()));
        result = ((result* 31)+((this.createdBy == null)? 0 :this.createdBy.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.resourceTableType == null)? 0 :this.resourceTableType.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof AnalyticsTableHook) == false) {
            return false;
        }
        AnalyticsTableHook rhs = ((AnalyticsTableHook) other);
        return ((((((((((((((((((((((((((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites)))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.analyticsTableType == rhs.analyticsTableType)||((this.analyticsTableType!= null)&&this.analyticsTableType.equals(rhs.analyticsTableType))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.sql == rhs.sql)||((this.sql!= null)&&this.sql.equals(rhs.sql))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.phase == rhs.phase)||((this.phase!= null)&&this.phase.equals(rhs.phase))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.sharing == rhs.sharing)||((this.sharing!= null)&&this.sharing.equals(rhs.sharing))))&&((this.createdBy == rhs.createdBy)||((this.createdBy!= null)&&this.createdBy.equals(rhs.createdBy))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.resourceTableType == rhs.resourceTableType)||((this.resourceTableType!= null)&&this.resourceTableType.equals(rhs.resourceTableType))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))));
    }

    @Generated("jsonschema2pojo")
    public enum AnalyticsTablePhase {

        RESOURCE_TABLE_POPULATED("RESOURCE_TABLE_POPULATED"),
        ANALYTICS_TABLE_POPULATED("ANALYTICS_TABLE_POPULATED");
        private final String value;
        private final static Map<String, AnalyticsTableHook.AnalyticsTablePhase> CONSTANTS = new HashMap<String, AnalyticsTableHook.AnalyticsTablePhase>();

        static {
            for (AnalyticsTableHook.AnalyticsTablePhase c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        AnalyticsTablePhase(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static AnalyticsTableHook.AnalyticsTablePhase fromValue(String value) {
            AnalyticsTableHook.AnalyticsTablePhase constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum ResourceTableType {

        ORG_UNIT_STRUCTURE("ORG_UNIT_STRUCTURE"),
        DATA_SET_ORG_UNIT_CATEGORY("DATA_SET_ORG_UNIT_CATEGORY"),
        CATEGORY_OPTION_COMBO_NAME("CATEGORY_OPTION_COMBO_NAME"),
        DATA_ELEMENT_GROUP_SET_STRUCTURE("DATA_ELEMENT_GROUP_SET_STRUCTURE"),
        INDICATOR_GROUP_SET_STRUCTURE("INDICATOR_GROUP_SET_STRUCTURE"),
        ORG_UNIT_GROUP_SET_STRUCTURE("ORG_UNIT_GROUP_SET_STRUCTURE"),
        CATEGORY_STRUCTURE("CATEGORY_STRUCTURE"),
        DATA_ELEMENT_STRUCTURE("DATA_ELEMENT_STRUCTURE"),
        PERIOD_STRUCTURE("PERIOD_STRUCTURE"),
        DATE_PERIOD_STRUCTURE("DATE_PERIOD_STRUCTURE"),
        DATA_ELEMENT_CATEGORY_OPTION_COMBO("DATA_ELEMENT_CATEGORY_OPTION_COMBO"),
        DATA_APPROVAL_REMAP_LEVEL("DATA_APPROVAL_REMAP_LEVEL"),
        DATA_APPROVAL_MIN_LEVEL("DATA_APPROVAL_MIN_LEVEL");
        private final String value;
        private final static Map<String, AnalyticsTableHook.ResourceTableType> CONSTANTS = new HashMap<String, AnalyticsTableHook.ResourceTableType>();

        static {
            for (AnalyticsTableHook.ResourceTableType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ResourceTableType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static AnalyticsTableHook.ResourceTableType fromValue(String value) {
            AnalyticsTableHook.ResourceTableType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
