
package org.hisp.dhis.api.model.v2_38_1;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "capPercentage",
    "hardCapPercentage",
    "softCapPercentage"
})
@Generated("jsonschema2pojo")
public class CacheCapInfo implements Serializable
{

    @JsonProperty("capPercentage")
    private Integer capPercentage;
    @JsonProperty("hardCapPercentage")
    private Integer hardCapPercentage;
    @JsonProperty("softCapPercentage")
    private Integer softCapPercentage;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -1375757060466574745L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public CacheCapInfo() {
    }

    /**
     * 
     * @param source
     */
    public CacheCapInfo(CacheCapInfo source) {
        super();
        this.capPercentage = source.capPercentage;
        this.hardCapPercentage = source.hardCapPercentage;
        this.softCapPercentage = source.softCapPercentage;
    }

    /**
     * 
     * @param softCapPercentage
     * @param capPercentage
     * @param hardCapPercentage
     */
    public CacheCapInfo(Integer capPercentage, Integer hardCapPercentage, Integer softCapPercentage) {
        super();
        this.capPercentage = capPercentage;
        this.hardCapPercentage = hardCapPercentage;
        this.softCapPercentage = softCapPercentage;
    }

    @JsonProperty("capPercentage")
    public Optional<Integer> getCapPercentage() {
        return Optional.ofNullable(capPercentage);
    }

    @JsonProperty("capPercentage")
    public void setCapPercentage(Integer capPercentage) {
        this.capPercentage = capPercentage;
    }

    public CacheCapInfo withCapPercentage(Integer capPercentage) {
        this.capPercentage = capPercentage;
        return this;
    }

    @JsonProperty("hardCapPercentage")
    public Optional<Integer> getHardCapPercentage() {
        return Optional.ofNullable(hardCapPercentage);
    }

    @JsonProperty("hardCapPercentage")
    public void setHardCapPercentage(Integer hardCapPercentage) {
        this.hardCapPercentage = hardCapPercentage;
    }

    public CacheCapInfo withHardCapPercentage(Integer hardCapPercentage) {
        this.hardCapPercentage = hardCapPercentage;
        return this;
    }

    @JsonProperty("softCapPercentage")
    public Optional<Integer> getSoftCapPercentage() {
        return Optional.ofNullable(softCapPercentage);
    }

    @JsonProperty("softCapPercentage")
    public void setSoftCapPercentage(Integer softCapPercentage) {
        this.softCapPercentage = softCapPercentage;
    }

    public CacheCapInfo withSoftCapPercentage(Integer softCapPercentage) {
        this.softCapPercentage = softCapPercentage;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public CacheCapInfo withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "capPercentage":
                if (value instanceof Integer) {
                    setCapPercentage(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"capPercentage\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "hardCapPercentage":
                if (value instanceof Integer) {
                    setHardCapPercentage(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"hardCapPercentage\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "softCapPercentage":
                if (value instanceof Integer) {
                    setSoftCapPercentage(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"softCapPercentage\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "capPercentage":
                return getCapPercentage();
            case "hardCapPercentage":
                return getHardCapPercentage();
            case "softCapPercentage":
                return getSoftCapPercentage();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, CacheCapInfo.NOT_FOUND_VALUE);
        if (CacheCapInfo.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public CacheCapInfo with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CacheCapInfo.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("capPercentage");
        sb.append('=');
        sb.append(((this.capPercentage == null)?"<null>":this.capPercentage));
        sb.append(',');
        sb.append("hardCapPercentage");
        sb.append('=');
        sb.append(((this.hardCapPercentage == null)?"<null>":this.hardCapPercentage));
        sb.append(',');
        sb.append("softCapPercentage");
        sb.append('=');
        sb.append(((this.softCapPercentage == null)?"<null>":this.softCapPercentage));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.softCapPercentage == null)? 0 :this.softCapPercentage.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.capPercentage == null)? 0 :this.capPercentage.hashCode()));
        result = ((result* 31)+((this.hardCapPercentage == null)? 0 :this.hardCapPercentage.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof CacheCapInfo) == false) {
            return false;
        }
        CacheCapInfo rhs = ((CacheCapInfo) other);
        return (((((this.softCapPercentage == rhs.softCapPercentage)||((this.softCapPercentage!= null)&&this.softCapPercentage.equals(rhs.softCapPercentage)))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.capPercentage == rhs.capPercentage)||((this.capPercentage!= null)&&this.capPercentage.equals(rhs.capPercentage))))&&((this.hardCapPercentage == rhs.hardCapPercentage)||((this.hardCapPercentage!= null)&&this.hardCapPercentage.equals(rhs.hardCapPercentage))));
    }

}
