
package org.hisp.dhis.api.model.v2_38_1;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "dataDimensionItemType",
    "dataElement",
    "dataElementOperand",
    "indicator",
    "programAttribute",
    "programDataElement",
    "programIndicator",
    "reportingRate"
})
@Generated("jsonschema2pojo")
public class DataDimensionItem implements Serializable
{

    @JsonProperty("dataDimensionItemType")
    private DataDimensionItem.DataDimensionItemType dataDimensionItemType;
    @JsonProperty("dataElement")
    private DataElement dataElement;
    @JsonProperty("dataElementOperand")
    private DataElementOperand dataElementOperand;
    @JsonProperty("indicator")
    private Indicator indicator;
    @JsonProperty("programAttribute")
    private ProgramTrackedEntityAttributeDimensionItem programAttribute;
    @JsonProperty("programDataElement")
    private ProgramDataElementDimensionItem programDataElement;
    @JsonProperty("programIndicator")
    private ProgramIndicator programIndicator;
    @JsonProperty("reportingRate")
    private ReportingRate reportingRate;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -4646216979905180367L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DataDimensionItem() {
    }

    /**
     * 
     * @param source
     */
    public DataDimensionItem(DataDimensionItem source) {
        super();
        this.dataDimensionItemType = source.dataDimensionItemType;
        this.dataElement = source.dataElement;
        this.dataElementOperand = source.dataElementOperand;
        this.indicator = source.indicator;
        this.programAttribute = source.programAttribute;
        this.programDataElement = source.programDataElement;
        this.programIndicator = source.programIndicator;
        this.reportingRate = source.reportingRate;
    }

    /**
     * 
     * @param indicator
     * @param programDataElement
     * @param programAttribute
     * @param reportingRate
     * @param dataElementOperand
     * @param dataDimensionItemType
     * @param programIndicator
     * @param dataElement
     */
    public DataDimensionItem(DataDimensionItem.DataDimensionItemType dataDimensionItemType, DataElement dataElement, DataElementOperand dataElementOperand, Indicator indicator, ProgramTrackedEntityAttributeDimensionItem programAttribute, ProgramDataElementDimensionItem programDataElement, ProgramIndicator programIndicator, ReportingRate reportingRate) {
        super();
        this.dataDimensionItemType = dataDimensionItemType;
        this.dataElement = dataElement;
        this.dataElementOperand = dataElementOperand;
        this.indicator = indicator;
        this.programAttribute = programAttribute;
        this.programDataElement = programDataElement;
        this.programIndicator = programIndicator;
        this.reportingRate = reportingRate;
    }

    @JsonProperty("dataDimensionItemType")
    public Optional<DataDimensionItem.DataDimensionItemType> getDataDimensionItemType() {
        return Optional.ofNullable(dataDimensionItemType);
    }

    @JsonProperty("dataDimensionItemType")
    public void setDataDimensionItemType(DataDimensionItem.DataDimensionItemType dataDimensionItemType) {
        this.dataDimensionItemType = dataDimensionItemType;
    }

    public DataDimensionItem withDataDimensionItemType(DataDimensionItem.DataDimensionItemType dataDimensionItemType) {
        this.dataDimensionItemType = dataDimensionItemType;
        return this;
    }

    @JsonProperty("dataElement")
    public Optional<DataElement> getDataElement() {
        return Optional.ofNullable(dataElement);
    }

    @JsonProperty("dataElement")
    public void setDataElement(DataElement dataElement) {
        this.dataElement = dataElement;
    }

    public DataDimensionItem withDataElement(DataElement dataElement) {
        this.dataElement = dataElement;
        return this;
    }

    @JsonProperty("dataElementOperand")
    public Optional<DataElementOperand> getDataElementOperand() {
        return Optional.ofNullable(dataElementOperand);
    }

    @JsonProperty("dataElementOperand")
    public void setDataElementOperand(DataElementOperand dataElementOperand) {
        this.dataElementOperand = dataElementOperand;
    }

    public DataDimensionItem withDataElementOperand(DataElementOperand dataElementOperand) {
        this.dataElementOperand = dataElementOperand;
        return this;
    }

    @JsonProperty("indicator")
    public Optional<Indicator> getIndicator() {
        return Optional.ofNullable(indicator);
    }

    @JsonProperty("indicator")
    public void setIndicator(Indicator indicator) {
        this.indicator = indicator;
    }

    public DataDimensionItem withIndicator(Indicator indicator) {
        this.indicator = indicator;
        return this;
    }

    @JsonProperty("programAttribute")
    public Optional<ProgramTrackedEntityAttributeDimensionItem> getProgramAttribute() {
        return Optional.ofNullable(programAttribute);
    }

    @JsonProperty("programAttribute")
    public void setProgramAttribute(ProgramTrackedEntityAttributeDimensionItem programAttribute) {
        this.programAttribute = programAttribute;
    }

    public DataDimensionItem withProgramAttribute(ProgramTrackedEntityAttributeDimensionItem programAttribute) {
        this.programAttribute = programAttribute;
        return this;
    }

    @JsonProperty("programDataElement")
    public Optional<ProgramDataElementDimensionItem> getProgramDataElement() {
        return Optional.ofNullable(programDataElement);
    }

    @JsonProperty("programDataElement")
    public void setProgramDataElement(ProgramDataElementDimensionItem programDataElement) {
        this.programDataElement = programDataElement;
    }

    public DataDimensionItem withProgramDataElement(ProgramDataElementDimensionItem programDataElement) {
        this.programDataElement = programDataElement;
        return this;
    }

    @JsonProperty("programIndicator")
    public Optional<ProgramIndicator> getProgramIndicator() {
        return Optional.ofNullable(programIndicator);
    }

    @JsonProperty("programIndicator")
    public void setProgramIndicator(ProgramIndicator programIndicator) {
        this.programIndicator = programIndicator;
    }

    public DataDimensionItem withProgramIndicator(ProgramIndicator programIndicator) {
        this.programIndicator = programIndicator;
        return this;
    }

    @JsonProperty("reportingRate")
    public Optional<ReportingRate> getReportingRate() {
        return Optional.ofNullable(reportingRate);
    }

    @JsonProperty("reportingRate")
    public void setReportingRate(ReportingRate reportingRate) {
        this.reportingRate = reportingRate;
    }

    public DataDimensionItem withReportingRate(ReportingRate reportingRate) {
        this.reportingRate = reportingRate;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public DataDimensionItem withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "dataDimensionItemType":
                if (value instanceof DataDimensionItem.DataDimensionItemType) {
                    setDataDimensionItemType(((DataDimensionItem.DataDimensionItemType) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataDimensionItemType\" is of type \"org.hisp.dhis.api.model.v2_38_1.DataDimensionItem.DataDimensionItemType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataElement":
                if (value instanceof DataElement) {
                    setDataElement(((DataElement) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataElement\" is of type \"org.hisp.dhis.api.model.v2_38_1.DataElement\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataElementOperand":
                if (value instanceof DataElementOperand) {
                    setDataElementOperand(((DataElementOperand) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataElementOperand\" is of type \"org.hisp.dhis.api.model.v2_38_1.DataElementOperand\", but got "+ value.getClass().toString()));
                }
                return true;
            case "indicator":
                if (value instanceof Indicator) {
                    setIndicator(((Indicator) value));
                } else {
                    throw new IllegalArgumentException(("property \"indicator\" is of type \"org.hisp.dhis.api.model.v2_38_1.Indicator\", but got "+ value.getClass().toString()));
                }
                return true;
            case "programAttribute":
                if (value instanceof ProgramTrackedEntityAttributeDimensionItem) {
                    setProgramAttribute(((ProgramTrackedEntityAttributeDimensionItem) value));
                } else {
                    throw new IllegalArgumentException(("property \"programAttribute\" is of type \"org.hisp.dhis.api.model.v2_38_1.ProgramTrackedEntityAttributeDimensionItem\", but got "+ value.getClass().toString()));
                }
                return true;
            case "programDataElement":
                if (value instanceof ProgramDataElementDimensionItem) {
                    setProgramDataElement(((ProgramDataElementDimensionItem) value));
                } else {
                    throw new IllegalArgumentException(("property \"programDataElement\" is of type \"org.hisp.dhis.api.model.v2_38_1.ProgramDataElementDimensionItem\", but got "+ value.getClass().toString()));
                }
                return true;
            case "programIndicator":
                if (value instanceof ProgramIndicator) {
                    setProgramIndicator(((ProgramIndicator) value));
                } else {
                    throw new IllegalArgumentException(("property \"programIndicator\" is of type \"org.hisp.dhis.api.model.v2_38_1.ProgramIndicator\", but got "+ value.getClass().toString()));
                }
                return true;
            case "reportingRate":
                if (value instanceof ReportingRate) {
                    setReportingRate(((ReportingRate) value));
                } else {
                    throw new IllegalArgumentException(("property \"reportingRate\" is of type \"org.hisp.dhis.api.model.v2_38_1.ReportingRate\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "dataDimensionItemType":
                return getDataDimensionItemType();
            case "dataElement":
                return getDataElement();
            case "dataElementOperand":
                return getDataElementOperand();
            case "indicator":
                return getIndicator();
            case "programAttribute":
                return getProgramAttribute();
            case "programDataElement":
                return getProgramDataElement();
            case "programIndicator":
                return getProgramIndicator();
            case "reportingRate":
                return getReportingRate();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, DataDimensionItem.NOT_FOUND_VALUE);
        if (DataDimensionItem.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public DataDimensionItem with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DataDimensionItem.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("dataDimensionItemType");
        sb.append('=');
        sb.append(((this.dataDimensionItemType == null)?"<null>":this.dataDimensionItemType));
        sb.append(',');
        sb.append("dataElement");
        sb.append('=');
        sb.append(((this.dataElement == null)?"<null>":this.dataElement));
        sb.append(',');
        sb.append("dataElementOperand");
        sb.append('=');
        sb.append(((this.dataElementOperand == null)?"<null>":this.dataElementOperand));
        sb.append(',');
        sb.append("indicator");
        sb.append('=');
        sb.append(((this.indicator == null)?"<null>":this.indicator));
        sb.append(',');
        sb.append("programAttribute");
        sb.append('=');
        sb.append(((this.programAttribute == null)?"<null>":this.programAttribute));
        sb.append(',');
        sb.append("programDataElement");
        sb.append('=');
        sb.append(((this.programDataElement == null)?"<null>":this.programDataElement));
        sb.append(',');
        sb.append("programIndicator");
        sb.append('=');
        sb.append(((this.programIndicator == null)?"<null>":this.programIndicator));
        sb.append(',');
        sb.append("reportingRate");
        sb.append('=');
        sb.append(((this.reportingRate == null)?"<null>":this.reportingRate));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.indicator == null)? 0 :this.indicator.hashCode()));
        result = ((result* 31)+((this.programDataElement == null)? 0 :this.programDataElement.hashCode()));
        result = ((result* 31)+((this.programAttribute == null)? 0 :this.programAttribute.hashCode()));
        result = ((result* 31)+((this.reportingRate == null)? 0 :this.reportingRate.hashCode()));
        result = ((result* 31)+((this.dataElementOperand == null)? 0 :this.dataElementOperand.hashCode()));
        result = ((result* 31)+((this.dataDimensionItemType == null)? 0 :this.dataDimensionItemType.hashCode()));
        result = ((result* 31)+((this.programIndicator == null)? 0 :this.programIndicator.hashCode()));
        result = ((result* 31)+((this.dataElement == null)? 0 :this.dataElement.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof DataDimensionItem) == false) {
            return false;
        }
        DataDimensionItem rhs = ((DataDimensionItem) other);
        return ((((((((((this.indicator == rhs.indicator)||((this.indicator!= null)&&this.indicator.equals(rhs.indicator)))&&((this.programDataElement == rhs.programDataElement)||((this.programDataElement!= null)&&this.programDataElement.equals(rhs.programDataElement))))&&((this.programAttribute == rhs.programAttribute)||((this.programAttribute!= null)&&this.programAttribute.equals(rhs.programAttribute))))&&((this.reportingRate == rhs.reportingRate)||((this.reportingRate!= null)&&this.reportingRate.equals(rhs.reportingRate))))&&((this.dataElementOperand == rhs.dataElementOperand)||((this.dataElementOperand!= null)&&this.dataElementOperand.equals(rhs.dataElementOperand))))&&((this.dataDimensionItemType == rhs.dataDimensionItemType)||((this.dataDimensionItemType!= null)&&this.dataDimensionItemType.equals(rhs.dataDimensionItemType))))&&((this.programIndicator == rhs.programIndicator)||((this.programIndicator!= null)&&this.programIndicator.equals(rhs.programIndicator))))&&((this.dataElement == rhs.dataElement)||((this.dataElement!= null)&&this.dataElement.equals(rhs.dataElement))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))));
    }

    @Generated("jsonschema2pojo")
    public enum DataDimensionItemType {

        INDICATOR("INDICATOR"),
        DATA_ELEMENT("DATA_ELEMENT"),
        DATA_ELEMENT_OPERAND("DATA_ELEMENT_OPERAND"),
        REPORTING_RATE("REPORTING_RATE"),
        PROGRAM_INDICATOR("PROGRAM_INDICATOR"),
        PROGRAM_DATA_ELEMENT("PROGRAM_DATA_ELEMENT"),
        PROGRAM_ATTRIBUTE("PROGRAM_ATTRIBUTE"),
        VALIDATION_RULE("VALIDATION_RULE");
        private final String value;
        private final static Map<String, DataDimensionItem.DataDimensionItemType> CONSTANTS = new HashMap<String, DataDimensionItem.DataDimensionItemType>();

        static {
            for (DataDimensionItem.DataDimensionItemType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        DataDimensionItemType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DataDimensionItem.DataDimensionItemType fromValue(String value) {
            DataDimensionItem.DataDimensionItemType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
