
package org.hisp.dhis.api.model.v2_38_1;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "description",
    "introduction",
    "name",
    "recommendation",
    "section",
    "severity"
})
@Generated("jsonschema2pojo")
public class DataIntegrityCheck implements Serializable
{

    @JsonProperty("description")
    private String description;
    @JsonProperty("introduction")
    private String introduction;
    @JsonProperty("name")
    private String name;
    @JsonProperty("recommendation")
    private String recommendation;
    @JsonProperty("section")
    private String section;
    @JsonProperty("severity")
    private DataIntegrityCheck.DataIntegritySeverity severity;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 2867841401485606943L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DataIntegrityCheck() {
    }

    /**
     * 
     * @param source
     */
    public DataIntegrityCheck(DataIntegrityCheck source) {
        super();
        this.description = source.description;
        this.introduction = source.introduction;
        this.name = source.name;
        this.recommendation = source.recommendation;
        this.section = source.section;
        this.severity = source.severity;
    }

    /**
     * 
     * @param severity
     * @param name
     * @param description
     * @param recommendation
     * @param section
     * @param introduction
     */
    public DataIntegrityCheck(String description, String introduction, String name, String recommendation, String section, DataIntegrityCheck.DataIntegritySeverity severity) {
        super();
        this.description = description;
        this.introduction = introduction;
        this.name = name;
        this.recommendation = recommendation;
        this.section = section;
        this.severity = severity;
    }

    @JsonProperty("description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    public DataIntegrityCheck withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty("introduction")
    public Optional<String> getIntroduction() {
        return Optional.ofNullable(introduction);
    }

    @JsonProperty("introduction")
    public void setIntroduction(String introduction) {
        this.introduction = introduction;
    }

    public DataIntegrityCheck withIntroduction(String introduction) {
        this.introduction = introduction;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public DataIntegrityCheck withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("recommendation")
    public Optional<String> getRecommendation() {
        return Optional.ofNullable(recommendation);
    }

    @JsonProperty("recommendation")
    public void setRecommendation(String recommendation) {
        this.recommendation = recommendation;
    }

    public DataIntegrityCheck withRecommendation(String recommendation) {
        this.recommendation = recommendation;
        return this;
    }

    @JsonProperty("section")
    public Optional<String> getSection() {
        return Optional.ofNullable(section);
    }

    @JsonProperty("section")
    public void setSection(String section) {
        this.section = section;
    }

    public DataIntegrityCheck withSection(String section) {
        this.section = section;
        return this;
    }

    @JsonProperty("severity")
    public Optional<DataIntegrityCheck.DataIntegritySeverity> getSeverity() {
        return Optional.ofNullable(severity);
    }

    @JsonProperty("severity")
    public void setSeverity(DataIntegrityCheck.DataIntegritySeverity severity) {
        this.severity = severity;
    }

    public DataIntegrityCheck withSeverity(DataIntegrityCheck.DataIntegritySeverity severity) {
        this.severity = severity;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public DataIntegrityCheck withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "description":
                if (value instanceof String) {
                    setDescription(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"description\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "introduction":
                if (value instanceof String) {
                    setIntroduction(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"introduction\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "name":
                if (value instanceof String) {
                    setName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "recommendation":
                if (value instanceof String) {
                    setRecommendation(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"recommendation\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "section":
                if (value instanceof String) {
                    setSection(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"section\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "severity":
                if (value instanceof DataIntegrityCheck.DataIntegritySeverity) {
                    setSeverity(((DataIntegrityCheck.DataIntegritySeverity) value));
                } else {
                    throw new IllegalArgumentException(("property \"severity\" is of type \"org.hisp.dhis.api.model.v2_38_1.DataIntegrityCheck.DataIntegritySeverity\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "description":
                return getDescription();
            case "introduction":
                return getIntroduction();
            case "name":
                return getName();
            case "recommendation":
                return getRecommendation();
            case "section":
                return getSection();
            case "severity":
                return getSeverity();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, DataIntegrityCheck.NOT_FOUND_VALUE);
        if (DataIntegrityCheck.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public DataIntegrityCheck with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DataIntegrityCheck.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("introduction");
        sb.append('=');
        sb.append(((this.introduction == null)?"<null>":this.introduction));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("recommendation");
        sb.append('=');
        sb.append(((this.recommendation == null)?"<null>":this.recommendation));
        sb.append(',');
        sb.append("section");
        sb.append('=');
        sb.append(((this.section == null)?"<null>":this.section));
        sb.append(',');
        sb.append("severity");
        sb.append('=');
        sb.append(((this.severity == null)?"<null>":this.severity));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.severity == null)? 0 :this.severity.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.recommendation == null)? 0 :this.recommendation.hashCode()));
        result = ((result* 31)+((this.section == null)? 0 :this.section.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.introduction == null)? 0 :this.introduction.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof DataIntegrityCheck) == false) {
            return false;
        }
        DataIntegrityCheck rhs = ((DataIntegrityCheck) other);
        return ((((((((this.severity == rhs.severity)||((this.severity!= null)&&this.severity.equals(rhs.severity)))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.recommendation == rhs.recommendation)||((this.recommendation!= null)&&this.recommendation.equals(rhs.recommendation))))&&((this.section == rhs.section)||((this.section!= null)&&this.section.equals(rhs.section))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.introduction == rhs.introduction)||((this.introduction!= null)&&this.introduction.equals(rhs.introduction))));
    }

    @Generated("jsonschema2pojo")
    public enum DataIntegritySeverity {

        INFO("INFO"),
        WARNING("WARNING"),
        SEVERE("SEVERE"),
        CRITICAL("CRITICAL");
        private final String value;
        private final static Map<String, DataIntegrityCheck.DataIntegritySeverity> CONSTANTS = new HashMap<String, DataIntegrityCheck.DataIntegritySeverity>();

        static {
            for (DataIntegrityCheck.DataIntegritySeverity c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        DataIntegritySeverity(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DataIntegrityCheck.DataIntegritySeverity fromValue(String value) {
            DataIntegrityCheck.DataIntegritySeverity constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
