
package org.hisp.dhis.api.model.v2_38_1;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "attributeCategoryOptions",
    "attributeOptionCombo",
    "categoryOptionComboIdScheme",
    "completeDate",
    "dataElementIdScheme",
    "dataSet",
    "dataSetIdScheme",
    "dataValues",
    "dryRun",
    "idScheme",
    "orgUnit",
    "orgUnitIdScheme",
    "period",
    "strategy"
})
@Generated("jsonschema2pojo")
public class DataValueSet implements Serializable
{

    @JsonProperty("attributeCategoryOptions")
    private List<String> attributeCategoryOptions = null;
    @JsonProperty("attributeOptionCombo")
    private String attributeOptionCombo;
    @JsonProperty("categoryOptionComboIdScheme")
    private String categoryOptionComboIdScheme;
    @JsonProperty("completeDate")
    private String completeDate;
    @JsonProperty("dataElementIdScheme")
    private String dataElementIdScheme;
    @JsonProperty("dataSet")
    private String dataSet;
    @JsonProperty("dataSetIdScheme")
    private String dataSetIdScheme;
    @JsonProperty("dataValues")
    private List<DataValue__1> dataValues = null;
    @JsonProperty("dryRun")
    private Boolean dryRun;
    @JsonProperty("idScheme")
    private String idScheme;
    @JsonProperty("orgUnit")
    private String orgUnit;
    @JsonProperty("orgUnitIdScheme")
    private String orgUnitIdScheme;
    @JsonProperty("period")
    private String period;
    @JsonProperty("strategy")
    private String strategy;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 2537917624122905870L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DataValueSet() {
    }

    /**
     * 
     * @param source
     */
    public DataValueSet(DataValueSet source) {
        super();
        this.attributeCategoryOptions = source.attributeCategoryOptions;
        this.attributeOptionCombo = source.attributeOptionCombo;
        this.categoryOptionComboIdScheme = source.categoryOptionComboIdScheme;
        this.completeDate = source.completeDate;
        this.dataElementIdScheme = source.dataElementIdScheme;
        this.dataSet = source.dataSet;
        this.dataSetIdScheme = source.dataSetIdScheme;
        this.dataValues = source.dataValues;
        this.dryRun = source.dryRun;
        this.idScheme = source.idScheme;
        this.orgUnit = source.orgUnit;
        this.orgUnitIdScheme = source.orgUnitIdScheme;
        this.period = source.period;
        this.strategy = source.strategy;
    }

    /**
     * 
     * @param dataElementIdScheme
     * @param dataValues
     * @param dataSetIdScheme
     * @param period
     * @param dryRun
     * @param orgUnitIdScheme
     * @param attributeCategoryOptions
     * @param orgUnit
     * @param completeDate
     * @param idScheme
     * @param attributeOptionCombo
     * @param categoryOptionComboIdScheme
     * @param strategy
     * @param dataSet
     */
    public DataValueSet(List<String> attributeCategoryOptions, String attributeOptionCombo, String categoryOptionComboIdScheme, String completeDate, String dataElementIdScheme, String dataSet, String dataSetIdScheme, List<DataValue__1> dataValues, Boolean dryRun, String idScheme, String orgUnit, String orgUnitIdScheme, String period, String strategy) {
        super();
        this.attributeCategoryOptions = attributeCategoryOptions;
        this.attributeOptionCombo = attributeOptionCombo;
        this.categoryOptionComboIdScheme = categoryOptionComboIdScheme;
        this.completeDate = completeDate;
        this.dataElementIdScheme = dataElementIdScheme;
        this.dataSet = dataSet;
        this.dataSetIdScheme = dataSetIdScheme;
        this.dataValues = dataValues;
        this.dryRun = dryRun;
        this.idScheme = idScheme;
        this.orgUnit = orgUnit;
        this.orgUnitIdScheme = orgUnitIdScheme;
        this.period = period;
        this.strategy = strategy;
    }

    @JsonProperty("attributeCategoryOptions")
    public Optional<List<String>> getAttributeCategoryOptions() {
        return Optional.ofNullable(attributeCategoryOptions);
    }

    @JsonProperty("attributeCategoryOptions")
    public void setAttributeCategoryOptions(List<String> attributeCategoryOptions) {
        this.attributeCategoryOptions = attributeCategoryOptions;
    }

    public DataValueSet withAttributeCategoryOptions(List<String> attributeCategoryOptions) {
        this.attributeCategoryOptions = attributeCategoryOptions;
        return this;
    }

    @JsonProperty("attributeOptionCombo")
    public Optional<String> getAttributeOptionCombo() {
        return Optional.ofNullable(attributeOptionCombo);
    }

    @JsonProperty("attributeOptionCombo")
    public void setAttributeOptionCombo(String attributeOptionCombo) {
        this.attributeOptionCombo = attributeOptionCombo;
    }

    public DataValueSet withAttributeOptionCombo(String attributeOptionCombo) {
        this.attributeOptionCombo = attributeOptionCombo;
        return this;
    }

    @JsonProperty("categoryOptionComboIdScheme")
    public Optional<String> getCategoryOptionComboIdScheme() {
        return Optional.ofNullable(categoryOptionComboIdScheme);
    }

    @JsonProperty("categoryOptionComboIdScheme")
    public void setCategoryOptionComboIdScheme(String categoryOptionComboIdScheme) {
        this.categoryOptionComboIdScheme = categoryOptionComboIdScheme;
    }

    public DataValueSet withCategoryOptionComboIdScheme(String categoryOptionComboIdScheme) {
        this.categoryOptionComboIdScheme = categoryOptionComboIdScheme;
        return this;
    }

    @JsonProperty("completeDate")
    public Optional<String> getCompleteDate() {
        return Optional.ofNullable(completeDate);
    }

    @JsonProperty("completeDate")
    public void setCompleteDate(String completeDate) {
        this.completeDate = completeDate;
    }

    public DataValueSet withCompleteDate(String completeDate) {
        this.completeDate = completeDate;
        return this;
    }

    @JsonProperty("dataElementIdScheme")
    public Optional<String> getDataElementIdScheme() {
        return Optional.ofNullable(dataElementIdScheme);
    }

    @JsonProperty("dataElementIdScheme")
    public void setDataElementIdScheme(String dataElementIdScheme) {
        this.dataElementIdScheme = dataElementIdScheme;
    }

    public DataValueSet withDataElementIdScheme(String dataElementIdScheme) {
        this.dataElementIdScheme = dataElementIdScheme;
        return this;
    }

    @JsonProperty("dataSet")
    public Optional<String> getDataSet() {
        return Optional.ofNullable(dataSet);
    }

    @JsonProperty("dataSet")
    public void setDataSet(String dataSet) {
        this.dataSet = dataSet;
    }

    public DataValueSet withDataSet(String dataSet) {
        this.dataSet = dataSet;
        return this;
    }

    @JsonProperty("dataSetIdScheme")
    public Optional<String> getDataSetIdScheme() {
        return Optional.ofNullable(dataSetIdScheme);
    }

    @JsonProperty("dataSetIdScheme")
    public void setDataSetIdScheme(String dataSetIdScheme) {
        this.dataSetIdScheme = dataSetIdScheme;
    }

    public DataValueSet withDataSetIdScheme(String dataSetIdScheme) {
        this.dataSetIdScheme = dataSetIdScheme;
        return this;
    }

    @JsonProperty("dataValues")
    public Optional<List<DataValue__1>> getDataValues() {
        return Optional.ofNullable(dataValues);
    }

    @JsonProperty("dataValues")
    public void setDataValues(List<DataValue__1> dataValues) {
        this.dataValues = dataValues;
    }

    public DataValueSet withDataValues(List<DataValue__1> dataValues) {
        this.dataValues = dataValues;
        return this;
    }

    @JsonProperty("dryRun")
    public Optional<Boolean> getDryRun() {
        return Optional.ofNullable(dryRun);
    }

    @JsonProperty("dryRun")
    public void setDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
    }

    public DataValueSet withDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    @JsonProperty("idScheme")
    public Optional<String> getIdScheme() {
        return Optional.ofNullable(idScheme);
    }

    @JsonProperty("idScheme")
    public void setIdScheme(String idScheme) {
        this.idScheme = idScheme;
    }

    public DataValueSet withIdScheme(String idScheme) {
        this.idScheme = idScheme;
        return this;
    }

    @JsonProperty("orgUnit")
    public Optional<String> getOrgUnit() {
        return Optional.ofNullable(orgUnit);
    }

    @JsonProperty("orgUnit")
    public void setOrgUnit(String orgUnit) {
        this.orgUnit = orgUnit;
    }

    public DataValueSet withOrgUnit(String orgUnit) {
        this.orgUnit = orgUnit;
        return this;
    }

    @JsonProperty("orgUnitIdScheme")
    public Optional<String> getOrgUnitIdScheme() {
        return Optional.ofNullable(orgUnitIdScheme);
    }

    @JsonProperty("orgUnitIdScheme")
    public void setOrgUnitIdScheme(String orgUnitIdScheme) {
        this.orgUnitIdScheme = orgUnitIdScheme;
    }

    public DataValueSet withOrgUnitIdScheme(String orgUnitIdScheme) {
        this.orgUnitIdScheme = orgUnitIdScheme;
        return this;
    }

    @JsonProperty("period")
    public Optional<String> getPeriod() {
        return Optional.ofNullable(period);
    }

    @JsonProperty("period")
    public void setPeriod(String period) {
        this.period = period;
    }

    public DataValueSet withPeriod(String period) {
        this.period = period;
        return this;
    }

    @JsonProperty("strategy")
    public Optional<String> getStrategy() {
        return Optional.ofNullable(strategy);
    }

    @JsonProperty("strategy")
    public void setStrategy(String strategy) {
        this.strategy = strategy;
    }

    public DataValueSet withStrategy(String strategy) {
        this.strategy = strategy;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public DataValueSet withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "attributeCategoryOptions":
                if (value instanceof List) {
                    setAttributeCategoryOptions(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeCategoryOptions\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "attributeOptionCombo":
                if (value instanceof String) {
                    setAttributeOptionCombo(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeOptionCombo\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "categoryOptionComboIdScheme":
                if (value instanceof String) {
                    setCategoryOptionComboIdScheme(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"categoryOptionComboIdScheme\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "completeDate":
                if (value instanceof String) {
                    setCompleteDate(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"completeDate\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataElementIdScheme":
                if (value instanceof String) {
                    setDataElementIdScheme(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataElementIdScheme\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataSet":
                if (value instanceof String) {
                    setDataSet(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataSet\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataSetIdScheme":
                if (value instanceof String) {
                    setDataSetIdScheme(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataSetIdScheme\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataValues":
                if (value instanceof List) {
                    setDataValues(((List<DataValue__1> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.DataValue__1>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dryRun":
                if (value instanceof Boolean) {
                    setDryRun(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"dryRun\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "idScheme":
                if (value instanceof String) {
                    setIdScheme(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"idScheme\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "orgUnit":
                if (value instanceof String) {
                    setOrgUnit(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"orgUnit\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "orgUnitIdScheme":
                if (value instanceof String) {
                    setOrgUnitIdScheme(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"orgUnitIdScheme\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "period":
                if (value instanceof String) {
                    setPeriod(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"period\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "strategy":
                if (value instanceof String) {
                    setStrategy(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"strategy\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "attributeCategoryOptions":
                return getAttributeCategoryOptions();
            case "attributeOptionCombo":
                return getAttributeOptionCombo();
            case "categoryOptionComboIdScheme":
                return getCategoryOptionComboIdScheme();
            case "completeDate":
                return getCompleteDate();
            case "dataElementIdScheme":
                return getDataElementIdScheme();
            case "dataSet":
                return getDataSet();
            case "dataSetIdScheme":
                return getDataSetIdScheme();
            case "dataValues":
                return getDataValues();
            case "dryRun":
                return getDryRun();
            case "idScheme":
                return getIdScheme();
            case "orgUnit":
                return getOrgUnit();
            case "orgUnitIdScheme":
                return getOrgUnitIdScheme();
            case "period":
                return getPeriod();
            case "strategy":
                return getStrategy();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, DataValueSet.NOT_FOUND_VALUE);
        if (DataValueSet.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public DataValueSet with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DataValueSet.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("attributeCategoryOptions");
        sb.append('=');
        sb.append(((this.attributeCategoryOptions == null)?"<null>":this.attributeCategoryOptions));
        sb.append(',');
        sb.append("attributeOptionCombo");
        sb.append('=');
        sb.append(((this.attributeOptionCombo == null)?"<null>":this.attributeOptionCombo));
        sb.append(',');
        sb.append("categoryOptionComboIdScheme");
        sb.append('=');
        sb.append(((this.categoryOptionComboIdScheme == null)?"<null>":this.categoryOptionComboIdScheme));
        sb.append(',');
        sb.append("completeDate");
        sb.append('=');
        sb.append(((this.completeDate == null)?"<null>":this.completeDate));
        sb.append(',');
        sb.append("dataElementIdScheme");
        sb.append('=');
        sb.append(((this.dataElementIdScheme == null)?"<null>":this.dataElementIdScheme));
        sb.append(',');
        sb.append("dataSet");
        sb.append('=');
        sb.append(((this.dataSet == null)?"<null>":this.dataSet));
        sb.append(',');
        sb.append("dataSetIdScheme");
        sb.append('=');
        sb.append(((this.dataSetIdScheme == null)?"<null>":this.dataSetIdScheme));
        sb.append(',');
        sb.append("dataValues");
        sb.append('=');
        sb.append(((this.dataValues == null)?"<null>":this.dataValues));
        sb.append(',');
        sb.append("dryRun");
        sb.append('=');
        sb.append(((this.dryRun == null)?"<null>":this.dryRun));
        sb.append(',');
        sb.append("idScheme");
        sb.append('=');
        sb.append(((this.idScheme == null)?"<null>":this.idScheme));
        sb.append(',');
        sb.append("orgUnit");
        sb.append('=');
        sb.append(((this.orgUnit == null)?"<null>":this.orgUnit));
        sb.append(',');
        sb.append("orgUnitIdScheme");
        sb.append('=');
        sb.append(((this.orgUnitIdScheme == null)?"<null>":this.orgUnitIdScheme));
        sb.append(',');
        sb.append("period");
        sb.append('=');
        sb.append(((this.period == null)?"<null>":this.period));
        sb.append(',');
        sb.append("strategy");
        sb.append('=');
        sb.append(((this.strategy == null)?"<null>":this.strategy));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.dataElementIdScheme == null)? 0 :this.dataElementIdScheme.hashCode()));
        result = ((result* 31)+((this.dataValues == null)? 0 :this.dataValues.hashCode()));
        result = ((result* 31)+((this.dataSetIdScheme == null)? 0 :this.dataSetIdScheme.hashCode()));
        result = ((result* 31)+((this.period == null)? 0 :this.period.hashCode()));
        result = ((result* 31)+((this.dryRun == null)? 0 :this.dryRun.hashCode()));
        result = ((result* 31)+((this.orgUnitIdScheme == null)? 0 :this.orgUnitIdScheme.hashCode()));
        result = ((result* 31)+((this.attributeCategoryOptions == null)? 0 :this.attributeCategoryOptions.hashCode()));
        result = ((result* 31)+((this.orgUnit == null)? 0 :this.orgUnit.hashCode()));
        result = ((result* 31)+((this.completeDate == null)? 0 :this.completeDate.hashCode()));
        result = ((result* 31)+((this.idScheme == null)? 0 :this.idScheme.hashCode()));
        result = ((result* 31)+((this.attributeOptionCombo == null)? 0 :this.attributeOptionCombo.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.categoryOptionComboIdScheme == null)? 0 :this.categoryOptionComboIdScheme.hashCode()));
        result = ((result* 31)+((this.strategy == null)? 0 :this.strategy.hashCode()));
        result = ((result* 31)+((this.dataSet == null)? 0 :this.dataSet.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof DataValueSet) == false) {
            return false;
        }
        DataValueSet rhs = ((DataValueSet) other);
        return ((((((((((((((((this.dataElementIdScheme == rhs.dataElementIdScheme)||((this.dataElementIdScheme!= null)&&this.dataElementIdScheme.equals(rhs.dataElementIdScheme)))&&((this.dataValues == rhs.dataValues)||((this.dataValues!= null)&&this.dataValues.equals(rhs.dataValues))))&&((this.dataSetIdScheme == rhs.dataSetIdScheme)||((this.dataSetIdScheme!= null)&&this.dataSetIdScheme.equals(rhs.dataSetIdScheme))))&&((this.period == rhs.period)||((this.period!= null)&&this.period.equals(rhs.period))))&&((this.dryRun == rhs.dryRun)||((this.dryRun!= null)&&this.dryRun.equals(rhs.dryRun))))&&((this.orgUnitIdScheme == rhs.orgUnitIdScheme)||((this.orgUnitIdScheme!= null)&&this.orgUnitIdScheme.equals(rhs.orgUnitIdScheme))))&&((this.attributeCategoryOptions == rhs.attributeCategoryOptions)||((this.attributeCategoryOptions!= null)&&this.attributeCategoryOptions.equals(rhs.attributeCategoryOptions))))&&((this.orgUnit == rhs.orgUnit)||((this.orgUnit!= null)&&this.orgUnit.equals(rhs.orgUnit))))&&((this.completeDate == rhs.completeDate)||((this.completeDate!= null)&&this.completeDate.equals(rhs.completeDate))))&&((this.idScheme == rhs.idScheme)||((this.idScheme!= null)&&this.idScheme.equals(rhs.idScheme))))&&((this.attributeOptionCombo == rhs.attributeOptionCombo)||((this.attributeOptionCombo!= null)&&this.attributeOptionCombo.equals(rhs.attributeOptionCombo))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.categoryOptionComboIdScheme == rhs.categoryOptionComboIdScheme)||((this.categoryOptionComboIdScheme!= null)&&this.categoryOptionComboIdScheme.equals(rhs.categoryOptionComboIdScheme))))&&((this.strategy == rhs.strategy)||((this.strategy!= null)&&this.strategy.equals(rhs.strategy))))&&((this.dataSet == rhs.dataSet)||((this.dataSet!= null)&&this.dataSet.equals(rhs.dataSet))));
    }

}
