
package org.hisp.dhis.api.model.v2_38_1;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "assignedUserMode",
    "assignedUsers",
    "attributeValueFilters",
    "displayColumnOrder",
    "enrollmentCreatedDate",
    "enrollmentIncidentDate",
    "enrollmentStatus",
    "eventDate",
    "eventStatus",
    "followUp",
    "lastUpdatedDate",
    "order",
    "organisationUnit",
    "ouMode",
    "programStage",
    "trackedEntityInstances",
    "trackedEntityType"
})
@Generated("jsonschema2pojo")
public class EntityQueryCriteria implements Serializable
{

    @JsonProperty("assignedUserMode")
    private AssignedUserSelectionMode assignedUserMode;
    @JsonProperty("assignedUsers")
    private List<String> assignedUsers = null;
    @JsonProperty("attributeValueFilters")
    private List<AttributeValueFilter> attributeValueFilters = null;
    @JsonProperty("displayColumnOrder")
    private List<String> displayColumnOrder = null;
    @JsonProperty("enrollmentCreatedDate")
    private DateFilterPeriod enrollmentCreatedDate;
    @JsonProperty("enrollmentIncidentDate")
    private DateFilterPeriod enrollmentIncidentDate;
    @JsonProperty("enrollmentStatus")
    private org.hisp.dhis.api.model.v2_38_1.EventChart.ProgramStatus enrollmentStatus;
    @JsonProperty("eventDate")
    private DateFilterPeriod eventDate;
    @JsonProperty("eventStatus")
    private org.hisp.dhis.api.model.v2_38_1.EventChart.EventStatus eventStatus;
    @JsonProperty("followUp")
    private Boolean followUp;
    @JsonProperty("lastUpdatedDate")
    private DateFilterPeriod lastUpdatedDate;
    @JsonProperty("order")
    private String order;
    @JsonProperty("organisationUnit")
    private String organisationUnit;
    @JsonProperty("ouMode")
    private org.hisp.dhis.api.model.v2_38_1.MapView.OrganisationUnitSelectionMode ouMode;
    @JsonProperty("programStage")
    private String programStage;
    @JsonProperty("trackedEntityInstances")
    private List<String> trackedEntityInstances = null;
    @JsonProperty("trackedEntityType")
    private String trackedEntityType;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -8729270210416175362L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public EntityQueryCriteria() {
    }

    /**
     * 
     * @param source
     */
    public EntityQueryCriteria(EntityQueryCriteria source) {
        super();
        this.assignedUserMode = source.assignedUserMode;
        this.assignedUsers = source.assignedUsers;
        this.attributeValueFilters = source.attributeValueFilters;
        this.displayColumnOrder = source.displayColumnOrder;
        this.enrollmentCreatedDate = source.enrollmentCreatedDate;
        this.enrollmentIncidentDate = source.enrollmentIncidentDate;
        this.enrollmentStatus = source.enrollmentStatus;
        this.eventDate = source.eventDate;
        this.eventStatus = source.eventStatus;
        this.followUp = source.followUp;
        this.lastUpdatedDate = source.lastUpdatedDate;
        this.order = source.order;
        this.organisationUnit = source.organisationUnit;
        this.ouMode = source.ouMode;
        this.programStage = source.programStage;
        this.trackedEntityInstances = source.trackedEntityInstances;
        this.trackedEntityType = source.trackedEntityType;
    }

    /**
     * 
     * @param assignedUserMode
     * @param programStage
     * @param organisationUnit
     * @param enrollmentIncidentDate
     * @param trackedEntityInstances
     * @param assignedUsers
     * @param enrollmentCreatedDate
     * @param attributeValueFilters
     * @param followUp
     * @param lastUpdatedDate
     * @param trackedEntityType
     * @param enrollmentStatus
     * @param ouMode
     * @param displayColumnOrder
     * @param eventStatus
     * @param eventDate
     * @param order
     */
    public EntityQueryCriteria(AssignedUserSelectionMode assignedUserMode, List<String> assignedUsers, List<AttributeValueFilter> attributeValueFilters, List<String> displayColumnOrder, DateFilterPeriod enrollmentCreatedDate, DateFilterPeriod enrollmentIncidentDate, org.hisp.dhis.api.model.v2_38_1.EventChart.ProgramStatus enrollmentStatus, DateFilterPeriod eventDate, org.hisp.dhis.api.model.v2_38_1.EventChart.EventStatus eventStatus, Boolean followUp, DateFilterPeriod lastUpdatedDate, String order, String organisationUnit, org.hisp.dhis.api.model.v2_38_1.MapView.OrganisationUnitSelectionMode ouMode, String programStage, List<String> trackedEntityInstances, String trackedEntityType) {
        super();
        this.assignedUserMode = assignedUserMode;
        this.assignedUsers = assignedUsers;
        this.attributeValueFilters = attributeValueFilters;
        this.displayColumnOrder = displayColumnOrder;
        this.enrollmentCreatedDate = enrollmentCreatedDate;
        this.enrollmentIncidentDate = enrollmentIncidentDate;
        this.enrollmentStatus = enrollmentStatus;
        this.eventDate = eventDate;
        this.eventStatus = eventStatus;
        this.followUp = followUp;
        this.lastUpdatedDate = lastUpdatedDate;
        this.order = order;
        this.organisationUnit = organisationUnit;
        this.ouMode = ouMode;
        this.programStage = programStage;
        this.trackedEntityInstances = trackedEntityInstances;
        this.trackedEntityType = trackedEntityType;
    }

    @JsonProperty("assignedUserMode")
    public Optional<AssignedUserSelectionMode> getAssignedUserMode() {
        return Optional.ofNullable(assignedUserMode);
    }

    @JsonProperty("assignedUserMode")
    public void setAssignedUserMode(AssignedUserSelectionMode assignedUserMode) {
        this.assignedUserMode = assignedUserMode;
    }

    public EntityQueryCriteria withAssignedUserMode(AssignedUserSelectionMode assignedUserMode) {
        this.assignedUserMode = assignedUserMode;
        return this;
    }

    @JsonProperty("assignedUsers")
    public Optional<List<String>> getAssignedUsers() {
        return Optional.ofNullable(assignedUsers);
    }

    @JsonProperty("assignedUsers")
    public void setAssignedUsers(List<String> assignedUsers) {
        this.assignedUsers = assignedUsers;
    }

    public EntityQueryCriteria withAssignedUsers(List<String> assignedUsers) {
        this.assignedUsers = assignedUsers;
        return this;
    }

    @JsonProperty("attributeValueFilters")
    public Optional<List<AttributeValueFilter>> getAttributeValueFilters() {
        return Optional.ofNullable(attributeValueFilters);
    }

    @JsonProperty("attributeValueFilters")
    public void setAttributeValueFilters(List<AttributeValueFilter> attributeValueFilters) {
        this.attributeValueFilters = attributeValueFilters;
    }

    public EntityQueryCriteria withAttributeValueFilters(List<AttributeValueFilter> attributeValueFilters) {
        this.attributeValueFilters = attributeValueFilters;
        return this;
    }

    @JsonProperty("displayColumnOrder")
    public Optional<List<String>> getDisplayColumnOrder() {
        return Optional.ofNullable(displayColumnOrder);
    }

    @JsonProperty("displayColumnOrder")
    public void setDisplayColumnOrder(List<String> displayColumnOrder) {
        this.displayColumnOrder = displayColumnOrder;
    }

    public EntityQueryCriteria withDisplayColumnOrder(List<String> displayColumnOrder) {
        this.displayColumnOrder = displayColumnOrder;
        return this;
    }

    @JsonProperty("enrollmentCreatedDate")
    public Optional<DateFilterPeriod> getEnrollmentCreatedDate() {
        return Optional.ofNullable(enrollmentCreatedDate);
    }

    @JsonProperty("enrollmentCreatedDate")
    public void setEnrollmentCreatedDate(DateFilterPeriod enrollmentCreatedDate) {
        this.enrollmentCreatedDate = enrollmentCreatedDate;
    }

    public EntityQueryCriteria withEnrollmentCreatedDate(DateFilterPeriod enrollmentCreatedDate) {
        this.enrollmentCreatedDate = enrollmentCreatedDate;
        return this;
    }

    @JsonProperty("enrollmentIncidentDate")
    public Optional<DateFilterPeriod> getEnrollmentIncidentDate() {
        return Optional.ofNullable(enrollmentIncidentDate);
    }

    @JsonProperty("enrollmentIncidentDate")
    public void setEnrollmentIncidentDate(DateFilterPeriod enrollmentIncidentDate) {
        this.enrollmentIncidentDate = enrollmentIncidentDate;
    }

    public EntityQueryCriteria withEnrollmentIncidentDate(DateFilterPeriod enrollmentIncidentDate) {
        this.enrollmentIncidentDate = enrollmentIncidentDate;
        return this;
    }

    @JsonProperty("enrollmentStatus")
    public Optional<org.hisp.dhis.api.model.v2_38_1.EventChart.ProgramStatus> getEnrollmentStatus() {
        return Optional.ofNullable(enrollmentStatus);
    }

    @JsonProperty("enrollmentStatus")
    public void setEnrollmentStatus(org.hisp.dhis.api.model.v2_38_1.EventChart.ProgramStatus enrollmentStatus) {
        this.enrollmentStatus = enrollmentStatus;
    }

    public EntityQueryCriteria withEnrollmentStatus(org.hisp.dhis.api.model.v2_38_1.EventChart.ProgramStatus enrollmentStatus) {
        this.enrollmentStatus = enrollmentStatus;
        return this;
    }

    @JsonProperty("eventDate")
    public Optional<DateFilterPeriod> getEventDate() {
        return Optional.ofNullable(eventDate);
    }

    @JsonProperty("eventDate")
    public void setEventDate(DateFilterPeriod eventDate) {
        this.eventDate = eventDate;
    }

    public EntityQueryCriteria withEventDate(DateFilterPeriod eventDate) {
        this.eventDate = eventDate;
        return this;
    }

    @JsonProperty("eventStatus")
    public Optional<org.hisp.dhis.api.model.v2_38_1.EventChart.EventStatus> getEventStatus() {
        return Optional.ofNullable(eventStatus);
    }

    @JsonProperty("eventStatus")
    public void setEventStatus(org.hisp.dhis.api.model.v2_38_1.EventChart.EventStatus eventStatus) {
        this.eventStatus = eventStatus;
    }

    public EntityQueryCriteria withEventStatus(org.hisp.dhis.api.model.v2_38_1.EventChart.EventStatus eventStatus) {
        this.eventStatus = eventStatus;
        return this;
    }

    @JsonProperty("followUp")
    public Optional<Boolean> getFollowUp() {
        return Optional.ofNullable(followUp);
    }

    @JsonProperty("followUp")
    public void setFollowUp(Boolean followUp) {
        this.followUp = followUp;
    }

    public EntityQueryCriteria withFollowUp(Boolean followUp) {
        this.followUp = followUp;
        return this;
    }

    @JsonProperty("lastUpdatedDate")
    public Optional<DateFilterPeriod> getLastUpdatedDate() {
        return Optional.ofNullable(lastUpdatedDate);
    }

    @JsonProperty("lastUpdatedDate")
    public void setLastUpdatedDate(DateFilterPeriod lastUpdatedDate) {
        this.lastUpdatedDate = lastUpdatedDate;
    }

    public EntityQueryCriteria withLastUpdatedDate(DateFilterPeriod lastUpdatedDate) {
        this.lastUpdatedDate = lastUpdatedDate;
        return this;
    }

    @JsonProperty("order")
    public Optional<String> getOrder() {
        return Optional.ofNullable(order);
    }

    @JsonProperty("order")
    public void setOrder(String order) {
        this.order = order;
    }

    public EntityQueryCriteria withOrder(String order) {
        this.order = order;
        return this;
    }

    @JsonProperty("organisationUnit")
    public Optional<String> getOrganisationUnit() {
        return Optional.ofNullable(organisationUnit);
    }

    @JsonProperty("organisationUnit")
    public void setOrganisationUnit(String organisationUnit) {
        this.organisationUnit = organisationUnit;
    }

    public EntityQueryCriteria withOrganisationUnit(String organisationUnit) {
        this.organisationUnit = organisationUnit;
        return this;
    }

    @JsonProperty("ouMode")
    public Optional<org.hisp.dhis.api.model.v2_38_1.MapView.OrganisationUnitSelectionMode> getOuMode() {
        return Optional.ofNullable(ouMode);
    }

    @JsonProperty("ouMode")
    public void setOuMode(org.hisp.dhis.api.model.v2_38_1.MapView.OrganisationUnitSelectionMode ouMode) {
        this.ouMode = ouMode;
    }

    public EntityQueryCriteria withOuMode(org.hisp.dhis.api.model.v2_38_1.MapView.OrganisationUnitSelectionMode ouMode) {
        this.ouMode = ouMode;
        return this;
    }

    @JsonProperty("programStage")
    public Optional<String> getProgramStage() {
        return Optional.ofNullable(programStage);
    }

    @JsonProperty("programStage")
    public void setProgramStage(String programStage) {
        this.programStage = programStage;
    }

    public EntityQueryCriteria withProgramStage(String programStage) {
        this.programStage = programStage;
        return this;
    }

    @JsonProperty("trackedEntityInstances")
    public Optional<List<String>> getTrackedEntityInstances() {
        return Optional.ofNullable(trackedEntityInstances);
    }

    @JsonProperty("trackedEntityInstances")
    public void setTrackedEntityInstances(List<String> trackedEntityInstances) {
        this.trackedEntityInstances = trackedEntityInstances;
    }

    public EntityQueryCriteria withTrackedEntityInstances(List<String> trackedEntityInstances) {
        this.trackedEntityInstances = trackedEntityInstances;
        return this;
    }

    @JsonProperty("trackedEntityType")
    public Optional<String> getTrackedEntityType() {
        return Optional.ofNullable(trackedEntityType);
    }

    @JsonProperty("trackedEntityType")
    public void setTrackedEntityType(String trackedEntityType) {
        this.trackedEntityType = trackedEntityType;
    }

    public EntityQueryCriteria withTrackedEntityType(String trackedEntityType) {
        this.trackedEntityType = trackedEntityType;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public EntityQueryCriteria withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "assignedUserMode":
                if (value instanceof AssignedUserSelectionMode) {
                    setAssignedUserMode(((AssignedUserSelectionMode) value));
                } else {
                    throw new IllegalArgumentException(("property \"assignedUserMode\" is of type \"org.hisp.dhis.api.model.v2_38_1.AssignedUserSelectionMode\", but got "+ value.getClass().toString()));
                }
                return true;
            case "assignedUsers":
                if (value instanceof List) {
                    setAssignedUsers(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"assignedUsers\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "attributeValueFilters":
                if (value instanceof List) {
                    setAttributeValueFilters(((List<AttributeValueFilter> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeValueFilters\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.AttributeValueFilter>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayColumnOrder":
                if (value instanceof List) {
                    setDisplayColumnOrder(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayColumnOrder\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "enrollmentCreatedDate":
                if (value instanceof DateFilterPeriod) {
                    setEnrollmentCreatedDate(((DateFilterPeriod) value));
                } else {
                    throw new IllegalArgumentException(("property \"enrollmentCreatedDate\" is of type \"org.hisp.dhis.api.model.v2_38_1.DateFilterPeriod\", but got "+ value.getClass().toString()));
                }
                return true;
            case "enrollmentIncidentDate":
                if (value instanceof DateFilterPeriod) {
                    setEnrollmentIncidentDate(((DateFilterPeriod) value));
                } else {
                    throw new IllegalArgumentException(("property \"enrollmentIncidentDate\" is of type \"org.hisp.dhis.api.model.v2_38_1.DateFilterPeriod\", but got "+ value.getClass().toString()));
                }
                return true;
            case "enrollmentStatus":
                if (value instanceof org.hisp.dhis.api.model.v2_38_1.EventChart.ProgramStatus) {
                    setEnrollmentStatus(((org.hisp.dhis.api.model.v2_38_1.EventChart.ProgramStatus) value));
                } else {
                    throw new IllegalArgumentException(("property \"enrollmentStatus\" is of type \"org.hisp.dhis.api.model.v2_38_1.EventChart.ProgramStatus\", but got "+ value.getClass().toString()));
                }
                return true;
            case "eventDate":
                if (value instanceof DateFilterPeriod) {
                    setEventDate(((DateFilterPeriod) value));
                } else {
                    throw new IllegalArgumentException(("property \"eventDate\" is of type \"org.hisp.dhis.api.model.v2_38_1.DateFilterPeriod\", but got "+ value.getClass().toString()));
                }
                return true;
            case "eventStatus":
                if (value instanceof org.hisp.dhis.api.model.v2_38_1.EventChart.EventStatus) {
                    setEventStatus(((org.hisp.dhis.api.model.v2_38_1.EventChart.EventStatus) value));
                } else {
                    throw new IllegalArgumentException(("property \"eventStatus\" is of type \"org.hisp.dhis.api.model.v2_38_1.EventChart.EventStatus\", but got "+ value.getClass().toString()));
                }
                return true;
            case "followUp":
                if (value instanceof Boolean) {
                    setFollowUp(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"followUp\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdatedDate":
                if (value instanceof DateFilterPeriod) {
                    setLastUpdatedDate(((DateFilterPeriod) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdatedDate\" is of type \"org.hisp.dhis.api.model.v2_38_1.DateFilterPeriod\", but got "+ value.getClass().toString()));
                }
                return true;
            case "order":
                if (value instanceof String) {
                    setOrder(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"order\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "organisationUnit":
                if (value instanceof String) {
                    setOrganisationUnit(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"organisationUnit\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "ouMode":
                if (value instanceof org.hisp.dhis.api.model.v2_38_1.MapView.OrganisationUnitSelectionMode) {
                    setOuMode(((org.hisp.dhis.api.model.v2_38_1.MapView.OrganisationUnitSelectionMode) value));
                } else {
                    throw new IllegalArgumentException(("property \"ouMode\" is of type \"org.hisp.dhis.api.model.v2_38_1.MapView.OrganisationUnitSelectionMode\", but got "+ value.getClass().toString()));
                }
                return true;
            case "programStage":
                if (value instanceof String) {
                    setProgramStage(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"programStage\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "trackedEntityInstances":
                if (value instanceof List) {
                    setTrackedEntityInstances(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"trackedEntityInstances\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "trackedEntityType":
                if (value instanceof String) {
                    setTrackedEntityType(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"trackedEntityType\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "assignedUserMode":
                return getAssignedUserMode();
            case "assignedUsers":
                return getAssignedUsers();
            case "attributeValueFilters":
                return getAttributeValueFilters();
            case "displayColumnOrder":
                return getDisplayColumnOrder();
            case "enrollmentCreatedDate":
                return getEnrollmentCreatedDate();
            case "enrollmentIncidentDate":
                return getEnrollmentIncidentDate();
            case "enrollmentStatus":
                return getEnrollmentStatus();
            case "eventDate":
                return getEventDate();
            case "eventStatus":
                return getEventStatus();
            case "followUp":
                return getFollowUp();
            case "lastUpdatedDate":
                return getLastUpdatedDate();
            case "order":
                return getOrder();
            case "organisationUnit":
                return getOrganisationUnit();
            case "ouMode":
                return getOuMode();
            case "programStage":
                return getProgramStage();
            case "trackedEntityInstances":
                return getTrackedEntityInstances();
            case "trackedEntityType":
                return getTrackedEntityType();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, EntityQueryCriteria.NOT_FOUND_VALUE);
        if (EntityQueryCriteria.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public EntityQueryCriteria with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(EntityQueryCriteria.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("assignedUserMode");
        sb.append('=');
        sb.append(((this.assignedUserMode == null)?"<null>":this.assignedUserMode));
        sb.append(',');
        sb.append("assignedUsers");
        sb.append('=');
        sb.append(((this.assignedUsers == null)?"<null>":this.assignedUsers));
        sb.append(',');
        sb.append("attributeValueFilters");
        sb.append('=');
        sb.append(((this.attributeValueFilters == null)?"<null>":this.attributeValueFilters));
        sb.append(',');
        sb.append("displayColumnOrder");
        sb.append('=');
        sb.append(((this.displayColumnOrder == null)?"<null>":this.displayColumnOrder));
        sb.append(',');
        sb.append("enrollmentCreatedDate");
        sb.append('=');
        sb.append(((this.enrollmentCreatedDate == null)?"<null>":this.enrollmentCreatedDate));
        sb.append(',');
        sb.append("enrollmentIncidentDate");
        sb.append('=');
        sb.append(((this.enrollmentIncidentDate == null)?"<null>":this.enrollmentIncidentDate));
        sb.append(',');
        sb.append("enrollmentStatus");
        sb.append('=');
        sb.append(((this.enrollmentStatus == null)?"<null>":this.enrollmentStatus));
        sb.append(',');
        sb.append("eventDate");
        sb.append('=');
        sb.append(((this.eventDate == null)?"<null>":this.eventDate));
        sb.append(',');
        sb.append("eventStatus");
        sb.append('=');
        sb.append(((this.eventStatus == null)?"<null>":this.eventStatus));
        sb.append(',');
        sb.append("followUp");
        sb.append('=');
        sb.append(((this.followUp == null)?"<null>":this.followUp));
        sb.append(',');
        sb.append("lastUpdatedDate");
        sb.append('=');
        sb.append(((this.lastUpdatedDate == null)?"<null>":this.lastUpdatedDate));
        sb.append(',');
        sb.append("order");
        sb.append('=');
        sb.append(((this.order == null)?"<null>":this.order));
        sb.append(',');
        sb.append("organisationUnit");
        sb.append('=');
        sb.append(((this.organisationUnit == null)?"<null>":this.organisationUnit));
        sb.append(',');
        sb.append("ouMode");
        sb.append('=');
        sb.append(((this.ouMode == null)?"<null>":this.ouMode));
        sb.append(',');
        sb.append("programStage");
        sb.append('=');
        sb.append(((this.programStage == null)?"<null>":this.programStage));
        sb.append(',');
        sb.append("trackedEntityInstances");
        sb.append('=');
        sb.append(((this.trackedEntityInstances == null)?"<null>":this.trackedEntityInstances));
        sb.append(',');
        sb.append("trackedEntityType");
        sb.append('=');
        sb.append(((this.trackedEntityType == null)?"<null>":this.trackedEntityType));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.assignedUserMode == null)? 0 :this.assignedUserMode.hashCode()));
        result = ((result* 31)+((this.programStage == null)? 0 :this.programStage.hashCode()));
        result = ((result* 31)+((this.organisationUnit == null)? 0 :this.organisationUnit.hashCode()));
        result = ((result* 31)+((this.enrollmentIncidentDate == null)? 0 :this.enrollmentIncidentDate.hashCode()));
        result = ((result* 31)+((this.trackedEntityInstances == null)? 0 :this.trackedEntityInstances.hashCode()));
        result = ((result* 31)+((this.assignedUsers == null)? 0 :this.assignedUsers.hashCode()));
        result = ((result* 31)+((this.enrollmentCreatedDate == null)? 0 :this.enrollmentCreatedDate.hashCode()));
        result = ((result* 31)+((this.attributeValueFilters == null)? 0 :this.attributeValueFilters.hashCode()));
        result = ((result* 31)+((this.followUp == null)? 0 :this.followUp.hashCode()));
        result = ((result* 31)+((this.lastUpdatedDate == null)? 0 :this.lastUpdatedDate.hashCode()));
        result = ((result* 31)+((this.trackedEntityType == null)? 0 :this.trackedEntityType.hashCode()));
        result = ((result* 31)+((this.enrollmentStatus == null)? 0 :this.enrollmentStatus.hashCode()));
        result = ((result* 31)+((this.ouMode == null)? 0 :this.ouMode.hashCode()));
        result = ((result* 31)+((this.displayColumnOrder == null)? 0 :this.displayColumnOrder.hashCode()));
        result = ((result* 31)+((this.eventStatus == null)? 0 :this.eventStatus.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.eventDate == null)? 0 :this.eventDate.hashCode()));
        result = ((result* 31)+((this.order == null)? 0 :this.order.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof EntityQueryCriteria) == false) {
            return false;
        }
        EntityQueryCriteria rhs = ((EntityQueryCriteria) other);
        return (((((((((((((((((((this.assignedUserMode == rhs.assignedUserMode)||((this.assignedUserMode!= null)&&this.assignedUserMode.equals(rhs.assignedUserMode)))&&((this.programStage == rhs.programStage)||((this.programStage!= null)&&this.programStage.equals(rhs.programStage))))&&((this.organisationUnit == rhs.organisationUnit)||((this.organisationUnit!= null)&&this.organisationUnit.equals(rhs.organisationUnit))))&&((this.enrollmentIncidentDate == rhs.enrollmentIncidentDate)||((this.enrollmentIncidentDate!= null)&&this.enrollmentIncidentDate.equals(rhs.enrollmentIncidentDate))))&&((this.trackedEntityInstances == rhs.trackedEntityInstances)||((this.trackedEntityInstances!= null)&&this.trackedEntityInstances.equals(rhs.trackedEntityInstances))))&&((this.assignedUsers == rhs.assignedUsers)||((this.assignedUsers!= null)&&this.assignedUsers.equals(rhs.assignedUsers))))&&((this.enrollmentCreatedDate == rhs.enrollmentCreatedDate)||((this.enrollmentCreatedDate!= null)&&this.enrollmentCreatedDate.equals(rhs.enrollmentCreatedDate))))&&((this.attributeValueFilters == rhs.attributeValueFilters)||((this.attributeValueFilters!= null)&&this.attributeValueFilters.equals(rhs.attributeValueFilters))))&&((this.followUp == rhs.followUp)||((this.followUp!= null)&&this.followUp.equals(rhs.followUp))))&&((this.lastUpdatedDate == rhs.lastUpdatedDate)||((this.lastUpdatedDate!= null)&&this.lastUpdatedDate.equals(rhs.lastUpdatedDate))))&&((this.trackedEntityType == rhs.trackedEntityType)||((this.trackedEntityType!= null)&&this.trackedEntityType.equals(rhs.trackedEntityType))))&&((this.enrollmentStatus == rhs.enrollmentStatus)||((this.enrollmentStatus!= null)&&this.enrollmentStatus.equals(rhs.enrollmentStatus))))&&((this.ouMode == rhs.ouMode)||((this.ouMode!= null)&&this.ouMode.equals(rhs.ouMode))))&&((this.displayColumnOrder == rhs.displayColumnOrder)||((this.displayColumnOrder!= null)&&this.displayColumnOrder.equals(rhs.displayColumnOrder))))&&((this.eventStatus == rhs.eventStatus)||((this.eventStatus!= null)&&this.eventStatus.equals(rhs.eventStatus))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.eventDate == rhs.eventDate)||((this.eventDate!= null)&&this.eventDate.equals(rhs.eventDate))))&&((this.order == rhs.order)||((this.order!= null)&&this.order.equals(rhs.order))));
    }

}
