
package org.hisp.dhis.api.model.v2_38_1;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "executionTime",
    "plan",
    "planningTime",
    "query",
    "timeInMillis"
})
@Generated("jsonschema2pojo")
public class ExecutionPlan implements Serializable
{

    @JsonProperty("executionTime")
    private Double executionTime;
    /**
     * Undefined
     * 
     */
    @JsonProperty("plan")
    private List<Object> plan = null;
    @JsonProperty("planningTime")
    private Double planningTime;
    @JsonProperty("query")
    private String query;
    @JsonProperty("timeInMillis")
    private Double timeInMillis;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 3250939337669866062L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ExecutionPlan() {
    }

    /**
     * 
     * @param source
     */
    public ExecutionPlan(ExecutionPlan source) {
        super();
        this.executionTime = source.executionTime;
        this.plan = source.plan;
        this.planningTime = source.planningTime;
        this.query = source.query;
        this.timeInMillis = source.timeInMillis;
    }

    /**
     * 
     * @param executionTime
     * @param query
     * @param timeInMillis
     * @param plan
     * @param planningTime
     */
    public ExecutionPlan(Double executionTime, List<Object> plan, Double planningTime, String query, Double timeInMillis) {
        super();
        this.executionTime = executionTime;
        this.plan = plan;
        this.planningTime = planningTime;
        this.query = query;
        this.timeInMillis = timeInMillis;
    }

    @JsonProperty("executionTime")
    public Optional<Double> getExecutionTime() {
        return Optional.ofNullable(executionTime);
    }

    @JsonProperty("executionTime")
    public void setExecutionTime(Double executionTime) {
        this.executionTime = executionTime;
    }

    public ExecutionPlan withExecutionTime(Double executionTime) {
        this.executionTime = executionTime;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("plan")
    public Optional<List<Object>> getPlan() {
        return Optional.ofNullable(plan);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("plan")
    public void setPlan(List<Object> plan) {
        this.plan = plan;
    }

    public ExecutionPlan withPlan(List<Object> plan) {
        this.plan = plan;
        return this;
    }

    @JsonProperty("planningTime")
    public Optional<Double> getPlanningTime() {
        return Optional.ofNullable(planningTime);
    }

    @JsonProperty("planningTime")
    public void setPlanningTime(Double planningTime) {
        this.planningTime = planningTime;
    }

    public ExecutionPlan withPlanningTime(Double planningTime) {
        this.planningTime = planningTime;
        return this;
    }

    @JsonProperty("query")
    public Optional<String> getQuery() {
        return Optional.ofNullable(query);
    }

    @JsonProperty("query")
    public void setQuery(String query) {
        this.query = query;
    }

    public ExecutionPlan withQuery(String query) {
        this.query = query;
        return this;
    }

    @JsonProperty("timeInMillis")
    public Optional<Double> getTimeInMillis() {
        return Optional.ofNullable(timeInMillis);
    }

    @JsonProperty("timeInMillis")
    public void setTimeInMillis(Double timeInMillis) {
        this.timeInMillis = timeInMillis;
    }

    public ExecutionPlan withTimeInMillis(Double timeInMillis) {
        this.timeInMillis = timeInMillis;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ExecutionPlan withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "executionTime":
                if (value instanceof Double) {
                    setExecutionTime(((Double) value));
                } else {
                    throw new IllegalArgumentException(("property \"executionTime\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                }
                return true;
            case "plan":
                if (value instanceof List) {
                    setPlan(((List<Object> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"plan\" is of type \"java.util.List<java.lang.Object>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "planningTime":
                if (value instanceof Double) {
                    setPlanningTime(((Double) value));
                } else {
                    throw new IllegalArgumentException(("property \"planningTime\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                }
                return true;
            case "query":
                if (value instanceof String) {
                    setQuery(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"query\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "timeInMillis":
                if (value instanceof Double) {
                    setTimeInMillis(((Double) value));
                } else {
                    throw new IllegalArgumentException(("property \"timeInMillis\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "executionTime":
                return getExecutionTime();
            case "plan":
                return getPlan();
            case "planningTime":
                return getPlanningTime();
            case "query":
                return getQuery();
            case "timeInMillis":
                return getTimeInMillis();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ExecutionPlan.NOT_FOUND_VALUE);
        if (ExecutionPlan.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ExecutionPlan with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ExecutionPlan.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("executionTime");
        sb.append('=');
        sb.append(((this.executionTime == null)?"<null>":this.executionTime));
        sb.append(',');
        sb.append("plan");
        sb.append('=');
        sb.append(((this.plan == null)?"<null>":this.plan));
        sb.append(',');
        sb.append("planningTime");
        sb.append('=');
        sb.append(((this.planningTime == null)?"<null>":this.planningTime));
        sb.append(',');
        sb.append("query");
        sb.append('=');
        sb.append(((this.query == null)?"<null>":this.query));
        sb.append(',');
        sb.append("timeInMillis");
        sb.append('=');
        sb.append(((this.timeInMillis == null)?"<null>":this.timeInMillis));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.executionTime == null)? 0 :this.executionTime.hashCode()));
        result = ((result* 31)+((this.query == null)? 0 :this.query.hashCode()));
        result = ((result* 31)+((this.timeInMillis == null)? 0 :this.timeInMillis.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.plan == null)? 0 :this.plan.hashCode()));
        result = ((result* 31)+((this.planningTime == null)? 0 :this.planningTime.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ExecutionPlan) == false) {
            return false;
        }
        ExecutionPlan rhs = ((ExecutionPlan) other);
        return (((((((this.executionTime == rhs.executionTime)||((this.executionTime!= null)&&this.executionTime.equals(rhs.executionTime)))&&((this.query == rhs.query)||((this.query!= null)&&this.query.equals(rhs.query))))&&((this.timeInMillis == rhs.timeInMillis)||((this.timeInMillis!= null)&&this.timeInMillis.equals(rhs.timeInMillis))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.plan == rhs.plan)||((this.plan!= null)&&this.plan.equals(rhs.plan))))&&((this.planningTime == rhs.planningTime)||((this.planningTime!= null)&&this.planningTime.equals(rhs.planningTime))));
    }

}
