
package org.hisp.dhis.api.model.v2_38_1;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "deleted",
    "ignored",
    "importOptions",
    "importSummaries",
    "imported",
    "responseType",
    "status",
    "total",
    "updated"
})
@Generated("jsonschema2pojo")
public class ImportSummaries implements Serializable
{

    @JsonProperty("deleted")
    private Integer deleted;
    @JsonProperty("ignored")
    private Integer ignored;
    @JsonProperty("importOptions")
    private ImportOptions importOptions;
    @JsonProperty("importSummaries")
    private List<ImportSummary> importSummaries = null;
    @JsonProperty("imported")
    private Integer imported;
    @JsonProperty("responseType")
    private String responseType;
    @JsonProperty("status")
    private ImportStatus status;
    @JsonProperty("total")
    private Integer total;
    @JsonProperty("updated")
    private Integer updated;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 125511851225266938L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ImportSummaries() {
    }

    /**
     * 
     * @param source
     */
    public ImportSummaries(ImportSummaries source) {
        super();
        this.deleted = source.deleted;
        this.ignored = source.ignored;
        this.importOptions = source.importOptions;
        this.importSummaries = source.importSummaries;
        this.imported = source.imported;
        this.responseType = source.responseType;
        this.status = source.status;
        this.total = source.total;
        this.updated = source.updated;
    }

    /**
     * 
     * @param ignored
     * @param importOptions
     * @param responseType
     * @param total
     * @param deleted
     * @param imported
     * @param importSummaries
     * @param updated
     * @param status
     */
    public ImportSummaries(Integer deleted, Integer ignored, ImportOptions importOptions, List<ImportSummary> importSummaries, Integer imported, String responseType, ImportStatus status, Integer total, Integer updated) {
        super();
        this.deleted = deleted;
        this.ignored = ignored;
        this.importOptions = importOptions;
        this.importSummaries = importSummaries;
        this.imported = imported;
        this.responseType = responseType;
        this.status = status;
        this.total = total;
        this.updated = updated;
    }

    @JsonProperty("deleted")
    public Optional<Integer> getDeleted() {
        return Optional.ofNullable(deleted);
    }

    @JsonProperty("deleted")
    public void setDeleted(Integer deleted) {
        this.deleted = deleted;
    }

    public ImportSummaries withDeleted(Integer deleted) {
        this.deleted = deleted;
        return this;
    }

    @JsonProperty("ignored")
    public Optional<Integer> getIgnored() {
        return Optional.ofNullable(ignored);
    }

    @JsonProperty("ignored")
    public void setIgnored(Integer ignored) {
        this.ignored = ignored;
    }

    public ImportSummaries withIgnored(Integer ignored) {
        this.ignored = ignored;
        return this;
    }

    @JsonProperty("importOptions")
    public Optional<ImportOptions> getImportOptions() {
        return Optional.ofNullable(importOptions);
    }

    @JsonProperty("importOptions")
    public void setImportOptions(ImportOptions importOptions) {
        this.importOptions = importOptions;
    }

    public ImportSummaries withImportOptions(ImportOptions importOptions) {
        this.importOptions = importOptions;
        return this;
    }

    @JsonProperty("importSummaries")
    public Optional<List<ImportSummary>> getImportSummaries() {
        return Optional.ofNullable(importSummaries);
    }

    @JsonProperty("importSummaries")
    public void setImportSummaries(List<ImportSummary> importSummaries) {
        this.importSummaries = importSummaries;
    }

    public ImportSummaries withImportSummaries(List<ImportSummary> importSummaries) {
        this.importSummaries = importSummaries;
        return this;
    }

    @JsonProperty("imported")
    public Optional<Integer> getImported() {
        return Optional.ofNullable(imported);
    }

    @JsonProperty("imported")
    public void setImported(Integer imported) {
        this.imported = imported;
    }

    public ImportSummaries withImported(Integer imported) {
        this.imported = imported;
        return this;
    }

    @JsonProperty("responseType")
    public Optional<String> getResponseType() {
        return Optional.ofNullable(responseType);
    }

    @JsonProperty("responseType")
    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    public ImportSummaries withResponseType(String responseType) {
        this.responseType = responseType;
        return this;
    }

    @JsonProperty("status")
    public Optional<ImportStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    @JsonProperty("status")
    public void setStatus(ImportStatus status) {
        this.status = status;
    }

    public ImportSummaries withStatus(ImportStatus status) {
        this.status = status;
        return this;
    }

    @JsonProperty("total")
    public Optional<Integer> getTotal() {
        return Optional.ofNullable(total);
    }

    @JsonProperty("total")
    public void setTotal(Integer total) {
        this.total = total;
    }

    public ImportSummaries withTotal(Integer total) {
        this.total = total;
        return this;
    }

    @JsonProperty("updated")
    public Optional<Integer> getUpdated() {
        return Optional.ofNullable(updated);
    }

    @JsonProperty("updated")
    public void setUpdated(Integer updated) {
        this.updated = updated;
    }

    public ImportSummaries withUpdated(Integer updated) {
        this.updated = updated;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ImportSummaries withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "deleted":
                if (value instanceof Integer) {
                    setDeleted(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"deleted\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "ignored":
                if (value instanceof Integer) {
                    setIgnored(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"ignored\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "importOptions":
                if (value instanceof ImportOptions) {
                    setImportOptions(((ImportOptions) value));
                } else {
                    throw new IllegalArgumentException(("property \"importOptions\" is of type \"org.hisp.dhis.api.model.v2_38_1.ImportOptions\", but got "+ value.getClass().toString()));
                }
                return true;
            case "importSummaries":
                if (value instanceof List) {
                    setImportSummaries(((List<ImportSummary> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"importSummaries\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.ImportSummary>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "imported":
                if (value instanceof Integer) {
                    setImported(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"imported\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "responseType":
                if (value instanceof String) {
                    setResponseType(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"responseType\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "status":
                if (value instanceof ImportStatus) {
                    setStatus(((ImportStatus) value));
                } else {
                    throw new IllegalArgumentException(("property \"status\" is of type \"org.hisp.dhis.api.model.v2_38_1.ImportStatus\", but got "+ value.getClass().toString()));
                }
                return true;
            case "total":
                if (value instanceof Integer) {
                    setTotal(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"total\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "updated":
                if (value instanceof Integer) {
                    setUpdated(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"updated\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "deleted":
                return getDeleted();
            case "ignored":
                return getIgnored();
            case "importOptions":
                return getImportOptions();
            case "importSummaries":
                return getImportSummaries();
            case "imported":
                return getImported();
            case "responseType":
                return getResponseType();
            case "status":
                return getStatus();
            case "total":
                return getTotal();
            case "updated":
                return getUpdated();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ImportSummaries.NOT_FOUND_VALUE);
        if (ImportSummaries.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ImportSummaries with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ImportSummaries.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("deleted");
        sb.append('=');
        sb.append(((this.deleted == null)?"<null>":this.deleted));
        sb.append(',');
        sb.append("ignored");
        sb.append('=');
        sb.append(((this.ignored == null)?"<null>":this.ignored));
        sb.append(',');
        sb.append("importOptions");
        sb.append('=');
        sb.append(((this.importOptions == null)?"<null>":this.importOptions));
        sb.append(',');
        sb.append("importSummaries");
        sb.append('=');
        sb.append(((this.importSummaries == null)?"<null>":this.importSummaries));
        sb.append(',');
        sb.append("imported");
        sb.append('=');
        sb.append(((this.imported == null)?"<null>":this.imported));
        sb.append(',');
        sb.append("responseType");
        sb.append('=');
        sb.append(((this.responseType == null)?"<null>":this.responseType));
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(((this.status == null)?"<null>":this.status));
        sb.append(',');
        sb.append("total");
        sb.append('=');
        sb.append(((this.total == null)?"<null>":this.total));
        sb.append(',');
        sb.append("updated");
        sb.append('=');
        sb.append(((this.updated == null)?"<null>":this.updated));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.ignored == null)? 0 :this.ignored.hashCode()));
        result = ((result* 31)+((this.importOptions == null)? 0 :this.importOptions.hashCode()));
        result = ((result* 31)+((this.responseType == null)? 0 :this.responseType.hashCode()));
        result = ((result* 31)+((this.total == null)? 0 :this.total.hashCode()));
        result = ((result* 31)+((this.deleted == null)? 0 :this.deleted.hashCode()));
        result = ((result* 31)+((this.imported == null)? 0 :this.imported.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.importSummaries == null)? 0 :this.importSummaries.hashCode()));
        result = ((result* 31)+((this.updated == null)? 0 :this.updated.hashCode()));
        result = ((result* 31)+((this.status == null)? 0 :this.status.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ImportSummaries) == false) {
            return false;
        }
        ImportSummaries rhs = ((ImportSummaries) other);
        return (((((((((((this.ignored == rhs.ignored)||((this.ignored!= null)&&this.ignored.equals(rhs.ignored)))&&((this.importOptions == rhs.importOptions)||((this.importOptions!= null)&&this.importOptions.equals(rhs.importOptions))))&&((this.responseType == rhs.responseType)||((this.responseType!= null)&&this.responseType.equals(rhs.responseType))))&&((this.total == rhs.total)||((this.total!= null)&&this.total.equals(rhs.total))))&&((this.deleted == rhs.deleted)||((this.deleted!= null)&&this.deleted.equals(rhs.deleted))))&&((this.imported == rhs.imported)||((this.imported!= null)&&this.imported.equals(rhs.imported))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.importSummaries == rhs.importSummaries)||((this.importSummaries!= null)&&this.importSummaries.equals(rhs.importSummaries))))&&((this.updated == rhs.updated)||((this.updated!= null)&&this.updated.equals(rhs.updated))))&&((this.status == rhs.status)||((this.status!= null)&&this.status.equals(rhs.status))));
    }

}
