
package org.hisp.dhis.api.model.v2_38_1;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "enrollments",
    "relationships",
    "trackedEntityAttributes"
})
@Generated("jsonschema2pojo")
public class MergeObject implements Serializable
{

    @JsonProperty("enrollments")
    private List<String> enrollments = null;
    @JsonProperty("relationships")
    private List<String> relationships = null;
    @JsonProperty("trackedEntityAttributes")
    private List<String> trackedEntityAttributes = null;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -3137490216159491207L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public MergeObject() {
    }

    /**
     * 
     * @param source
     */
    public MergeObject(MergeObject source) {
        super();
        this.enrollments = source.enrollments;
        this.relationships = source.relationships;
        this.trackedEntityAttributes = source.trackedEntityAttributes;
    }

    /**
     * 
     * @param relationships
     * @param trackedEntityAttributes
     * @param enrollments
     */
    public MergeObject(List<String> enrollments, List<String> relationships, List<String> trackedEntityAttributes) {
        super();
        this.enrollments = enrollments;
        this.relationships = relationships;
        this.trackedEntityAttributes = trackedEntityAttributes;
    }

    @JsonProperty("enrollments")
    public Optional<List<String>> getEnrollments() {
        return Optional.ofNullable(enrollments);
    }

    @JsonProperty("enrollments")
    public void setEnrollments(List<String> enrollments) {
        this.enrollments = enrollments;
    }

    public MergeObject withEnrollments(List<String> enrollments) {
        this.enrollments = enrollments;
        return this;
    }

    @JsonProperty("relationships")
    public Optional<List<String>> getRelationships() {
        return Optional.ofNullable(relationships);
    }

    @JsonProperty("relationships")
    public void setRelationships(List<String> relationships) {
        this.relationships = relationships;
    }

    public MergeObject withRelationships(List<String> relationships) {
        this.relationships = relationships;
        return this;
    }

    @JsonProperty("trackedEntityAttributes")
    public Optional<List<String>> getTrackedEntityAttributes() {
        return Optional.ofNullable(trackedEntityAttributes);
    }

    @JsonProperty("trackedEntityAttributes")
    public void setTrackedEntityAttributes(List<String> trackedEntityAttributes) {
        this.trackedEntityAttributes = trackedEntityAttributes;
    }

    public MergeObject withTrackedEntityAttributes(List<String> trackedEntityAttributes) {
        this.trackedEntityAttributes = trackedEntityAttributes;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public MergeObject withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "enrollments":
                if (value instanceof List) {
                    setEnrollments(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"enrollments\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "relationships":
                if (value instanceof List) {
                    setRelationships(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"relationships\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "trackedEntityAttributes":
                if (value instanceof List) {
                    setTrackedEntityAttributes(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"trackedEntityAttributes\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "enrollments":
                return getEnrollments();
            case "relationships":
                return getRelationships();
            case "trackedEntityAttributes":
                return getTrackedEntityAttributes();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, MergeObject.NOT_FOUND_VALUE);
        if (MergeObject.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public MergeObject with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(MergeObject.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("enrollments");
        sb.append('=');
        sb.append(((this.enrollments == null)?"<null>":this.enrollments));
        sb.append(',');
        sb.append("relationships");
        sb.append('=');
        sb.append(((this.relationships == null)?"<null>":this.relationships));
        sb.append(',');
        sb.append("trackedEntityAttributes");
        sb.append('=');
        sb.append(((this.trackedEntityAttributes == null)?"<null>":this.trackedEntityAttributes));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.relationships == null)? 0 :this.relationships.hashCode()));
        result = ((result* 31)+((this.trackedEntityAttributes == null)? 0 :this.trackedEntityAttributes.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.enrollments == null)? 0 :this.enrollments.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof MergeObject) == false) {
            return false;
        }
        MergeObject rhs = ((MergeObject) other);
        return (((((this.relationships == rhs.relationships)||((this.relationships!= null)&&this.relationships.equals(rhs.relationships)))&&((this.trackedEntityAttributes == rhs.trackedEntityAttributes)||((this.trackedEntityAttributes!= null)&&this.trackedEntityAttributes.equals(rhs.trackedEntityAttributes))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.enrollments == rhs.enrollments)||((this.enrollments!= null)&&this.enrollments.equals(rhs.enrollments))));
    }

}
