
package org.hisp.dhis.api.model.v2_38_1;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "aggregationType",
    "allItems",
    "attributeValues",
    "code",
    "compulsory",
    "created",
    "createdBy",
    "dataDimension",
    "dataDimensionType",
    "description",
    "dimension",
    "dimensionItemKeywords",
    "dimensionType",
    "displayDescription",
    "displayFormName",
    "displayName",
    "displayShortName",
    "externalAccess",
    "favorite",
    "favorites",
    "filter",
    "formName",
    "href",
    "id",
    "includeSubhierarchyInAnalytics",
    "items",
    "lastUpdated",
    "lastUpdatedBy",
    "legendSet",
    "name",
    "optionSet",
    "organisationUnitGroups",
    "programStage",
    "publicAccess",
    "repetition",
    "sharing",
    "shortName",
    "translations",
    "user",
    "userAccesses",
    "userGroupAccesses",
    "valueType"
})
@Generated("jsonschema2pojo")
public class OrganisationUnitGroupSet implements Serializable
{

    @JsonProperty("access")
    private Access access;
    @JsonProperty("aggregationType")
    private AggregationType aggregationType;
    @JsonProperty("allItems")
    private Boolean allItems;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues = null;
    @JsonProperty("code")
    private String code;
    @JsonProperty("compulsory")
    private Boolean compulsory;
    @JsonProperty("created")
    private Date created;
    @JsonProperty("createdBy")
    private User createdBy;
    @JsonProperty("dataDimension")
    private Boolean dataDimension;
    @JsonProperty("dataDimensionType")
    private org.hisp.dhis.api.model.v2_38_1.CategoryOptionGroup.DataDimensionType dataDimensionType;
    @JsonProperty("description")
    private String description;
    @JsonProperty("dimension")
    private String dimension;
    /**
     * Undefined
     * 
     */
    @JsonProperty("dimensionItemKeywords")
    private Object dimensionItemKeywords;
    @JsonProperty("dimensionType")
    private org.hisp.dhis.api.model.v2_38_1.CategoryOptionGroupSet.DimensionType dimensionType;
    @JsonProperty("displayDescription")
    private String displayDescription;
    @JsonProperty("displayFormName")
    private String displayFormName;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("displayShortName")
    private String displayShortName;
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites = null;
    @JsonProperty("filter")
    private String filter;
    @JsonProperty("formName")
    private String formName;
    @JsonProperty("href")
    private String href;
    @JsonProperty("id")
    private String id;
    @JsonProperty("includeSubhierarchyInAnalytics")
    private Boolean includeSubhierarchyInAnalytics;
    @JsonProperty("items")
    private List<Object> items = null;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    @JsonProperty("lastUpdatedBy")
    private User lastUpdatedBy;
    @JsonProperty("legendSet")
    private LegendSet legendSet;
    @JsonProperty("name")
    private String name;
    @JsonProperty("optionSet")
    private OptionSet optionSet;
    @JsonProperty("organisationUnitGroups")
    private List<OrganisationUnitGroup> organisationUnitGroups = null;
    @JsonProperty("programStage")
    private ProgramStage programStage;
    @JsonProperty("publicAccess")
    private String publicAccess;
    @JsonProperty("repetition")
    private EventRepetition repetition;
    @JsonProperty("sharing")
    private Sharing sharing;
    @JsonProperty("shortName")
    private String shortName;
    @JsonProperty("translations")
    private List<Translation> translations = null;
    @JsonProperty("user")
    private User user;
    @JsonProperty("userAccesses")
    private List<UserAccess> userAccesses = null;
    @JsonProperty("userGroupAccesses")
    private List<UserGroupAccess> userGroupAccesses = null;
    @JsonProperty("valueType")
    private OptionSet.ValueType valueType;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -4376109762516509858L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public OrganisationUnitGroupSet() {
    }

    /**
     * 
     * @param source
     */
    public OrganisationUnitGroupSet(OrganisationUnitGroupSet source) {
        super();
        this.access = source.access;
        this.aggregationType = source.aggregationType;
        this.allItems = source.allItems;
        this.attributeValues = source.attributeValues;
        this.code = source.code;
        this.compulsory = source.compulsory;
        this.created = source.created;
        this.createdBy = source.createdBy;
        this.dataDimension = source.dataDimension;
        this.dataDimensionType = source.dataDimensionType;
        this.description = source.description;
        this.dimension = source.dimension;
        this.dimensionItemKeywords = source.dimensionItemKeywords;
        this.dimensionType = source.dimensionType;
        this.displayDescription = source.displayDescription;
        this.displayFormName = source.displayFormName;
        this.displayName = source.displayName;
        this.displayShortName = source.displayShortName;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.filter = source.filter;
        this.formName = source.formName;
        this.href = source.href;
        this.id = source.id;
        this.includeSubhierarchyInAnalytics = source.includeSubhierarchyInAnalytics;
        this.items = source.items;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.legendSet = source.legendSet;
        this.name = source.name;
        this.optionSet = source.optionSet;
        this.organisationUnitGroups = source.organisationUnitGroups;
        this.programStage = source.programStage;
        this.publicAccess = source.publicAccess;
        this.repetition = source.repetition;
        this.sharing = source.sharing;
        this.shortName = source.shortName;
        this.translations = source.translations;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userGroupAccesses = source.userGroupAccesses;
        this.valueType = source.valueType;
    }

    /**
     * 
     * @param dataDimensionType
     * @param dimensionItemKeywords
     * @param favorites
     * @param aggregationType
     * @param dimensionType
     * @param access
     * @param code
     * @param displayName
     * @param publicAccess
     * @param description
     * @param repetition
     * @param displayShortName
     * @param externalAccess
     * @param lastUpdated
     * @param optionSet
     * @param translations
     * @param formName
     * @param valueType
     * @param href
     * @param id
     * @param organisationUnitGroups
     * @param dimension
     * @param displayDescription
     * @param lastUpdatedBy
     * @param programStage
     * @param userGroupAccesses
     * @param allItems
     * @param created
     * @param attributeValues
     * @param sharing
     * @param displayFormName
     * @param filter
     * @param compulsory
     * @param createdBy
     * @param includeSubhierarchyInAnalytics
     * @param userAccesses
     * @param legendSet
     * @param name
     * @param dataDimension
     * @param shortName
     * @param favorite
     * @param items
     * @param user
     */
    public OrganisationUnitGroupSet(Access access, AggregationType aggregationType, Boolean allItems, List<AttributeValue> attributeValues, String code, Boolean compulsory, Date created, User createdBy, Boolean dataDimension, org.hisp.dhis.api.model.v2_38_1.CategoryOptionGroup.DataDimensionType dataDimensionType, String description, String dimension, Object dimensionItemKeywords, org.hisp.dhis.api.model.v2_38_1.CategoryOptionGroupSet.DimensionType dimensionType, String displayDescription, String displayFormName, String displayName, String displayShortName, Boolean externalAccess, Boolean favorite, List<String> favorites, String filter, String formName, String href, String id, Boolean includeSubhierarchyInAnalytics, List<Object> items, Date lastUpdated, User lastUpdatedBy, LegendSet legendSet, String name, OptionSet optionSet, List<OrganisationUnitGroup> organisationUnitGroups, ProgramStage programStage, String publicAccess, EventRepetition repetition, Sharing sharing, String shortName, List<Translation> translations, User user, List<UserAccess> userAccesses, List<UserGroupAccess> userGroupAccesses, OptionSet.ValueType valueType) {
        super();
        this.access = access;
        this.aggregationType = aggregationType;
        this.allItems = allItems;
        this.attributeValues = attributeValues;
        this.code = code;
        this.compulsory = compulsory;
        this.created = created;
        this.createdBy = createdBy;
        this.dataDimension = dataDimension;
        this.dataDimensionType = dataDimensionType;
        this.description = description;
        this.dimension = dimension;
        this.dimensionItemKeywords = dimensionItemKeywords;
        this.dimensionType = dimensionType;
        this.displayDescription = displayDescription;
        this.displayFormName = displayFormName;
        this.displayName = displayName;
        this.displayShortName = displayShortName;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.filter = filter;
        this.formName = formName;
        this.href = href;
        this.id = id;
        this.includeSubhierarchyInAnalytics = includeSubhierarchyInAnalytics;
        this.items = items;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.legendSet = legendSet;
        this.name = name;
        this.optionSet = optionSet;
        this.organisationUnitGroups = organisationUnitGroups;
        this.programStage = programStage;
        this.publicAccess = publicAccess;
        this.repetition = repetition;
        this.sharing = sharing;
        this.shortName = shortName;
        this.translations = translations;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userGroupAccesses = userGroupAccesses;
        this.valueType = valueType;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public OrganisationUnitGroupSet withAccess(Access access) {
        this.access = access;
        return this;
    }

    @JsonProperty("aggregationType")
    public Optional<AggregationType> getAggregationType() {
        return Optional.ofNullable(aggregationType);
    }

    @JsonProperty("aggregationType")
    public void setAggregationType(AggregationType aggregationType) {
        this.aggregationType = aggregationType;
    }

    public OrganisationUnitGroupSet withAggregationType(AggregationType aggregationType) {
        this.aggregationType = aggregationType;
        return this;
    }

    @JsonProperty("allItems")
    public Optional<Boolean> getAllItems() {
        return Optional.ofNullable(allItems);
    }

    @JsonProperty("allItems")
    public void setAllItems(Boolean allItems) {
        this.allItems = allItems;
    }

    public OrganisationUnitGroupSet withAllItems(Boolean allItems) {
        this.allItems = allItems;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public OrganisationUnitGroupSet withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public OrganisationUnitGroupSet withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("compulsory")
    public Optional<Boolean> getCompulsory() {
        return Optional.ofNullable(compulsory);
    }

    @JsonProperty("compulsory")
    public void setCompulsory(Boolean compulsory) {
        this.compulsory = compulsory;
    }

    public OrganisationUnitGroupSet withCompulsory(Boolean compulsory) {
        this.compulsory = compulsory;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public OrganisationUnitGroupSet withCreated(Date created) {
        this.created = created;
        return this;
    }

    @JsonProperty("createdBy")
    public Optional<User> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    @JsonProperty("createdBy")
    public void setCreatedBy(User createdBy) {
        this.createdBy = createdBy;
    }

    public OrganisationUnitGroupSet withCreatedBy(User createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @JsonProperty("dataDimension")
    public Optional<Boolean> getDataDimension() {
        return Optional.ofNullable(dataDimension);
    }

    @JsonProperty("dataDimension")
    public void setDataDimension(Boolean dataDimension) {
        this.dataDimension = dataDimension;
    }

    public OrganisationUnitGroupSet withDataDimension(Boolean dataDimension) {
        this.dataDimension = dataDimension;
        return this;
    }

    @JsonProperty("dataDimensionType")
    public Optional<org.hisp.dhis.api.model.v2_38_1.CategoryOptionGroup.DataDimensionType> getDataDimensionType() {
        return Optional.ofNullable(dataDimensionType);
    }

    @JsonProperty("dataDimensionType")
    public void setDataDimensionType(org.hisp.dhis.api.model.v2_38_1.CategoryOptionGroup.DataDimensionType dataDimensionType) {
        this.dataDimensionType = dataDimensionType;
    }

    public OrganisationUnitGroupSet withDataDimensionType(org.hisp.dhis.api.model.v2_38_1.CategoryOptionGroup.DataDimensionType dataDimensionType) {
        this.dataDimensionType = dataDimensionType;
        return this;
    }

    @JsonProperty("description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    public OrganisationUnitGroupSet withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty("dimension")
    public Optional<String> getDimension() {
        return Optional.ofNullable(dimension);
    }

    @JsonProperty("dimension")
    public void setDimension(String dimension) {
        this.dimension = dimension;
    }

    public OrganisationUnitGroupSet withDimension(String dimension) {
        this.dimension = dimension;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("dimensionItemKeywords")
    public Optional<Object> getDimensionItemKeywords() {
        return Optional.ofNullable(dimensionItemKeywords);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("dimensionItemKeywords")
    public void setDimensionItemKeywords(Object dimensionItemKeywords) {
        this.dimensionItemKeywords = dimensionItemKeywords;
    }

    public OrganisationUnitGroupSet withDimensionItemKeywords(Object dimensionItemKeywords) {
        this.dimensionItemKeywords = dimensionItemKeywords;
        return this;
    }

    @JsonProperty("dimensionType")
    public Optional<org.hisp.dhis.api.model.v2_38_1.CategoryOptionGroupSet.DimensionType> getDimensionType() {
        return Optional.ofNullable(dimensionType);
    }

    @JsonProperty("dimensionType")
    public void setDimensionType(org.hisp.dhis.api.model.v2_38_1.CategoryOptionGroupSet.DimensionType dimensionType) {
        this.dimensionType = dimensionType;
    }

    public OrganisationUnitGroupSet withDimensionType(org.hisp.dhis.api.model.v2_38_1.CategoryOptionGroupSet.DimensionType dimensionType) {
        this.dimensionType = dimensionType;
        return this;
    }

    @JsonProperty("displayDescription")
    public Optional<String> getDisplayDescription() {
        return Optional.ofNullable(displayDescription);
    }

    @JsonProperty("displayDescription")
    public void setDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
    }

    public OrganisationUnitGroupSet withDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
        return this;
    }

    @JsonProperty("displayFormName")
    public Optional<String> getDisplayFormName() {
        return Optional.ofNullable(displayFormName);
    }

    @JsonProperty("displayFormName")
    public void setDisplayFormName(String displayFormName) {
        this.displayFormName = displayFormName;
    }

    public OrganisationUnitGroupSet withDisplayFormName(String displayFormName) {
        this.displayFormName = displayFormName;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public OrganisationUnitGroupSet withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("displayShortName")
    public Optional<String> getDisplayShortName() {
        return Optional.ofNullable(displayShortName);
    }

    @JsonProperty("displayShortName")
    public void setDisplayShortName(String displayShortName) {
        this.displayShortName = displayShortName;
    }

    public OrganisationUnitGroupSet withDisplayShortName(String displayShortName) {
        this.displayShortName = displayShortName;
        return this;
    }

    @JsonProperty("externalAccess")
    public Optional<Boolean> getExternalAccess() {
        return Optional.ofNullable(externalAccess);
    }

    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public OrganisationUnitGroupSet withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    @JsonProperty("favorite")
    public Optional<Boolean> getFavorite() {
        return Optional.ofNullable(favorite);
    }

    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public OrganisationUnitGroupSet withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public OrganisationUnitGroupSet withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @JsonProperty("filter")
    public Optional<String> getFilter() {
        return Optional.ofNullable(filter);
    }

    @JsonProperty("filter")
    public void setFilter(String filter) {
        this.filter = filter;
    }

    public OrganisationUnitGroupSet withFilter(String filter) {
        this.filter = filter;
        return this;
    }

    @JsonProperty("formName")
    public Optional<String> getFormName() {
        return Optional.ofNullable(formName);
    }

    @JsonProperty("formName")
    public void setFormName(String formName) {
        this.formName = formName;
    }

    public OrganisationUnitGroupSet withFormName(String formName) {
        this.formName = formName;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public OrganisationUnitGroupSet withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public OrganisationUnitGroupSet withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("includeSubhierarchyInAnalytics")
    public Optional<Boolean> getIncludeSubhierarchyInAnalytics() {
        return Optional.ofNullable(includeSubhierarchyInAnalytics);
    }

    @JsonProperty("includeSubhierarchyInAnalytics")
    public void setIncludeSubhierarchyInAnalytics(Boolean includeSubhierarchyInAnalytics) {
        this.includeSubhierarchyInAnalytics = includeSubhierarchyInAnalytics;
    }

    public OrganisationUnitGroupSet withIncludeSubhierarchyInAnalytics(Boolean includeSubhierarchyInAnalytics) {
        this.includeSubhierarchyInAnalytics = includeSubhierarchyInAnalytics;
        return this;
    }

    @JsonProperty("items")
    public Optional<List<Object>> getItems() {
        return Optional.ofNullable(items);
    }

    @JsonProperty("items")
    public void setItems(List<Object> items) {
        this.items = items;
    }

    public OrganisationUnitGroupSet withItems(List<Object> items) {
        this.items = items;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public OrganisationUnitGroupSet withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @JsonProperty("lastUpdatedBy")
    public Optional<User> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public OrganisationUnitGroupSet withLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    @JsonProperty("legendSet")
    public Optional<LegendSet> getLegendSet() {
        return Optional.ofNullable(legendSet);
    }

    @JsonProperty("legendSet")
    public void setLegendSet(LegendSet legendSet) {
        this.legendSet = legendSet;
    }

    public OrganisationUnitGroupSet withLegendSet(LegendSet legendSet) {
        this.legendSet = legendSet;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public OrganisationUnitGroupSet withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("optionSet")
    public Optional<OptionSet> getOptionSet() {
        return Optional.ofNullable(optionSet);
    }

    @JsonProperty("optionSet")
    public void setOptionSet(OptionSet optionSet) {
        this.optionSet = optionSet;
    }

    public OrganisationUnitGroupSet withOptionSet(OptionSet optionSet) {
        this.optionSet = optionSet;
        return this;
    }

    @JsonProperty("organisationUnitGroups")
    public Optional<List<OrganisationUnitGroup>> getOrganisationUnitGroups() {
        return Optional.ofNullable(organisationUnitGroups);
    }

    @JsonProperty("organisationUnitGroups")
    public void setOrganisationUnitGroups(List<OrganisationUnitGroup> organisationUnitGroups) {
        this.organisationUnitGroups = organisationUnitGroups;
    }

    public OrganisationUnitGroupSet withOrganisationUnitGroups(List<OrganisationUnitGroup> organisationUnitGroups) {
        this.organisationUnitGroups = organisationUnitGroups;
        return this;
    }

    @JsonProperty("programStage")
    public Optional<ProgramStage> getProgramStage() {
        return Optional.ofNullable(programStage);
    }

    @JsonProperty("programStage")
    public void setProgramStage(ProgramStage programStage) {
        this.programStage = programStage;
    }

    public OrganisationUnitGroupSet withProgramStage(ProgramStage programStage) {
        this.programStage = programStage;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public OrganisationUnitGroupSet withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    @JsonProperty("repetition")
    public Optional<EventRepetition> getRepetition() {
        return Optional.ofNullable(repetition);
    }

    @JsonProperty("repetition")
    public void setRepetition(EventRepetition repetition) {
        this.repetition = repetition;
    }

    public OrganisationUnitGroupSet withRepetition(EventRepetition repetition) {
        this.repetition = repetition;
        return this;
    }

    @JsonProperty("sharing")
    public Optional<Sharing> getSharing() {
        return Optional.ofNullable(sharing);
    }

    @JsonProperty("sharing")
    public void setSharing(Sharing sharing) {
        this.sharing = sharing;
    }

    public OrganisationUnitGroupSet withSharing(Sharing sharing) {
        this.sharing = sharing;
        return this;
    }

    @JsonProperty("shortName")
    public Optional<String> getShortName() {
        return Optional.ofNullable(shortName);
    }

    @JsonProperty("shortName")
    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public OrganisationUnitGroupSet withShortName(String shortName) {
        this.shortName = shortName;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public OrganisationUnitGroupSet withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    @JsonProperty("user")
    public Optional<User> getUser() {
        return Optional.ofNullable(user);
    }

    @JsonProperty("user")
    public void setUser(User user) {
        this.user = user;
    }

    public OrganisationUnitGroupSet withUser(User user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<UserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public OrganisationUnitGroupSet withUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<UserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public OrganisationUnitGroupSet withUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    @JsonProperty("valueType")
    public Optional<OptionSet.ValueType> getValueType() {
        return Optional.ofNullable(valueType);
    }

    @JsonProperty("valueType")
    public void setValueType(OptionSet.ValueType valueType) {
        this.valueType = valueType;
    }

    public OrganisationUnitGroupSet withValueType(OptionSet.ValueType valueType) {
        this.valueType = valueType;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public OrganisationUnitGroupSet withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "access":
                if (value instanceof Access) {
                    setAccess(((Access) value));
                } else {
                    throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v2_38_1.Access\", but got "+ value.getClass().toString()));
                }
                return true;
            case "aggregationType":
                if (value instanceof AggregationType) {
                    setAggregationType(((AggregationType) value));
                } else {
                    throw new IllegalArgumentException(("property \"aggregationType\" is of type \"org.hisp.dhis.api.model.v2_38_1.AggregationType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "allItems":
                if (value instanceof Boolean) {
                    setAllItems(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"allItems\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "attributeValues":
                if (value instanceof List) {
                    setAttributeValues(((List<AttributeValue> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.AttributeValue>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "code":
                if (value instanceof String) {
                    setCode(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "compulsory":
                if (value instanceof Boolean) {
                    setCompulsory(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"compulsory\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "created":
                if (value instanceof Date) {
                    setCreated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "createdBy":
                if (value instanceof User) {
                    setCreatedBy(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"createdBy\" is of type \"org.hisp.dhis.api.model.v2_38_1.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataDimension":
                if (value instanceof Boolean) {
                    setDataDimension(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataDimension\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataDimensionType":
                if (value instanceof org.hisp.dhis.api.model.v2_38_1.CategoryOptionGroup.DataDimensionType) {
                    setDataDimensionType(((org.hisp.dhis.api.model.v2_38_1.CategoryOptionGroup.DataDimensionType) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataDimensionType\" is of type \"org.hisp.dhis.api.model.v2_38_1.CategoryOptionGroup.DataDimensionType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "description":
                if (value instanceof String) {
                    setDescription(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"description\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dimension":
                if (value instanceof String) {
                    setDimension(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"dimension\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dimensionItemKeywords":
                if (value instanceof Object) {
                    setDimensionItemKeywords(((Object) value));
                } else {
                    throw new IllegalArgumentException(("property \"dimensionItemKeywords\" is of type \"java.lang.Object\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dimensionType":
                if (value instanceof org.hisp.dhis.api.model.v2_38_1.CategoryOptionGroupSet.DimensionType) {
                    setDimensionType(((org.hisp.dhis.api.model.v2_38_1.CategoryOptionGroupSet.DimensionType) value));
                } else {
                    throw new IllegalArgumentException(("property \"dimensionType\" is of type \"org.hisp.dhis.api.model.v2_38_1.CategoryOptionGroupSet.DimensionType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayDescription":
                if (value instanceof String) {
                    setDisplayDescription(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayDescription\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayFormName":
                if (value instanceof String) {
                    setDisplayFormName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayFormName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayName":
                if (value instanceof String) {
                    setDisplayName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayShortName":
                if (value instanceof String) {
                    setDisplayShortName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayShortName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "externalAccess":
                if (value instanceof Boolean) {
                    setExternalAccess(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "favorite":
                if (value instanceof Boolean) {
                    setFavorite(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "favorites":
                if (value instanceof List) {
                    setFavorites(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "filter":
                if (value instanceof String) {
                    setFilter(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"filter\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "formName":
                if (value instanceof String) {
                    setFormName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"formName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "href":
                if (value instanceof String) {
                    setHref(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "id":
                if (value instanceof String) {
                    setId(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "includeSubhierarchyInAnalytics":
                if (value instanceof Boolean) {
                    setIncludeSubhierarchyInAnalytics(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"includeSubhierarchyInAnalytics\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "items":
                if (value instanceof List) {
                    setItems(((List<Object> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"items\" is of type \"java.util.List<java.lang.Object>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdated":
                if (value instanceof Date) {
                    setLastUpdated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdatedBy":
                if (value instanceof User) {
                    setLastUpdatedBy(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v2_38_1.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "legendSet":
                if (value instanceof LegendSet) {
                    setLegendSet(((LegendSet) value));
                } else {
                    throw new IllegalArgumentException(("property \"legendSet\" is of type \"org.hisp.dhis.api.model.v2_38_1.LegendSet\", but got "+ value.getClass().toString()));
                }
                return true;
            case "name":
                if (value instanceof String) {
                    setName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "optionSet":
                if (value instanceof OptionSet) {
                    setOptionSet(((OptionSet) value));
                } else {
                    throw new IllegalArgumentException(("property \"optionSet\" is of type \"org.hisp.dhis.api.model.v2_38_1.OptionSet\", but got "+ value.getClass().toString()));
                }
                return true;
            case "organisationUnitGroups":
                if (value instanceof List) {
                    setOrganisationUnitGroups(((List<OrganisationUnitGroup> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"organisationUnitGroups\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.OrganisationUnitGroup>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "programStage":
                if (value instanceof ProgramStage) {
                    setProgramStage(((ProgramStage) value));
                } else {
                    throw new IllegalArgumentException(("property \"programStage\" is of type \"org.hisp.dhis.api.model.v2_38_1.ProgramStage\", but got "+ value.getClass().toString()));
                }
                return true;
            case "publicAccess":
                if (value instanceof String) {
                    setPublicAccess(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "repetition":
                if (value instanceof EventRepetition) {
                    setRepetition(((EventRepetition) value));
                } else {
                    throw new IllegalArgumentException(("property \"repetition\" is of type \"org.hisp.dhis.api.model.v2_38_1.EventRepetition\", but got "+ value.getClass().toString()));
                }
                return true;
            case "sharing":
                if (value instanceof Sharing) {
                    setSharing(((Sharing) value));
                } else {
                    throw new IllegalArgumentException(("property \"sharing\" is of type \"org.hisp.dhis.api.model.v2_38_1.Sharing\", but got "+ value.getClass().toString()));
                }
                return true;
            case "shortName":
                if (value instanceof String) {
                    setShortName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"shortName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "translations":
                if (value instanceof List) {
                    setTranslations(((List<Translation> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.Translation>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "user":
                if (value instanceof User) {
                    setUser(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v2_38_1.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userAccesses":
                if (value instanceof List) {
                    setUserAccesses(((List<UserAccess> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.UserAccess>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userGroupAccesses":
                if (value instanceof List) {
                    setUserGroupAccesses(((List<UserGroupAccess> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.UserGroupAccess>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "valueType":
                if (value instanceof OptionSet.ValueType) {
                    setValueType(((OptionSet.ValueType) value));
                } else {
                    throw new IllegalArgumentException(("property \"valueType\" is of type \"org.hisp.dhis.api.model.v2_38_1.OptionSet.ValueType\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "access":
                return getAccess();
            case "aggregationType":
                return getAggregationType();
            case "allItems":
                return getAllItems();
            case "attributeValues":
                return getAttributeValues();
            case "code":
                return getCode();
            case "compulsory":
                return getCompulsory();
            case "created":
                return getCreated();
            case "createdBy":
                return getCreatedBy();
            case "dataDimension":
                return getDataDimension();
            case "dataDimensionType":
                return getDataDimensionType();
            case "description":
                return getDescription();
            case "dimension":
                return getDimension();
            case "dimensionItemKeywords":
                return getDimensionItemKeywords();
            case "dimensionType":
                return getDimensionType();
            case "displayDescription":
                return getDisplayDescription();
            case "displayFormName":
                return getDisplayFormName();
            case "displayName":
                return getDisplayName();
            case "displayShortName":
                return getDisplayShortName();
            case "externalAccess":
                return getExternalAccess();
            case "favorite":
                return getFavorite();
            case "favorites":
                return getFavorites();
            case "filter":
                return getFilter();
            case "formName":
                return getFormName();
            case "href":
                return getHref();
            case "id":
                return getId();
            case "includeSubhierarchyInAnalytics":
                return getIncludeSubhierarchyInAnalytics();
            case "items":
                return getItems();
            case "lastUpdated":
                return getLastUpdated();
            case "lastUpdatedBy":
                return getLastUpdatedBy();
            case "legendSet":
                return getLegendSet();
            case "name":
                return getName();
            case "optionSet":
                return getOptionSet();
            case "organisationUnitGroups":
                return getOrganisationUnitGroups();
            case "programStage":
                return getProgramStage();
            case "publicAccess":
                return getPublicAccess();
            case "repetition":
                return getRepetition();
            case "sharing":
                return getSharing();
            case "shortName":
                return getShortName();
            case "translations":
                return getTranslations();
            case "user":
                return getUser();
            case "userAccesses":
                return getUserAccesses();
            case "userGroupAccesses":
                return getUserGroupAccesses();
            case "valueType":
                return getValueType();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, OrganisationUnitGroupSet.NOT_FOUND_VALUE);
        if (OrganisationUnitGroupSet.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public OrganisationUnitGroupSet with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OrganisationUnitGroupSet.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("aggregationType");
        sb.append('=');
        sb.append(((this.aggregationType == null)?"<null>":this.aggregationType));
        sb.append(',');
        sb.append("allItems");
        sb.append('=');
        sb.append(((this.allItems == null)?"<null>":this.allItems));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("compulsory");
        sb.append('=');
        sb.append(((this.compulsory == null)?"<null>":this.compulsory));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("createdBy");
        sb.append('=');
        sb.append(((this.createdBy == null)?"<null>":this.createdBy));
        sb.append(',');
        sb.append("dataDimension");
        sb.append('=');
        sb.append(((this.dataDimension == null)?"<null>":this.dataDimension));
        sb.append(',');
        sb.append("dataDimensionType");
        sb.append('=');
        sb.append(((this.dataDimensionType == null)?"<null>":this.dataDimensionType));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("dimension");
        sb.append('=');
        sb.append(((this.dimension == null)?"<null>":this.dimension));
        sb.append(',');
        sb.append("dimensionItemKeywords");
        sb.append('=');
        sb.append(((this.dimensionItemKeywords == null)?"<null>":this.dimensionItemKeywords));
        sb.append(',');
        sb.append("dimensionType");
        sb.append('=');
        sb.append(((this.dimensionType == null)?"<null>":this.dimensionType));
        sb.append(',');
        sb.append("displayDescription");
        sb.append('=');
        sb.append(((this.displayDescription == null)?"<null>":this.displayDescription));
        sb.append(',');
        sb.append("displayFormName");
        sb.append('=');
        sb.append(((this.displayFormName == null)?"<null>":this.displayFormName));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("displayShortName");
        sb.append('=');
        sb.append(((this.displayShortName == null)?"<null>":this.displayShortName));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("filter");
        sb.append('=');
        sb.append(((this.filter == null)?"<null>":this.filter));
        sb.append(',');
        sb.append("formName");
        sb.append('=');
        sb.append(((this.formName == null)?"<null>":this.formName));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("includeSubhierarchyInAnalytics");
        sb.append('=');
        sb.append(((this.includeSubhierarchyInAnalytics == null)?"<null>":this.includeSubhierarchyInAnalytics));
        sb.append(',');
        sb.append("items");
        sb.append('=');
        sb.append(((this.items == null)?"<null>":this.items));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("legendSet");
        sb.append('=');
        sb.append(((this.legendSet == null)?"<null>":this.legendSet));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("optionSet");
        sb.append('=');
        sb.append(((this.optionSet == null)?"<null>":this.optionSet));
        sb.append(',');
        sb.append("organisationUnitGroups");
        sb.append('=');
        sb.append(((this.organisationUnitGroups == null)?"<null>":this.organisationUnitGroups));
        sb.append(',');
        sb.append("programStage");
        sb.append('=');
        sb.append(((this.programStage == null)?"<null>":this.programStage));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("repetition");
        sb.append('=');
        sb.append(((this.repetition == null)?"<null>":this.repetition));
        sb.append(',');
        sb.append("sharing");
        sb.append('=');
        sb.append(((this.sharing == null)?"<null>":this.sharing));
        sb.append(',');
        sb.append("shortName");
        sb.append('=');
        sb.append(((this.shortName == null)?"<null>":this.shortName));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("valueType");
        sb.append('=');
        sb.append(((this.valueType == null)?"<null>":this.valueType));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.dataDimensionType == null)? 0 :this.dataDimensionType.hashCode()));
        result = ((result* 31)+((this.dimensionItemKeywords == null)? 0 :this.dimensionItemKeywords.hashCode()));
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.aggregationType == null)? 0 :this.aggregationType.hashCode()));
        result = ((result* 31)+((this.dimensionType == null)? 0 :this.dimensionType.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.repetition == null)? 0 :this.repetition.hashCode()));
        result = ((result* 31)+((this.displayShortName == null)? 0 :this.displayShortName.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.optionSet == null)? 0 :this.optionSet.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.formName == null)? 0 :this.formName.hashCode()));
        result = ((result* 31)+((this.valueType == null)? 0 :this.valueType.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.organisationUnitGroups == null)? 0 :this.organisationUnitGroups.hashCode()));
        result = ((result* 31)+((this.dimension == null)? 0 :this.dimension.hashCode()));
        result = ((result* 31)+((this.displayDescription == null)? 0 :this.displayDescription.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.programStage == null)? 0 :this.programStage.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.allItems == null)? 0 :this.allItems.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.sharing == null)? 0 :this.sharing.hashCode()));
        result = ((result* 31)+((this.displayFormName == null)? 0 :this.displayFormName.hashCode()));
        result = ((result* 31)+((this.filter == null)? 0 :this.filter.hashCode()));
        result = ((result* 31)+((this.compulsory == null)? 0 :this.compulsory.hashCode()));
        result = ((result* 31)+((this.createdBy == null)? 0 :this.createdBy.hashCode()));
        result = ((result* 31)+((this.includeSubhierarchyInAnalytics == null)? 0 :this.includeSubhierarchyInAnalytics.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.legendSet == null)? 0 :this.legendSet.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.dataDimension == null)? 0 :this.dataDimension.hashCode()));
        result = ((result* 31)+((this.shortName == null)? 0 :this.shortName.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.items == null)? 0 :this.items.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OrganisationUnitGroupSet) == false) {
            return false;
        }
        OrganisationUnitGroupSet rhs = ((OrganisationUnitGroupSet) other);
        return (((((((((((((((((((((((((((((((((((((((((((((this.dataDimensionType == rhs.dataDimensionType)||((this.dataDimensionType!= null)&&this.dataDimensionType.equals(rhs.dataDimensionType)))&&((this.dimensionItemKeywords == rhs.dimensionItemKeywords)||((this.dimensionItemKeywords!= null)&&this.dimensionItemKeywords.equals(rhs.dimensionItemKeywords))))&&((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites))))&&((this.aggregationType == rhs.aggregationType)||((this.aggregationType!= null)&&this.aggregationType.equals(rhs.aggregationType))))&&((this.dimensionType == rhs.dimensionType)||((this.dimensionType!= null)&&this.dimensionType.equals(rhs.dimensionType))))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.repetition == rhs.repetition)||((this.repetition!= null)&&this.repetition.equals(rhs.repetition))))&&((this.displayShortName == rhs.displayShortName)||((this.displayShortName!= null)&&this.displayShortName.equals(rhs.displayShortName))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.optionSet == rhs.optionSet)||((this.optionSet!= null)&&this.optionSet.equals(rhs.optionSet))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.formName == rhs.formName)||((this.formName!= null)&&this.formName.equals(rhs.formName))))&&((this.valueType == rhs.valueType)||((this.valueType!= null)&&this.valueType.equals(rhs.valueType))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.organisationUnitGroups == rhs.organisationUnitGroups)||((this.organisationUnitGroups!= null)&&this.organisationUnitGroups.equals(rhs.organisationUnitGroups))))&&((this.dimension == rhs.dimension)||((this.dimension!= null)&&this.dimension.equals(rhs.dimension))))&&((this.displayDescription == rhs.displayDescription)||((this.displayDescription!= null)&&this.displayDescription.equals(rhs.displayDescription))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.programStage == rhs.programStage)||((this.programStage!= null)&&this.programStage.equals(rhs.programStage))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.allItems == rhs.allItems)||((this.allItems!= null)&&this.allItems.equals(rhs.allItems))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.sharing == rhs.sharing)||((this.sharing!= null)&&this.sharing.equals(rhs.sharing))))&&((this.displayFormName == rhs.displayFormName)||((this.displayFormName!= null)&&this.displayFormName.equals(rhs.displayFormName))))&&((this.filter == rhs.filter)||((this.filter!= null)&&this.filter.equals(rhs.filter))))&&((this.compulsory == rhs.compulsory)||((this.compulsory!= null)&&this.compulsory.equals(rhs.compulsory))))&&((this.createdBy == rhs.createdBy)||((this.createdBy!= null)&&this.createdBy.equals(rhs.createdBy))))&&((this.includeSubhierarchyInAnalytics == rhs.includeSubhierarchyInAnalytics)||((this.includeSubhierarchyInAnalytics!= null)&&this.includeSubhierarchyInAnalytics.equals(rhs.includeSubhierarchyInAnalytics))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.legendSet == rhs.legendSet)||((this.legendSet!= null)&&this.legendSet.equals(rhs.legendSet))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.dataDimension == rhs.dataDimension)||((this.dataDimension!= null)&&this.dataDimension.equals(rhs.dataDimension))))&&((this.shortName == rhs.shortName)||((this.shortName!= null)&&this.shortName.equals(rhs.shortName))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.items == rhs.items)||((this.items!= null)&&this.items.equals(rhs.items))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))));
    }

}
