
package org.hisp.dhis.api.model.v2_38_1;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "attributeValues",
    "code",
    "content",
    "created",
    "createdBy",
    "data",
    "dataElement",
    "displayContent",
    "displayName",
    "externalAccess",
    "favorite",
    "favorites",
    "href",
    "id",
    "lastUpdated",
    "lastUpdatedBy",
    "location",
    "name",
    "option",
    "optionGroup",
    "programIndicator",
    "programRule",
    "programRuleActionEvaluationEnvironments",
    "programRuleActionEvaluationTime",
    "programRuleActionType",
    "programStage",
    "programStageSection",
    "publicAccess",
    "sharing",
    "templateUid",
    "trackedEntityAttribute",
    "translations",
    "user",
    "userAccesses",
    "userGroupAccesses"
})
@Generated("jsonschema2pojo")
public class ProgramRuleAction implements Serializable
{

    @JsonProperty("access")
    private Access access;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues = null;
    @JsonProperty("code")
    private String code;
    @JsonProperty("content")
    private String content;
    @JsonProperty("created")
    private Date created;
    @JsonProperty("createdBy")
    private User createdBy;
    @JsonProperty("data")
    private String data;
    @JsonProperty("dataElement")
    private DataElement dataElement;
    @JsonProperty("displayContent")
    private String displayContent;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites = null;
    @JsonProperty("href")
    private String href;
    @JsonProperty("id")
    private String id;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    @JsonProperty("lastUpdatedBy")
    private User lastUpdatedBy;
    @JsonProperty("location")
    private String location;
    @JsonProperty("name")
    private String name;
    @JsonProperty("option")
    private Option option;
    @JsonProperty("optionGroup")
    private OptionGroup optionGroup;
    @JsonProperty("programIndicator")
    private ProgramIndicator programIndicator;
    @JsonProperty("programRule")
    private ProgramRule programRule;
    @JsonProperty("programRuleActionEvaluationEnvironments")
    private List<ProgramRuleActionEvaluationEnvironment> programRuleActionEvaluationEnvironments = null;
    @JsonProperty("programRuleActionEvaluationTime")
    private ProgramRuleAction.ProgramRuleActionEvaluationTime programRuleActionEvaluationTime;
    @JsonProperty("programRuleActionType")
    private ProgramRuleAction.ProgramRuleActionType programRuleActionType;
    @JsonProperty("programStage")
    private ProgramStage programStage;
    @JsonProperty("programStageSection")
    private ProgramStageSection programStageSection;
    @JsonProperty("publicAccess")
    private String publicAccess;
    @JsonProperty("sharing")
    private Sharing sharing;
    @JsonProperty("templateUid")
    private String templateUid;
    @JsonProperty("trackedEntityAttribute")
    private TrackedEntityAttribute trackedEntityAttribute;
    @JsonProperty("translations")
    private List<Translation> translations = null;
    @JsonProperty("user")
    private User user;
    @JsonProperty("userAccesses")
    private List<UserAccess> userAccesses = null;
    @JsonProperty("userGroupAccesses")
    private List<UserGroupAccess> userGroupAccesses = null;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -1843693028300968766L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ProgramRuleAction() {
    }

    /**
     * 
     * @param source
     */
    public ProgramRuleAction(ProgramRuleAction source) {
        super();
        this.access = source.access;
        this.attributeValues = source.attributeValues;
        this.code = source.code;
        this.content = source.content;
        this.created = source.created;
        this.createdBy = source.createdBy;
        this.data = source.data;
        this.dataElement = source.dataElement;
        this.displayContent = source.displayContent;
        this.displayName = source.displayName;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.href = source.href;
        this.id = source.id;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.location = source.location;
        this.name = source.name;
        this.option = source.option;
        this.optionGroup = source.optionGroup;
        this.programIndicator = source.programIndicator;
        this.programRule = source.programRule;
        this.programRuleActionEvaluationEnvironments = source.programRuleActionEvaluationEnvironments;
        this.programRuleActionEvaluationTime = source.programRuleActionEvaluationTime;
        this.programRuleActionType = source.programRuleActionType;
        this.programStage = source.programStage;
        this.programStageSection = source.programStageSection;
        this.publicAccess = source.publicAccess;
        this.sharing = source.sharing;
        this.templateUid = source.templateUid;
        this.trackedEntityAttribute = source.trackedEntityAttribute;
        this.translations = source.translations;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userGroupAccesses = source.userGroupAccesses;
    }

    /**
     * 
     * @param favorites
     * @param access
     * @param code
     * @param data
     * @param optionGroup
     * @param displayName
     * @param publicAccess
     * @param templateUid
     * @param content
     * @param trackedEntityAttribute
     * @param externalAccess
     * @param lastUpdated
     * @param displayContent
     * @param programRuleActionEvaluationEnvironments
     * @param translations
     * @param programIndicator
     * @param href
     * @param id
     * @param programRule
     * @param programStageSection
     * @param lastUpdatedBy
     * @param programRuleActionType
     * @param programStage
     * @param userGroupAccesses
     * @param created
     * @param attributeValues
     * @param dataElement
     * @param sharing
     * @param createdBy
     * @param userAccesses
     * @param name
     * @param location
     * @param favorite
     * @param user
     * @param option
     * @param programRuleActionEvaluationTime
     */
    public ProgramRuleAction(Access access, List<AttributeValue> attributeValues, String code, String content, Date created, User createdBy, String data, DataElement dataElement, String displayContent, String displayName, Boolean externalAccess, Boolean favorite, List<String> favorites, String href, String id, Date lastUpdated, User lastUpdatedBy, String location, String name, Option option, OptionGroup optionGroup, ProgramIndicator programIndicator, ProgramRule programRule, List<ProgramRuleActionEvaluationEnvironment> programRuleActionEvaluationEnvironments, ProgramRuleAction.ProgramRuleActionEvaluationTime programRuleActionEvaluationTime, ProgramRuleAction.ProgramRuleActionType programRuleActionType, ProgramStage programStage, ProgramStageSection programStageSection, String publicAccess, Sharing sharing, String templateUid, TrackedEntityAttribute trackedEntityAttribute, List<Translation> translations, User user, List<UserAccess> userAccesses, List<UserGroupAccess> userGroupAccesses) {
        super();
        this.access = access;
        this.attributeValues = attributeValues;
        this.code = code;
        this.content = content;
        this.created = created;
        this.createdBy = createdBy;
        this.data = data;
        this.dataElement = dataElement;
        this.displayContent = displayContent;
        this.displayName = displayName;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.href = href;
        this.id = id;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.location = location;
        this.name = name;
        this.option = option;
        this.optionGroup = optionGroup;
        this.programIndicator = programIndicator;
        this.programRule = programRule;
        this.programRuleActionEvaluationEnvironments = programRuleActionEvaluationEnvironments;
        this.programRuleActionEvaluationTime = programRuleActionEvaluationTime;
        this.programRuleActionType = programRuleActionType;
        this.programStage = programStage;
        this.programStageSection = programStageSection;
        this.publicAccess = publicAccess;
        this.sharing = sharing;
        this.templateUid = templateUid;
        this.trackedEntityAttribute = trackedEntityAttribute;
        this.translations = translations;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userGroupAccesses = userGroupAccesses;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public ProgramRuleAction withAccess(Access access) {
        this.access = access;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public ProgramRuleAction withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public ProgramRuleAction withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("content")
    public Optional<String> getContent() {
        return Optional.ofNullable(content);
    }

    @JsonProperty("content")
    public void setContent(String content) {
        this.content = content;
    }

    public ProgramRuleAction withContent(String content) {
        this.content = content;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public ProgramRuleAction withCreated(Date created) {
        this.created = created;
        return this;
    }

    @JsonProperty("createdBy")
    public Optional<User> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    @JsonProperty("createdBy")
    public void setCreatedBy(User createdBy) {
        this.createdBy = createdBy;
    }

    public ProgramRuleAction withCreatedBy(User createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @JsonProperty("data")
    public Optional<String> getData() {
        return Optional.ofNullable(data);
    }

    @JsonProperty("data")
    public void setData(String data) {
        this.data = data;
    }

    public ProgramRuleAction withData(String data) {
        this.data = data;
        return this;
    }

    @JsonProperty("dataElement")
    public Optional<DataElement> getDataElement() {
        return Optional.ofNullable(dataElement);
    }

    @JsonProperty("dataElement")
    public void setDataElement(DataElement dataElement) {
        this.dataElement = dataElement;
    }

    public ProgramRuleAction withDataElement(DataElement dataElement) {
        this.dataElement = dataElement;
        return this;
    }

    @JsonProperty("displayContent")
    public Optional<String> getDisplayContent() {
        return Optional.ofNullable(displayContent);
    }

    @JsonProperty("displayContent")
    public void setDisplayContent(String displayContent) {
        this.displayContent = displayContent;
    }

    public ProgramRuleAction withDisplayContent(String displayContent) {
        this.displayContent = displayContent;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ProgramRuleAction withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("externalAccess")
    public Optional<Boolean> getExternalAccess() {
        return Optional.ofNullable(externalAccess);
    }

    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public ProgramRuleAction withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    @JsonProperty("favorite")
    public Optional<Boolean> getFavorite() {
        return Optional.ofNullable(favorite);
    }

    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public ProgramRuleAction withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public ProgramRuleAction withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public ProgramRuleAction withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public ProgramRuleAction withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public ProgramRuleAction withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @JsonProperty("lastUpdatedBy")
    public Optional<User> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public ProgramRuleAction withLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    @JsonProperty("location")
    public Optional<String> getLocation() {
        return Optional.ofNullable(location);
    }

    @JsonProperty("location")
    public void setLocation(String location) {
        this.location = location;
    }

    public ProgramRuleAction withLocation(String location) {
        this.location = location;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public ProgramRuleAction withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("option")
    public Optional<Option> getOption() {
        return Optional.ofNullable(option);
    }

    @JsonProperty("option")
    public void setOption(Option option) {
        this.option = option;
    }

    public ProgramRuleAction withOption(Option option) {
        this.option = option;
        return this;
    }

    @JsonProperty("optionGroup")
    public Optional<OptionGroup> getOptionGroup() {
        return Optional.ofNullable(optionGroup);
    }

    @JsonProperty("optionGroup")
    public void setOptionGroup(OptionGroup optionGroup) {
        this.optionGroup = optionGroup;
    }

    public ProgramRuleAction withOptionGroup(OptionGroup optionGroup) {
        this.optionGroup = optionGroup;
        return this;
    }

    @JsonProperty("programIndicator")
    public Optional<ProgramIndicator> getProgramIndicator() {
        return Optional.ofNullable(programIndicator);
    }

    @JsonProperty("programIndicator")
    public void setProgramIndicator(ProgramIndicator programIndicator) {
        this.programIndicator = programIndicator;
    }

    public ProgramRuleAction withProgramIndicator(ProgramIndicator programIndicator) {
        this.programIndicator = programIndicator;
        return this;
    }

    @JsonProperty("programRule")
    public Optional<ProgramRule> getProgramRule() {
        return Optional.ofNullable(programRule);
    }

    @JsonProperty("programRule")
    public void setProgramRule(ProgramRule programRule) {
        this.programRule = programRule;
    }

    public ProgramRuleAction withProgramRule(ProgramRule programRule) {
        this.programRule = programRule;
        return this;
    }

    @JsonProperty("programRuleActionEvaluationEnvironments")
    public Optional<List<ProgramRuleActionEvaluationEnvironment>> getProgramRuleActionEvaluationEnvironments() {
        return Optional.ofNullable(programRuleActionEvaluationEnvironments);
    }

    @JsonProperty("programRuleActionEvaluationEnvironments")
    public void setProgramRuleActionEvaluationEnvironments(List<ProgramRuleActionEvaluationEnvironment> programRuleActionEvaluationEnvironments) {
        this.programRuleActionEvaluationEnvironments = programRuleActionEvaluationEnvironments;
    }

    public ProgramRuleAction withProgramRuleActionEvaluationEnvironments(List<ProgramRuleActionEvaluationEnvironment> programRuleActionEvaluationEnvironments) {
        this.programRuleActionEvaluationEnvironments = programRuleActionEvaluationEnvironments;
        return this;
    }

    @JsonProperty("programRuleActionEvaluationTime")
    public Optional<ProgramRuleAction.ProgramRuleActionEvaluationTime> getProgramRuleActionEvaluationTime() {
        return Optional.ofNullable(programRuleActionEvaluationTime);
    }

    @JsonProperty("programRuleActionEvaluationTime")
    public void setProgramRuleActionEvaluationTime(ProgramRuleAction.ProgramRuleActionEvaluationTime programRuleActionEvaluationTime) {
        this.programRuleActionEvaluationTime = programRuleActionEvaluationTime;
    }

    public ProgramRuleAction withProgramRuleActionEvaluationTime(ProgramRuleAction.ProgramRuleActionEvaluationTime programRuleActionEvaluationTime) {
        this.programRuleActionEvaluationTime = programRuleActionEvaluationTime;
        return this;
    }

    @JsonProperty("programRuleActionType")
    public Optional<ProgramRuleAction.ProgramRuleActionType> getProgramRuleActionType() {
        return Optional.ofNullable(programRuleActionType);
    }

    @JsonProperty("programRuleActionType")
    public void setProgramRuleActionType(ProgramRuleAction.ProgramRuleActionType programRuleActionType) {
        this.programRuleActionType = programRuleActionType;
    }

    public ProgramRuleAction withProgramRuleActionType(ProgramRuleAction.ProgramRuleActionType programRuleActionType) {
        this.programRuleActionType = programRuleActionType;
        return this;
    }

    @JsonProperty("programStage")
    public Optional<ProgramStage> getProgramStage() {
        return Optional.ofNullable(programStage);
    }

    @JsonProperty("programStage")
    public void setProgramStage(ProgramStage programStage) {
        this.programStage = programStage;
    }

    public ProgramRuleAction withProgramStage(ProgramStage programStage) {
        this.programStage = programStage;
        return this;
    }

    @JsonProperty("programStageSection")
    public Optional<ProgramStageSection> getProgramStageSection() {
        return Optional.ofNullable(programStageSection);
    }

    @JsonProperty("programStageSection")
    public void setProgramStageSection(ProgramStageSection programStageSection) {
        this.programStageSection = programStageSection;
    }

    public ProgramRuleAction withProgramStageSection(ProgramStageSection programStageSection) {
        this.programStageSection = programStageSection;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public ProgramRuleAction withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    @JsonProperty("sharing")
    public Optional<Sharing> getSharing() {
        return Optional.ofNullable(sharing);
    }

    @JsonProperty("sharing")
    public void setSharing(Sharing sharing) {
        this.sharing = sharing;
    }

    public ProgramRuleAction withSharing(Sharing sharing) {
        this.sharing = sharing;
        return this;
    }

    @JsonProperty("templateUid")
    public Optional<String> getTemplateUid() {
        return Optional.ofNullable(templateUid);
    }

    @JsonProperty("templateUid")
    public void setTemplateUid(String templateUid) {
        this.templateUid = templateUid;
    }

    public ProgramRuleAction withTemplateUid(String templateUid) {
        this.templateUid = templateUid;
        return this;
    }

    @JsonProperty("trackedEntityAttribute")
    public Optional<TrackedEntityAttribute> getTrackedEntityAttribute() {
        return Optional.ofNullable(trackedEntityAttribute);
    }

    @JsonProperty("trackedEntityAttribute")
    public void setTrackedEntityAttribute(TrackedEntityAttribute trackedEntityAttribute) {
        this.trackedEntityAttribute = trackedEntityAttribute;
    }

    public ProgramRuleAction withTrackedEntityAttribute(TrackedEntityAttribute trackedEntityAttribute) {
        this.trackedEntityAttribute = trackedEntityAttribute;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public ProgramRuleAction withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    @JsonProperty("user")
    public Optional<User> getUser() {
        return Optional.ofNullable(user);
    }

    @JsonProperty("user")
    public void setUser(User user) {
        this.user = user;
    }

    public ProgramRuleAction withUser(User user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<UserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public ProgramRuleAction withUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<UserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public ProgramRuleAction withUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ProgramRuleAction withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "access":
                if (value instanceof Access) {
                    setAccess(((Access) value));
                } else {
                    throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v2_38_1.Access\", but got "+ value.getClass().toString()));
                }
                return true;
            case "attributeValues":
                if (value instanceof List) {
                    setAttributeValues(((List<AttributeValue> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.AttributeValue>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "code":
                if (value instanceof String) {
                    setCode(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "content":
                if (value instanceof String) {
                    setContent(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"content\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "created":
                if (value instanceof Date) {
                    setCreated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "createdBy":
                if (value instanceof User) {
                    setCreatedBy(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"createdBy\" is of type \"org.hisp.dhis.api.model.v2_38_1.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "data":
                if (value instanceof String) {
                    setData(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"data\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataElement":
                if (value instanceof DataElement) {
                    setDataElement(((DataElement) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataElement\" is of type \"org.hisp.dhis.api.model.v2_38_1.DataElement\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayContent":
                if (value instanceof String) {
                    setDisplayContent(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayContent\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayName":
                if (value instanceof String) {
                    setDisplayName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "externalAccess":
                if (value instanceof Boolean) {
                    setExternalAccess(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "favorite":
                if (value instanceof Boolean) {
                    setFavorite(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "favorites":
                if (value instanceof List) {
                    setFavorites(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "href":
                if (value instanceof String) {
                    setHref(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "id":
                if (value instanceof String) {
                    setId(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdated":
                if (value instanceof Date) {
                    setLastUpdated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdatedBy":
                if (value instanceof User) {
                    setLastUpdatedBy(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v2_38_1.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "location":
                if (value instanceof String) {
                    setLocation(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"location\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "name":
                if (value instanceof String) {
                    setName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "option":
                if (value instanceof Option) {
                    setOption(((Option) value));
                } else {
                    throw new IllegalArgumentException(("property \"option\" is of type \"org.hisp.dhis.api.model.v2_38_1.Option\", but got "+ value.getClass().toString()));
                }
                return true;
            case "optionGroup":
                if (value instanceof OptionGroup) {
                    setOptionGroup(((OptionGroup) value));
                } else {
                    throw new IllegalArgumentException(("property \"optionGroup\" is of type \"org.hisp.dhis.api.model.v2_38_1.OptionGroup\", but got "+ value.getClass().toString()));
                }
                return true;
            case "programIndicator":
                if (value instanceof ProgramIndicator) {
                    setProgramIndicator(((ProgramIndicator) value));
                } else {
                    throw new IllegalArgumentException(("property \"programIndicator\" is of type \"org.hisp.dhis.api.model.v2_38_1.ProgramIndicator\", but got "+ value.getClass().toString()));
                }
                return true;
            case "programRule":
                if (value instanceof ProgramRule) {
                    setProgramRule(((ProgramRule) value));
                } else {
                    throw new IllegalArgumentException(("property \"programRule\" is of type \"org.hisp.dhis.api.model.v2_38_1.ProgramRule\", but got "+ value.getClass().toString()));
                }
                return true;
            case "programRuleActionEvaluationEnvironments":
                if (value instanceof List) {
                    setProgramRuleActionEvaluationEnvironments(((List<ProgramRuleActionEvaluationEnvironment> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"programRuleActionEvaluationEnvironments\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.ProgramRuleActionEvaluationEnvironment>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "programRuleActionEvaluationTime":
                if (value instanceof ProgramRuleAction.ProgramRuleActionEvaluationTime) {
                    setProgramRuleActionEvaluationTime(((ProgramRuleAction.ProgramRuleActionEvaluationTime) value));
                } else {
                    throw new IllegalArgumentException(("property \"programRuleActionEvaluationTime\" is of type \"org.hisp.dhis.api.model.v2_38_1.ProgramRuleAction.ProgramRuleActionEvaluationTime\", but got "+ value.getClass().toString()));
                }
                return true;
            case "programRuleActionType":
                if (value instanceof ProgramRuleAction.ProgramRuleActionType) {
                    setProgramRuleActionType(((ProgramRuleAction.ProgramRuleActionType) value));
                } else {
                    throw new IllegalArgumentException(("property \"programRuleActionType\" is of type \"org.hisp.dhis.api.model.v2_38_1.ProgramRuleAction.ProgramRuleActionType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "programStage":
                if (value instanceof ProgramStage) {
                    setProgramStage(((ProgramStage) value));
                } else {
                    throw new IllegalArgumentException(("property \"programStage\" is of type \"org.hisp.dhis.api.model.v2_38_1.ProgramStage\", but got "+ value.getClass().toString()));
                }
                return true;
            case "programStageSection":
                if (value instanceof ProgramStageSection) {
                    setProgramStageSection(((ProgramStageSection) value));
                } else {
                    throw new IllegalArgumentException(("property \"programStageSection\" is of type \"org.hisp.dhis.api.model.v2_38_1.ProgramStageSection\", but got "+ value.getClass().toString()));
                }
                return true;
            case "publicAccess":
                if (value instanceof String) {
                    setPublicAccess(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "sharing":
                if (value instanceof Sharing) {
                    setSharing(((Sharing) value));
                } else {
                    throw new IllegalArgumentException(("property \"sharing\" is of type \"org.hisp.dhis.api.model.v2_38_1.Sharing\", but got "+ value.getClass().toString()));
                }
                return true;
            case "templateUid":
                if (value instanceof String) {
                    setTemplateUid(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"templateUid\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "trackedEntityAttribute":
                if (value instanceof TrackedEntityAttribute) {
                    setTrackedEntityAttribute(((TrackedEntityAttribute) value));
                } else {
                    throw new IllegalArgumentException(("property \"trackedEntityAttribute\" is of type \"org.hisp.dhis.api.model.v2_38_1.TrackedEntityAttribute\", but got "+ value.getClass().toString()));
                }
                return true;
            case "translations":
                if (value instanceof List) {
                    setTranslations(((List<Translation> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.Translation>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "user":
                if (value instanceof User) {
                    setUser(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v2_38_1.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userAccesses":
                if (value instanceof List) {
                    setUserAccesses(((List<UserAccess> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.UserAccess>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userGroupAccesses":
                if (value instanceof List) {
                    setUserGroupAccesses(((List<UserGroupAccess> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.UserGroupAccess>\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "access":
                return getAccess();
            case "attributeValues":
                return getAttributeValues();
            case "code":
                return getCode();
            case "content":
                return getContent();
            case "created":
                return getCreated();
            case "createdBy":
                return getCreatedBy();
            case "data":
                return getData();
            case "dataElement":
                return getDataElement();
            case "displayContent":
                return getDisplayContent();
            case "displayName":
                return getDisplayName();
            case "externalAccess":
                return getExternalAccess();
            case "favorite":
                return getFavorite();
            case "favorites":
                return getFavorites();
            case "href":
                return getHref();
            case "id":
                return getId();
            case "lastUpdated":
                return getLastUpdated();
            case "lastUpdatedBy":
                return getLastUpdatedBy();
            case "location":
                return getLocation();
            case "name":
                return getName();
            case "option":
                return getOption();
            case "optionGroup":
                return getOptionGroup();
            case "programIndicator":
                return getProgramIndicator();
            case "programRule":
                return getProgramRule();
            case "programRuleActionEvaluationEnvironments":
                return getProgramRuleActionEvaluationEnvironments();
            case "programRuleActionEvaluationTime":
                return getProgramRuleActionEvaluationTime();
            case "programRuleActionType":
                return getProgramRuleActionType();
            case "programStage":
                return getProgramStage();
            case "programStageSection":
                return getProgramStageSection();
            case "publicAccess":
                return getPublicAccess();
            case "sharing":
                return getSharing();
            case "templateUid":
                return getTemplateUid();
            case "trackedEntityAttribute":
                return getTrackedEntityAttribute();
            case "translations":
                return getTranslations();
            case "user":
                return getUser();
            case "userAccesses":
                return getUserAccesses();
            case "userGroupAccesses":
                return getUserGroupAccesses();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ProgramRuleAction.NOT_FOUND_VALUE);
        if (ProgramRuleAction.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ProgramRuleAction with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ProgramRuleAction.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("content");
        sb.append('=');
        sb.append(((this.content == null)?"<null>":this.content));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("createdBy");
        sb.append('=');
        sb.append(((this.createdBy == null)?"<null>":this.createdBy));
        sb.append(',');
        sb.append("data");
        sb.append('=');
        sb.append(((this.data == null)?"<null>":this.data));
        sb.append(',');
        sb.append("dataElement");
        sb.append('=');
        sb.append(((this.dataElement == null)?"<null>":this.dataElement));
        sb.append(',');
        sb.append("displayContent");
        sb.append('=');
        sb.append(((this.displayContent == null)?"<null>":this.displayContent));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("location");
        sb.append('=');
        sb.append(((this.location == null)?"<null>":this.location));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("option");
        sb.append('=');
        sb.append(((this.option == null)?"<null>":this.option));
        sb.append(',');
        sb.append("optionGroup");
        sb.append('=');
        sb.append(((this.optionGroup == null)?"<null>":this.optionGroup));
        sb.append(',');
        sb.append("programIndicator");
        sb.append('=');
        sb.append(((this.programIndicator == null)?"<null>":this.programIndicator));
        sb.append(',');
        sb.append("programRule");
        sb.append('=');
        sb.append(((this.programRule == null)?"<null>":this.programRule));
        sb.append(',');
        sb.append("programRuleActionEvaluationEnvironments");
        sb.append('=');
        sb.append(((this.programRuleActionEvaluationEnvironments == null)?"<null>":this.programRuleActionEvaluationEnvironments));
        sb.append(',');
        sb.append("programRuleActionEvaluationTime");
        sb.append('=');
        sb.append(((this.programRuleActionEvaluationTime == null)?"<null>":this.programRuleActionEvaluationTime));
        sb.append(',');
        sb.append("programRuleActionType");
        sb.append('=');
        sb.append(((this.programRuleActionType == null)?"<null>":this.programRuleActionType));
        sb.append(',');
        sb.append("programStage");
        sb.append('=');
        sb.append(((this.programStage == null)?"<null>":this.programStage));
        sb.append(',');
        sb.append("programStageSection");
        sb.append('=');
        sb.append(((this.programStageSection == null)?"<null>":this.programStageSection));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("sharing");
        sb.append('=');
        sb.append(((this.sharing == null)?"<null>":this.sharing));
        sb.append(',');
        sb.append("templateUid");
        sb.append('=');
        sb.append(((this.templateUid == null)?"<null>":this.templateUid));
        sb.append(',');
        sb.append("trackedEntityAttribute");
        sb.append('=');
        sb.append(((this.trackedEntityAttribute == null)?"<null>":this.trackedEntityAttribute));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.data == null)? 0 :this.data.hashCode()));
        result = ((result* 31)+((this.optionGroup == null)? 0 :this.optionGroup.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.templateUid == null)? 0 :this.templateUid.hashCode()));
        result = ((result* 31)+((this.content == null)? 0 :this.content.hashCode()));
        result = ((result* 31)+((this.trackedEntityAttribute == null)? 0 :this.trackedEntityAttribute.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.displayContent == null)? 0 :this.displayContent.hashCode()));
        result = ((result* 31)+((this.programRuleActionEvaluationEnvironments == null)? 0 :this.programRuleActionEvaluationEnvironments.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.programIndicator == null)? 0 :this.programIndicator.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.programRule == null)? 0 :this.programRule.hashCode()));
        result = ((result* 31)+((this.programStageSection == null)? 0 :this.programStageSection.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.programRuleActionType == null)? 0 :this.programRuleActionType.hashCode()));
        result = ((result* 31)+((this.programStage == null)? 0 :this.programStage.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.dataElement == null)? 0 :this.dataElement.hashCode()));
        result = ((result* 31)+((this.sharing == null)? 0 :this.sharing.hashCode()));
        result = ((result* 31)+((this.createdBy == null)? 0 :this.createdBy.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.location == null)? 0 :this.location.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        result = ((result* 31)+((this.option == null)? 0 :this.option.hashCode()));
        result = ((result* 31)+((this.programRuleActionEvaluationTime == null)? 0 :this.programRuleActionEvaluationTime.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ProgramRuleAction) == false) {
            return false;
        }
        ProgramRuleAction rhs = ((ProgramRuleAction) other);
        return ((((((((((((((((((((((((((((((((((((((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites)))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.data == rhs.data)||((this.data!= null)&&this.data.equals(rhs.data))))&&((this.optionGroup == rhs.optionGroup)||((this.optionGroup!= null)&&this.optionGroup.equals(rhs.optionGroup))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.templateUid == rhs.templateUid)||((this.templateUid!= null)&&this.templateUid.equals(rhs.templateUid))))&&((this.content == rhs.content)||((this.content!= null)&&this.content.equals(rhs.content))))&&((this.trackedEntityAttribute == rhs.trackedEntityAttribute)||((this.trackedEntityAttribute!= null)&&this.trackedEntityAttribute.equals(rhs.trackedEntityAttribute))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.displayContent == rhs.displayContent)||((this.displayContent!= null)&&this.displayContent.equals(rhs.displayContent))))&&((this.programRuleActionEvaluationEnvironments == rhs.programRuleActionEvaluationEnvironments)||((this.programRuleActionEvaluationEnvironments!= null)&&this.programRuleActionEvaluationEnvironments.equals(rhs.programRuleActionEvaluationEnvironments))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.programIndicator == rhs.programIndicator)||((this.programIndicator!= null)&&this.programIndicator.equals(rhs.programIndicator))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.programRule == rhs.programRule)||((this.programRule!= null)&&this.programRule.equals(rhs.programRule))))&&((this.programStageSection == rhs.programStageSection)||((this.programStageSection!= null)&&this.programStageSection.equals(rhs.programStageSection))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.programRuleActionType == rhs.programRuleActionType)||((this.programRuleActionType!= null)&&this.programRuleActionType.equals(rhs.programRuleActionType))))&&((this.programStage == rhs.programStage)||((this.programStage!= null)&&this.programStage.equals(rhs.programStage))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.dataElement == rhs.dataElement)||((this.dataElement!= null)&&this.dataElement.equals(rhs.dataElement))))&&((this.sharing == rhs.sharing)||((this.sharing!= null)&&this.sharing.equals(rhs.sharing))))&&((this.createdBy == rhs.createdBy)||((this.createdBy!= null)&&this.createdBy.equals(rhs.createdBy))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.location == rhs.location)||((this.location!= null)&&this.location.equals(rhs.location))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))))&&((this.option == rhs.option)||((this.option!= null)&&this.option.equals(rhs.option))))&&((this.programRuleActionEvaluationTime == rhs.programRuleActionEvaluationTime)||((this.programRuleActionEvaluationTime!= null)&&this.programRuleActionEvaluationTime.equals(rhs.programRuleActionEvaluationTime))));
    }

    @Generated("jsonschema2pojo")
    public enum ProgramRuleActionEvaluationTime {

        ON_DATA_ENTRY("ON_DATA_ENTRY"),
        ON_COMPLETE("ON_COMPLETE"),
        ALWAYS("ALWAYS");
        private final String value;
        private final static Map<String, ProgramRuleAction.ProgramRuleActionEvaluationTime> CONSTANTS = new HashMap<String, ProgramRuleAction.ProgramRuleActionEvaluationTime>();

        static {
            for (ProgramRuleAction.ProgramRuleActionEvaluationTime c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ProgramRuleActionEvaluationTime(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ProgramRuleAction.ProgramRuleActionEvaluationTime fromValue(String value) {
            ProgramRuleAction.ProgramRuleActionEvaluationTime constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum ProgramRuleActionType {

        DISPLAYTEXT("DISPLAYTEXT"),
        DISPLAYKEYVALUEPAIR("DISPLAYKEYVALUEPAIR"),
        HIDEFIELD("HIDEFIELD"),
        HIDESECTION("HIDESECTION"),
        HIDEPROGRAMSTAGE("HIDEPROGRAMSTAGE"),
        ASSIGN("ASSIGN"),
        SHOWWARNING("SHOWWARNING"),
        WARNINGONCOMPLETE("WARNINGONCOMPLETE"),
        SHOWERROR("SHOWERROR"),
        ERRORONCOMPLETE("ERRORONCOMPLETE"),
        CREATEEVENT("CREATEEVENT"),
        SETMANDATORYFIELD("SETMANDATORYFIELD"),
        SENDMESSAGE("SENDMESSAGE"),
        SCHEDULEMESSAGE("SCHEDULEMESSAGE"),
        HIDEOPTION("HIDEOPTION"),
        SHOWOPTIONGROUP("SHOWOPTIONGROUP"),
        HIDEOPTIONGROUP("HIDEOPTIONGROUP");
        private final String value;
        private final static Map<String, ProgramRuleAction.ProgramRuleActionType> CONSTANTS = new HashMap<String, ProgramRuleAction.ProgramRuleActionType>();

        static {
            for (ProgramRuleAction.ProgramRuleActionType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ProgramRuleActionType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ProgramRuleAction.ProgramRuleActionType fromValue(String value) {
            ProgramRuleAction.ProgramRuleActionType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
