
package org.hisp.dhis.api.model.v2_38_1;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "attributeValues",
    "code",
    "codeValueSeparator",
    "completenessMethod",
    "created",
    "createdBy",
    "currentPeriodUsedForReporting",
    "dataset",
    "defaultMessage",
    "displayName",
    "externalAccess",
    "favorite",
    "favorites",
    "href",
    "id",
    "lastUpdated",
    "lastUpdatedBy",
    "moreThanOneOrgUnitMessage",
    "name",
    "noUserMessage",
    "parserType",
    "program",
    "programStage",
    "publicAccess",
    "receivedMessage",
    "separator",
    "sharing",
    "smsCodes",
    "specialCharacters",
    "successMessage",
    "translations",
    "user",
    "userAccesses",
    "userGroup",
    "userGroupAccesses",
    "wrongFormatMessage"
})
@Generated("jsonschema2pojo")
public class SMSCommand implements Serializable
{

    @JsonProperty("access")
    private Access access;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues = null;
    @JsonProperty("code")
    private String code;
    @JsonProperty("codeValueSeparator")
    private String codeValueSeparator;
    @JsonProperty("completenessMethod")
    private CompletenessMethod completenessMethod;
    @JsonProperty("created")
    private Date created;
    @JsonProperty("createdBy")
    private User createdBy;
    @JsonProperty("currentPeriodUsedForReporting")
    private Boolean currentPeriodUsedForReporting;
    @JsonProperty("dataset")
    private DataSet dataset;
    @JsonProperty("defaultMessage")
    private String defaultMessage;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites = null;
    @JsonProperty("href")
    private String href;
    @JsonProperty("id")
    private String id;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    @JsonProperty("lastUpdatedBy")
    private User lastUpdatedBy;
    @JsonProperty("moreThanOneOrgUnitMessage")
    private String moreThanOneOrgUnitMessage;
    @JsonProperty("name")
    private String name;
    @JsonProperty("noUserMessage")
    private String noUserMessage;
    @JsonProperty("parserType")
    private ParserType parserType;
    @JsonProperty("program")
    private Program program;
    @JsonProperty("programStage")
    private ProgramStage programStage;
    @JsonProperty("publicAccess")
    private String publicAccess;
    @JsonProperty("receivedMessage")
    private String receivedMessage;
    @JsonProperty("separator")
    private String separator;
    @JsonProperty("sharing")
    private Sharing sharing;
    @JsonProperty("smsCodes")
    private List<SMSCode> smsCodes = null;
    @JsonProperty("specialCharacters")
    private List<SMSSpecialCharacter> specialCharacters = null;
    @JsonProperty("successMessage")
    private String successMessage;
    @JsonProperty("translations")
    private List<Translation> translations = null;
    @JsonProperty("user")
    private User user;
    @JsonProperty("userAccesses")
    private List<UserAccess> userAccesses = null;
    @JsonProperty("userGroup")
    private UserGroup userGroup;
    @JsonProperty("userGroupAccesses")
    private List<UserGroupAccess> userGroupAccesses = null;
    @JsonProperty("wrongFormatMessage")
    private String wrongFormatMessage;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 7338832035875762565L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public SMSCommand() {
    }

    /**
     * 
     * @param source
     */
    public SMSCommand(SMSCommand source) {
        super();
        this.access = source.access;
        this.attributeValues = source.attributeValues;
        this.code = source.code;
        this.codeValueSeparator = source.codeValueSeparator;
        this.completenessMethod = source.completenessMethod;
        this.created = source.created;
        this.createdBy = source.createdBy;
        this.currentPeriodUsedForReporting = source.currentPeriodUsedForReporting;
        this.dataset = source.dataset;
        this.defaultMessage = source.defaultMessage;
        this.displayName = source.displayName;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.href = source.href;
        this.id = source.id;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.moreThanOneOrgUnitMessage = source.moreThanOneOrgUnitMessage;
        this.name = source.name;
        this.noUserMessage = source.noUserMessage;
        this.parserType = source.parserType;
        this.program = source.program;
        this.programStage = source.programStage;
        this.publicAccess = source.publicAccess;
        this.receivedMessage = source.receivedMessage;
        this.separator = source.separator;
        this.sharing = source.sharing;
        this.smsCodes = source.smsCodes;
        this.specialCharacters = source.specialCharacters;
        this.successMessage = source.successMessage;
        this.translations = source.translations;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userGroup = source.userGroup;
        this.userGroupAccesses = source.userGroupAccesses;
        this.wrongFormatMessage = source.wrongFormatMessage;
    }

    /**
     * 
     * @param favorites
     * @param moreThanOneOrgUnitMessage
     * @param smsCodes
     * @param access
     * @param code
     * @param displayName
     * @param publicAccess
     * @param specialCharacters
     * @param currentPeriodUsedForReporting
     * @param program
     * @param externalAccess
     * @param lastUpdated
     * @param noUserMessage
     * @param receivedMessage
     * @param translations
     * @param defaultMessage
     * @param href
     * @param id
     * @param userGroup
     * @param lastUpdatedBy
     * @param programStage
     * @param userGroupAccesses
     * @param completenessMethod
     * @param created
     * @param attributeValues
     * @param wrongFormatMessage
     * @param sharing
     * @param separator
     * @param successMessage
     * @param codeValueSeparator
     * @param parserType
     * @param createdBy
     * @param userAccesses
     * @param name
     * @param dataset
     * @param favorite
     * @param user
     */
    public SMSCommand(Access access, List<AttributeValue> attributeValues, String code, String codeValueSeparator, CompletenessMethod completenessMethod, Date created, User createdBy, Boolean currentPeriodUsedForReporting, DataSet dataset, String defaultMessage, String displayName, Boolean externalAccess, Boolean favorite, List<String> favorites, String href, String id, Date lastUpdated, User lastUpdatedBy, String moreThanOneOrgUnitMessage, String name, String noUserMessage, ParserType parserType, Program program, ProgramStage programStage, String publicAccess, String receivedMessage, String separator, Sharing sharing, List<SMSCode> smsCodes, List<SMSSpecialCharacter> specialCharacters, String successMessage, List<Translation> translations, User user, List<UserAccess> userAccesses, UserGroup userGroup, List<UserGroupAccess> userGroupAccesses, String wrongFormatMessage) {
        super();
        this.access = access;
        this.attributeValues = attributeValues;
        this.code = code;
        this.codeValueSeparator = codeValueSeparator;
        this.completenessMethod = completenessMethod;
        this.created = created;
        this.createdBy = createdBy;
        this.currentPeriodUsedForReporting = currentPeriodUsedForReporting;
        this.dataset = dataset;
        this.defaultMessage = defaultMessage;
        this.displayName = displayName;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.href = href;
        this.id = id;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.moreThanOneOrgUnitMessage = moreThanOneOrgUnitMessage;
        this.name = name;
        this.noUserMessage = noUserMessage;
        this.parserType = parserType;
        this.program = program;
        this.programStage = programStage;
        this.publicAccess = publicAccess;
        this.receivedMessage = receivedMessage;
        this.separator = separator;
        this.sharing = sharing;
        this.smsCodes = smsCodes;
        this.specialCharacters = specialCharacters;
        this.successMessage = successMessage;
        this.translations = translations;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userGroup = userGroup;
        this.userGroupAccesses = userGroupAccesses;
        this.wrongFormatMessage = wrongFormatMessage;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public SMSCommand withAccess(Access access) {
        this.access = access;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public SMSCommand withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public SMSCommand withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("codeValueSeparator")
    public Optional<String> getCodeValueSeparator() {
        return Optional.ofNullable(codeValueSeparator);
    }

    @JsonProperty("codeValueSeparator")
    public void setCodeValueSeparator(String codeValueSeparator) {
        this.codeValueSeparator = codeValueSeparator;
    }

    public SMSCommand withCodeValueSeparator(String codeValueSeparator) {
        this.codeValueSeparator = codeValueSeparator;
        return this;
    }

    @JsonProperty("completenessMethod")
    public Optional<CompletenessMethod> getCompletenessMethod() {
        return Optional.ofNullable(completenessMethod);
    }

    @JsonProperty("completenessMethod")
    public void setCompletenessMethod(CompletenessMethod completenessMethod) {
        this.completenessMethod = completenessMethod;
    }

    public SMSCommand withCompletenessMethod(CompletenessMethod completenessMethod) {
        this.completenessMethod = completenessMethod;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public SMSCommand withCreated(Date created) {
        this.created = created;
        return this;
    }

    @JsonProperty("createdBy")
    public Optional<User> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    @JsonProperty("createdBy")
    public void setCreatedBy(User createdBy) {
        this.createdBy = createdBy;
    }

    public SMSCommand withCreatedBy(User createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @JsonProperty("currentPeriodUsedForReporting")
    public Optional<Boolean> getCurrentPeriodUsedForReporting() {
        return Optional.ofNullable(currentPeriodUsedForReporting);
    }

    @JsonProperty("currentPeriodUsedForReporting")
    public void setCurrentPeriodUsedForReporting(Boolean currentPeriodUsedForReporting) {
        this.currentPeriodUsedForReporting = currentPeriodUsedForReporting;
    }

    public SMSCommand withCurrentPeriodUsedForReporting(Boolean currentPeriodUsedForReporting) {
        this.currentPeriodUsedForReporting = currentPeriodUsedForReporting;
        return this;
    }

    @JsonProperty("dataset")
    public Optional<DataSet> getDataset() {
        return Optional.ofNullable(dataset);
    }

    @JsonProperty("dataset")
    public void setDataset(DataSet dataset) {
        this.dataset = dataset;
    }

    public SMSCommand withDataset(DataSet dataset) {
        this.dataset = dataset;
        return this;
    }

    @JsonProperty("defaultMessage")
    public Optional<String> getDefaultMessage() {
        return Optional.ofNullable(defaultMessage);
    }

    @JsonProperty("defaultMessage")
    public void setDefaultMessage(String defaultMessage) {
        this.defaultMessage = defaultMessage;
    }

    public SMSCommand withDefaultMessage(String defaultMessage) {
        this.defaultMessage = defaultMessage;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public SMSCommand withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("externalAccess")
    public Optional<Boolean> getExternalAccess() {
        return Optional.ofNullable(externalAccess);
    }

    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public SMSCommand withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    @JsonProperty("favorite")
    public Optional<Boolean> getFavorite() {
        return Optional.ofNullable(favorite);
    }

    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public SMSCommand withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public SMSCommand withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public SMSCommand withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public SMSCommand withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public SMSCommand withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @JsonProperty("lastUpdatedBy")
    public Optional<User> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public SMSCommand withLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    @JsonProperty("moreThanOneOrgUnitMessage")
    public Optional<String> getMoreThanOneOrgUnitMessage() {
        return Optional.ofNullable(moreThanOneOrgUnitMessage);
    }

    @JsonProperty("moreThanOneOrgUnitMessage")
    public void setMoreThanOneOrgUnitMessage(String moreThanOneOrgUnitMessage) {
        this.moreThanOneOrgUnitMessage = moreThanOneOrgUnitMessage;
    }

    public SMSCommand withMoreThanOneOrgUnitMessage(String moreThanOneOrgUnitMessage) {
        this.moreThanOneOrgUnitMessage = moreThanOneOrgUnitMessage;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public SMSCommand withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("noUserMessage")
    public Optional<String> getNoUserMessage() {
        return Optional.ofNullable(noUserMessage);
    }

    @JsonProperty("noUserMessage")
    public void setNoUserMessage(String noUserMessage) {
        this.noUserMessage = noUserMessage;
    }

    public SMSCommand withNoUserMessage(String noUserMessage) {
        this.noUserMessage = noUserMessage;
        return this;
    }

    @JsonProperty("parserType")
    public Optional<ParserType> getParserType() {
        return Optional.ofNullable(parserType);
    }

    @JsonProperty("parserType")
    public void setParserType(ParserType parserType) {
        this.parserType = parserType;
    }

    public SMSCommand withParserType(ParserType parserType) {
        this.parserType = parserType;
        return this;
    }

    @JsonProperty("program")
    public Optional<Program> getProgram() {
        return Optional.ofNullable(program);
    }

    @JsonProperty("program")
    public void setProgram(Program program) {
        this.program = program;
    }

    public SMSCommand withProgram(Program program) {
        this.program = program;
        return this;
    }

    @JsonProperty("programStage")
    public Optional<ProgramStage> getProgramStage() {
        return Optional.ofNullable(programStage);
    }

    @JsonProperty("programStage")
    public void setProgramStage(ProgramStage programStage) {
        this.programStage = programStage;
    }

    public SMSCommand withProgramStage(ProgramStage programStage) {
        this.programStage = programStage;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public SMSCommand withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    @JsonProperty("receivedMessage")
    public Optional<String> getReceivedMessage() {
        return Optional.ofNullable(receivedMessage);
    }

    @JsonProperty("receivedMessage")
    public void setReceivedMessage(String receivedMessage) {
        this.receivedMessage = receivedMessage;
    }

    public SMSCommand withReceivedMessage(String receivedMessage) {
        this.receivedMessage = receivedMessage;
        return this;
    }

    @JsonProperty("separator")
    public Optional<String> getSeparator() {
        return Optional.ofNullable(separator);
    }

    @JsonProperty("separator")
    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public SMSCommand withSeparator(String separator) {
        this.separator = separator;
        return this;
    }

    @JsonProperty("sharing")
    public Optional<Sharing> getSharing() {
        return Optional.ofNullable(sharing);
    }

    @JsonProperty("sharing")
    public void setSharing(Sharing sharing) {
        this.sharing = sharing;
    }

    public SMSCommand withSharing(Sharing sharing) {
        this.sharing = sharing;
        return this;
    }

    @JsonProperty("smsCodes")
    public Optional<List<SMSCode>> getSmsCodes() {
        return Optional.ofNullable(smsCodes);
    }

    @JsonProperty("smsCodes")
    public void setSmsCodes(List<SMSCode> smsCodes) {
        this.smsCodes = smsCodes;
    }

    public SMSCommand withSmsCodes(List<SMSCode> smsCodes) {
        this.smsCodes = smsCodes;
        return this;
    }

    @JsonProperty("specialCharacters")
    public Optional<List<SMSSpecialCharacter>> getSpecialCharacters() {
        return Optional.ofNullable(specialCharacters);
    }

    @JsonProperty("specialCharacters")
    public void setSpecialCharacters(List<SMSSpecialCharacter> specialCharacters) {
        this.specialCharacters = specialCharacters;
    }

    public SMSCommand withSpecialCharacters(List<SMSSpecialCharacter> specialCharacters) {
        this.specialCharacters = specialCharacters;
        return this;
    }

    @JsonProperty("successMessage")
    public Optional<String> getSuccessMessage() {
        return Optional.ofNullable(successMessage);
    }

    @JsonProperty("successMessage")
    public void setSuccessMessage(String successMessage) {
        this.successMessage = successMessage;
    }

    public SMSCommand withSuccessMessage(String successMessage) {
        this.successMessage = successMessage;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public SMSCommand withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    @JsonProperty("user")
    public Optional<User> getUser() {
        return Optional.ofNullable(user);
    }

    @JsonProperty("user")
    public void setUser(User user) {
        this.user = user;
    }

    public SMSCommand withUser(User user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<UserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public SMSCommand withUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userGroup")
    public Optional<UserGroup> getUserGroup() {
        return Optional.ofNullable(userGroup);
    }

    @JsonProperty("userGroup")
    public void setUserGroup(UserGroup userGroup) {
        this.userGroup = userGroup;
    }

    public SMSCommand withUserGroup(UserGroup userGroup) {
        this.userGroup = userGroup;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<UserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public SMSCommand withUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    @JsonProperty("wrongFormatMessage")
    public Optional<String> getWrongFormatMessage() {
        return Optional.ofNullable(wrongFormatMessage);
    }

    @JsonProperty("wrongFormatMessage")
    public void setWrongFormatMessage(String wrongFormatMessage) {
        this.wrongFormatMessage = wrongFormatMessage;
    }

    public SMSCommand withWrongFormatMessage(String wrongFormatMessage) {
        this.wrongFormatMessage = wrongFormatMessage;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public SMSCommand withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "access":
                if (value instanceof Access) {
                    setAccess(((Access) value));
                } else {
                    throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v2_38_1.Access\", but got "+ value.getClass().toString()));
                }
                return true;
            case "attributeValues":
                if (value instanceof List) {
                    setAttributeValues(((List<AttributeValue> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.AttributeValue>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "code":
                if (value instanceof String) {
                    setCode(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "codeValueSeparator":
                if (value instanceof String) {
                    setCodeValueSeparator(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"codeValueSeparator\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "completenessMethod":
                if (value instanceof CompletenessMethod) {
                    setCompletenessMethod(((CompletenessMethod) value));
                } else {
                    throw new IllegalArgumentException(("property \"completenessMethod\" is of type \"org.hisp.dhis.api.model.v2_38_1.CompletenessMethod\", but got "+ value.getClass().toString()));
                }
                return true;
            case "created":
                if (value instanceof Date) {
                    setCreated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "createdBy":
                if (value instanceof User) {
                    setCreatedBy(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"createdBy\" is of type \"org.hisp.dhis.api.model.v2_38_1.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "currentPeriodUsedForReporting":
                if (value instanceof Boolean) {
                    setCurrentPeriodUsedForReporting(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"currentPeriodUsedForReporting\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataset":
                if (value instanceof DataSet) {
                    setDataset(((DataSet) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataset\" is of type \"org.hisp.dhis.api.model.v2_38_1.DataSet\", but got "+ value.getClass().toString()));
                }
                return true;
            case "defaultMessage":
                if (value instanceof String) {
                    setDefaultMessage(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"defaultMessage\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayName":
                if (value instanceof String) {
                    setDisplayName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "externalAccess":
                if (value instanceof Boolean) {
                    setExternalAccess(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "favorite":
                if (value instanceof Boolean) {
                    setFavorite(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "favorites":
                if (value instanceof List) {
                    setFavorites(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "href":
                if (value instanceof String) {
                    setHref(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "id":
                if (value instanceof String) {
                    setId(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdated":
                if (value instanceof Date) {
                    setLastUpdated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdatedBy":
                if (value instanceof User) {
                    setLastUpdatedBy(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v2_38_1.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "moreThanOneOrgUnitMessage":
                if (value instanceof String) {
                    setMoreThanOneOrgUnitMessage(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"moreThanOneOrgUnitMessage\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "name":
                if (value instanceof String) {
                    setName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "noUserMessage":
                if (value instanceof String) {
                    setNoUserMessage(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"noUserMessage\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "parserType":
                if (value instanceof ParserType) {
                    setParserType(((ParserType) value));
                } else {
                    throw new IllegalArgumentException(("property \"parserType\" is of type \"org.hisp.dhis.api.model.v2_38_1.ParserType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "program":
                if (value instanceof Program) {
                    setProgram(((Program) value));
                } else {
                    throw new IllegalArgumentException(("property \"program\" is of type \"org.hisp.dhis.api.model.v2_38_1.Program\", but got "+ value.getClass().toString()));
                }
                return true;
            case "programStage":
                if (value instanceof ProgramStage) {
                    setProgramStage(((ProgramStage) value));
                } else {
                    throw new IllegalArgumentException(("property \"programStage\" is of type \"org.hisp.dhis.api.model.v2_38_1.ProgramStage\", but got "+ value.getClass().toString()));
                }
                return true;
            case "publicAccess":
                if (value instanceof String) {
                    setPublicAccess(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "receivedMessage":
                if (value instanceof String) {
                    setReceivedMessage(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"receivedMessage\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "separator":
                if (value instanceof String) {
                    setSeparator(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"separator\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "sharing":
                if (value instanceof Sharing) {
                    setSharing(((Sharing) value));
                } else {
                    throw new IllegalArgumentException(("property \"sharing\" is of type \"org.hisp.dhis.api.model.v2_38_1.Sharing\", but got "+ value.getClass().toString()));
                }
                return true;
            case "smsCodes":
                if (value instanceof List) {
                    setSmsCodes(((List<SMSCode> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"smsCodes\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.SMSCode>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "specialCharacters":
                if (value instanceof List) {
                    setSpecialCharacters(((List<SMSSpecialCharacter> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"specialCharacters\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.SMSSpecialCharacter>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "successMessage":
                if (value instanceof String) {
                    setSuccessMessage(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"successMessage\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "translations":
                if (value instanceof List) {
                    setTranslations(((List<Translation> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.Translation>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "user":
                if (value instanceof User) {
                    setUser(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v2_38_1.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userAccesses":
                if (value instanceof List) {
                    setUserAccesses(((List<UserAccess> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.UserAccess>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userGroup":
                if (value instanceof UserGroup) {
                    setUserGroup(((UserGroup) value));
                } else {
                    throw new IllegalArgumentException(("property \"userGroup\" is of type \"org.hisp.dhis.api.model.v2_38_1.UserGroup\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userGroupAccesses":
                if (value instanceof List) {
                    setUserGroupAccesses(((List<UserGroupAccess> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.UserGroupAccess>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "wrongFormatMessage":
                if (value instanceof String) {
                    setWrongFormatMessage(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"wrongFormatMessage\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "access":
                return getAccess();
            case "attributeValues":
                return getAttributeValues();
            case "code":
                return getCode();
            case "codeValueSeparator":
                return getCodeValueSeparator();
            case "completenessMethod":
                return getCompletenessMethod();
            case "created":
                return getCreated();
            case "createdBy":
                return getCreatedBy();
            case "currentPeriodUsedForReporting":
                return getCurrentPeriodUsedForReporting();
            case "dataset":
                return getDataset();
            case "defaultMessage":
                return getDefaultMessage();
            case "displayName":
                return getDisplayName();
            case "externalAccess":
                return getExternalAccess();
            case "favorite":
                return getFavorite();
            case "favorites":
                return getFavorites();
            case "href":
                return getHref();
            case "id":
                return getId();
            case "lastUpdated":
                return getLastUpdated();
            case "lastUpdatedBy":
                return getLastUpdatedBy();
            case "moreThanOneOrgUnitMessage":
                return getMoreThanOneOrgUnitMessage();
            case "name":
                return getName();
            case "noUserMessage":
                return getNoUserMessage();
            case "parserType":
                return getParserType();
            case "program":
                return getProgram();
            case "programStage":
                return getProgramStage();
            case "publicAccess":
                return getPublicAccess();
            case "receivedMessage":
                return getReceivedMessage();
            case "separator":
                return getSeparator();
            case "sharing":
                return getSharing();
            case "smsCodes":
                return getSmsCodes();
            case "specialCharacters":
                return getSpecialCharacters();
            case "successMessage":
                return getSuccessMessage();
            case "translations":
                return getTranslations();
            case "user":
                return getUser();
            case "userAccesses":
                return getUserAccesses();
            case "userGroup":
                return getUserGroup();
            case "userGroupAccesses":
                return getUserGroupAccesses();
            case "wrongFormatMessage":
                return getWrongFormatMessage();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, SMSCommand.NOT_FOUND_VALUE);
        if (SMSCommand.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public SMSCommand with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SMSCommand.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("codeValueSeparator");
        sb.append('=');
        sb.append(((this.codeValueSeparator == null)?"<null>":this.codeValueSeparator));
        sb.append(',');
        sb.append("completenessMethod");
        sb.append('=');
        sb.append(((this.completenessMethod == null)?"<null>":this.completenessMethod));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("createdBy");
        sb.append('=');
        sb.append(((this.createdBy == null)?"<null>":this.createdBy));
        sb.append(',');
        sb.append("currentPeriodUsedForReporting");
        sb.append('=');
        sb.append(((this.currentPeriodUsedForReporting == null)?"<null>":this.currentPeriodUsedForReporting));
        sb.append(',');
        sb.append("dataset");
        sb.append('=');
        sb.append(((this.dataset == null)?"<null>":this.dataset));
        sb.append(',');
        sb.append("defaultMessage");
        sb.append('=');
        sb.append(((this.defaultMessage == null)?"<null>":this.defaultMessage));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("moreThanOneOrgUnitMessage");
        sb.append('=');
        sb.append(((this.moreThanOneOrgUnitMessage == null)?"<null>":this.moreThanOneOrgUnitMessage));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("noUserMessage");
        sb.append('=');
        sb.append(((this.noUserMessage == null)?"<null>":this.noUserMessage));
        sb.append(',');
        sb.append("parserType");
        sb.append('=');
        sb.append(((this.parserType == null)?"<null>":this.parserType));
        sb.append(',');
        sb.append("program");
        sb.append('=');
        sb.append(((this.program == null)?"<null>":this.program));
        sb.append(',');
        sb.append("programStage");
        sb.append('=');
        sb.append(((this.programStage == null)?"<null>":this.programStage));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("receivedMessage");
        sb.append('=');
        sb.append(((this.receivedMessage == null)?"<null>":this.receivedMessage));
        sb.append(',');
        sb.append("separator");
        sb.append('=');
        sb.append(((this.separator == null)?"<null>":this.separator));
        sb.append(',');
        sb.append("sharing");
        sb.append('=');
        sb.append(((this.sharing == null)?"<null>":this.sharing));
        sb.append(',');
        sb.append("smsCodes");
        sb.append('=');
        sb.append(((this.smsCodes == null)?"<null>":this.smsCodes));
        sb.append(',');
        sb.append("specialCharacters");
        sb.append('=');
        sb.append(((this.specialCharacters == null)?"<null>":this.specialCharacters));
        sb.append(',');
        sb.append("successMessage");
        sb.append('=');
        sb.append(((this.successMessage == null)?"<null>":this.successMessage));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userGroup");
        sb.append('=');
        sb.append(((this.userGroup == null)?"<null>":this.userGroup));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("wrongFormatMessage");
        sb.append('=');
        sb.append(((this.wrongFormatMessage == null)?"<null>":this.wrongFormatMessage));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.moreThanOneOrgUnitMessage == null)? 0 :this.moreThanOneOrgUnitMessage.hashCode()));
        result = ((result* 31)+((this.smsCodes == null)? 0 :this.smsCodes.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.specialCharacters == null)? 0 :this.specialCharacters.hashCode()));
        result = ((result* 31)+((this.currentPeriodUsedForReporting == null)? 0 :this.currentPeriodUsedForReporting.hashCode()));
        result = ((result* 31)+((this.program == null)? 0 :this.program.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.noUserMessage == null)? 0 :this.noUserMessage.hashCode()));
        result = ((result* 31)+((this.receivedMessage == null)? 0 :this.receivedMessage.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.defaultMessage == null)? 0 :this.defaultMessage.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.userGroup == null)? 0 :this.userGroup.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.programStage == null)? 0 :this.programStage.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.completenessMethod == null)? 0 :this.completenessMethod.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.wrongFormatMessage == null)? 0 :this.wrongFormatMessage.hashCode()));
        result = ((result* 31)+((this.sharing == null)? 0 :this.sharing.hashCode()));
        result = ((result* 31)+((this.separator == null)? 0 :this.separator.hashCode()));
        result = ((result* 31)+((this.successMessage == null)? 0 :this.successMessage.hashCode()));
        result = ((result* 31)+((this.codeValueSeparator == null)? 0 :this.codeValueSeparator.hashCode()));
        result = ((result* 31)+((this.parserType == null)? 0 :this.parserType.hashCode()));
        result = ((result* 31)+((this.createdBy == null)? 0 :this.createdBy.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.dataset == null)? 0 :this.dataset.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof SMSCommand) == false) {
            return false;
        }
        SMSCommand rhs = ((SMSCommand) other);
        return (((((((((((((((((((((((((((((((((((((((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites)))&&((this.moreThanOneOrgUnitMessage == rhs.moreThanOneOrgUnitMessage)||((this.moreThanOneOrgUnitMessage!= null)&&this.moreThanOneOrgUnitMessage.equals(rhs.moreThanOneOrgUnitMessage))))&&((this.smsCodes == rhs.smsCodes)||((this.smsCodes!= null)&&this.smsCodes.equals(rhs.smsCodes))))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.specialCharacters == rhs.specialCharacters)||((this.specialCharacters!= null)&&this.specialCharacters.equals(rhs.specialCharacters))))&&((this.currentPeriodUsedForReporting == rhs.currentPeriodUsedForReporting)||((this.currentPeriodUsedForReporting!= null)&&this.currentPeriodUsedForReporting.equals(rhs.currentPeriodUsedForReporting))))&&((this.program == rhs.program)||((this.program!= null)&&this.program.equals(rhs.program))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.noUserMessage == rhs.noUserMessage)||((this.noUserMessage!= null)&&this.noUserMessage.equals(rhs.noUserMessage))))&&((this.receivedMessage == rhs.receivedMessage)||((this.receivedMessage!= null)&&this.receivedMessage.equals(rhs.receivedMessage))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.defaultMessage == rhs.defaultMessage)||((this.defaultMessage!= null)&&this.defaultMessage.equals(rhs.defaultMessage))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.userGroup == rhs.userGroup)||((this.userGroup!= null)&&this.userGroup.equals(rhs.userGroup))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.programStage == rhs.programStage)||((this.programStage!= null)&&this.programStage.equals(rhs.programStage))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.completenessMethod == rhs.completenessMethod)||((this.completenessMethod!= null)&&this.completenessMethod.equals(rhs.completenessMethod))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.wrongFormatMessage == rhs.wrongFormatMessage)||((this.wrongFormatMessage!= null)&&this.wrongFormatMessage.equals(rhs.wrongFormatMessage))))&&((this.sharing == rhs.sharing)||((this.sharing!= null)&&this.sharing.equals(rhs.sharing))))&&((this.separator == rhs.separator)||((this.separator!= null)&&this.separator.equals(rhs.separator))))&&((this.successMessage == rhs.successMessage)||((this.successMessage!= null)&&this.successMessage.equals(rhs.successMessage))))&&((this.codeValueSeparator == rhs.codeValueSeparator)||((this.codeValueSeparator!= null)&&this.codeValueSeparator.equals(rhs.codeValueSeparator))))&&((this.parserType == rhs.parserType)||((this.parserType!= null)&&this.parserType.equals(rhs.parserType))))&&((this.createdBy == rhs.createdBy)||((this.createdBy!= null)&&this.createdBy.equals(rhs.createdBy))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.dataset == rhs.dataset)||((this.dataset!= null)&&this.dataset.equals(rhs.dataset))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))));
    }

}
