
package org.hisp.dhis.api.model.v2_38_1;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "accessedBy",
    "auditType",
    "comment",
    "created",
    "trackedEntityInstance"
})
@Generated("jsonschema2pojo")
public class TrackedEntityInstanceAudit implements Serializable
{

    @JsonProperty("accessedBy")
    private String accessedBy;
    @JsonProperty("auditType")
    private AuditType auditType;
    @JsonProperty("comment")
    private String comment;
    @JsonProperty("created")
    private Date created;
    @JsonProperty("trackedEntityInstance")
    private String trackedEntityInstance;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 7829665194835424362L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TrackedEntityInstanceAudit() {
    }

    /**
     * 
     * @param source
     */
    public TrackedEntityInstanceAudit(TrackedEntityInstanceAudit source) {
        super();
        this.accessedBy = source.accessedBy;
        this.auditType = source.auditType;
        this.comment = source.comment;
        this.created = source.created;
        this.trackedEntityInstance = source.trackedEntityInstance;
    }

    /**
     * 
     * @param created
     * @param comment
     * @param auditType
     * @param accessedBy
     * @param trackedEntityInstance
     */
    public TrackedEntityInstanceAudit(String accessedBy, AuditType auditType, String comment, Date created, String trackedEntityInstance) {
        super();
        this.accessedBy = accessedBy;
        this.auditType = auditType;
        this.comment = comment;
        this.created = created;
        this.trackedEntityInstance = trackedEntityInstance;
    }

    @JsonProperty("accessedBy")
    public Optional<String> getAccessedBy() {
        return Optional.ofNullable(accessedBy);
    }

    @JsonProperty("accessedBy")
    public void setAccessedBy(String accessedBy) {
        this.accessedBy = accessedBy;
    }

    public TrackedEntityInstanceAudit withAccessedBy(String accessedBy) {
        this.accessedBy = accessedBy;
        return this;
    }

    @JsonProperty("auditType")
    public Optional<AuditType> getAuditType() {
        return Optional.ofNullable(auditType);
    }

    @JsonProperty("auditType")
    public void setAuditType(AuditType auditType) {
        this.auditType = auditType;
    }

    public TrackedEntityInstanceAudit withAuditType(AuditType auditType) {
        this.auditType = auditType;
        return this;
    }

    @JsonProperty("comment")
    public Optional<String> getComment() {
        return Optional.ofNullable(comment);
    }

    @JsonProperty("comment")
    public void setComment(String comment) {
        this.comment = comment;
    }

    public TrackedEntityInstanceAudit withComment(String comment) {
        this.comment = comment;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public TrackedEntityInstanceAudit withCreated(Date created) {
        this.created = created;
        return this;
    }

    @JsonProperty("trackedEntityInstance")
    public Optional<String> getTrackedEntityInstance() {
        return Optional.ofNullable(trackedEntityInstance);
    }

    @JsonProperty("trackedEntityInstance")
    public void setTrackedEntityInstance(String trackedEntityInstance) {
        this.trackedEntityInstance = trackedEntityInstance;
    }

    public TrackedEntityInstanceAudit withTrackedEntityInstance(String trackedEntityInstance) {
        this.trackedEntityInstance = trackedEntityInstance;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public TrackedEntityInstanceAudit withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "accessedBy":
                if (value instanceof String) {
                    setAccessedBy(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"accessedBy\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "auditType":
                if (value instanceof AuditType) {
                    setAuditType(((AuditType) value));
                } else {
                    throw new IllegalArgumentException(("property \"auditType\" is of type \"org.hisp.dhis.api.model.v2_38_1.AuditType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "comment":
                if (value instanceof String) {
                    setComment(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"comment\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "created":
                if (value instanceof Date) {
                    setCreated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "trackedEntityInstance":
                if (value instanceof String) {
                    setTrackedEntityInstance(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"trackedEntityInstance\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "accessedBy":
                return getAccessedBy();
            case "auditType":
                return getAuditType();
            case "comment":
                return getComment();
            case "created":
                return getCreated();
            case "trackedEntityInstance":
                return getTrackedEntityInstance();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, TrackedEntityInstanceAudit.NOT_FOUND_VALUE);
        if (TrackedEntityInstanceAudit.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public TrackedEntityInstanceAudit with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TrackedEntityInstanceAudit.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("accessedBy");
        sb.append('=');
        sb.append(((this.accessedBy == null)?"<null>":this.accessedBy));
        sb.append(',');
        sb.append("auditType");
        sb.append('=');
        sb.append(((this.auditType == null)?"<null>":this.auditType));
        sb.append(',');
        sb.append("comment");
        sb.append('=');
        sb.append(((this.comment == null)?"<null>":this.comment));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("trackedEntityInstance");
        sb.append('=');
        sb.append(((this.trackedEntityInstance == null)?"<null>":this.trackedEntityInstance));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.comment == null)? 0 :this.comment.hashCode()));
        result = ((result* 31)+((this.auditType == null)? 0 :this.auditType.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.accessedBy == null)? 0 :this.accessedBy.hashCode()));
        result = ((result* 31)+((this.trackedEntityInstance == null)? 0 :this.trackedEntityInstance.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TrackedEntityInstanceAudit) == false) {
            return false;
        }
        TrackedEntityInstanceAudit rhs = ((TrackedEntityInstanceAudit) other);
        return (((((((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created)))&&((this.comment == rhs.comment)||((this.comment!= null)&&this.comment.equals(rhs.comment))))&&((this.auditType == rhs.auditType)||((this.auditType!= null)&&this.auditType.equals(rhs.auditType))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.accessedBy == rhs.accessedBy)||((this.accessedBy!= null)&&this.accessedBy.equals(rhs.accessedBy))))&&((this.trackedEntityInstance == rhs.trackedEntityInstance)||((this.trackedEntityInstance!= null)&&this.trackedEntityInstance.equals(rhs.trackedEntityInstance))));
    }

}
