
package org.hisp.dhis.api.model.v2_39_1;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "attributeValues",
    "categoryAttribute",
    "categoryOptionAttribute",
    "categoryOptionComboAttribute",
    "categoryOptionGroupAttribute",
    "categoryOptionGroupSetAttribute",
    "code",
    "constantAttribute",
    "created",
    "createdBy",
    "dataElementAttribute",
    "dataElementGroupAttribute",
    "dataElementGroupSetAttribute",
    "dataSetAttribute",
    "description",
    "displayDescription",
    "displayFormName",
    "displayName",
    "displayShortName",
    "documentAttribute",
    "eventChartAttribute",
    "eventReportAttribute",
    "externalAccess",
    "favorite",
    "favorites",
    "formName",
    "href",
    "id",
    "indicatorAttribute",
    "indicatorGroupAttribute",
    "lastUpdated",
    "lastUpdatedBy",
    "legendSetAttribute",
    "mandatory",
    "mapAttribute",
    "name",
    "optionAttribute",
    "optionSet",
    "optionSetAttribute",
    "organisationUnitAttribute",
    "organisationUnitGroupAttribute",
    "organisationUnitGroupSetAttribute",
    "programAttribute",
    "programIndicatorAttribute",
    "programStageAttribute",
    "publicAccess",
    "relationshipTypeAttribute",
    "sectionAttribute",
    "sharing",
    "shortName",
    "sortOrder",
    "sqlViewAttribute",
    "trackedEntityAttributeAttribute",
    "trackedEntityTypeAttribute",
    "translations",
    "unique",
    "user",
    "userAccesses",
    "userAttribute",
    "userGroupAccesses",
    "userGroupAttribute",
    "validationRuleAttribute",
    "validationRuleGroupAttribute",
    "valueType",
    "visualizationAttribute"
})
@Generated("jsonschema2pojo")
public class Attribute implements Serializable
{

    @JsonProperty("access")
    private Access access;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues = null;
    @JsonProperty("categoryAttribute")
    private Boolean categoryAttribute;
    @JsonProperty("categoryOptionAttribute")
    private Boolean categoryOptionAttribute;
    @JsonProperty("categoryOptionComboAttribute")
    private Boolean categoryOptionComboAttribute;
    @JsonProperty("categoryOptionGroupAttribute")
    private Boolean categoryOptionGroupAttribute;
    @JsonProperty("categoryOptionGroupSetAttribute")
    private Boolean categoryOptionGroupSetAttribute;
    @JsonProperty("code")
    private String code;
    @JsonProperty("constantAttribute")
    private Boolean constantAttribute;
    @JsonProperty("created")
    private Date created;
    @JsonProperty("createdBy")
    private User createdBy;
    @JsonProperty("dataElementAttribute")
    private Boolean dataElementAttribute;
    @JsonProperty("dataElementGroupAttribute")
    private Boolean dataElementGroupAttribute;
    @JsonProperty("dataElementGroupSetAttribute")
    private Boolean dataElementGroupSetAttribute;
    @JsonProperty("dataSetAttribute")
    private Boolean dataSetAttribute;
    @JsonProperty("description")
    private String description;
    @JsonProperty("displayDescription")
    private String displayDescription;
    @JsonProperty("displayFormName")
    private String displayFormName;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("displayShortName")
    private String displayShortName;
    @JsonProperty("documentAttribute")
    private Boolean documentAttribute;
    @JsonProperty("eventChartAttribute")
    private Boolean eventChartAttribute;
    @JsonProperty("eventReportAttribute")
    private Boolean eventReportAttribute;
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites = null;
    @JsonProperty("formName")
    private String formName;
    @JsonProperty("href")
    private String href;
    @JsonProperty("id")
    private String id;
    @JsonProperty("indicatorAttribute")
    private Boolean indicatorAttribute;
    @JsonProperty("indicatorGroupAttribute")
    private Boolean indicatorGroupAttribute;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    @JsonProperty("lastUpdatedBy")
    private User lastUpdatedBy;
    @JsonProperty("legendSetAttribute")
    private Boolean legendSetAttribute;
    @JsonProperty("mandatory")
    private Boolean mandatory;
    @JsonProperty("mapAttribute")
    private Boolean mapAttribute;
    @JsonProperty("name")
    private String name;
    @JsonProperty("optionAttribute")
    private Boolean optionAttribute;
    @JsonProperty("optionSet")
    private OptionSet optionSet;
    @JsonProperty("optionSetAttribute")
    private Boolean optionSetAttribute;
    @JsonProperty("organisationUnitAttribute")
    private Boolean organisationUnitAttribute;
    @JsonProperty("organisationUnitGroupAttribute")
    private Boolean organisationUnitGroupAttribute;
    @JsonProperty("organisationUnitGroupSetAttribute")
    private Boolean organisationUnitGroupSetAttribute;
    @JsonProperty("programAttribute")
    private Boolean programAttribute;
    @JsonProperty("programIndicatorAttribute")
    private Boolean programIndicatorAttribute;
    @JsonProperty("programStageAttribute")
    private Boolean programStageAttribute;
    @JsonProperty("publicAccess")
    private String publicAccess;
    @JsonProperty("relationshipTypeAttribute")
    private Boolean relationshipTypeAttribute;
    @JsonProperty("sectionAttribute")
    private Boolean sectionAttribute;
    @JsonProperty("sharing")
    private Sharing sharing;
    @JsonProperty("shortName")
    private String shortName;
    @JsonProperty("sortOrder")
    private Integer sortOrder;
    @JsonProperty("sqlViewAttribute")
    private Boolean sqlViewAttribute;
    @JsonProperty("trackedEntityAttributeAttribute")
    private Boolean trackedEntityAttributeAttribute;
    @JsonProperty("trackedEntityTypeAttribute")
    private Boolean trackedEntityTypeAttribute;
    @JsonProperty("translations")
    private List<Translation> translations = null;
    @JsonProperty("unique")
    private Boolean unique;
    @JsonProperty("user")
    private User user;
    @JsonProperty("userAccesses")
    private List<UserAccess> userAccesses = null;
    @JsonProperty("userAttribute")
    private Boolean userAttribute;
    @JsonProperty("userGroupAccesses")
    private List<UserGroupAccess> userGroupAccesses = null;
    @JsonProperty("userGroupAttribute")
    private Boolean userGroupAttribute;
    @JsonProperty("validationRuleAttribute")
    private Boolean validationRuleAttribute;
    @JsonProperty("validationRuleGroupAttribute")
    private Boolean validationRuleGroupAttribute;
    @JsonProperty("valueType")
    private OptionSet.ValueType valueType;
    @JsonProperty("visualizationAttribute")
    private Boolean visualizationAttribute;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -5393090799219617993L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Attribute() {
    }

    /**
     * 
     * @param source
     */
    public Attribute(Attribute source) {
        super();
        this.access = source.access;
        this.attributeValues = source.attributeValues;
        this.categoryAttribute = source.categoryAttribute;
        this.categoryOptionAttribute = source.categoryOptionAttribute;
        this.categoryOptionComboAttribute = source.categoryOptionComboAttribute;
        this.categoryOptionGroupAttribute = source.categoryOptionGroupAttribute;
        this.categoryOptionGroupSetAttribute = source.categoryOptionGroupSetAttribute;
        this.code = source.code;
        this.constantAttribute = source.constantAttribute;
        this.created = source.created;
        this.createdBy = source.createdBy;
        this.dataElementAttribute = source.dataElementAttribute;
        this.dataElementGroupAttribute = source.dataElementGroupAttribute;
        this.dataElementGroupSetAttribute = source.dataElementGroupSetAttribute;
        this.dataSetAttribute = source.dataSetAttribute;
        this.description = source.description;
        this.displayDescription = source.displayDescription;
        this.displayFormName = source.displayFormName;
        this.displayName = source.displayName;
        this.displayShortName = source.displayShortName;
        this.documentAttribute = source.documentAttribute;
        this.eventChartAttribute = source.eventChartAttribute;
        this.eventReportAttribute = source.eventReportAttribute;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.formName = source.formName;
        this.href = source.href;
        this.id = source.id;
        this.indicatorAttribute = source.indicatorAttribute;
        this.indicatorGroupAttribute = source.indicatorGroupAttribute;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.legendSetAttribute = source.legendSetAttribute;
        this.mandatory = source.mandatory;
        this.mapAttribute = source.mapAttribute;
        this.name = source.name;
        this.optionAttribute = source.optionAttribute;
        this.optionSet = source.optionSet;
        this.optionSetAttribute = source.optionSetAttribute;
        this.organisationUnitAttribute = source.organisationUnitAttribute;
        this.organisationUnitGroupAttribute = source.organisationUnitGroupAttribute;
        this.organisationUnitGroupSetAttribute = source.organisationUnitGroupSetAttribute;
        this.programAttribute = source.programAttribute;
        this.programIndicatorAttribute = source.programIndicatorAttribute;
        this.programStageAttribute = source.programStageAttribute;
        this.publicAccess = source.publicAccess;
        this.relationshipTypeAttribute = source.relationshipTypeAttribute;
        this.sectionAttribute = source.sectionAttribute;
        this.sharing = source.sharing;
        this.shortName = source.shortName;
        this.sortOrder = source.sortOrder;
        this.sqlViewAttribute = source.sqlViewAttribute;
        this.trackedEntityAttributeAttribute = source.trackedEntityAttributeAttribute;
        this.trackedEntityTypeAttribute = source.trackedEntityTypeAttribute;
        this.translations = source.translations;
        this.unique = source.unique;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userAttribute = source.userAttribute;
        this.userGroupAccesses = source.userGroupAccesses;
        this.userGroupAttribute = source.userGroupAttribute;
        this.validationRuleAttribute = source.validationRuleAttribute;
        this.validationRuleGroupAttribute = source.validationRuleGroupAttribute;
        this.valueType = source.valueType;
        this.visualizationAttribute = source.visualizationAttribute;
    }

    /**
     * 
     * @param indicatorAttribute
     * @param indicatorGroupAttribute
     * @param mapAttribute
     * @param publicAccess
     * @param userGroupAttribute
     * @param dataElementAttribute
     * @param lastUpdated
     * @param constantAttribute
     * @param translations
     * @param valueType
     * @param categoryOptionAttribute
     * @param eventChartAttribute
     * @param href
     * @param id
     * @param optionSetAttribute
     * @param displayDescription
     * @param lastUpdatedBy
     * @param sqlViewAttribute
     * @param userGroupAccesses
     * @param created
     * @param visualizationAttribute
     * @param legendSetAttribute
     * @param attributeValues
     * @param sharing
     * @param displayFormName
     * @param organisationUnitAttribute
     * @param trackedEntityAttributeAttribute
     * @param dataSetAttribute
     * @param documentAttribute
     * @param sortOrder
     * @param unique
     * @param userAccesses
     * @param name
     * @param validationRuleGroupAttribute
     * @param shortName
     * @param dataElementGroupAttribute
     * @param favorite
     * @param sectionAttribute
     * @param favorites
     * @param access
     * @param code
     * @param trackedEntityTypeAttribute
     * @param displayName
     * @param userAttribute
     * @param description
     * @param categoryOptionGroupAttribute
     * @param mandatory
     * @param displayShortName
     * @param eventReportAttribute
     * @param externalAccess
     * @param programStageAttribute
     * @param programAttribute
     * @param optionSet
     * @param categoryAttribute
     * @param categoryOptionComboAttribute
     * @param formName
     * @param categoryOptionGroupSetAttribute
     * @param programIndicatorAttribute
     * @param validationRuleAttribute
     * @param organisationUnitGroupAttribute
     * @param dataElementGroupSetAttribute
     * @param relationshipTypeAttribute
     * @param organisationUnitGroupSetAttribute
     * @param createdBy
     * @param user
     * @param optionAttribute
     */
    public Attribute(Access access, List<AttributeValue> attributeValues, Boolean categoryAttribute, Boolean categoryOptionAttribute, Boolean categoryOptionComboAttribute, Boolean categoryOptionGroupAttribute, Boolean categoryOptionGroupSetAttribute, String code, Boolean constantAttribute, Date created, User createdBy, Boolean dataElementAttribute, Boolean dataElementGroupAttribute, Boolean dataElementGroupSetAttribute, Boolean dataSetAttribute, String description, String displayDescription, String displayFormName, String displayName, String displayShortName, Boolean documentAttribute, Boolean eventChartAttribute, Boolean eventReportAttribute, Boolean externalAccess, Boolean favorite, List<String> favorites, String formName, String href, String id, Boolean indicatorAttribute, Boolean indicatorGroupAttribute, Date lastUpdated, User lastUpdatedBy, Boolean legendSetAttribute, Boolean mandatory, Boolean mapAttribute, String name, Boolean optionAttribute, OptionSet optionSet, Boolean optionSetAttribute, Boolean organisationUnitAttribute, Boolean organisationUnitGroupAttribute, Boolean organisationUnitGroupSetAttribute, Boolean programAttribute, Boolean programIndicatorAttribute, Boolean programStageAttribute, String publicAccess, Boolean relationshipTypeAttribute, Boolean sectionAttribute, Sharing sharing, String shortName, Integer sortOrder, Boolean sqlViewAttribute, Boolean trackedEntityAttributeAttribute, Boolean trackedEntityTypeAttribute, List<Translation> translations, Boolean unique, User user, List<UserAccess> userAccesses, Boolean userAttribute, List<UserGroupAccess> userGroupAccesses, Boolean userGroupAttribute, Boolean validationRuleAttribute, Boolean validationRuleGroupAttribute, OptionSet.ValueType valueType, Boolean visualizationAttribute) {
        super();
        this.access = access;
        this.attributeValues = attributeValues;
        this.categoryAttribute = categoryAttribute;
        this.categoryOptionAttribute = categoryOptionAttribute;
        this.categoryOptionComboAttribute = categoryOptionComboAttribute;
        this.categoryOptionGroupAttribute = categoryOptionGroupAttribute;
        this.categoryOptionGroupSetAttribute = categoryOptionGroupSetAttribute;
        this.code = code;
        this.constantAttribute = constantAttribute;
        this.created = created;
        this.createdBy = createdBy;
        this.dataElementAttribute = dataElementAttribute;
        this.dataElementGroupAttribute = dataElementGroupAttribute;
        this.dataElementGroupSetAttribute = dataElementGroupSetAttribute;
        this.dataSetAttribute = dataSetAttribute;
        this.description = description;
        this.displayDescription = displayDescription;
        this.displayFormName = displayFormName;
        this.displayName = displayName;
        this.displayShortName = displayShortName;
        this.documentAttribute = documentAttribute;
        this.eventChartAttribute = eventChartAttribute;
        this.eventReportAttribute = eventReportAttribute;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.formName = formName;
        this.href = href;
        this.id = id;
        this.indicatorAttribute = indicatorAttribute;
        this.indicatorGroupAttribute = indicatorGroupAttribute;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.legendSetAttribute = legendSetAttribute;
        this.mandatory = mandatory;
        this.mapAttribute = mapAttribute;
        this.name = name;
        this.optionAttribute = optionAttribute;
        this.optionSet = optionSet;
        this.optionSetAttribute = optionSetAttribute;
        this.organisationUnitAttribute = organisationUnitAttribute;
        this.organisationUnitGroupAttribute = organisationUnitGroupAttribute;
        this.organisationUnitGroupSetAttribute = organisationUnitGroupSetAttribute;
        this.programAttribute = programAttribute;
        this.programIndicatorAttribute = programIndicatorAttribute;
        this.programStageAttribute = programStageAttribute;
        this.publicAccess = publicAccess;
        this.relationshipTypeAttribute = relationshipTypeAttribute;
        this.sectionAttribute = sectionAttribute;
        this.sharing = sharing;
        this.shortName = shortName;
        this.sortOrder = sortOrder;
        this.sqlViewAttribute = sqlViewAttribute;
        this.trackedEntityAttributeAttribute = trackedEntityAttributeAttribute;
        this.trackedEntityTypeAttribute = trackedEntityTypeAttribute;
        this.translations = translations;
        this.unique = unique;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userAttribute = userAttribute;
        this.userGroupAccesses = userGroupAccesses;
        this.userGroupAttribute = userGroupAttribute;
        this.validationRuleAttribute = validationRuleAttribute;
        this.validationRuleGroupAttribute = validationRuleGroupAttribute;
        this.valueType = valueType;
        this.visualizationAttribute = visualizationAttribute;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public Attribute withAccess(Access access) {
        this.access = access;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public Attribute withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    @JsonProperty("categoryAttribute")
    public Optional<Boolean> getCategoryAttribute() {
        return Optional.ofNullable(categoryAttribute);
    }

    @JsonProperty("categoryAttribute")
    public void setCategoryAttribute(Boolean categoryAttribute) {
        this.categoryAttribute = categoryAttribute;
    }

    public Attribute withCategoryAttribute(Boolean categoryAttribute) {
        this.categoryAttribute = categoryAttribute;
        return this;
    }

    @JsonProperty("categoryOptionAttribute")
    public Optional<Boolean> getCategoryOptionAttribute() {
        return Optional.ofNullable(categoryOptionAttribute);
    }

    @JsonProperty("categoryOptionAttribute")
    public void setCategoryOptionAttribute(Boolean categoryOptionAttribute) {
        this.categoryOptionAttribute = categoryOptionAttribute;
    }

    public Attribute withCategoryOptionAttribute(Boolean categoryOptionAttribute) {
        this.categoryOptionAttribute = categoryOptionAttribute;
        return this;
    }

    @JsonProperty("categoryOptionComboAttribute")
    public Optional<Boolean> getCategoryOptionComboAttribute() {
        return Optional.ofNullable(categoryOptionComboAttribute);
    }

    @JsonProperty("categoryOptionComboAttribute")
    public void setCategoryOptionComboAttribute(Boolean categoryOptionComboAttribute) {
        this.categoryOptionComboAttribute = categoryOptionComboAttribute;
    }

    public Attribute withCategoryOptionComboAttribute(Boolean categoryOptionComboAttribute) {
        this.categoryOptionComboAttribute = categoryOptionComboAttribute;
        return this;
    }

    @JsonProperty("categoryOptionGroupAttribute")
    public Optional<Boolean> getCategoryOptionGroupAttribute() {
        return Optional.ofNullable(categoryOptionGroupAttribute);
    }

    @JsonProperty("categoryOptionGroupAttribute")
    public void setCategoryOptionGroupAttribute(Boolean categoryOptionGroupAttribute) {
        this.categoryOptionGroupAttribute = categoryOptionGroupAttribute;
    }

    public Attribute withCategoryOptionGroupAttribute(Boolean categoryOptionGroupAttribute) {
        this.categoryOptionGroupAttribute = categoryOptionGroupAttribute;
        return this;
    }

    @JsonProperty("categoryOptionGroupSetAttribute")
    public Optional<Boolean> getCategoryOptionGroupSetAttribute() {
        return Optional.ofNullable(categoryOptionGroupSetAttribute);
    }

    @JsonProperty("categoryOptionGroupSetAttribute")
    public void setCategoryOptionGroupSetAttribute(Boolean categoryOptionGroupSetAttribute) {
        this.categoryOptionGroupSetAttribute = categoryOptionGroupSetAttribute;
    }

    public Attribute withCategoryOptionGroupSetAttribute(Boolean categoryOptionGroupSetAttribute) {
        this.categoryOptionGroupSetAttribute = categoryOptionGroupSetAttribute;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public Attribute withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("constantAttribute")
    public Optional<Boolean> getConstantAttribute() {
        return Optional.ofNullable(constantAttribute);
    }

    @JsonProperty("constantAttribute")
    public void setConstantAttribute(Boolean constantAttribute) {
        this.constantAttribute = constantAttribute;
    }

    public Attribute withConstantAttribute(Boolean constantAttribute) {
        this.constantAttribute = constantAttribute;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public Attribute withCreated(Date created) {
        this.created = created;
        return this;
    }

    @JsonProperty("createdBy")
    public Optional<User> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    @JsonProperty("createdBy")
    public void setCreatedBy(User createdBy) {
        this.createdBy = createdBy;
    }

    public Attribute withCreatedBy(User createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @JsonProperty("dataElementAttribute")
    public Optional<Boolean> getDataElementAttribute() {
        return Optional.ofNullable(dataElementAttribute);
    }

    @JsonProperty("dataElementAttribute")
    public void setDataElementAttribute(Boolean dataElementAttribute) {
        this.dataElementAttribute = dataElementAttribute;
    }

    public Attribute withDataElementAttribute(Boolean dataElementAttribute) {
        this.dataElementAttribute = dataElementAttribute;
        return this;
    }

    @JsonProperty("dataElementGroupAttribute")
    public Optional<Boolean> getDataElementGroupAttribute() {
        return Optional.ofNullable(dataElementGroupAttribute);
    }

    @JsonProperty("dataElementGroupAttribute")
    public void setDataElementGroupAttribute(Boolean dataElementGroupAttribute) {
        this.dataElementGroupAttribute = dataElementGroupAttribute;
    }

    public Attribute withDataElementGroupAttribute(Boolean dataElementGroupAttribute) {
        this.dataElementGroupAttribute = dataElementGroupAttribute;
        return this;
    }

    @JsonProperty("dataElementGroupSetAttribute")
    public Optional<Boolean> getDataElementGroupSetAttribute() {
        return Optional.ofNullable(dataElementGroupSetAttribute);
    }

    @JsonProperty("dataElementGroupSetAttribute")
    public void setDataElementGroupSetAttribute(Boolean dataElementGroupSetAttribute) {
        this.dataElementGroupSetAttribute = dataElementGroupSetAttribute;
    }

    public Attribute withDataElementGroupSetAttribute(Boolean dataElementGroupSetAttribute) {
        this.dataElementGroupSetAttribute = dataElementGroupSetAttribute;
        return this;
    }

    @JsonProperty("dataSetAttribute")
    public Optional<Boolean> getDataSetAttribute() {
        return Optional.ofNullable(dataSetAttribute);
    }

    @JsonProperty("dataSetAttribute")
    public void setDataSetAttribute(Boolean dataSetAttribute) {
        this.dataSetAttribute = dataSetAttribute;
    }

    public Attribute withDataSetAttribute(Boolean dataSetAttribute) {
        this.dataSetAttribute = dataSetAttribute;
        return this;
    }

    @JsonProperty("description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    public Attribute withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty("displayDescription")
    public Optional<String> getDisplayDescription() {
        return Optional.ofNullable(displayDescription);
    }

    @JsonProperty("displayDescription")
    public void setDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
    }

    public Attribute withDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
        return this;
    }

    @JsonProperty("displayFormName")
    public Optional<String> getDisplayFormName() {
        return Optional.ofNullable(displayFormName);
    }

    @JsonProperty("displayFormName")
    public void setDisplayFormName(String displayFormName) {
        this.displayFormName = displayFormName;
    }

    public Attribute withDisplayFormName(String displayFormName) {
        this.displayFormName = displayFormName;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Attribute withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("displayShortName")
    public Optional<String> getDisplayShortName() {
        return Optional.ofNullable(displayShortName);
    }

    @JsonProperty("displayShortName")
    public void setDisplayShortName(String displayShortName) {
        this.displayShortName = displayShortName;
    }

    public Attribute withDisplayShortName(String displayShortName) {
        this.displayShortName = displayShortName;
        return this;
    }

    @JsonProperty("documentAttribute")
    public Optional<Boolean> getDocumentAttribute() {
        return Optional.ofNullable(documentAttribute);
    }

    @JsonProperty("documentAttribute")
    public void setDocumentAttribute(Boolean documentAttribute) {
        this.documentAttribute = documentAttribute;
    }

    public Attribute withDocumentAttribute(Boolean documentAttribute) {
        this.documentAttribute = documentAttribute;
        return this;
    }

    @JsonProperty("eventChartAttribute")
    public Optional<Boolean> getEventChartAttribute() {
        return Optional.ofNullable(eventChartAttribute);
    }

    @JsonProperty("eventChartAttribute")
    public void setEventChartAttribute(Boolean eventChartAttribute) {
        this.eventChartAttribute = eventChartAttribute;
    }

    public Attribute withEventChartAttribute(Boolean eventChartAttribute) {
        this.eventChartAttribute = eventChartAttribute;
        return this;
    }

    @JsonProperty("eventReportAttribute")
    public Optional<Boolean> getEventReportAttribute() {
        return Optional.ofNullable(eventReportAttribute);
    }

    @JsonProperty("eventReportAttribute")
    public void setEventReportAttribute(Boolean eventReportAttribute) {
        this.eventReportAttribute = eventReportAttribute;
    }

    public Attribute withEventReportAttribute(Boolean eventReportAttribute) {
        this.eventReportAttribute = eventReportAttribute;
        return this;
    }

    @JsonProperty("externalAccess")
    public Optional<Boolean> getExternalAccess() {
        return Optional.ofNullable(externalAccess);
    }

    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public Attribute withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    @JsonProperty("favorite")
    public Optional<Boolean> getFavorite() {
        return Optional.ofNullable(favorite);
    }

    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public Attribute withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public Attribute withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @JsonProperty("formName")
    public Optional<String> getFormName() {
        return Optional.ofNullable(formName);
    }

    @JsonProperty("formName")
    public void setFormName(String formName) {
        this.formName = formName;
    }

    public Attribute withFormName(String formName) {
        this.formName = formName;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public Attribute withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public Attribute withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("indicatorAttribute")
    public Optional<Boolean> getIndicatorAttribute() {
        return Optional.ofNullable(indicatorAttribute);
    }

    @JsonProperty("indicatorAttribute")
    public void setIndicatorAttribute(Boolean indicatorAttribute) {
        this.indicatorAttribute = indicatorAttribute;
    }

    public Attribute withIndicatorAttribute(Boolean indicatorAttribute) {
        this.indicatorAttribute = indicatorAttribute;
        return this;
    }

    @JsonProperty("indicatorGroupAttribute")
    public Optional<Boolean> getIndicatorGroupAttribute() {
        return Optional.ofNullable(indicatorGroupAttribute);
    }

    @JsonProperty("indicatorGroupAttribute")
    public void setIndicatorGroupAttribute(Boolean indicatorGroupAttribute) {
        this.indicatorGroupAttribute = indicatorGroupAttribute;
    }

    public Attribute withIndicatorGroupAttribute(Boolean indicatorGroupAttribute) {
        this.indicatorGroupAttribute = indicatorGroupAttribute;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public Attribute withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @JsonProperty("lastUpdatedBy")
    public Optional<User> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public Attribute withLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    @JsonProperty("legendSetAttribute")
    public Optional<Boolean> getLegendSetAttribute() {
        return Optional.ofNullable(legendSetAttribute);
    }

    @JsonProperty("legendSetAttribute")
    public void setLegendSetAttribute(Boolean legendSetAttribute) {
        this.legendSetAttribute = legendSetAttribute;
    }

    public Attribute withLegendSetAttribute(Boolean legendSetAttribute) {
        this.legendSetAttribute = legendSetAttribute;
        return this;
    }

    @JsonProperty("mandatory")
    public Optional<Boolean> getMandatory() {
        return Optional.ofNullable(mandatory);
    }

    @JsonProperty("mandatory")
    public void setMandatory(Boolean mandatory) {
        this.mandatory = mandatory;
    }

    public Attribute withMandatory(Boolean mandatory) {
        this.mandatory = mandatory;
        return this;
    }

    @JsonProperty("mapAttribute")
    public Optional<Boolean> getMapAttribute() {
        return Optional.ofNullable(mapAttribute);
    }

    @JsonProperty("mapAttribute")
    public void setMapAttribute(Boolean mapAttribute) {
        this.mapAttribute = mapAttribute;
    }

    public Attribute withMapAttribute(Boolean mapAttribute) {
        this.mapAttribute = mapAttribute;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public Attribute withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("optionAttribute")
    public Optional<Boolean> getOptionAttribute() {
        return Optional.ofNullable(optionAttribute);
    }

    @JsonProperty("optionAttribute")
    public void setOptionAttribute(Boolean optionAttribute) {
        this.optionAttribute = optionAttribute;
    }

    public Attribute withOptionAttribute(Boolean optionAttribute) {
        this.optionAttribute = optionAttribute;
        return this;
    }

    @JsonProperty("optionSet")
    public Optional<OptionSet> getOptionSet() {
        return Optional.ofNullable(optionSet);
    }

    @JsonProperty("optionSet")
    public void setOptionSet(OptionSet optionSet) {
        this.optionSet = optionSet;
    }

    public Attribute withOptionSet(OptionSet optionSet) {
        this.optionSet = optionSet;
        return this;
    }

    @JsonProperty("optionSetAttribute")
    public Optional<Boolean> getOptionSetAttribute() {
        return Optional.ofNullable(optionSetAttribute);
    }

    @JsonProperty("optionSetAttribute")
    public void setOptionSetAttribute(Boolean optionSetAttribute) {
        this.optionSetAttribute = optionSetAttribute;
    }

    public Attribute withOptionSetAttribute(Boolean optionSetAttribute) {
        this.optionSetAttribute = optionSetAttribute;
        return this;
    }

    @JsonProperty("organisationUnitAttribute")
    public Optional<Boolean> getOrganisationUnitAttribute() {
        return Optional.ofNullable(organisationUnitAttribute);
    }

    @JsonProperty("organisationUnitAttribute")
    public void setOrganisationUnitAttribute(Boolean organisationUnitAttribute) {
        this.organisationUnitAttribute = organisationUnitAttribute;
    }

    public Attribute withOrganisationUnitAttribute(Boolean organisationUnitAttribute) {
        this.organisationUnitAttribute = organisationUnitAttribute;
        return this;
    }

    @JsonProperty("organisationUnitGroupAttribute")
    public Optional<Boolean> getOrganisationUnitGroupAttribute() {
        return Optional.ofNullable(organisationUnitGroupAttribute);
    }

    @JsonProperty("organisationUnitGroupAttribute")
    public void setOrganisationUnitGroupAttribute(Boolean organisationUnitGroupAttribute) {
        this.organisationUnitGroupAttribute = organisationUnitGroupAttribute;
    }

    public Attribute withOrganisationUnitGroupAttribute(Boolean organisationUnitGroupAttribute) {
        this.organisationUnitGroupAttribute = organisationUnitGroupAttribute;
        return this;
    }

    @JsonProperty("organisationUnitGroupSetAttribute")
    public Optional<Boolean> getOrganisationUnitGroupSetAttribute() {
        return Optional.ofNullable(organisationUnitGroupSetAttribute);
    }

    @JsonProperty("organisationUnitGroupSetAttribute")
    public void setOrganisationUnitGroupSetAttribute(Boolean organisationUnitGroupSetAttribute) {
        this.organisationUnitGroupSetAttribute = organisationUnitGroupSetAttribute;
    }

    public Attribute withOrganisationUnitGroupSetAttribute(Boolean organisationUnitGroupSetAttribute) {
        this.organisationUnitGroupSetAttribute = organisationUnitGroupSetAttribute;
        return this;
    }

    @JsonProperty("programAttribute")
    public Optional<Boolean> getProgramAttribute() {
        return Optional.ofNullable(programAttribute);
    }

    @JsonProperty("programAttribute")
    public void setProgramAttribute(Boolean programAttribute) {
        this.programAttribute = programAttribute;
    }

    public Attribute withProgramAttribute(Boolean programAttribute) {
        this.programAttribute = programAttribute;
        return this;
    }

    @JsonProperty("programIndicatorAttribute")
    public Optional<Boolean> getProgramIndicatorAttribute() {
        return Optional.ofNullable(programIndicatorAttribute);
    }

    @JsonProperty("programIndicatorAttribute")
    public void setProgramIndicatorAttribute(Boolean programIndicatorAttribute) {
        this.programIndicatorAttribute = programIndicatorAttribute;
    }

    public Attribute withProgramIndicatorAttribute(Boolean programIndicatorAttribute) {
        this.programIndicatorAttribute = programIndicatorAttribute;
        return this;
    }

    @JsonProperty("programStageAttribute")
    public Optional<Boolean> getProgramStageAttribute() {
        return Optional.ofNullable(programStageAttribute);
    }

    @JsonProperty("programStageAttribute")
    public void setProgramStageAttribute(Boolean programStageAttribute) {
        this.programStageAttribute = programStageAttribute;
    }

    public Attribute withProgramStageAttribute(Boolean programStageAttribute) {
        this.programStageAttribute = programStageAttribute;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public Attribute withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    @JsonProperty("relationshipTypeAttribute")
    public Optional<Boolean> getRelationshipTypeAttribute() {
        return Optional.ofNullable(relationshipTypeAttribute);
    }

    @JsonProperty("relationshipTypeAttribute")
    public void setRelationshipTypeAttribute(Boolean relationshipTypeAttribute) {
        this.relationshipTypeAttribute = relationshipTypeAttribute;
    }

    public Attribute withRelationshipTypeAttribute(Boolean relationshipTypeAttribute) {
        this.relationshipTypeAttribute = relationshipTypeAttribute;
        return this;
    }

    @JsonProperty("sectionAttribute")
    public Optional<Boolean> getSectionAttribute() {
        return Optional.ofNullable(sectionAttribute);
    }

    @JsonProperty("sectionAttribute")
    public void setSectionAttribute(Boolean sectionAttribute) {
        this.sectionAttribute = sectionAttribute;
    }

    public Attribute withSectionAttribute(Boolean sectionAttribute) {
        this.sectionAttribute = sectionAttribute;
        return this;
    }

    @JsonProperty("sharing")
    public Optional<Sharing> getSharing() {
        return Optional.ofNullable(sharing);
    }

    @JsonProperty("sharing")
    public void setSharing(Sharing sharing) {
        this.sharing = sharing;
    }

    public Attribute withSharing(Sharing sharing) {
        this.sharing = sharing;
        return this;
    }

    @JsonProperty("shortName")
    public Optional<String> getShortName() {
        return Optional.ofNullable(shortName);
    }

    @JsonProperty("shortName")
    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public Attribute withShortName(String shortName) {
        this.shortName = shortName;
        return this;
    }

    @JsonProperty("sortOrder")
    public Optional<Integer> getSortOrder() {
        return Optional.ofNullable(sortOrder);
    }

    @JsonProperty("sortOrder")
    public void setSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
    }

    public Attribute withSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
        return this;
    }

    @JsonProperty("sqlViewAttribute")
    public Optional<Boolean> getSqlViewAttribute() {
        return Optional.ofNullable(sqlViewAttribute);
    }

    @JsonProperty("sqlViewAttribute")
    public void setSqlViewAttribute(Boolean sqlViewAttribute) {
        this.sqlViewAttribute = sqlViewAttribute;
    }

    public Attribute withSqlViewAttribute(Boolean sqlViewAttribute) {
        this.sqlViewAttribute = sqlViewAttribute;
        return this;
    }

    @JsonProperty("trackedEntityAttributeAttribute")
    public Optional<Boolean> getTrackedEntityAttributeAttribute() {
        return Optional.ofNullable(trackedEntityAttributeAttribute);
    }

    @JsonProperty("trackedEntityAttributeAttribute")
    public void setTrackedEntityAttributeAttribute(Boolean trackedEntityAttributeAttribute) {
        this.trackedEntityAttributeAttribute = trackedEntityAttributeAttribute;
    }

    public Attribute withTrackedEntityAttributeAttribute(Boolean trackedEntityAttributeAttribute) {
        this.trackedEntityAttributeAttribute = trackedEntityAttributeAttribute;
        return this;
    }

    @JsonProperty("trackedEntityTypeAttribute")
    public Optional<Boolean> getTrackedEntityTypeAttribute() {
        return Optional.ofNullable(trackedEntityTypeAttribute);
    }

    @JsonProperty("trackedEntityTypeAttribute")
    public void setTrackedEntityTypeAttribute(Boolean trackedEntityTypeAttribute) {
        this.trackedEntityTypeAttribute = trackedEntityTypeAttribute;
    }

    public Attribute withTrackedEntityTypeAttribute(Boolean trackedEntityTypeAttribute) {
        this.trackedEntityTypeAttribute = trackedEntityTypeAttribute;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public Attribute withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    @JsonProperty("unique")
    public Optional<Boolean> getUnique() {
        return Optional.ofNullable(unique);
    }

    @JsonProperty("unique")
    public void setUnique(Boolean unique) {
        this.unique = unique;
    }

    public Attribute withUnique(Boolean unique) {
        this.unique = unique;
        return this;
    }

    @JsonProperty("user")
    public Optional<User> getUser() {
        return Optional.ofNullable(user);
    }

    @JsonProperty("user")
    public void setUser(User user) {
        this.user = user;
    }

    public Attribute withUser(User user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<UserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public Attribute withUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userAttribute")
    public Optional<Boolean> getUserAttribute() {
        return Optional.ofNullable(userAttribute);
    }

    @JsonProperty("userAttribute")
    public void setUserAttribute(Boolean userAttribute) {
        this.userAttribute = userAttribute;
    }

    public Attribute withUserAttribute(Boolean userAttribute) {
        this.userAttribute = userAttribute;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<UserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public Attribute withUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    @JsonProperty("userGroupAttribute")
    public Optional<Boolean> getUserGroupAttribute() {
        return Optional.ofNullable(userGroupAttribute);
    }

    @JsonProperty("userGroupAttribute")
    public void setUserGroupAttribute(Boolean userGroupAttribute) {
        this.userGroupAttribute = userGroupAttribute;
    }

    public Attribute withUserGroupAttribute(Boolean userGroupAttribute) {
        this.userGroupAttribute = userGroupAttribute;
        return this;
    }

    @JsonProperty("validationRuleAttribute")
    public Optional<Boolean> getValidationRuleAttribute() {
        return Optional.ofNullable(validationRuleAttribute);
    }

    @JsonProperty("validationRuleAttribute")
    public void setValidationRuleAttribute(Boolean validationRuleAttribute) {
        this.validationRuleAttribute = validationRuleAttribute;
    }

    public Attribute withValidationRuleAttribute(Boolean validationRuleAttribute) {
        this.validationRuleAttribute = validationRuleAttribute;
        return this;
    }

    @JsonProperty("validationRuleGroupAttribute")
    public Optional<Boolean> getValidationRuleGroupAttribute() {
        return Optional.ofNullable(validationRuleGroupAttribute);
    }

    @JsonProperty("validationRuleGroupAttribute")
    public void setValidationRuleGroupAttribute(Boolean validationRuleGroupAttribute) {
        this.validationRuleGroupAttribute = validationRuleGroupAttribute;
    }

    public Attribute withValidationRuleGroupAttribute(Boolean validationRuleGroupAttribute) {
        this.validationRuleGroupAttribute = validationRuleGroupAttribute;
        return this;
    }

    @JsonProperty("valueType")
    public Optional<OptionSet.ValueType> getValueType() {
        return Optional.ofNullable(valueType);
    }

    @JsonProperty("valueType")
    public void setValueType(OptionSet.ValueType valueType) {
        this.valueType = valueType;
    }

    public Attribute withValueType(OptionSet.ValueType valueType) {
        this.valueType = valueType;
        return this;
    }

    @JsonProperty("visualizationAttribute")
    public Optional<Boolean> getVisualizationAttribute() {
        return Optional.ofNullable(visualizationAttribute);
    }

    @JsonProperty("visualizationAttribute")
    public void setVisualizationAttribute(Boolean visualizationAttribute) {
        this.visualizationAttribute = visualizationAttribute;
    }

    public Attribute withVisualizationAttribute(Boolean visualizationAttribute) {
        this.visualizationAttribute = visualizationAttribute;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Attribute withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "access":
                if (value instanceof Access) {
                    setAccess(((Access) value));
                } else {
                    throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v2_39_1.Access\", but got "+ value.getClass().toString()));
                }
                return true;
            case "attributeValues":
                if (value instanceof List) {
                    setAttributeValues(((List<AttributeValue> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.AttributeValue>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "categoryAttribute":
                if (value instanceof Boolean) {
                    setCategoryAttribute(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"categoryAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "categoryOptionAttribute":
                if (value instanceof Boolean) {
                    setCategoryOptionAttribute(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"categoryOptionAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "categoryOptionComboAttribute":
                if (value instanceof Boolean) {
                    setCategoryOptionComboAttribute(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"categoryOptionComboAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "categoryOptionGroupAttribute":
                if (value instanceof Boolean) {
                    setCategoryOptionGroupAttribute(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"categoryOptionGroupAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "categoryOptionGroupSetAttribute":
                if (value instanceof Boolean) {
                    setCategoryOptionGroupSetAttribute(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"categoryOptionGroupSetAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "code":
                if (value instanceof String) {
                    setCode(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "constantAttribute":
                if (value instanceof Boolean) {
                    setConstantAttribute(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"constantAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "created":
                if (value instanceof Date) {
                    setCreated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "createdBy":
                if (value instanceof User) {
                    setCreatedBy(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"createdBy\" is of type \"org.hisp.dhis.api.model.v2_39_1.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataElementAttribute":
                if (value instanceof Boolean) {
                    setDataElementAttribute(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataElementAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataElementGroupAttribute":
                if (value instanceof Boolean) {
                    setDataElementGroupAttribute(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataElementGroupAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataElementGroupSetAttribute":
                if (value instanceof Boolean) {
                    setDataElementGroupSetAttribute(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataElementGroupSetAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataSetAttribute":
                if (value instanceof Boolean) {
                    setDataSetAttribute(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataSetAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "description":
                if (value instanceof String) {
                    setDescription(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"description\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayDescription":
                if (value instanceof String) {
                    setDisplayDescription(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayDescription\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayFormName":
                if (value instanceof String) {
                    setDisplayFormName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayFormName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayName":
                if (value instanceof String) {
                    setDisplayName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayShortName":
                if (value instanceof String) {
                    setDisplayShortName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayShortName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "documentAttribute":
                if (value instanceof Boolean) {
                    setDocumentAttribute(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"documentAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "eventChartAttribute":
                if (value instanceof Boolean) {
                    setEventChartAttribute(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"eventChartAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "eventReportAttribute":
                if (value instanceof Boolean) {
                    setEventReportAttribute(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"eventReportAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "externalAccess":
                if (value instanceof Boolean) {
                    setExternalAccess(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "favorite":
                if (value instanceof Boolean) {
                    setFavorite(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "favorites":
                if (value instanceof List) {
                    setFavorites(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "formName":
                if (value instanceof String) {
                    setFormName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"formName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "href":
                if (value instanceof String) {
                    setHref(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "id":
                if (value instanceof String) {
                    setId(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "indicatorAttribute":
                if (value instanceof Boolean) {
                    setIndicatorAttribute(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"indicatorAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "indicatorGroupAttribute":
                if (value instanceof Boolean) {
                    setIndicatorGroupAttribute(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"indicatorGroupAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdated":
                if (value instanceof Date) {
                    setLastUpdated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdatedBy":
                if (value instanceof User) {
                    setLastUpdatedBy(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v2_39_1.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "legendSetAttribute":
                if (value instanceof Boolean) {
                    setLegendSetAttribute(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"legendSetAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "mandatory":
                if (value instanceof Boolean) {
                    setMandatory(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"mandatory\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "mapAttribute":
                if (value instanceof Boolean) {
                    setMapAttribute(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"mapAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "name":
                if (value instanceof String) {
                    setName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "optionAttribute":
                if (value instanceof Boolean) {
                    setOptionAttribute(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"optionAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "optionSet":
                if (value instanceof OptionSet) {
                    setOptionSet(((OptionSet) value));
                } else {
                    throw new IllegalArgumentException(("property \"optionSet\" is of type \"org.hisp.dhis.api.model.v2_39_1.OptionSet\", but got "+ value.getClass().toString()));
                }
                return true;
            case "optionSetAttribute":
                if (value instanceof Boolean) {
                    setOptionSetAttribute(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"optionSetAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "organisationUnitAttribute":
                if (value instanceof Boolean) {
                    setOrganisationUnitAttribute(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"organisationUnitAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "organisationUnitGroupAttribute":
                if (value instanceof Boolean) {
                    setOrganisationUnitGroupAttribute(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"organisationUnitGroupAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "organisationUnitGroupSetAttribute":
                if (value instanceof Boolean) {
                    setOrganisationUnitGroupSetAttribute(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"organisationUnitGroupSetAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "programAttribute":
                if (value instanceof Boolean) {
                    setProgramAttribute(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"programAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "programIndicatorAttribute":
                if (value instanceof Boolean) {
                    setProgramIndicatorAttribute(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"programIndicatorAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "programStageAttribute":
                if (value instanceof Boolean) {
                    setProgramStageAttribute(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"programStageAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "publicAccess":
                if (value instanceof String) {
                    setPublicAccess(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "relationshipTypeAttribute":
                if (value instanceof Boolean) {
                    setRelationshipTypeAttribute(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"relationshipTypeAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "sectionAttribute":
                if (value instanceof Boolean) {
                    setSectionAttribute(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"sectionAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "sharing":
                if (value instanceof Sharing) {
                    setSharing(((Sharing) value));
                } else {
                    throw new IllegalArgumentException(("property \"sharing\" is of type \"org.hisp.dhis.api.model.v2_39_1.Sharing\", but got "+ value.getClass().toString()));
                }
                return true;
            case "shortName":
                if (value instanceof String) {
                    setShortName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"shortName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "sortOrder":
                if (value instanceof Integer) {
                    setSortOrder(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"sortOrder\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "sqlViewAttribute":
                if (value instanceof Boolean) {
                    setSqlViewAttribute(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"sqlViewAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "trackedEntityAttributeAttribute":
                if (value instanceof Boolean) {
                    setTrackedEntityAttributeAttribute(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"trackedEntityAttributeAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "trackedEntityTypeAttribute":
                if (value instanceof Boolean) {
                    setTrackedEntityTypeAttribute(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"trackedEntityTypeAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "translations":
                if (value instanceof List) {
                    setTranslations(((List<Translation> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.Translation>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "unique":
                if (value instanceof Boolean) {
                    setUnique(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"unique\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "user":
                if (value instanceof User) {
                    setUser(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v2_39_1.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userAccesses":
                if (value instanceof List) {
                    setUserAccesses(((List<UserAccess> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.UserAccess>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userAttribute":
                if (value instanceof Boolean) {
                    setUserAttribute(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"userAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userGroupAccesses":
                if (value instanceof List) {
                    setUserGroupAccesses(((List<UserGroupAccess> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.UserGroupAccess>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userGroupAttribute":
                if (value instanceof Boolean) {
                    setUserGroupAttribute(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"userGroupAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "validationRuleAttribute":
                if (value instanceof Boolean) {
                    setValidationRuleAttribute(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"validationRuleAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "validationRuleGroupAttribute":
                if (value instanceof Boolean) {
                    setValidationRuleGroupAttribute(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"validationRuleGroupAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "valueType":
                if (value instanceof OptionSet.ValueType) {
                    setValueType(((OptionSet.ValueType) value));
                } else {
                    throw new IllegalArgumentException(("property \"valueType\" is of type \"org.hisp.dhis.api.model.v2_39_1.OptionSet.ValueType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "visualizationAttribute":
                if (value instanceof Boolean) {
                    setVisualizationAttribute(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"visualizationAttribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "access":
                return getAccess();
            case "attributeValues":
                return getAttributeValues();
            case "categoryAttribute":
                return getCategoryAttribute();
            case "categoryOptionAttribute":
                return getCategoryOptionAttribute();
            case "categoryOptionComboAttribute":
                return getCategoryOptionComboAttribute();
            case "categoryOptionGroupAttribute":
                return getCategoryOptionGroupAttribute();
            case "categoryOptionGroupSetAttribute":
                return getCategoryOptionGroupSetAttribute();
            case "code":
                return getCode();
            case "constantAttribute":
                return getConstantAttribute();
            case "created":
                return getCreated();
            case "createdBy":
                return getCreatedBy();
            case "dataElementAttribute":
                return getDataElementAttribute();
            case "dataElementGroupAttribute":
                return getDataElementGroupAttribute();
            case "dataElementGroupSetAttribute":
                return getDataElementGroupSetAttribute();
            case "dataSetAttribute":
                return getDataSetAttribute();
            case "description":
                return getDescription();
            case "displayDescription":
                return getDisplayDescription();
            case "displayFormName":
                return getDisplayFormName();
            case "displayName":
                return getDisplayName();
            case "displayShortName":
                return getDisplayShortName();
            case "documentAttribute":
                return getDocumentAttribute();
            case "eventChartAttribute":
                return getEventChartAttribute();
            case "eventReportAttribute":
                return getEventReportAttribute();
            case "externalAccess":
                return getExternalAccess();
            case "favorite":
                return getFavorite();
            case "favorites":
                return getFavorites();
            case "formName":
                return getFormName();
            case "href":
                return getHref();
            case "id":
                return getId();
            case "indicatorAttribute":
                return getIndicatorAttribute();
            case "indicatorGroupAttribute":
                return getIndicatorGroupAttribute();
            case "lastUpdated":
                return getLastUpdated();
            case "lastUpdatedBy":
                return getLastUpdatedBy();
            case "legendSetAttribute":
                return getLegendSetAttribute();
            case "mandatory":
                return getMandatory();
            case "mapAttribute":
                return getMapAttribute();
            case "name":
                return getName();
            case "optionAttribute":
                return getOptionAttribute();
            case "optionSet":
                return getOptionSet();
            case "optionSetAttribute":
                return getOptionSetAttribute();
            case "organisationUnitAttribute":
                return getOrganisationUnitAttribute();
            case "organisationUnitGroupAttribute":
                return getOrganisationUnitGroupAttribute();
            case "organisationUnitGroupSetAttribute":
                return getOrganisationUnitGroupSetAttribute();
            case "programAttribute":
                return getProgramAttribute();
            case "programIndicatorAttribute":
                return getProgramIndicatorAttribute();
            case "programStageAttribute":
                return getProgramStageAttribute();
            case "publicAccess":
                return getPublicAccess();
            case "relationshipTypeAttribute":
                return getRelationshipTypeAttribute();
            case "sectionAttribute":
                return getSectionAttribute();
            case "sharing":
                return getSharing();
            case "shortName":
                return getShortName();
            case "sortOrder":
                return getSortOrder();
            case "sqlViewAttribute":
                return getSqlViewAttribute();
            case "trackedEntityAttributeAttribute":
                return getTrackedEntityAttributeAttribute();
            case "trackedEntityTypeAttribute":
                return getTrackedEntityTypeAttribute();
            case "translations":
                return getTranslations();
            case "unique":
                return getUnique();
            case "user":
                return getUser();
            case "userAccesses":
                return getUserAccesses();
            case "userAttribute":
                return getUserAttribute();
            case "userGroupAccesses":
                return getUserGroupAccesses();
            case "userGroupAttribute":
                return getUserGroupAttribute();
            case "validationRuleAttribute":
                return getValidationRuleAttribute();
            case "validationRuleGroupAttribute":
                return getValidationRuleGroupAttribute();
            case "valueType":
                return getValueType();
            case "visualizationAttribute":
                return getVisualizationAttribute();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, Attribute.NOT_FOUND_VALUE);
        if (Attribute.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public Attribute with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Attribute.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("categoryAttribute");
        sb.append('=');
        sb.append(((this.categoryAttribute == null)?"<null>":this.categoryAttribute));
        sb.append(',');
        sb.append("categoryOptionAttribute");
        sb.append('=');
        sb.append(((this.categoryOptionAttribute == null)?"<null>":this.categoryOptionAttribute));
        sb.append(',');
        sb.append("categoryOptionComboAttribute");
        sb.append('=');
        sb.append(((this.categoryOptionComboAttribute == null)?"<null>":this.categoryOptionComboAttribute));
        sb.append(',');
        sb.append("categoryOptionGroupAttribute");
        sb.append('=');
        sb.append(((this.categoryOptionGroupAttribute == null)?"<null>":this.categoryOptionGroupAttribute));
        sb.append(',');
        sb.append("categoryOptionGroupSetAttribute");
        sb.append('=');
        sb.append(((this.categoryOptionGroupSetAttribute == null)?"<null>":this.categoryOptionGroupSetAttribute));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("constantAttribute");
        sb.append('=');
        sb.append(((this.constantAttribute == null)?"<null>":this.constantAttribute));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("createdBy");
        sb.append('=');
        sb.append(((this.createdBy == null)?"<null>":this.createdBy));
        sb.append(',');
        sb.append("dataElementAttribute");
        sb.append('=');
        sb.append(((this.dataElementAttribute == null)?"<null>":this.dataElementAttribute));
        sb.append(',');
        sb.append("dataElementGroupAttribute");
        sb.append('=');
        sb.append(((this.dataElementGroupAttribute == null)?"<null>":this.dataElementGroupAttribute));
        sb.append(',');
        sb.append("dataElementGroupSetAttribute");
        sb.append('=');
        sb.append(((this.dataElementGroupSetAttribute == null)?"<null>":this.dataElementGroupSetAttribute));
        sb.append(',');
        sb.append("dataSetAttribute");
        sb.append('=');
        sb.append(((this.dataSetAttribute == null)?"<null>":this.dataSetAttribute));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("displayDescription");
        sb.append('=');
        sb.append(((this.displayDescription == null)?"<null>":this.displayDescription));
        sb.append(',');
        sb.append("displayFormName");
        sb.append('=');
        sb.append(((this.displayFormName == null)?"<null>":this.displayFormName));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("displayShortName");
        sb.append('=');
        sb.append(((this.displayShortName == null)?"<null>":this.displayShortName));
        sb.append(',');
        sb.append("documentAttribute");
        sb.append('=');
        sb.append(((this.documentAttribute == null)?"<null>":this.documentAttribute));
        sb.append(',');
        sb.append("eventChartAttribute");
        sb.append('=');
        sb.append(((this.eventChartAttribute == null)?"<null>":this.eventChartAttribute));
        sb.append(',');
        sb.append("eventReportAttribute");
        sb.append('=');
        sb.append(((this.eventReportAttribute == null)?"<null>":this.eventReportAttribute));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("formName");
        sb.append('=');
        sb.append(((this.formName == null)?"<null>":this.formName));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("indicatorAttribute");
        sb.append('=');
        sb.append(((this.indicatorAttribute == null)?"<null>":this.indicatorAttribute));
        sb.append(',');
        sb.append("indicatorGroupAttribute");
        sb.append('=');
        sb.append(((this.indicatorGroupAttribute == null)?"<null>":this.indicatorGroupAttribute));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("legendSetAttribute");
        sb.append('=');
        sb.append(((this.legendSetAttribute == null)?"<null>":this.legendSetAttribute));
        sb.append(',');
        sb.append("mandatory");
        sb.append('=');
        sb.append(((this.mandatory == null)?"<null>":this.mandatory));
        sb.append(',');
        sb.append("mapAttribute");
        sb.append('=');
        sb.append(((this.mapAttribute == null)?"<null>":this.mapAttribute));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("optionAttribute");
        sb.append('=');
        sb.append(((this.optionAttribute == null)?"<null>":this.optionAttribute));
        sb.append(',');
        sb.append("optionSet");
        sb.append('=');
        sb.append(((this.optionSet == null)?"<null>":this.optionSet));
        sb.append(',');
        sb.append("optionSetAttribute");
        sb.append('=');
        sb.append(((this.optionSetAttribute == null)?"<null>":this.optionSetAttribute));
        sb.append(',');
        sb.append("organisationUnitAttribute");
        sb.append('=');
        sb.append(((this.organisationUnitAttribute == null)?"<null>":this.organisationUnitAttribute));
        sb.append(',');
        sb.append("organisationUnitGroupAttribute");
        sb.append('=');
        sb.append(((this.organisationUnitGroupAttribute == null)?"<null>":this.organisationUnitGroupAttribute));
        sb.append(',');
        sb.append("organisationUnitGroupSetAttribute");
        sb.append('=');
        sb.append(((this.organisationUnitGroupSetAttribute == null)?"<null>":this.organisationUnitGroupSetAttribute));
        sb.append(',');
        sb.append("programAttribute");
        sb.append('=');
        sb.append(((this.programAttribute == null)?"<null>":this.programAttribute));
        sb.append(',');
        sb.append("programIndicatorAttribute");
        sb.append('=');
        sb.append(((this.programIndicatorAttribute == null)?"<null>":this.programIndicatorAttribute));
        sb.append(',');
        sb.append("programStageAttribute");
        sb.append('=');
        sb.append(((this.programStageAttribute == null)?"<null>":this.programStageAttribute));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("relationshipTypeAttribute");
        sb.append('=');
        sb.append(((this.relationshipTypeAttribute == null)?"<null>":this.relationshipTypeAttribute));
        sb.append(',');
        sb.append("sectionAttribute");
        sb.append('=');
        sb.append(((this.sectionAttribute == null)?"<null>":this.sectionAttribute));
        sb.append(',');
        sb.append("sharing");
        sb.append('=');
        sb.append(((this.sharing == null)?"<null>":this.sharing));
        sb.append(',');
        sb.append("shortName");
        sb.append('=');
        sb.append(((this.shortName == null)?"<null>":this.shortName));
        sb.append(',');
        sb.append("sortOrder");
        sb.append('=');
        sb.append(((this.sortOrder == null)?"<null>":this.sortOrder));
        sb.append(',');
        sb.append("sqlViewAttribute");
        sb.append('=');
        sb.append(((this.sqlViewAttribute == null)?"<null>":this.sqlViewAttribute));
        sb.append(',');
        sb.append("trackedEntityAttributeAttribute");
        sb.append('=');
        sb.append(((this.trackedEntityAttributeAttribute == null)?"<null>":this.trackedEntityAttributeAttribute));
        sb.append(',');
        sb.append("trackedEntityTypeAttribute");
        sb.append('=');
        sb.append(((this.trackedEntityTypeAttribute == null)?"<null>":this.trackedEntityTypeAttribute));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("unique");
        sb.append('=');
        sb.append(((this.unique == null)?"<null>":this.unique));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userAttribute");
        sb.append('=');
        sb.append(((this.userAttribute == null)?"<null>":this.userAttribute));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("userGroupAttribute");
        sb.append('=');
        sb.append(((this.userGroupAttribute == null)?"<null>":this.userGroupAttribute));
        sb.append(',');
        sb.append("validationRuleAttribute");
        sb.append('=');
        sb.append(((this.validationRuleAttribute == null)?"<null>":this.validationRuleAttribute));
        sb.append(',');
        sb.append("validationRuleGroupAttribute");
        sb.append('=');
        sb.append(((this.validationRuleGroupAttribute == null)?"<null>":this.validationRuleGroupAttribute));
        sb.append(',');
        sb.append("valueType");
        sb.append('=');
        sb.append(((this.valueType == null)?"<null>":this.valueType));
        sb.append(',');
        sb.append("visualizationAttribute");
        sb.append('=');
        sb.append(((this.visualizationAttribute == null)?"<null>":this.visualizationAttribute));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.indicatorAttribute == null)? 0 :this.indicatorAttribute.hashCode()));
        result = ((result* 31)+((this.indicatorGroupAttribute == null)? 0 :this.indicatorGroupAttribute.hashCode()));
        result = ((result* 31)+((this.mapAttribute == null)? 0 :this.mapAttribute.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.userGroupAttribute == null)? 0 :this.userGroupAttribute.hashCode()));
        result = ((result* 31)+((this.dataElementAttribute == null)? 0 :this.dataElementAttribute.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.constantAttribute == null)? 0 :this.constantAttribute.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.valueType == null)? 0 :this.valueType.hashCode()));
        result = ((result* 31)+((this.categoryOptionAttribute == null)? 0 :this.categoryOptionAttribute.hashCode()));
        result = ((result* 31)+((this.eventChartAttribute == null)? 0 :this.eventChartAttribute.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.optionSetAttribute == null)? 0 :this.optionSetAttribute.hashCode()));
        result = ((result* 31)+((this.displayDescription == null)? 0 :this.displayDescription.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.sqlViewAttribute == null)? 0 :this.sqlViewAttribute.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.visualizationAttribute == null)? 0 :this.visualizationAttribute.hashCode()));
        result = ((result* 31)+((this.legendSetAttribute == null)? 0 :this.legendSetAttribute.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.sharing == null)? 0 :this.sharing.hashCode()));
        result = ((result* 31)+((this.displayFormName == null)? 0 :this.displayFormName.hashCode()));
        result = ((result* 31)+((this.organisationUnitAttribute == null)? 0 :this.organisationUnitAttribute.hashCode()));
        result = ((result* 31)+((this.trackedEntityAttributeAttribute == null)? 0 :this.trackedEntityAttributeAttribute.hashCode()));
        result = ((result* 31)+((this.dataSetAttribute == null)? 0 :this.dataSetAttribute.hashCode()));
        result = ((result* 31)+((this.documentAttribute == null)? 0 :this.documentAttribute.hashCode()));
        result = ((result* 31)+((this.sortOrder == null)? 0 :this.sortOrder.hashCode()));
        result = ((result* 31)+((this.unique == null)? 0 :this.unique.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.validationRuleGroupAttribute == null)? 0 :this.validationRuleGroupAttribute.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.shortName == null)? 0 :this.shortName.hashCode()));
        result = ((result* 31)+((this.dataElementGroupAttribute == null)? 0 :this.dataElementGroupAttribute.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.sectionAttribute == null)? 0 :this.sectionAttribute.hashCode()));
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.trackedEntityTypeAttribute == null)? 0 :this.trackedEntityTypeAttribute.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.userAttribute == null)? 0 :this.userAttribute.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.categoryOptionGroupAttribute == null)? 0 :this.categoryOptionGroupAttribute.hashCode()));
        result = ((result* 31)+((this.mandatory == null)? 0 :this.mandatory.hashCode()));
        result = ((result* 31)+((this.displayShortName == null)? 0 :this.displayShortName.hashCode()));
        result = ((result* 31)+((this.eventReportAttribute == null)? 0 :this.eventReportAttribute.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.programStageAttribute == null)? 0 :this.programStageAttribute.hashCode()));
        result = ((result* 31)+((this.programAttribute == null)? 0 :this.programAttribute.hashCode()));
        result = ((result* 31)+((this.optionSet == null)? 0 :this.optionSet.hashCode()));
        result = ((result* 31)+((this.categoryAttribute == null)? 0 :this.categoryAttribute.hashCode()));
        result = ((result* 31)+((this.categoryOptionComboAttribute == null)? 0 :this.categoryOptionComboAttribute.hashCode()));
        result = ((result* 31)+((this.formName == null)? 0 :this.formName.hashCode()));
        result = ((result* 31)+((this.categoryOptionGroupSetAttribute == null)? 0 :this.categoryOptionGroupSetAttribute.hashCode()));
        result = ((result* 31)+((this.programIndicatorAttribute == null)? 0 :this.programIndicatorAttribute.hashCode()));
        result = ((result* 31)+((this.validationRuleAttribute == null)? 0 :this.validationRuleAttribute.hashCode()));
        result = ((result* 31)+((this.organisationUnitGroupAttribute == null)? 0 :this.organisationUnitGroupAttribute.hashCode()));
        result = ((result* 31)+((this.dataElementGroupSetAttribute == null)? 0 :this.dataElementGroupSetAttribute.hashCode()));
        result = ((result* 31)+((this.relationshipTypeAttribute == null)? 0 :this.relationshipTypeAttribute.hashCode()));
        result = ((result* 31)+((this.organisationUnitGroupSetAttribute == null)? 0 :this.organisationUnitGroupSetAttribute.hashCode()));
        result = ((result* 31)+((this.createdBy == null)? 0 :this.createdBy.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        result = ((result* 31)+((this.optionAttribute == null)? 0 :this.optionAttribute.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Attribute) == false) {
            return false;
        }
        Attribute rhs = ((Attribute) other);
        return ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((this.indicatorAttribute == rhs.indicatorAttribute)||((this.indicatorAttribute!= null)&&this.indicatorAttribute.equals(rhs.indicatorAttribute)))&&((this.indicatorGroupAttribute == rhs.indicatorGroupAttribute)||((this.indicatorGroupAttribute!= null)&&this.indicatorGroupAttribute.equals(rhs.indicatorGroupAttribute))))&&((this.mapAttribute == rhs.mapAttribute)||((this.mapAttribute!= null)&&this.mapAttribute.equals(rhs.mapAttribute))))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.userGroupAttribute == rhs.userGroupAttribute)||((this.userGroupAttribute!= null)&&this.userGroupAttribute.equals(rhs.userGroupAttribute))))&&((this.dataElementAttribute == rhs.dataElementAttribute)||((this.dataElementAttribute!= null)&&this.dataElementAttribute.equals(rhs.dataElementAttribute))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.constantAttribute == rhs.constantAttribute)||((this.constantAttribute!= null)&&this.constantAttribute.equals(rhs.constantAttribute))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.valueType == rhs.valueType)||((this.valueType!= null)&&this.valueType.equals(rhs.valueType))))&&((this.categoryOptionAttribute == rhs.categoryOptionAttribute)||((this.categoryOptionAttribute!= null)&&this.categoryOptionAttribute.equals(rhs.categoryOptionAttribute))))&&((this.eventChartAttribute == rhs.eventChartAttribute)||((this.eventChartAttribute!= null)&&this.eventChartAttribute.equals(rhs.eventChartAttribute))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.optionSetAttribute == rhs.optionSetAttribute)||((this.optionSetAttribute!= null)&&this.optionSetAttribute.equals(rhs.optionSetAttribute))))&&((this.displayDescription == rhs.displayDescription)||((this.displayDescription!= null)&&this.displayDescription.equals(rhs.displayDescription))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.sqlViewAttribute == rhs.sqlViewAttribute)||((this.sqlViewAttribute!= null)&&this.sqlViewAttribute.equals(rhs.sqlViewAttribute))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.visualizationAttribute == rhs.visualizationAttribute)||((this.visualizationAttribute!= null)&&this.visualizationAttribute.equals(rhs.visualizationAttribute))))&&((this.legendSetAttribute == rhs.legendSetAttribute)||((this.legendSetAttribute!= null)&&this.legendSetAttribute.equals(rhs.legendSetAttribute))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.sharing == rhs.sharing)||((this.sharing!= null)&&this.sharing.equals(rhs.sharing))))&&((this.displayFormName == rhs.displayFormName)||((this.displayFormName!= null)&&this.displayFormName.equals(rhs.displayFormName))))&&((this.organisationUnitAttribute == rhs.organisationUnitAttribute)||((this.organisationUnitAttribute!= null)&&this.organisationUnitAttribute.equals(rhs.organisationUnitAttribute))))&&((this.trackedEntityAttributeAttribute == rhs.trackedEntityAttributeAttribute)||((this.trackedEntityAttributeAttribute!= null)&&this.trackedEntityAttributeAttribute.equals(rhs.trackedEntityAttributeAttribute))))&&((this.dataSetAttribute == rhs.dataSetAttribute)||((this.dataSetAttribute!= null)&&this.dataSetAttribute.equals(rhs.dataSetAttribute))))&&((this.documentAttribute == rhs.documentAttribute)||((this.documentAttribute!= null)&&this.documentAttribute.equals(rhs.documentAttribute))))&&((this.sortOrder == rhs.sortOrder)||((this.sortOrder!= null)&&this.sortOrder.equals(rhs.sortOrder))))&&((this.unique == rhs.unique)||((this.unique!= null)&&this.unique.equals(rhs.unique))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.validationRuleGroupAttribute == rhs.validationRuleGroupAttribute)||((this.validationRuleGroupAttribute!= null)&&this.validationRuleGroupAttribute.equals(rhs.validationRuleGroupAttribute))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.shortName == rhs.shortName)||((this.shortName!= null)&&this.shortName.equals(rhs.shortName))))&&((this.dataElementGroupAttribute == rhs.dataElementGroupAttribute)||((this.dataElementGroupAttribute!= null)&&this.dataElementGroupAttribute.equals(rhs.dataElementGroupAttribute))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.sectionAttribute == rhs.sectionAttribute)||((this.sectionAttribute!= null)&&this.sectionAttribute.equals(rhs.sectionAttribute))))&&((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites))))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.trackedEntityTypeAttribute == rhs.trackedEntityTypeAttribute)||((this.trackedEntityTypeAttribute!= null)&&this.trackedEntityTypeAttribute.equals(rhs.trackedEntityTypeAttribute))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.userAttribute == rhs.userAttribute)||((this.userAttribute!= null)&&this.userAttribute.equals(rhs.userAttribute))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.categoryOptionGroupAttribute == rhs.categoryOptionGroupAttribute)||((this.categoryOptionGroupAttribute!= null)&&this.categoryOptionGroupAttribute.equals(rhs.categoryOptionGroupAttribute))))&&((this.mandatory == rhs.mandatory)||((this.mandatory!= null)&&this.mandatory.equals(rhs.mandatory))))&&((this.displayShortName == rhs.displayShortName)||((this.displayShortName!= null)&&this.displayShortName.equals(rhs.displayShortName))))&&((this.eventReportAttribute == rhs.eventReportAttribute)||((this.eventReportAttribute!= null)&&this.eventReportAttribute.equals(rhs.eventReportAttribute))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.programStageAttribute == rhs.programStageAttribute)||((this.programStageAttribute!= null)&&this.programStageAttribute.equals(rhs.programStageAttribute))))&&((this.programAttribute == rhs.programAttribute)||((this.programAttribute!= null)&&this.programAttribute.equals(rhs.programAttribute))))&&((this.optionSet == rhs.optionSet)||((this.optionSet!= null)&&this.optionSet.equals(rhs.optionSet))))&&((this.categoryAttribute == rhs.categoryAttribute)||((this.categoryAttribute!= null)&&this.categoryAttribute.equals(rhs.categoryAttribute))))&&((this.categoryOptionComboAttribute == rhs.categoryOptionComboAttribute)||((this.categoryOptionComboAttribute!= null)&&this.categoryOptionComboAttribute.equals(rhs.categoryOptionComboAttribute))))&&((this.formName == rhs.formName)||((this.formName!= null)&&this.formName.equals(rhs.formName))))&&((this.categoryOptionGroupSetAttribute == rhs.categoryOptionGroupSetAttribute)||((this.categoryOptionGroupSetAttribute!= null)&&this.categoryOptionGroupSetAttribute.equals(rhs.categoryOptionGroupSetAttribute))))&&((this.programIndicatorAttribute == rhs.programIndicatorAttribute)||((this.programIndicatorAttribute!= null)&&this.programIndicatorAttribute.equals(rhs.programIndicatorAttribute))))&&((this.validationRuleAttribute == rhs.validationRuleAttribute)||((this.validationRuleAttribute!= null)&&this.validationRuleAttribute.equals(rhs.validationRuleAttribute))))&&((this.organisationUnitGroupAttribute == rhs.organisationUnitGroupAttribute)||((this.organisationUnitGroupAttribute!= null)&&this.organisationUnitGroupAttribute.equals(rhs.organisationUnitGroupAttribute))))&&((this.dataElementGroupSetAttribute == rhs.dataElementGroupSetAttribute)||((this.dataElementGroupSetAttribute!= null)&&this.dataElementGroupSetAttribute.equals(rhs.dataElementGroupSetAttribute))))&&((this.relationshipTypeAttribute == rhs.relationshipTypeAttribute)||((this.relationshipTypeAttribute!= null)&&this.relationshipTypeAttribute.equals(rhs.relationshipTypeAttribute))))&&((this.organisationUnitGroupSetAttribute == rhs.organisationUnitGroupSetAttribute)||((this.organisationUnitGroupSetAttribute!= null)&&this.organisationUnitGroupSetAttribute.equals(rhs.organisationUnitGroupSetAttribute))))&&((this.createdBy == rhs.createdBy)||((this.createdBy!= null)&&this.createdBy.equals(rhs.createdBy))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))))&&((this.optionAttribute == rhs.optionAttribute)||((this.optionAttribute!= null)&&this.optionAttribute.equals(rhs.optionAttribute))));
    }

}
