
package org.hisp.dhis.api.model.v2_39_1;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "averageEntrySize",
    "averageEntrySizeHumanReadable",
    "burden",
    "entries",
    "highBurdenEntries",
    "hits",
    "hitsMissesRatio",
    "misses",
    "name",
    "size",
    "sizeHumanReadable"
})
@Generated("jsonschema2pojo")
public class CacheGroupInfo implements Serializable
{

    @JsonProperty("averageEntrySize")
    private Integer averageEntrySize;
    @JsonProperty("averageEntrySizeHumanReadable")
    private String averageEntrySizeHumanReadable;
    @JsonProperty("burden")
    private Double burden;
    @JsonProperty("entries")
    private Integer entries;
    @JsonProperty("highBurdenEntries")
    private Integer highBurdenEntries;
    @JsonProperty("hits")
    private Integer hits;
    @JsonProperty("hitsMissesRatio")
    private Double hitsMissesRatio;
    @JsonProperty("misses")
    private Integer misses;
    @JsonProperty("name")
    private String name;
    @JsonProperty("size")
    private Integer size;
    @JsonProperty("sizeHumanReadable")
    private String sizeHumanReadable;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -3971462196888420760L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public CacheGroupInfo() {
    }

    /**
     * 
     * @param source
     */
    public CacheGroupInfo(CacheGroupInfo source) {
        super();
        this.averageEntrySize = source.averageEntrySize;
        this.averageEntrySizeHumanReadable = source.averageEntrySizeHumanReadable;
        this.burden = source.burden;
        this.entries = source.entries;
        this.highBurdenEntries = source.highBurdenEntries;
        this.hits = source.hits;
        this.hitsMissesRatio = source.hitsMissesRatio;
        this.misses = source.misses;
        this.name = source.name;
        this.size = source.size;
        this.sizeHumanReadable = source.sizeHumanReadable;
    }

    /**
     * 
     * @param hits
     * @param averageEntrySizeHumanReadable
     * @param entries
     * @param highBurdenEntries
     * @param size
     * @param misses
     * @param hitsMissesRatio
     * @param name
     * @param sizeHumanReadable
     * @param averageEntrySize
     * @param burden
     */
    public CacheGroupInfo(Integer averageEntrySize, String averageEntrySizeHumanReadable, Double burden, Integer entries, Integer highBurdenEntries, Integer hits, Double hitsMissesRatio, Integer misses, String name, Integer size, String sizeHumanReadable) {
        super();
        this.averageEntrySize = averageEntrySize;
        this.averageEntrySizeHumanReadable = averageEntrySizeHumanReadable;
        this.burden = burden;
        this.entries = entries;
        this.highBurdenEntries = highBurdenEntries;
        this.hits = hits;
        this.hitsMissesRatio = hitsMissesRatio;
        this.misses = misses;
        this.name = name;
        this.size = size;
        this.sizeHumanReadable = sizeHumanReadable;
    }

    @JsonProperty("averageEntrySize")
    public Optional<Integer> getAverageEntrySize() {
        return Optional.ofNullable(averageEntrySize);
    }

    @JsonProperty("averageEntrySize")
    public void setAverageEntrySize(Integer averageEntrySize) {
        this.averageEntrySize = averageEntrySize;
    }

    public CacheGroupInfo withAverageEntrySize(Integer averageEntrySize) {
        this.averageEntrySize = averageEntrySize;
        return this;
    }

    @JsonProperty("averageEntrySizeHumanReadable")
    public Optional<String> getAverageEntrySizeHumanReadable() {
        return Optional.ofNullable(averageEntrySizeHumanReadable);
    }

    @JsonProperty("averageEntrySizeHumanReadable")
    public void setAverageEntrySizeHumanReadable(String averageEntrySizeHumanReadable) {
        this.averageEntrySizeHumanReadable = averageEntrySizeHumanReadable;
    }

    public CacheGroupInfo withAverageEntrySizeHumanReadable(String averageEntrySizeHumanReadable) {
        this.averageEntrySizeHumanReadable = averageEntrySizeHumanReadable;
        return this;
    }

    @JsonProperty("burden")
    public Optional<Double> getBurden() {
        return Optional.ofNullable(burden);
    }

    @JsonProperty("burden")
    public void setBurden(Double burden) {
        this.burden = burden;
    }

    public CacheGroupInfo withBurden(Double burden) {
        this.burden = burden;
        return this;
    }

    @JsonProperty("entries")
    public Optional<Integer> getEntries() {
        return Optional.ofNullable(entries);
    }

    @JsonProperty("entries")
    public void setEntries(Integer entries) {
        this.entries = entries;
    }

    public CacheGroupInfo withEntries(Integer entries) {
        this.entries = entries;
        return this;
    }

    @JsonProperty("highBurdenEntries")
    public Optional<Integer> getHighBurdenEntries() {
        return Optional.ofNullable(highBurdenEntries);
    }

    @JsonProperty("highBurdenEntries")
    public void setHighBurdenEntries(Integer highBurdenEntries) {
        this.highBurdenEntries = highBurdenEntries;
    }

    public CacheGroupInfo withHighBurdenEntries(Integer highBurdenEntries) {
        this.highBurdenEntries = highBurdenEntries;
        return this;
    }

    @JsonProperty("hits")
    public Optional<Integer> getHits() {
        return Optional.ofNullable(hits);
    }

    @JsonProperty("hits")
    public void setHits(Integer hits) {
        this.hits = hits;
    }

    public CacheGroupInfo withHits(Integer hits) {
        this.hits = hits;
        return this;
    }

    @JsonProperty("hitsMissesRatio")
    public Optional<Double> getHitsMissesRatio() {
        return Optional.ofNullable(hitsMissesRatio);
    }

    @JsonProperty("hitsMissesRatio")
    public void setHitsMissesRatio(Double hitsMissesRatio) {
        this.hitsMissesRatio = hitsMissesRatio;
    }

    public CacheGroupInfo withHitsMissesRatio(Double hitsMissesRatio) {
        this.hitsMissesRatio = hitsMissesRatio;
        return this;
    }

    @JsonProperty("misses")
    public Optional<Integer> getMisses() {
        return Optional.ofNullable(misses);
    }

    @JsonProperty("misses")
    public void setMisses(Integer misses) {
        this.misses = misses;
    }

    public CacheGroupInfo withMisses(Integer misses) {
        this.misses = misses;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public CacheGroupInfo withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("size")
    public Optional<Integer> getSize() {
        return Optional.ofNullable(size);
    }

    @JsonProperty("size")
    public void setSize(Integer size) {
        this.size = size;
    }

    public CacheGroupInfo withSize(Integer size) {
        this.size = size;
        return this;
    }

    @JsonProperty("sizeHumanReadable")
    public Optional<String> getSizeHumanReadable() {
        return Optional.ofNullable(sizeHumanReadable);
    }

    @JsonProperty("sizeHumanReadable")
    public void setSizeHumanReadable(String sizeHumanReadable) {
        this.sizeHumanReadable = sizeHumanReadable;
    }

    public CacheGroupInfo withSizeHumanReadable(String sizeHumanReadable) {
        this.sizeHumanReadable = sizeHumanReadable;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public CacheGroupInfo withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "averageEntrySize":
                if (value instanceof Integer) {
                    setAverageEntrySize(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"averageEntrySize\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "averageEntrySizeHumanReadable":
                if (value instanceof String) {
                    setAverageEntrySizeHumanReadable(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"averageEntrySizeHumanReadable\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "burden":
                if (value instanceof Double) {
                    setBurden(((Double) value));
                } else {
                    throw new IllegalArgumentException(("property \"burden\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                }
                return true;
            case "entries":
                if (value instanceof Integer) {
                    setEntries(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"entries\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "highBurdenEntries":
                if (value instanceof Integer) {
                    setHighBurdenEntries(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"highBurdenEntries\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "hits":
                if (value instanceof Integer) {
                    setHits(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"hits\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "hitsMissesRatio":
                if (value instanceof Double) {
                    setHitsMissesRatio(((Double) value));
                } else {
                    throw new IllegalArgumentException(("property \"hitsMissesRatio\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                }
                return true;
            case "misses":
                if (value instanceof Integer) {
                    setMisses(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"misses\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "name":
                if (value instanceof String) {
                    setName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "size":
                if (value instanceof Integer) {
                    setSize(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"size\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "sizeHumanReadable":
                if (value instanceof String) {
                    setSizeHumanReadable(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"sizeHumanReadable\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "averageEntrySize":
                return getAverageEntrySize();
            case "averageEntrySizeHumanReadable":
                return getAverageEntrySizeHumanReadable();
            case "burden":
                return getBurden();
            case "entries":
                return getEntries();
            case "highBurdenEntries":
                return getHighBurdenEntries();
            case "hits":
                return getHits();
            case "hitsMissesRatio":
                return getHitsMissesRatio();
            case "misses":
                return getMisses();
            case "name":
                return getName();
            case "size":
                return getSize();
            case "sizeHumanReadable":
                return getSizeHumanReadable();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, CacheGroupInfo.NOT_FOUND_VALUE);
        if (CacheGroupInfo.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public CacheGroupInfo with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CacheGroupInfo.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("averageEntrySize");
        sb.append('=');
        sb.append(((this.averageEntrySize == null)?"<null>":this.averageEntrySize));
        sb.append(',');
        sb.append("averageEntrySizeHumanReadable");
        sb.append('=');
        sb.append(((this.averageEntrySizeHumanReadable == null)?"<null>":this.averageEntrySizeHumanReadable));
        sb.append(',');
        sb.append("burden");
        sb.append('=');
        sb.append(((this.burden == null)?"<null>":this.burden));
        sb.append(',');
        sb.append("entries");
        sb.append('=');
        sb.append(((this.entries == null)?"<null>":this.entries));
        sb.append(',');
        sb.append("highBurdenEntries");
        sb.append('=');
        sb.append(((this.highBurdenEntries == null)?"<null>":this.highBurdenEntries));
        sb.append(',');
        sb.append("hits");
        sb.append('=');
        sb.append(((this.hits == null)?"<null>":this.hits));
        sb.append(',');
        sb.append("hitsMissesRatio");
        sb.append('=');
        sb.append(((this.hitsMissesRatio == null)?"<null>":this.hitsMissesRatio));
        sb.append(',');
        sb.append("misses");
        sb.append('=');
        sb.append(((this.misses == null)?"<null>":this.misses));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("size");
        sb.append('=');
        sb.append(((this.size == null)?"<null>":this.size));
        sb.append(',');
        sb.append("sizeHumanReadable");
        sb.append('=');
        sb.append(((this.sizeHumanReadable == null)?"<null>":this.sizeHumanReadable));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.burden == null)? 0 :this.burden.hashCode()));
        result = ((result* 31)+((this.hits == null)? 0 :this.hits.hashCode()));
        result = ((result* 31)+((this.averageEntrySizeHumanReadable == null)? 0 :this.averageEntrySizeHumanReadable.hashCode()));
        result = ((result* 31)+((this.entries == null)? 0 :this.entries.hashCode()));
        result = ((result* 31)+((this.highBurdenEntries == null)? 0 :this.highBurdenEntries.hashCode()));
        result = ((result* 31)+((this.size == null)? 0 :this.size.hashCode()));
        result = ((result* 31)+((this.misses == null)? 0 :this.misses.hashCode()));
        result = ((result* 31)+((this.hitsMissesRatio == null)? 0 :this.hitsMissesRatio.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.sizeHumanReadable == null)? 0 :this.sizeHumanReadable.hashCode()));
        result = ((result* 31)+((this.averageEntrySize == null)? 0 :this.averageEntrySize.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof CacheGroupInfo) == false) {
            return false;
        }
        CacheGroupInfo rhs = ((CacheGroupInfo) other);
        return (((((((((((((this.burden == rhs.burden)||((this.burden!= null)&&this.burden.equals(rhs.burden)))&&((this.hits == rhs.hits)||((this.hits!= null)&&this.hits.equals(rhs.hits))))&&((this.averageEntrySizeHumanReadable == rhs.averageEntrySizeHumanReadable)||((this.averageEntrySizeHumanReadable!= null)&&this.averageEntrySizeHumanReadable.equals(rhs.averageEntrySizeHumanReadable))))&&((this.entries == rhs.entries)||((this.entries!= null)&&this.entries.equals(rhs.entries))))&&((this.highBurdenEntries == rhs.highBurdenEntries)||((this.highBurdenEntries!= null)&&this.highBurdenEntries.equals(rhs.highBurdenEntries))))&&((this.size == rhs.size)||((this.size!= null)&&this.size.equals(rhs.size))))&&((this.misses == rhs.misses)||((this.misses!= null)&&this.misses.equals(rhs.misses))))&&((this.hitsMissesRatio == rhs.hitsMissesRatio)||((this.hitsMissesRatio!= null)&&this.hitsMissesRatio.equals(rhs.hitsMissesRatio))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.sizeHumanReadable == rhs.sizeHumanReadable)||((this.sizeHumanReadable!= null)&&this.sizeHumanReadable.equals(rhs.sizeHumanReadable))))&&((this.averageEntrySize == rhs.averageEntrySize)||((this.averageEntrySize!= null)&&this.averageEntrySize.equals(rhs.averageEntrySize))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))));
    }

}
