
package org.hisp.dhis.api.model.v2_39_1;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "errorReports",
    "responseType"
})
@Generated("jsonschema2pojo")
public class ErrorReportsWebMessageResponse implements Serializable
{

    @JsonProperty("errorReports")
    private List<ErrorReport> errorReports = null;
    @JsonProperty("responseType")
    private String responseType;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -2322159481723730820L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ErrorReportsWebMessageResponse() {
    }

    /**
     * 
     * @param source
     */
    public ErrorReportsWebMessageResponse(ErrorReportsWebMessageResponse source) {
        super();
        this.errorReports = source.errorReports;
        this.responseType = source.responseType;
    }

    /**
     * 
     * @param responseType
     * @param errorReports
     */
    public ErrorReportsWebMessageResponse(List<ErrorReport> errorReports, String responseType) {
        super();
        this.errorReports = errorReports;
        this.responseType = responseType;
    }

    @JsonProperty("errorReports")
    public Optional<List<ErrorReport>> getErrorReports() {
        return Optional.ofNullable(errorReports);
    }

    @JsonProperty("errorReports")
    public void setErrorReports(List<ErrorReport> errorReports) {
        this.errorReports = errorReports;
    }

    public ErrorReportsWebMessageResponse withErrorReports(List<ErrorReport> errorReports) {
        this.errorReports = errorReports;
        return this;
    }

    @JsonProperty("responseType")
    public Optional<String> getResponseType() {
        return Optional.ofNullable(responseType);
    }

    @JsonProperty("responseType")
    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    public ErrorReportsWebMessageResponse withResponseType(String responseType) {
        this.responseType = responseType;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ErrorReportsWebMessageResponse withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "errorReports":
                if (value instanceof List) {
                    setErrorReports(((List<ErrorReport> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"errorReports\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.ErrorReport>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "responseType":
                if (value instanceof String) {
                    setResponseType(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"responseType\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "errorReports":
                return getErrorReports();
            case "responseType":
                return getResponseType();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ErrorReportsWebMessageResponse.NOT_FOUND_VALUE);
        if (ErrorReportsWebMessageResponse.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ErrorReportsWebMessageResponse with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ErrorReportsWebMessageResponse.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("errorReports");
        sb.append('=');
        sb.append(((this.errorReports == null)?"<null>":this.errorReports));
        sb.append(',');
        sb.append("responseType");
        sb.append('=');
        sb.append(((this.responseType == null)?"<null>":this.responseType));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.responseType == null)? 0 :this.responseType.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.errorReports == null)? 0 :this.errorReports.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ErrorReportsWebMessageResponse) == false) {
            return false;
        }
        ErrorReportsWebMessageResponse rhs = ((ErrorReportsWebMessageResponse) other);
        return ((((this.responseType == rhs.responseType)||((this.responseType!= null)&&this.responseType.equals(rhs.responseType)))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.errorReports == rhs.errorReports)||((this.errorReports!= null)&&this.errorReports.equals(rhs.errorReports))));
    }

}
