
package org.hisp.dhis.api.model.v2_39_1;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "alias",
    "attribute",
    "name",
    "propertyPath",
    "transformation",
    "transformationArgument",
    "translate"
})
@Generated("jsonschema2pojo")
public class Field implements Serializable
{

    @JsonProperty("alias")
    private String alias;
    @JsonProperty("attribute")
    private Boolean attribute;
    @JsonProperty("name")
    private String name;
    @JsonProperty("propertyPath")
    private String propertyPath;
    @JsonProperty("transformation")
    private Field.Transform transformation;
    @JsonProperty("transformationArgument")
    private String transformationArgument;
    @JsonProperty("translate")
    private Boolean translate;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -6521993928909487677L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Field() {
    }

    /**
     * 
     * @param source
     */
    public Field(Field source) {
        super();
        this.alias = source.alias;
        this.attribute = source.attribute;
        this.name = source.name;
        this.propertyPath = source.propertyPath;
        this.transformation = source.transformation;
        this.transformationArgument = source.transformationArgument;
        this.translate = source.translate;
    }

    /**
     * 
     * @param transformationArgument
     * @param name
     * @param alias
     * @param attribute
     * @param propertyPath
     * @param transformation
     * @param translate
     */
    public Field(String alias, Boolean attribute, String name, String propertyPath, Field.Transform transformation, String transformationArgument, Boolean translate) {
        super();
        this.alias = alias;
        this.attribute = attribute;
        this.name = name;
        this.propertyPath = propertyPath;
        this.transformation = transformation;
        this.transformationArgument = transformationArgument;
        this.translate = translate;
    }

    @JsonProperty("alias")
    public Optional<String> getAlias() {
        return Optional.ofNullable(alias);
    }

    @JsonProperty("alias")
    public void setAlias(String alias) {
        this.alias = alias;
    }

    public Field withAlias(String alias) {
        this.alias = alias;
        return this;
    }

    @JsonProperty("attribute")
    public Optional<Boolean> getAttribute() {
        return Optional.ofNullable(attribute);
    }

    @JsonProperty("attribute")
    public void setAttribute(Boolean attribute) {
        this.attribute = attribute;
    }

    public Field withAttribute(Boolean attribute) {
        this.attribute = attribute;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public Field withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("propertyPath")
    public Optional<String> getPropertyPath() {
        return Optional.ofNullable(propertyPath);
    }

    @JsonProperty("propertyPath")
    public void setPropertyPath(String propertyPath) {
        this.propertyPath = propertyPath;
    }

    public Field withPropertyPath(String propertyPath) {
        this.propertyPath = propertyPath;
        return this;
    }

    @JsonProperty("transformation")
    public Optional<Field.Transform> getTransformation() {
        return Optional.ofNullable(transformation);
    }

    @JsonProperty("transformation")
    public void setTransformation(Field.Transform transformation) {
        this.transformation = transformation;
    }

    public Field withTransformation(Field.Transform transformation) {
        this.transformation = transformation;
        return this;
    }

    @JsonProperty("transformationArgument")
    public Optional<String> getTransformationArgument() {
        return Optional.ofNullable(transformationArgument);
    }

    @JsonProperty("transformationArgument")
    public void setTransformationArgument(String transformationArgument) {
        this.transformationArgument = transformationArgument;
    }

    public Field withTransformationArgument(String transformationArgument) {
        this.transformationArgument = transformationArgument;
        return this;
    }

    @JsonProperty("translate")
    public Optional<Boolean> getTranslate() {
        return Optional.ofNullable(translate);
    }

    @JsonProperty("translate")
    public void setTranslate(Boolean translate) {
        this.translate = translate;
    }

    public Field withTranslate(Boolean translate) {
        this.translate = translate;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Field withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "alias":
                if (value instanceof String) {
                    setAlias(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"alias\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "attribute":
                if (value instanceof Boolean) {
                    setAttribute(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"attribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "name":
                if (value instanceof String) {
                    setName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "propertyPath":
                if (value instanceof String) {
                    setPropertyPath(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"propertyPath\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "transformation":
                if (value instanceof Field.Transform) {
                    setTransformation(((Field.Transform) value));
                } else {
                    throw new IllegalArgumentException(("property \"transformation\" is of type \"org.hisp.dhis.api.model.v2_39_1.Field.Transform\", but got "+ value.getClass().toString()));
                }
                return true;
            case "transformationArgument":
                if (value instanceof String) {
                    setTransformationArgument(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"transformationArgument\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "translate":
                if (value instanceof Boolean) {
                    setTranslate(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"translate\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "alias":
                return getAlias();
            case "attribute":
                return getAttribute();
            case "name":
                return getName();
            case "propertyPath":
                return getPropertyPath();
            case "transformation":
                return getTransformation();
            case "transformationArgument":
                return getTransformationArgument();
            case "translate":
                return getTranslate();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, Field.NOT_FOUND_VALUE);
        if (Field.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public Field with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Field.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("alias");
        sb.append('=');
        sb.append(((this.alias == null)?"<null>":this.alias));
        sb.append(',');
        sb.append("attribute");
        sb.append('=');
        sb.append(((this.attribute == null)?"<null>":this.attribute));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("propertyPath");
        sb.append('=');
        sb.append(((this.propertyPath == null)?"<null>":this.propertyPath));
        sb.append(',');
        sb.append("transformation");
        sb.append('=');
        sb.append(((this.transformation == null)?"<null>":this.transformation));
        sb.append(',');
        sb.append("transformationArgument");
        sb.append('=');
        sb.append(((this.transformationArgument == null)?"<null>":this.transformationArgument));
        sb.append(',');
        sb.append("translate");
        sb.append('=');
        sb.append(((this.translate == null)?"<null>":this.translate));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.transformationArgument == null)? 0 :this.transformationArgument.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.alias == null)? 0 :this.alias.hashCode()));
        result = ((result* 31)+((this.attribute == null)? 0 :this.attribute.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.propertyPath == null)? 0 :this.propertyPath.hashCode()));
        result = ((result* 31)+((this.transformation == null)? 0 :this.transformation.hashCode()));
        result = ((result* 31)+((this.translate == null)? 0 :this.translate.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Field) == false) {
            return false;
        }
        Field rhs = ((Field) other);
        return (((((((((this.transformationArgument == rhs.transformationArgument)||((this.transformationArgument!= null)&&this.transformationArgument.equals(rhs.transformationArgument)))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.alias == rhs.alias)||((this.alias!= null)&&this.alias.equals(rhs.alias))))&&((this.attribute == rhs.attribute)||((this.attribute!= null)&&this.attribute.equals(rhs.attribute))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.propertyPath == rhs.propertyPath)||((this.propertyPath!= null)&&this.propertyPath.equals(rhs.propertyPath))))&&((this.transformation == rhs.transformation)||((this.transformation!= null)&&this.transformation.equals(rhs.transformation))))&&((this.translate == rhs.translate)||((this.translate!= null)&&this.translate.equals(rhs.translate))));
    }

    @Generated("jsonschema2pojo")
    public enum Transform {

        AUTO("AUTO"),
        NONE("NONE"),
        IS_EMPTY("IS_EMPTY"),
        IS_NOT_EMPTY("IS_NOT_EMPTY"),
        SIZE("SIZE"),
        MEMBER("MEMBER"),
        NOT_MEMBER("NOT_MEMBER"),
        IDS("IDS"),
        ID_OBJECTS("ID_OBJECTS"),
        PLUCK("PLUCK"),
        FROM("FROM");
        private final String value;
        private final static Map<String, Field.Transform> CONSTANTS = new HashMap<String, Field.Transform>();

        static {
            for (Field.Transform c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        Transform(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Field.Transform fromValue(String value) {
            Field.Transform constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
