
package org.hisp.dhis.api.model.v2_39_1;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "attributeValue",
    "idScheme",
    "identifier"
})
@Generated("jsonschema2pojo")
public class MetadataIdentifier implements Serializable
{

    @JsonProperty("attributeValue")
    private String attributeValue;
    @JsonProperty("idScheme")
    private MetadataIdentifier.TrackerIdScheme idScheme;
    @JsonProperty("identifier")
    private String identifier;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 536836302444191147L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public MetadataIdentifier() {
    }

    /**
     * 
     * @param source
     */
    public MetadataIdentifier(MetadataIdentifier source) {
        super();
        this.attributeValue = source.attributeValue;
        this.idScheme = source.idScheme;
        this.identifier = source.identifier;
    }

    /**
     * 
     * @param idScheme
     * @param identifier
     * @param attributeValue
     */
    public MetadataIdentifier(String attributeValue, MetadataIdentifier.TrackerIdScheme idScheme, String identifier) {
        super();
        this.attributeValue = attributeValue;
        this.idScheme = idScheme;
        this.identifier = identifier;
    }

    @JsonProperty("attributeValue")
    public Optional<String> getAttributeValue() {
        return Optional.ofNullable(attributeValue);
    }

    @JsonProperty("attributeValue")
    public void setAttributeValue(String attributeValue) {
        this.attributeValue = attributeValue;
    }

    public MetadataIdentifier withAttributeValue(String attributeValue) {
        this.attributeValue = attributeValue;
        return this;
    }

    @JsonProperty("idScheme")
    public Optional<MetadataIdentifier.TrackerIdScheme> getIdScheme() {
        return Optional.ofNullable(idScheme);
    }

    @JsonProperty("idScheme")
    public void setIdScheme(MetadataIdentifier.TrackerIdScheme idScheme) {
        this.idScheme = idScheme;
    }

    public MetadataIdentifier withIdScheme(MetadataIdentifier.TrackerIdScheme idScheme) {
        this.idScheme = idScheme;
        return this;
    }

    @JsonProperty("identifier")
    public Optional<String> getIdentifier() {
        return Optional.ofNullable(identifier);
    }

    @JsonProperty("identifier")
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public MetadataIdentifier withIdentifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public MetadataIdentifier withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "attributeValue":
                if (value instanceof String) {
                    setAttributeValue(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeValue\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "idScheme":
                if (value instanceof MetadataIdentifier.TrackerIdScheme) {
                    setIdScheme(((MetadataIdentifier.TrackerIdScheme) value));
                } else {
                    throw new IllegalArgumentException(("property \"idScheme\" is of type \"org.hisp.dhis.api.model.v2_39_1.MetadataIdentifier.TrackerIdScheme\", but got "+ value.getClass().toString()));
                }
                return true;
            case "identifier":
                if (value instanceof String) {
                    setIdentifier(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"identifier\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "attributeValue":
                return getAttributeValue();
            case "idScheme":
                return getIdScheme();
            case "identifier":
                return getIdentifier();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, MetadataIdentifier.NOT_FOUND_VALUE);
        if (MetadataIdentifier.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public MetadataIdentifier with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(MetadataIdentifier.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("attributeValue");
        sb.append('=');
        sb.append(((this.attributeValue == null)?"<null>":this.attributeValue));
        sb.append(',');
        sb.append("idScheme");
        sb.append('=');
        sb.append(((this.idScheme == null)?"<null>":this.idScheme));
        sb.append(',');
        sb.append("identifier");
        sb.append('=');
        sb.append(((this.identifier == null)?"<null>":this.identifier));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.idScheme == null)? 0 :this.idScheme.hashCode()));
        result = ((result* 31)+((this.identifier == null)? 0 :this.identifier.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.attributeValue == null)? 0 :this.attributeValue.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof MetadataIdentifier) == false) {
            return false;
        }
        MetadataIdentifier rhs = ((MetadataIdentifier) other);
        return (((((this.idScheme == rhs.idScheme)||((this.idScheme!= null)&&this.idScheme.equals(rhs.idScheme)))&&((this.identifier == rhs.identifier)||((this.identifier!= null)&&this.identifier.equals(rhs.identifier))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.attributeValue == rhs.attributeValue)||((this.attributeValue!= null)&&this.attributeValue.equals(rhs.attributeValue))));
    }

    @Generated("jsonschema2pojo")
    public enum TrackerIdScheme {

        UID("UID"),
        CODE("CODE"),
        NAME("NAME"),
        ATTRIBUTE("ATTRIBUTE");
        private final String value;
        private final static Map<String, MetadataIdentifier.TrackerIdScheme> CONSTANTS = new HashMap<String, MetadataIdentifier.TrackerIdScheme>();

        static {
            for (MetadataIdentifier.TrackerIdScheme c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        TrackerIdScheme(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static MetadataIdentifier.TrackerIdScheme fromValue(String value) {
            MetadataIdentifier.TrackerIdScheme constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
