
package org.hisp.dhis.api.model.v2_39_1;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "axis",
    "dimensionItem",
    "type"
})
@Generated("jsonschema2pojo")
public class Series implements Serializable
{

    @JsonProperty("axis")
    private Integer axis;
    @JsonProperty("dimensionItem")
    private String dimensionItem;
    @JsonProperty("type")
    private Series.VisualizationType type;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 8526984385223888490L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Series() {
    }

    /**
     * 
     * @param source
     */
    public Series(Series source) {
        super();
        this.axis = source.axis;
        this.dimensionItem = source.dimensionItem;
        this.type = source.type;
    }

    /**
     * 
     * @param dimensionItem
     * @param axis
     * @param type
     */
    public Series(Integer axis, String dimensionItem, Series.VisualizationType type) {
        super();
        this.axis = axis;
        this.dimensionItem = dimensionItem;
        this.type = type;
    }

    @JsonProperty("axis")
    public Optional<Integer> getAxis() {
        return Optional.ofNullable(axis);
    }

    @JsonProperty("axis")
    public void setAxis(Integer axis) {
        this.axis = axis;
    }

    public Series withAxis(Integer axis) {
        this.axis = axis;
        return this;
    }

    @JsonProperty("dimensionItem")
    public Optional<String> getDimensionItem() {
        return Optional.ofNullable(dimensionItem);
    }

    @JsonProperty("dimensionItem")
    public void setDimensionItem(String dimensionItem) {
        this.dimensionItem = dimensionItem;
    }

    public Series withDimensionItem(String dimensionItem) {
        this.dimensionItem = dimensionItem;
        return this;
    }

    @JsonProperty("type")
    public Optional<Series.VisualizationType> getType() {
        return Optional.ofNullable(type);
    }

    @JsonProperty("type")
    public void setType(Series.VisualizationType type) {
        this.type = type;
    }

    public Series withType(Series.VisualizationType type) {
        this.type = type;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Series withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "axis":
                if (value instanceof Integer) {
                    setAxis(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"axis\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dimensionItem":
                if (value instanceof String) {
                    setDimensionItem(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"dimensionItem\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "type":
                if (value instanceof Series.VisualizationType) {
                    setType(((Series.VisualizationType) value));
                } else {
                    throw new IllegalArgumentException(("property \"type\" is of type \"org.hisp.dhis.api.model.v2_39_1.Series.VisualizationType\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "axis":
                return getAxis();
            case "dimensionItem":
                return getDimensionItem();
            case "type":
                return getType();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, Series.NOT_FOUND_VALUE);
        if (Series.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public Series with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Series.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("axis");
        sb.append('=');
        sb.append(((this.axis == null)?"<null>":this.axis));
        sb.append(',');
        sb.append("dimensionItem");
        sb.append('=');
        sb.append(((this.dimensionItem == null)?"<null>":this.dimensionItem));
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(((this.type == null)?"<null>":this.type));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.axis == null)? 0 :this.axis.hashCode()));
        result = ((result* 31)+((this.dimensionItem == null)? 0 :this.dimensionItem.hashCode()));
        result = ((result* 31)+((this.type == null)? 0 :this.type.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Series) == false) {
            return false;
        }
        Series rhs = ((Series) other);
        return (((((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties)))&&((this.axis == rhs.axis)||((this.axis!= null)&&this.axis.equals(rhs.axis))))&&((this.dimensionItem == rhs.dimensionItem)||((this.dimensionItem!= null)&&this.dimensionItem.equals(rhs.dimensionItem))))&&((this.type == rhs.type)||((this.type!= null)&&this.type.equals(rhs.type))));
    }

    @Generated("jsonschema2pojo")
    public enum VisualizationType {

        COLUMN("COLUMN"),
        STACKED_COLUMN("STACKED_COLUMN"),
        BAR("BAR"),
        STACKED_BAR("STACKED_BAR"),
        LINE("LINE"),
        AREA("AREA"),
        STACKED_AREA("STACKED_AREA"),
        PIE("PIE"),
        RADAR("RADAR"),
        GAUGE("GAUGE"),
        YEAR_OVER_YEAR_LINE("YEAR_OVER_YEAR_LINE"),
        YEAR_OVER_YEAR_COLUMN("YEAR_OVER_YEAR_COLUMN"),
        SCATTER("SCATTER"),
        BUBBLE("BUBBLE"),
        SINGLE_VALUE("SINGLE_VALUE"),
        PIVOT_TABLE("PIVOT_TABLE");
        private final String value;
        private final static Map<String, Series.VisualizationType> CONSTANTS = new HashMap<String, Series.VisualizationType>();

        static {
            for (Series.VisualizationType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        VisualizationType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Series.VisualizationType fromValue(String value) {
            Series.VisualizationType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
