
package org.hisp.dhis.api.model.v2_39_1;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "params",
    "requests"
})
@Generated("jsonschema2pojo")
public class Source implements Serializable
{

    @JsonProperty("params")
    private SourceParams params;
    @JsonProperty("requests")
    private List<SourceRequest> requests = null;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 7932626319759747415L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Source() {
    }

    /**
     * 
     * @param source
     */
    public Source(Source source) {
        super();
        this.params = source.params;
        this.requests = source.requests;
    }

    /**
     * 
     * @param requests
     * @param params
     */
    public Source(SourceParams params, List<SourceRequest> requests) {
        super();
        this.params = params;
        this.requests = requests;
    }

    @JsonProperty("params")
    public Optional<SourceParams> getParams() {
        return Optional.ofNullable(params);
    }

    @JsonProperty("params")
    public void setParams(SourceParams params) {
        this.params = params;
    }

    public Source withParams(SourceParams params) {
        this.params = params;
        return this;
    }

    @JsonProperty("requests")
    public Optional<List<SourceRequest>> getRequests() {
        return Optional.ofNullable(requests);
    }

    @JsonProperty("requests")
    public void setRequests(List<SourceRequest> requests) {
        this.requests = requests;
    }

    public Source withRequests(List<SourceRequest> requests) {
        this.requests = requests;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Source withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "params":
                if (value instanceof SourceParams) {
                    setParams(((SourceParams) value));
                } else {
                    throw new IllegalArgumentException(("property \"params\" is of type \"org.hisp.dhis.api.model.v2_39_1.SourceParams\", but got "+ value.getClass().toString()));
                }
                return true;
            case "requests":
                if (value instanceof List) {
                    setRequests(((List<SourceRequest> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"requests\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.SourceRequest>\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "params":
                return getParams();
            case "requests":
                return getRequests();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, Source.NOT_FOUND_VALUE);
        if (Source.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public Source with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Source.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("params");
        sb.append('=');
        sb.append(((this.params == null)?"<null>":this.params));
        sb.append(',');
        sb.append("requests");
        sb.append('=');
        sb.append(((this.requests == null)?"<null>":this.requests));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.requests == null)? 0 :this.requests.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.params == null)? 0 :this.params.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Source) == false) {
            return false;
        }
        Source rhs = ((Source) other);
        return ((((this.requests == rhs.requests)||((this.requests!= null)&&this.requests.equals(rhs.requests)))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.params == rhs.params)||((this.params!= null)&&this.params.equals(rhs.params))));
    }

}
