
package org.hisp.dhis.api.model.v2_39_1;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "displayName",
    "userUid"
})
@Generated("jsonschema2pojo")
public class UserAccess implements Serializable
{

    @JsonProperty("access")
    private String access;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("userUid")
    private String userUid;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -6549851830116650794L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public UserAccess() {
    }

    /**
     * 
     * @param source
     */
    public UserAccess(UserAccess source) {
        super();
        this.access = source.access;
        this.displayName = source.displayName;
        this.userUid = source.userUid;
    }

    /**
     * 
     * @param access
     * @param displayName
     * @param userUid
     */
    public UserAccess(String access, String displayName, String userUid) {
        super();
        this.access = access;
        this.displayName = displayName;
        this.userUid = userUid;
    }

    @JsonProperty("access")
    public Optional<String> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(String access) {
        this.access = access;
    }

    public UserAccess withAccess(String access) {
        this.access = access;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public UserAccess withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("userUid")
    public Optional<String> getUserUid() {
        return Optional.ofNullable(userUid);
    }

    @JsonProperty("userUid")
    public void setUserUid(String userUid) {
        this.userUid = userUid;
    }

    public UserAccess withUserUid(String userUid) {
        this.userUid = userUid;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public UserAccess withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "access":
                if (value instanceof String) {
                    setAccess(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"access\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayName":
                if (value instanceof String) {
                    setDisplayName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userUid":
                if (value instanceof String) {
                    setUserUid(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"userUid\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "access":
                return getAccess();
            case "displayName":
                return getDisplayName();
            case "userUid":
                return getUserUid();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, UserAccess.NOT_FOUND_VALUE);
        if (UserAccess.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public UserAccess with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(UserAccess.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("userUid");
        sb.append('=');
        sb.append(((this.userUid == null)?"<null>":this.userUid));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.userUid == null)? 0 :this.userUid.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof UserAccess) == false) {
            return false;
        }
        UserAccess rhs = ((UserAccess) other);
        return (((((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access)))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.userUid == rhs.userUid)||((this.userUid!= null)&&this.userUid.equals(rhs.userUid))));
    }

}
