
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "created",
    "demoUrl",
    "downloadUrl",
    "id",
    "lastUpdated",
    "maxDhisVersion",
    "minDhisVersion",
    "version"
})
@Generated("jsonschema2pojo")
public class AppVersion implements Serializable
{

    @JsonProperty("created")
    private Date created;
    @JsonProperty("demoUrl")
    private String demoUrl;
    @JsonProperty("downloadUrl")
    private String downloadUrl;
    @JsonProperty("id")
    private String id;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    @JsonProperty("maxDhisVersion")
    private String maxDhisVersion;
    @JsonProperty("minDhisVersion")
    private String minDhisVersion;
    @JsonProperty("version")
    private String version;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 2734040791610151746L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public AppVersion() {
    }

    /**
     * 
     * @param source
     */
    public AppVersion(AppVersion source) {
        super();
        this.created = source.created;
        this.demoUrl = source.demoUrl;
        this.downloadUrl = source.downloadUrl;
        this.id = source.id;
        this.lastUpdated = source.lastUpdated;
        this.maxDhisVersion = source.maxDhisVersion;
        this.minDhisVersion = source.minDhisVersion;
        this.version = source.version;
    }

    /**
     * 
     * @param demoUrl
     * @param lastUpdated
     * @param maxDhisVersion
     * @param minDhisVersion
     * @param created
     * @param downloadUrl
     * @param id
     * @param version
     */
    public AppVersion(Date created, String demoUrl, String downloadUrl, String id, Date lastUpdated, String maxDhisVersion, String minDhisVersion, String version) {
        super();
        this.created = created;
        this.demoUrl = demoUrl;
        this.downloadUrl = downloadUrl;
        this.id = id;
        this.lastUpdated = lastUpdated;
        this.maxDhisVersion = maxDhisVersion;
        this.minDhisVersion = minDhisVersion;
        this.version = version;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public AppVersion withCreated(Date created) {
        this.created = created;
        return this;
    }

    @JsonProperty("demoUrl")
    public Optional<String> getDemoUrl() {
        return Optional.ofNullable(demoUrl);
    }

    @JsonProperty("demoUrl")
    public void setDemoUrl(String demoUrl) {
        this.demoUrl = demoUrl;
    }

    public AppVersion withDemoUrl(String demoUrl) {
        this.demoUrl = demoUrl;
        return this;
    }

    @JsonProperty("downloadUrl")
    public Optional<String> getDownloadUrl() {
        return Optional.ofNullable(downloadUrl);
    }

    @JsonProperty("downloadUrl")
    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public AppVersion withDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public AppVersion withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public AppVersion withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @JsonProperty("maxDhisVersion")
    public Optional<String> getMaxDhisVersion() {
        return Optional.ofNullable(maxDhisVersion);
    }

    @JsonProperty("maxDhisVersion")
    public void setMaxDhisVersion(String maxDhisVersion) {
        this.maxDhisVersion = maxDhisVersion;
    }

    public AppVersion withMaxDhisVersion(String maxDhisVersion) {
        this.maxDhisVersion = maxDhisVersion;
        return this;
    }

    @JsonProperty("minDhisVersion")
    public Optional<String> getMinDhisVersion() {
        return Optional.ofNullable(minDhisVersion);
    }

    @JsonProperty("minDhisVersion")
    public void setMinDhisVersion(String minDhisVersion) {
        this.minDhisVersion = minDhisVersion;
    }

    public AppVersion withMinDhisVersion(String minDhisVersion) {
        this.minDhisVersion = minDhisVersion;
        return this;
    }

    @JsonProperty("version")
    public Optional<String> getVersion() {
        return Optional.ofNullable(version);
    }

    @JsonProperty("version")
    public void setVersion(String version) {
        this.version = version;
    }

    public AppVersion withVersion(String version) {
        this.version = version;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public AppVersion withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "created":
                if (value instanceof Date) {
                    setCreated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "demoUrl":
                if (value instanceof String) {
                    setDemoUrl(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"demoUrl\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "downloadUrl":
                if (value instanceof String) {
                    setDownloadUrl(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"downloadUrl\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "id":
                if (value instanceof String) {
                    setId(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdated":
                if (value instanceof Date) {
                    setLastUpdated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "maxDhisVersion":
                if (value instanceof String) {
                    setMaxDhisVersion(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"maxDhisVersion\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "minDhisVersion":
                if (value instanceof String) {
                    setMinDhisVersion(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"minDhisVersion\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "version":
                if (value instanceof String) {
                    setVersion(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"version\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "created":
                return getCreated();
            case "demoUrl":
                return getDemoUrl();
            case "downloadUrl":
                return getDownloadUrl();
            case "id":
                return getId();
            case "lastUpdated":
                return getLastUpdated();
            case "maxDhisVersion":
                return getMaxDhisVersion();
            case "minDhisVersion":
                return getMinDhisVersion();
            case "version":
                return getVersion();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, AppVersion.NOT_FOUND_VALUE);
        if (AppVersion.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public AppVersion with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(AppVersion.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("demoUrl");
        sb.append('=');
        sb.append(((this.demoUrl == null)?"<null>":this.demoUrl));
        sb.append(',');
        sb.append("downloadUrl");
        sb.append('=');
        sb.append(((this.downloadUrl == null)?"<null>":this.downloadUrl));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("maxDhisVersion");
        sb.append('=');
        sb.append(((this.maxDhisVersion == null)?"<null>":this.maxDhisVersion));
        sb.append(',');
        sb.append("minDhisVersion");
        sb.append('=');
        sb.append(((this.minDhisVersion == null)?"<null>":this.minDhisVersion));
        sb.append(',');
        sb.append("version");
        sb.append('=');
        sb.append(((this.version == null)?"<null>":this.version));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.demoUrl == null)? 0 :this.demoUrl.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.maxDhisVersion == null)? 0 :this.maxDhisVersion.hashCode()));
        result = ((result* 31)+((this.minDhisVersion == null)? 0 :this.minDhisVersion.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.downloadUrl == null)? 0 :this.downloadUrl.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.version == null)? 0 :this.version.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof AppVersion) == false) {
            return false;
        }
        AppVersion rhs = ((AppVersion) other);
        return ((((((((((this.demoUrl == rhs.demoUrl)||((this.demoUrl!= null)&&this.demoUrl.equals(rhs.demoUrl)))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.maxDhisVersion == rhs.maxDhisVersion)||((this.maxDhisVersion!= null)&&this.maxDhisVersion.equals(rhs.maxDhisVersion))))&&((this.minDhisVersion == rhs.minDhisVersion)||((this.minDhisVersion!= null)&&this.minDhisVersion.equals(rhs.minDhisVersion))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.downloadUrl == rhs.downloadUrl)||((this.downloadUrl!= null)&&this.downloadUrl.equals(rhs.downloadUrl))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.version == rhs.version)||((this.version!= null)&&this.version.equals(rhs.version))));
    }

}
