
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "approvals",
    "ds",
    "pe",
    "wf"
})
@Generated("jsonschema2pojo")
public class ApprovalsDto implements Serializable
{

    @JsonProperty("approvals")
    private List<ApprovalDto> approvals = null;
    @JsonProperty("ds")
    private List<String> ds = null;
    @JsonProperty("pe")
    private List<String> pe = null;
    @JsonProperty("wf")
    private List<String> wf = null;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -548844863151743367L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ApprovalsDto() {
    }

    /**
     * 
     * @param source
     */
    public ApprovalsDto(ApprovalsDto source) {
        super();
        this.approvals = source.approvals;
        this.ds = source.ds;
        this.pe = source.pe;
        this.wf = source.wf;
    }

    /**
     * 
     * @param pe
     * @param approvals
     * @param ds
     * @param wf
     */
    public ApprovalsDto(List<ApprovalDto> approvals, List<String> ds, List<String> pe, List<String> wf) {
        super();
        this.approvals = approvals;
        this.ds = ds;
        this.pe = pe;
        this.wf = wf;
    }

    @JsonProperty("approvals")
    public Optional<List<ApprovalDto>> getApprovals() {
        return Optional.ofNullable(approvals);
    }

    @JsonProperty("approvals")
    public void setApprovals(List<ApprovalDto> approvals) {
        this.approvals = approvals;
    }

    public ApprovalsDto withApprovals(List<ApprovalDto> approvals) {
        this.approvals = approvals;
        return this;
    }

    @JsonProperty("ds")
    public Optional<List<String>> getDs() {
        return Optional.ofNullable(ds);
    }

    @JsonProperty("ds")
    public void setDs(List<String> ds) {
        this.ds = ds;
    }

    public ApprovalsDto withDs(List<String> ds) {
        this.ds = ds;
        return this;
    }

    @JsonProperty("pe")
    public Optional<List<String>> getPe() {
        return Optional.ofNullable(pe);
    }

    @JsonProperty("pe")
    public void setPe(List<String> pe) {
        this.pe = pe;
    }

    public ApprovalsDto withPe(List<String> pe) {
        this.pe = pe;
        return this;
    }

    @JsonProperty("wf")
    public Optional<List<String>> getWf() {
        return Optional.ofNullable(wf);
    }

    @JsonProperty("wf")
    public void setWf(List<String> wf) {
        this.wf = wf;
    }

    public ApprovalsDto withWf(List<String> wf) {
        this.wf = wf;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ApprovalsDto withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "approvals":
                if (value instanceof List) {
                    setApprovals(((List<ApprovalDto> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"approvals\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.ApprovalDto>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "ds":
                if (value instanceof List) {
                    setDs(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"ds\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "pe":
                if (value instanceof List) {
                    setPe(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"pe\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "wf":
                if (value instanceof List) {
                    setWf(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"wf\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "approvals":
                return getApprovals();
            case "ds":
                return getDs();
            case "pe":
                return getPe();
            case "wf":
                return getWf();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ApprovalsDto.NOT_FOUND_VALUE);
        if (ApprovalsDto.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ApprovalsDto with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ApprovalsDto.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("approvals");
        sb.append('=');
        sb.append(((this.approvals == null)?"<null>":this.approvals));
        sb.append(',');
        sb.append("ds");
        sb.append('=');
        sb.append(((this.ds == null)?"<null>":this.ds));
        sb.append(',');
        sb.append("pe");
        sb.append('=');
        sb.append(((this.pe == null)?"<null>":this.pe));
        sb.append(',');
        sb.append("wf");
        sb.append('=');
        sb.append(((this.wf == null)?"<null>":this.wf));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.pe == null)? 0 :this.pe.hashCode()));
        result = ((result* 31)+((this.approvals == null)? 0 :this.approvals.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.ds == null)? 0 :this.ds.hashCode()));
        result = ((result* 31)+((this.wf == null)? 0 :this.wf.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ApprovalsDto) == false) {
            return false;
        }
        ApprovalsDto rhs = ((ApprovalsDto) other);
        return ((((((this.pe == rhs.pe)||((this.pe!= null)&&this.pe.equals(rhs.pe)))&&((this.approvals == rhs.approvals)||((this.approvals!= null)&&this.approvals.equals(rhs.approvals))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.ds == rhs.ds)||((this.ds!= null)&&this.ds.equals(rhs.ds))))&&((this.wf == rhs.wf)||((this.wf!= null)&&this.wf.equals(rhs.wf))));
    }

}
