
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "appKey",
    "attributeValues",
    "code",
    "contentCount",
    "created",
    "createdBy",
    "displayName",
    "eventChart",
    "eventReport",
    "eventVisualization",
    "externalAccess",
    "favorite",
    "favorites",
    "height",
    "href",
    "id",
    "interpretationCount",
    "interpretationLikeCount",
    "lastUpdated",
    "lastUpdatedBy",
    "map",
    "messages",
    "name",
    "publicAccess",
    "reports",
    "resources",
    "shape",
    "sharing",
    "text",
    "translations",
    "type",
    "user",
    "userAccesses",
    "userGroupAccesses",
    "users",
    "visualization",
    "width",
    "x",
    "y"
})
@Generated("jsonschema2pojo")
public class DashboardItem implements Serializable
{

    @JsonProperty("access")
    private Access access;
    @JsonProperty("appKey")
    private String appKey;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues = null;
    @JsonProperty("code")
    private String code;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("contentCount")
    private Integer contentCount;
    @JsonProperty("created")
    private Date created;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private RefUser createdBy;
    @JsonProperty("displayName")
    private String displayName;
    /**
     * A UID reference to a EventChart  
     * (Java name `org.hisp.dhis.eventchart.EventChart`)
     * 
     */
    @JsonProperty("eventChart")
    @JsonPropertyDescription("A UID reference to a EventChart  \n(Java name `org.hisp.dhis.eventchart.EventChart`)")
    private RefEventChart eventChart;
    /**
     * A UID reference to a EventReport  
     * (Java name `org.hisp.dhis.eventreport.EventReport`)
     * 
     */
    @JsonProperty("eventReport")
    @JsonPropertyDescription("A UID reference to a EventReport  \n(Java name `org.hisp.dhis.eventreport.EventReport`)")
    private RefEventReport eventReport;
    /**
     * A UID reference to a EventVisualization  
     * (Java name `org.hisp.dhis.eventvisualization.EventVisualization`)
     * 
     */
    @JsonProperty("eventVisualization")
    @JsonPropertyDescription("A UID reference to a EventVisualization  \n(Java name `org.hisp.dhis.eventvisualization.EventVisualization`)")
    private RefEventVisualization eventVisualization;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites = null;
    @JsonProperty("height")
    private Integer height;
    @JsonProperty("href")
    private String href;
    @JsonProperty("id")
    private String id;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("interpretationCount")
    private Integer interpretationCount;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("interpretationLikeCount")
    private Integer interpretationLikeCount;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private RefUser lastUpdatedBy;
    /**
     * A UID reference to a Map  
     * (Java name `org.hisp.dhis.mapping.Map`)
     * 
     */
    @JsonProperty("map")
    @JsonPropertyDescription("A UID reference to a Map  \n(Java name `org.hisp.dhis.mapping.Map`)")
    private RefMap map;
    @JsonProperty("messages")
    private Boolean messages;
    @JsonProperty("name")
    private String name;
    @JsonProperty("publicAccess")
    private String publicAccess;
    @JsonProperty("reports")
    private List<RefReport> reports = null;
    @JsonProperty("resources")
    private List<RefDocument> resources = null;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("shape")
    private DashboardItem.Shape shape;
    @JsonProperty("sharing")
    private Sharing sharing;
    @JsonProperty("text")
    private String text;
    @JsonProperty("translations")
    private List<Translation> translations = null;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("type")
    private DashboardItem.Type type;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private RefUser user;
    @JsonProperty("userAccesses")
    private List<UserAccess> userAccesses = null;
    @JsonProperty("userGroupAccesses")
    private List<UserGroupAccess> userGroupAccesses = null;
    @JsonProperty("users")
    private List<RefUser> users = null;
    /**
     * A UID reference to a Visualization  
     * (Java name `org.hisp.dhis.visualization.Visualization`)
     * 
     */
    @JsonProperty("visualization")
    @JsonPropertyDescription("A UID reference to a Visualization  \n(Java name `org.hisp.dhis.visualization.Visualization`)")
    private RefVisualization visualization;
    @JsonProperty("width")
    private Integer width;
    @JsonProperty("x")
    private Integer x;
    @JsonProperty("y")
    private Integer y;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -3794516334133026570L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DashboardItem() {
    }

    /**
     * 
     * @param source
     */
    public DashboardItem(DashboardItem source) {
        super();
        this.access = source.access;
        this.appKey = source.appKey;
        this.attributeValues = source.attributeValues;
        this.code = source.code;
        this.contentCount = source.contentCount;
        this.created = source.created;
        this.createdBy = source.createdBy;
        this.displayName = source.displayName;
        this.eventChart = source.eventChart;
        this.eventReport = source.eventReport;
        this.eventVisualization = source.eventVisualization;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.height = source.height;
        this.href = source.href;
        this.id = source.id;
        this.interpretationCount = source.interpretationCount;
        this.interpretationLikeCount = source.interpretationLikeCount;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.map = source.map;
        this.messages = source.messages;
        this.name = source.name;
        this.publicAccess = source.publicAccess;
        this.reports = source.reports;
        this.resources = source.resources;
        this.shape = source.shape;
        this.sharing = source.sharing;
        this.text = source.text;
        this.translations = source.translations;
        this.type = source.type;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userGroupAccesses = source.userGroupAccesses;
        this.users = source.users;
        this.visualization = source.visualization;
        this.width = source.width;
        this.x = source.x;
        this.y = source.y;
    }

    /**
     * 
     * @param favorites
     * @param reports
     * @param visualization
     * @param access
     * @param code
     * @param displayName
     * @param publicAccess
     * @param type
     * @param externalAccess
     * @param lastUpdated
     * @param translations
     * @param eventVisualization
     * @param appKey
     * @param href
     * @param id
     * @param text
     * @param map
     * @param contentCount
     * @param height
     * @param lastUpdatedBy
     * @param userGroupAccesses
     * @param shape
     * @param interpretationCount
     * @param created
     * @param attributeValues
     * @param resources
     * @param sharing
     * @param users
     * @param createdBy
     * @param eventReport
     * @param userAccesses
     * @param eventChart
     * @param name
     * @param width
     * @param x
     * @param interpretationLikeCount
     * @param messages
     * @param y
     * @param favorite
     * @param user
     */
    public DashboardItem(Access access, String appKey, List<AttributeValue> attributeValues, String code, Integer contentCount, Date created, RefUser createdBy, String displayName, RefEventChart eventChart, RefEventReport eventReport, RefEventVisualization eventVisualization, Boolean externalAccess, Boolean favorite, List<String> favorites, Integer height, String href, String id, Integer interpretationCount, Integer interpretationLikeCount, Date lastUpdated, RefUser lastUpdatedBy, RefMap map, Boolean messages, String name, String publicAccess, List<RefReport> reports, List<RefDocument> resources, DashboardItem.Shape shape, Sharing sharing, String text, List<Translation> translations, DashboardItem.Type type, RefUser user, List<UserAccess> userAccesses, List<UserGroupAccess> userGroupAccesses, List<RefUser> users, RefVisualization visualization, Integer width, Integer x, Integer y) {
        super();
        this.access = access;
        this.appKey = appKey;
        this.attributeValues = attributeValues;
        this.code = code;
        this.contentCount = contentCount;
        this.created = created;
        this.createdBy = createdBy;
        this.displayName = displayName;
        this.eventChart = eventChart;
        this.eventReport = eventReport;
        this.eventVisualization = eventVisualization;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.height = height;
        this.href = href;
        this.id = id;
        this.interpretationCount = interpretationCount;
        this.interpretationLikeCount = interpretationLikeCount;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.map = map;
        this.messages = messages;
        this.name = name;
        this.publicAccess = publicAccess;
        this.reports = reports;
        this.resources = resources;
        this.shape = shape;
        this.sharing = sharing;
        this.text = text;
        this.translations = translations;
        this.type = type;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userGroupAccesses = userGroupAccesses;
        this.users = users;
        this.visualization = visualization;
        this.width = width;
        this.x = x;
        this.y = y;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public DashboardItem withAccess(Access access) {
        this.access = access;
        return this;
    }

    @JsonProperty("appKey")
    public Optional<String> getAppKey() {
        return Optional.ofNullable(appKey);
    }

    @JsonProperty("appKey")
    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public DashboardItem withAppKey(String appKey) {
        this.appKey = appKey;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public DashboardItem withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public DashboardItem withCode(String code) {
        this.code = code;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("contentCount")
    public Integer getContentCount() {
        return contentCount;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("contentCount")
    public void setContentCount(Integer contentCount) {
        this.contentCount = contentCount;
    }

    public DashboardItem withContentCount(Integer contentCount) {
        this.contentCount = contentCount;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public DashboardItem withCreated(Date created) {
        this.created = created;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    public Optional<RefUser> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    public void setCreatedBy(RefUser createdBy) {
        this.createdBy = createdBy;
    }

    public DashboardItem withCreatedBy(RefUser createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public DashboardItem withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * A UID reference to a EventChart  
     * (Java name `org.hisp.dhis.eventchart.EventChart`)
     * 
     */
    @JsonProperty("eventChart")
    public Optional<RefEventChart> getEventChart() {
        return Optional.ofNullable(eventChart);
    }

    /**
     * A UID reference to a EventChart  
     * (Java name `org.hisp.dhis.eventchart.EventChart`)
     * 
     */
    @JsonProperty("eventChart")
    public void setEventChart(RefEventChart eventChart) {
        this.eventChart = eventChart;
    }

    public DashboardItem withEventChart(RefEventChart eventChart) {
        this.eventChart = eventChart;
        return this;
    }

    /**
     * A UID reference to a EventReport  
     * (Java name `org.hisp.dhis.eventreport.EventReport`)
     * 
     */
    @JsonProperty("eventReport")
    public Optional<RefEventReport> getEventReport() {
        return Optional.ofNullable(eventReport);
    }

    /**
     * A UID reference to a EventReport  
     * (Java name `org.hisp.dhis.eventreport.EventReport`)
     * 
     */
    @JsonProperty("eventReport")
    public void setEventReport(RefEventReport eventReport) {
        this.eventReport = eventReport;
    }

    public DashboardItem withEventReport(RefEventReport eventReport) {
        this.eventReport = eventReport;
        return this;
    }

    /**
     * A UID reference to a EventVisualization  
     * (Java name `org.hisp.dhis.eventvisualization.EventVisualization`)
     * 
     */
    @JsonProperty("eventVisualization")
    public Optional<RefEventVisualization> getEventVisualization() {
        return Optional.ofNullable(eventVisualization);
    }

    /**
     * A UID reference to a EventVisualization  
     * (Java name `org.hisp.dhis.eventvisualization.EventVisualization`)
     * 
     */
    @JsonProperty("eventVisualization")
    public void setEventVisualization(RefEventVisualization eventVisualization) {
        this.eventVisualization = eventVisualization;
    }

    public DashboardItem withEventVisualization(RefEventVisualization eventVisualization) {
        this.eventVisualization = eventVisualization;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("externalAccess")
    public Boolean getExternalAccess() {
        return externalAccess;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public DashboardItem withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("favorite")
    public Boolean getFavorite() {
        return favorite;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public DashboardItem withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public DashboardItem withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @JsonProperty("height")
    public Optional<Integer> getHeight() {
        return Optional.ofNullable(height);
    }

    @JsonProperty("height")
    public void setHeight(Integer height) {
        this.height = height;
    }

    public DashboardItem withHeight(Integer height) {
        this.height = height;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public DashboardItem withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public DashboardItem withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("interpretationCount")
    public Integer getInterpretationCount() {
        return interpretationCount;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("interpretationCount")
    public void setInterpretationCount(Integer interpretationCount) {
        this.interpretationCount = interpretationCount;
    }

    public DashboardItem withInterpretationCount(Integer interpretationCount) {
        this.interpretationCount = interpretationCount;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("interpretationLikeCount")
    public Integer getInterpretationLikeCount() {
        return interpretationLikeCount;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("interpretationLikeCount")
    public void setInterpretationLikeCount(Integer interpretationLikeCount) {
        this.interpretationLikeCount = interpretationLikeCount;
    }

    public DashboardItem withInterpretationLikeCount(Integer interpretationLikeCount) {
        this.interpretationLikeCount = interpretationLikeCount;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public DashboardItem withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    public Optional<RefUser> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(RefUser lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public DashboardItem withLastUpdatedBy(RefUser lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    /**
     * A UID reference to a Map  
     * (Java name `org.hisp.dhis.mapping.Map`)
     * 
     */
    @JsonProperty("map")
    public Optional<RefMap> getMap() {
        return Optional.ofNullable(map);
    }

    /**
     * A UID reference to a Map  
     * (Java name `org.hisp.dhis.mapping.Map`)
     * 
     */
    @JsonProperty("map")
    public void setMap(RefMap map) {
        this.map = map;
    }

    public DashboardItem withMap(RefMap map) {
        this.map = map;
        return this;
    }

    @JsonProperty("messages")
    public Optional<Boolean> getMessages() {
        return Optional.ofNullable(messages);
    }

    @JsonProperty("messages")
    public void setMessages(Boolean messages) {
        this.messages = messages;
    }

    public DashboardItem withMessages(Boolean messages) {
        this.messages = messages;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public DashboardItem withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public DashboardItem withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    @JsonProperty("reports")
    public Optional<List<RefReport>> getReports() {
        return Optional.ofNullable(reports);
    }

    @JsonProperty("reports")
    public void setReports(List<RefReport> reports) {
        this.reports = reports;
    }

    public DashboardItem withReports(List<RefReport> reports) {
        this.reports = reports;
        return this;
    }

    @JsonProperty("resources")
    public Optional<List<RefDocument>> getResources() {
        return Optional.ofNullable(resources);
    }

    @JsonProperty("resources")
    public void setResources(List<RefDocument> resources) {
        this.resources = resources;
    }

    public DashboardItem withResources(List<RefDocument> resources) {
        this.resources = resources;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("shape")
    public DashboardItem.Shape getShape() {
        return shape;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("shape")
    public void setShape(DashboardItem.Shape shape) {
        this.shape = shape;
    }

    public DashboardItem withShape(DashboardItem.Shape shape) {
        this.shape = shape;
        return this;
    }

    @JsonProperty("sharing")
    public Optional<Sharing> getSharing() {
        return Optional.ofNullable(sharing);
    }

    @JsonProperty("sharing")
    public void setSharing(Sharing sharing) {
        this.sharing = sharing;
    }

    public DashboardItem withSharing(Sharing sharing) {
        this.sharing = sharing;
        return this;
    }

    @JsonProperty("text")
    public Optional<String> getText() {
        return Optional.ofNullable(text);
    }

    @JsonProperty("text")
    public void setText(String text) {
        this.text = text;
    }

    public DashboardItem withText(String text) {
        this.text = text;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public DashboardItem withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("type")
    public DashboardItem.Type getType() {
        return type;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("type")
    public void setType(DashboardItem.Type type) {
        this.type = type;
    }

    public DashboardItem withType(DashboardItem.Type type) {
        this.type = type;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    public Optional<RefUser> getUser() {
        return Optional.ofNullable(user);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    public void setUser(RefUser user) {
        this.user = user;
    }

    public DashboardItem withUser(RefUser user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<UserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public DashboardItem withUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<UserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public DashboardItem withUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    @JsonProperty("users")
    public Optional<List<RefUser>> getUsers() {
        return Optional.ofNullable(users);
    }

    @JsonProperty("users")
    public void setUsers(List<RefUser> users) {
        this.users = users;
    }

    public DashboardItem withUsers(List<RefUser> users) {
        this.users = users;
        return this;
    }

    /**
     * A UID reference to a Visualization  
     * (Java name `org.hisp.dhis.visualization.Visualization`)
     * 
     */
    @JsonProperty("visualization")
    public Optional<RefVisualization> getVisualization() {
        return Optional.ofNullable(visualization);
    }

    /**
     * A UID reference to a Visualization  
     * (Java name `org.hisp.dhis.visualization.Visualization`)
     * 
     */
    @JsonProperty("visualization")
    public void setVisualization(RefVisualization visualization) {
        this.visualization = visualization;
    }

    public DashboardItem withVisualization(RefVisualization visualization) {
        this.visualization = visualization;
        return this;
    }

    @JsonProperty("width")
    public Optional<Integer> getWidth() {
        return Optional.ofNullable(width);
    }

    @JsonProperty("width")
    public void setWidth(Integer width) {
        this.width = width;
    }

    public DashboardItem withWidth(Integer width) {
        this.width = width;
        return this;
    }

    @JsonProperty("x")
    public Optional<Integer> getX() {
        return Optional.ofNullable(x);
    }

    @JsonProperty("x")
    public void setX(Integer x) {
        this.x = x;
    }

    public DashboardItem withX(Integer x) {
        this.x = x;
        return this;
    }

    @JsonProperty("y")
    public Optional<Integer> getY() {
        return Optional.ofNullable(y);
    }

    @JsonProperty("y")
    public void setY(Integer y) {
        this.y = y;
    }

    public DashboardItem withY(Integer y) {
        this.y = y;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public DashboardItem withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "access":
                if (value instanceof Access) {
                    setAccess(((Access) value));
                } else {
                    throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v40_0.Access\", but got "+ value.getClass().toString()));
                }
                return true;
            case "appKey":
                if (value instanceof String) {
                    setAppKey(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"appKey\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "attributeValues":
                if (value instanceof List) {
                    setAttributeValues(((List<AttributeValue> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.AttributeValue>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "code":
                if (value instanceof String) {
                    setCode(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "contentCount":
                if (value instanceof Integer) {
                    setContentCount(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"contentCount\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "created":
                if (value instanceof Date) {
                    setCreated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "createdBy":
                if (value instanceof RefUser) {
                    setCreatedBy(((RefUser) value));
                } else {
                    throw new IllegalArgumentException(("property \"createdBy\" is of type \"org.hisp.dhis.api.model.v40_0.RefUser\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayName":
                if (value instanceof String) {
                    setDisplayName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "eventChart":
                if (value instanceof RefEventChart) {
                    setEventChart(((RefEventChart) value));
                } else {
                    throw new IllegalArgumentException(("property \"eventChart\" is of type \"org.hisp.dhis.api.model.v40_0.RefEventChart\", but got "+ value.getClass().toString()));
                }
                return true;
            case "eventReport":
                if (value instanceof RefEventReport) {
                    setEventReport(((RefEventReport) value));
                } else {
                    throw new IllegalArgumentException(("property \"eventReport\" is of type \"org.hisp.dhis.api.model.v40_0.RefEventReport\", but got "+ value.getClass().toString()));
                }
                return true;
            case "eventVisualization":
                if (value instanceof RefEventVisualization) {
                    setEventVisualization(((RefEventVisualization) value));
                } else {
                    throw new IllegalArgumentException(("property \"eventVisualization\" is of type \"org.hisp.dhis.api.model.v40_0.RefEventVisualization\", but got "+ value.getClass().toString()));
                }
                return true;
            case "externalAccess":
                if (value instanceof Boolean) {
                    setExternalAccess(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "favorite":
                if (value instanceof Boolean) {
                    setFavorite(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "favorites":
                if (value instanceof List) {
                    setFavorites(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "height":
                if (value instanceof Integer) {
                    setHeight(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"height\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "href":
                if (value instanceof String) {
                    setHref(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "id":
                if (value instanceof String) {
                    setId(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "interpretationCount":
                if (value instanceof Integer) {
                    setInterpretationCount(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"interpretationCount\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "interpretationLikeCount":
                if (value instanceof Integer) {
                    setInterpretationLikeCount(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"interpretationLikeCount\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdated":
                if (value instanceof Date) {
                    setLastUpdated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdatedBy":
                if (value instanceof RefUser) {
                    setLastUpdatedBy(((RefUser) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v40_0.RefUser\", but got "+ value.getClass().toString()));
                }
                return true;
            case "map":
                if (value instanceof RefMap) {
                    setMap(((RefMap) value));
                } else {
                    throw new IllegalArgumentException(("property \"map\" is of type \"org.hisp.dhis.api.model.v40_0.RefMap\", but got "+ value.getClass().toString()));
                }
                return true;
            case "messages":
                if (value instanceof Boolean) {
                    setMessages(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"messages\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "name":
                if (value instanceof String) {
                    setName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "publicAccess":
                if (value instanceof String) {
                    setPublicAccess(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "reports":
                if (value instanceof List) {
                    setReports(((List<RefReport> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"reports\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.RefReport>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "resources":
                if (value instanceof List) {
                    setResources(((List<RefDocument> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"resources\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.RefDocument>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "shape":
                if (value instanceof DashboardItem.Shape) {
                    setShape(((DashboardItem.Shape) value));
                } else {
                    throw new IllegalArgumentException(("property \"shape\" is of type \"org.hisp.dhis.api.model.v40_0.DashboardItem.Shape\", but got "+ value.getClass().toString()));
                }
                return true;
            case "sharing":
                if (value instanceof Sharing) {
                    setSharing(((Sharing) value));
                } else {
                    throw new IllegalArgumentException(("property \"sharing\" is of type \"org.hisp.dhis.api.model.v40_0.Sharing\", but got "+ value.getClass().toString()));
                }
                return true;
            case "text":
                if (value instanceof String) {
                    setText(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"text\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "translations":
                if (value instanceof List) {
                    setTranslations(((List<Translation> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.Translation>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "type":
                if (value instanceof DashboardItem.Type) {
                    setType(((DashboardItem.Type) value));
                } else {
                    throw new IllegalArgumentException(("property \"type\" is of type \"org.hisp.dhis.api.model.v40_0.DashboardItem.Type\", but got "+ value.getClass().toString()));
                }
                return true;
            case "user":
                if (value instanceof RefUser) {
                    setUser(((RefUser) value));
                } else {
                    throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v40_0.RefUser\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userAccesses":
                if (value instanceof List) {
                    setUserAccesses(((List<UserAccess> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.UserAccess>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userGroupAccesses":
                if (value instanceof List) {
                    setUserGroupAccesses(((List<UserGroupAccess> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.UserGroupAccess>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "users":
                if (value instanceof List) {
                    setUsers(((List<RefUser> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"users\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.RefUser>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "visualization":
                if (value instanceof RefVisualization) {
                    setVisualization(((RefVisualization) value));
                } else {
                    throw new IllegalArgumentException(("property \"visualization\" is of type \"org.hisp.dhis.api.model.v40_0.RefVisualization\", but got "+ value.getClass().toString()));
                }
                return true;
            case "width":
                if (value instanceof Integer) {
                    setWidth(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"width\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "x":
                if (value instanceof Integer) {
                    setX(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"x\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "y":
                if (value instanceof Integer) {
                    setY(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"y\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "access":
                return getAccess();
            case "appKey":
                return getAppKey();
            case "attributeValues":
                return getAttributeValues();
            case "code":
                return getCode();
            case "contentCount":
                return getContentCount();
            case "created":
                return getCreated();
            case "createdBy":
                return getCreatedBy();
            case "displayName":
                return getDisplayName();
            case "eventChart":
                return getEventChart();
            case "eventReport":
                return getEventReport();
            case "eventVisualization":
                return getEventVisualization();
            case "externalAccess":
                return getExternalAccess();
            case "favorite":
                return getFavorite();
            case "favorites":
                return getFavorites();
            case "height":
                return getHeight();
            case "href":
                return getHref();
            case "id":
                return getId();
            case "interpretationCount":
                return getInterpretationCount();
            case "interpretationLikeCount":
                return getInterpretationLikeCount();
            case "lastUpdated":
                return getLastUpdated();
            case "lastUpdatedBy":
                return getLastUpdatedBy();
            case "map":
                return getMap();
            case "messages":
                return getMessages();
            case "name":
                return getName();
            case "publicAccess":
                return getPublicAccess();
            case "reports":
                return getReports();
            case "resources":
                return getResources();
            case "shape":
                return getShape();
            case "sharing":
                return getSharing();
            case "text":
                return getText();
            case "translations":
                return getTranslations();
            case "type":
                return getType();
            case "user":
                return getUser();
            case "userAccesses":
                return getUserAccesses();
            case "userGroupAccesses":
                return getUserGroupAccesses();
            case "users":
                return getUsers();
            case "visualization":
                return getVisualization();
            case "width":
                return getWidth();
            case "x":
                return getX();
            case "y":
                return getY();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, DashboardItem.NOT_FOUND_VALUE);
        if (DashboardItem.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public DashboardItem with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DashboardItem.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("appKey");
        sb.append('=');
        sb.append(((this.appKey == null)?"<null>":this.appKey));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("contentCount");
        sb.append('=');
        sb.append(((this.contentCount == null)?"<null>":this.contentCount));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("createdBy");
        sb.append('=');
        sb.append(((this.createdBy == null)?"<null>":this.createdBy));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("eventChart");
        sb.append('=');
        sb.append(((this.eventChart == null)?"<null>":this.eventChart));
        sb.append(',');
        sb.append("eventReport");
        sb.append('=');
        sb.append(((this.eventReport == null)?"<null>":this.eventReport));
        sb.append(',');
        sb.append("eventVisualization");
        sb.append('=');
        sb.append(((this.eventVisualization == null)?"<null>":this.eventVisualization));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("height");
        sb.append('=');
        sb.append(((this.height == null)?"<null>":this.height));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("interpretationCount");
        sb.append('=');
        sb.append(((this.interpretationCount == null)?"<null>":this.interpretationCount));
        sb.append(',');
        sb.append("interpretationLikeCount");
        sb.append('=');
        sb.append(((this.interpretationLikeCount == null)?"<null>":this.interpretationLikeCount));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("map");
        sb.append('=');
        sb.append(((this.map == null)?"<null>":this.map));
        sb.append(',');
        sb.append("messages");
        sb.append('=');
        sb.append(((this.messages == null)?"<null>":this.messages));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("reports");
        sb.append('=');
        sb.append(((this.reports == null)?"<null>":this.reports));
        sb.append(',');
        sb.append("resources");
        sb.append('=');
        sb.append(((this.resources == null)?"<null>":this.resources));
        sb.append(',');
        sb.append("shape");
        sb.append('=');
        sb.append(((this.shape == null)?"<null>":this.shape));
        sb.append(',');
        sb.append("sharing");
        sb.append('=');
        sb.append(((this.sharing == null)?"<null>":this.sharing));
        sb.append(',');
        sb.append("text");
        sb.append('=');
        sb.append(((this.text == null)?"<null>":this.text));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(((this.type == null)?"<null>":this.type));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("users");
        sb.append('=');
        sb.append(((this.users == null)?"<null>":this.users));
        sb.append(',');
        sb.append("visualization");
        sb.append('=');
        sb.append(((this.visualization == null)?"<null>":this.visualization));
        sb.append(',');
        sb.append("width");
        sb.append('=');
        sb.append(((this.width == null)?"<null>":this.width));
        sb.append(',');
        sb.append("x");
        sb.append('=');
        sb.append(((this.x == null)?"<null>":this.x));
        sb.append(',');
        sb.append("y");
        sb.append('=');
        sb.append(((this.y == null)?"<null>":this.y));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.reports == null)? 0 :this.reports.hashCode()));
        result = ((result* 31)+((this.visualization == null)? 0 :this.visualization.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.type == null)? 0 :this.type.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.eventVisualization == null)? 0 :this.eventVisualization.hashCode()));
        result = ((result* 31)+((this.appKey == null)? 0 :this.appKey.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.text == null)? 0 :this.text.hashCode()));
        result = ((result* 31)+((this.map == null)? 0 :this.map.hashCode()));
        result = ((result* 31)+((this.contentCount == null)? 0 :this.contentCount.hashCode()));
        result = ((result* 31)+((this.height == null)? 0 :this.height.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.shape == null)? 0 :this.shape.hashCode()));
        result = ((result* 31)+((this.interpretationCount == null)? 0 :this.interpretationCount.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.resources == null)? 0 :this.resources.hashCode()));
        result = ((result* 31)+((this.sharing == null)? 0 :this.sharing.hashCode()));
        result = ((result* 31)+((this.users == null)? 0 :this.users.hashCode()));
        result = ((result* 31)+((this.createdBy == null)? 0 :this.createdBy.hashCode()));
        result = ((result* 31)+((this.eventReport == null)? 0 :this.eventReport.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.eventChart == null)? 0 :this.eventChart.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.width == null)? 0 :this.width.hashCode()));
        result = ((result* 31)+((this.x == null)? 0 :this.x.hashCode()));
        result = ((result* 31)+((this.interpretationLikeCount == null)? 0 :this.interpretationLikeCount.hashCode()));
        result = ((result* 31)+((this.messages == null)? 0 :this.messages.hashCode()));
        result = ((result* 31)+((this.y == null)? 0 :this.y.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof DashboardItem) == false) {
            return false;
        }
        DashboardItem rhs = ((DashboardItem) other);
        return ((((((((((((((((((((((((((((((((((((((((((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites)))&&((this.reports == rhs.reports)||((this.reports!= null)&&this.reports.equals(rhs.reports))))&&((this.visualization == rhs.visualization)||((this.visualization!= null)&&this.visualization.equals(rhs.visualization))))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.type == rhs.type)||((this.type!= null)&&this.type.equals(rhs.type))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.eventVisualization == rhs.eventVisualization)||((this.eventVisualization!= null)&&this.eventVisualization.equals(rhs.eventVisualization))))&&((this.appKey == rhs.appKey)||((this.appKey!= null)&&this.appKey.equals(rhs.appKey))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.text == rhs.text)||((this.text!= null)&&this.text.equals(rhs.text))))&&((this.map == rhs.map)||((this.map!= null)&&this.map.equals(rhs.map))))&&((this.contentCount == rhs.contentCount)||((this.contentCount!= null)&&this.contentCount.equals(rhs.contentCount))))&&((this.height == rhs.height)||((this.height!= null)&&this.height.equals(rhs.height))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.shape == rhs.shape)||((this.shape!= null)&&this.shape.equals(rhs.shape))))&&((this.interpretationCount == rhs.interpretationCount)||((this.interpretationCount!= null)&&this.interpretationCount.equals(rhs.interpretationCount))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.resources == rhs.resources)||((this.resources!= null)&&this.resources.equals(rhs.resources))))&&((this.sharing == rhs.sharing)||((this.sharing!= null)&&this.sharing.equals(rhs.sharing))))&&((this.users == rhs.users)||((this.users!= null)&&this.users.equals(rhs.users))))&&((this.createdBy == rhs.createdBy)||((this.createdBy!= null)&&this.createdBy.equals(rhs.createdBy))))&&((this.eventReport == rhs.eventReport)||((this.eventReport!= null)&&this.eventReport.equals(rhs.eventReport))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.eventChart == rhs.eventChart)||((this.eventChart!= null)&&this.eventChart.equals(rhs.eventChart))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.width == rhs.width)||((this.width!= null)&&this.width.equals(rhs.width))))&&((this.x == rhs.x)||((this.x!= null)&&this.x.equals(rhs.x))))&&((this.interpretationLikeCount == rhs.interpretationLikeCount)||((this.interpretationLikeCount!= null)&&this.interpretationLikeCount.equals(rhs.interpretationLikeCount))))&&((this.messages == rhs.messages)||((this.messages!= null)&&this.messages.equals(rhs.messages))))&&((this.y == rhs.y)||((this.y!= null)&&this.y.equals(rhs.y))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))));
    }

    @Generated("jsonschema2pojo")
    public enum Shape {

        NORMAL("NORMAL"),
        DOUBLE_WIDTH("DOUBLE_WIDTH"),
        FULL_WIDTH("FULL_WIDTH");
        private final String value;
        private final static Map<String, DashboardItem.Shape> CONSTANTS = new HashMap<String, DashboardItem.Shape>();

        static {
            for (DashboardItem.Shape c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        Shape(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DashboardItem.Shape fromValue(String value) {
            DashboardItem.Shape constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum Type {

        VISUALIZATION("VISUALIZATION"),
        EVENT_VISUALIZATION("EVENT_VISUALIZATION"),
        EVENT_CHART("EVENT_CHART"),
        MAP("MAP"),
        EVENT_REPORT("EVENT_REPORT"),
        USERS("USERS"),
        REPORTS("REPORTS"),
        RESOURCES("RESOURCES"),
        TEXT("TEXT"),
        MESSAGES("MESSAGES"),
        APP("APP");
        private final String value;
        private final static Map<String, DashboardItem.Type> CONSTANTS = new HashMap<String, DashboardItem.Type>();

        static {
            for (DashboardItem.Type c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        Type(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DashboardItem.Type fromValue(String value) {
            DashboardItem.Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
