
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "ds",
    "endDate",
    "ou",
    "standardDeviation",
    "startDate"
})
@Generated("jsonschema2pojo")
public class DataAnalysisParams implements Serializable
{

    @JsonProperty("ds")
    private List<String> ds = null;
    @JsonProperty("endDate")
    private String endDate;
    @JsonProperty("ou")
    private String ou;
    @JsonProperty("standardDeviation")
    private Double standardDeviation;
    @JsonProperty("startDate")
    private String startDate;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -5898900461832884642L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DataAnalysisParams() {
    }

    /**
     * 
     * @param source
     */
    public DataAnalysisParams(DataAnalysisParams source) {
        super();
        this.ds = source.ds;
        this.endDate = source.endDate;
        this.ou = source.ou;
        this.standardDeviation = source.standardDeviation;
        this.startDate = source.startDate;
    }

    /**
     * 
     * @param endDate
     * @param ou
     * @param standardDeviation
     * @param startDate
     * @param ds
     */
    public DataAnalysisParams(List<String> ds, String endDate, String ou, Double standardDeviation, String startDate) {
        super();
        this.ds = ds;
        this.endDate = endDate;
        this.ou = ou;
        this.standardDeviation = standardDeviation;
        this.startDate = startDate;
    }

    @JsonProperty("ds")
    public Optional<List<String>> getDs() {
        return Optional.ofNullable(ds);
    }

    @JsonProperty("ds")
    public void setDs(List<String> ds) {
        this.ds = ds;
    }

    public DataAnalysisParams withDs(List<String> ds) {
        this.ds = ds;
        return this;
    }

    @JsonProperty("endDate")
    public Optional<String> getEndDate() {
        return Optional.ofNullable(endDate);
    }

    @JsonProperty("endDate")
    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public DataAnalysisParams withEndDate(String endDate) {
        this.endDate = endDate;
        return this;
    }

    @JsonProperty("ou")
    public Optional<String> getOu() {
        return Optional.ofNullable(ou);
    }

    @JsonProperty("ou")
    public void setOu(String ou) {
        this.ou = ou;
    }

    public DataAnalysisParams withOu(String ou) {
        this.ou = ou;
        return this;
    }

    @JsonProperty("standardDeviation")
    public Optional<Double> getStandardDeviation() {
        return Optional.ofNullable(standardDeviation);
    }

    @JsonProperty("standardDeviation")
    public void setStandardDeviation(Double standardDeviation) {
        this.standardDeviation = standardDeviation;
    }

    public DataAnalysisParams withStandardDeviation(Double standardDeviation) {
        this.standardDeviation = standardDeviation;
        return this;
    }

    @JsonProperty("startDate")
    public Optional<String> getStartDate() {
        return Optional.ofNullable(startDate);
    }

    @JsonProperty("startDate")
    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public DataAnalysisParams withStartDate(String startDate) {
        this.startDate = startDate;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public DataAnalysisParams withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "ds":
                if (value instanceof List) {
                    setDs(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"ds\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "endDate":
                if (value instanceof String) {
                    setEndDate(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"endDate\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "ou":
                if (value instanceof String) {
                    setOu(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"ou\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "standardDeviation":
                if (value instanceof Double) {
                    setStandardDeviation(((Double) value));
                } else {
                    throw new IllegalArgumentException(("property \"standardDeviation\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                }
                return true;
            case "startDate":
                if (value instanceof String) {
                    setStartDate(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"startDate\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "ds":
                return getDs();
            case "endDate":
                return getEndDate();
            case "ou":
                return getOu();
            case "standardDeviation":
                return getStandardDeviation();
            case "startDate":
                return getStartDate();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, DataAnalysisParams.NOT_FOUND_VALUE);
        if (DataAnalysisParams.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public DataAnalysisParams with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DataAnalysisParams.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("ds");
        sb.append('=');
        sb.append(((this.ds == null)?"<null>":this.ds));
        sb.append(',');
        sb.append("endDate");
        sb.append('=');
        sb.append(((this.endDate == null)?"<null>":this.endDate));
        sb.append(',');
        sb.append("ou");
        sb.append('=');
        sb.append(((this.ou == null)?"<null>":this.ou));
        sb.append(',');
        sb.append("standardDeviation");
        sb.append('=');
        sb.append(((this.standardDeviation == null)?"<null>":this.standardDeviation));
        sb.append(',');
        sb.append("startDate");
        sb.append('=');
        sb.append(((this.startDate == null)?"<null>":this.startDate));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.endDate == null)? 0 :this.endDate.hashCode()));
        result = ((result* 31)+((this.ou == null)? 0 :this.ou.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.standardDeviation == null)? 0 :this.standardDeviation.hashCode()));
        result = ((result* 31)+((this.startDate == null)? 0 :this.startDate.hashCode()));
        result = ((result* 31)+((this.ds == null)? 0 :this.ds.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof DataAnalysisParams) == false) {
            return false;
        }
        DataAnalysisParams rhs = ((DataAnalysisParams) other);
        return (((((((this.endDate == rhs.endDate)||((this.endDate!= null)&&this.endDate.equals(rhs.endDate)))&&((this.ou == rhs.ou)||((this.ou!= null)&&this.ou.equals(rhs.ou))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.standardDeviation == rhs.standardDeviation)||((this.standardDeviation!= null)&&this.standardDeviation.equals(rhs.standardDeviation))))&&((this.startDate == rhs.startDate)||((this.startDate!= null)&&this.startDate.equals(rhs.startDate))))&&((this.ds == rhs.ds)||((this.ds!= null)&&this.ds.equals(rhs.ds))));
    }

}
