
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "acceptedAt",
    "acceptedBy",
    "approvedAt",
    "approvedBy",
    "mayAccept",
    "mayApprove",
    "mayReadData",
    "mayUnaccept",
    "mayUnapprove",
    "state"
})
@Generated("jsonschema2pojo")
public class DataApprovalPermissions implements Serializable
{

    @JsonProperty("acceptedAt")
    private Date acceptedAt;
    @JsonProperty("acceptedBy")
    private String acceptedBy;
    @JsonProperty("approvedAt")
    private Date approvedAt;
    @JsonProperty("approvedBy")
    private String approvedBy;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("mayAccept")
    private Boolean mayAccept;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("mayApprove")
    private Boolean mayApprove;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("mayReadData")
    private Boolean mayReadData;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("mayUnaccept")
    private Boolean mayUnaccept;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("mayUnapprove")
    private Boolean mayUnapprove;
    @JsonProperty("state")
    private String state;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -8299806728358877971L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DataApprovalPermissions() {
    }

    /**
     * 
     * @param source
     */
    public DataApprovalPermissions(DataApprovalPermissions source) {
        super();
        this.acceptedAt = source.acceptedAt;
        this.acceptedBy = source.acceptedBy;
        this.approvedAt = source.approvedAt;
        this.approvedBy = source.approvedBy;
        this.mayAccept = source.mayAccept;
        this.mayApprove = source.mayApprove;
        this.mayReadData = source.mayReadData;
        this.mayUnaccept = source.mayUnaccept;
        this.mayUnapprove = source.mayUnapprove;
        this.state = source.state;
    }

    /**
     * 
     * @param mayUnaccept
     * @param approvedBy
     * @param mayUnapprove
     * @param acceptedBy
     * @param state
     * @param approvedAt
     * @param mayReadData
     * @param mayApprove
     * @param mayAccept
     * @param acceptedAt
     */
    public DataApprovalPermissions(Date acceptedAt, String acceptedBy, Date approvedAt, String approvedBy, Boolean mayAccept, Boolean mayApprove, Boolean mayReadData, Boolean mayUnaccept, Boolean mayUnapprove, String state) {
        super();
        this.acceptedAt = acceptedAt;
        this.acceptedBy = acceptedBy;
        this.approvedAt = approvedAt;
        this.approvedBy = approvedBy;
        this.mayAccept = mayAccept;
        this.mayApprove = mayApprove;
        this.mayReadData = mayReadData;
        this.mayUnaccept = mayUnaccept;
        this.mayUnapprove = mayUnapprove;
        this.state = state;
    }

    @JsonProperty("acceptedAt")
    public Optional<Date> getAcceptedAt() {
        return Optional.ofNullable(acceptedAt);
    }

    @JsonProperty("acceptedAt")
    public void setAcceptedAt(Date acceptedAt) {
        this.acceptedAt = acceptedAt;
    }

    public DataApprovalPermissions withAcceptedAt(Date acceptedAt) {
        this.acceptedAt = acceptedAt;
        return this;
    }

    @JsonProperty("acceptedBy")
    public Optional<String> getAcceptedBy() {
        return Optional.ofNullable(acceptedBy);
    }

    @JsonProperty("acceptedBy")
    public void setAcceptedBy(String acceptedBy) {
        this.acceptedBy = acceptedBy;
    }

    public DataApprovalPermissions withAcceptedBy(String acceptedBy) {
        this.acceptedBy = acceptedBy;
        return this;
    }

    @JsonProperty("approvedAt")
    public Optional<Date> getApprovedAt() {
        return Optional.ofNullable(approvedAt);
    }

    @JsonProperty("approvedAt")
    public void setApprovedAt(Date approvedAt) {
        this.approvedAt = approvedAt;
    }

    public DataApprovalPermissions withApprovedAt(Date approvedAt) {
        this.approvedAt = approvedAt;
        return this;
    }

    @JsonProperty("approvedBy")
    public Optional<String> getApprovedBy() {
        return Optional.ofNullable(approvedBy);
    }

    @JsonProperty("approvedBy")
    public void setApprovedBy(String approvedBy) {
        this.approvedBy = approvedBy;
    }

    public DataApprovalPermissions withApprovedBy(String approvedBy) {
        this.approvedBy = approvedBy;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("mayAccept")
    public Boolean getMayAccept() {
        return mayAccept;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("mayAccept")
    public void setMayAccept(Boolean mayAccept) {
        this.mayAccept = mayAccept;
    }

    public DataApprovalPermissions withMayAccept(Boolean mayAccept) {
        this.mayAccept = mayAccept;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("mayApprove")
    public Boolean getMayApprove() {
        return mayApprove;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("mayApprove")
    public void setMayApprove(Boolean mayApprove) {
        this.mayApprove = mayApprove;
    }

    public DataApprovalPermissions withMayApprove(Boolean mayApprove) {
        this.mayApprove = mayApprove;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("mayReadData")
    public Boolean getMayReadData() {
        return mayReadData;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("mayReadData")
    public void setMayReadData(Boolean mayReadData) {
        this.mayReadData = mayReadData;
    }

    public DataApprovalPermissions withMayReadData(Boolean mayReadData) {
        this.mayReadData = mayReadData;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("mayUnaccept")
    public Boolean getMayUnaccept() {
        return mayUnaccept;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("mayUnaccept")
    public void setMayUnaccept(Boolean mayUnaccept) {
        this.mayUnaccept = mayUnaccept;
    }

    public DataApprovalPermissions withMayUnaccept(Boolean mayUnaccept) {
        this.mayUnaccept = mayUnaccept;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("mayUnapprove")
    public Boolean getMayUnapprove() {
        return mayUnapprove;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("mayUnapprove")
    public void setMayUnapprove(Boolean mayUnapprove) {
        this.mayUnapprove = mayUnapprove;
    }

    public DataApprovalPermissions withMayUnapprove(Boolean mayUnapprove) {
        this.mayUnapprove = mayUnapprove;
        return this;
    }

    @JsonProperty("state")
    public Optional<String> getState() {
        return Optional.ofNullable(state);
    }

    @JsonProperty("state")
    public void setState(String state) {
        this.state = state;
    }

    public DataApprovalPermissions withState(String state) {
        this.state = state;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public DataApprovalPermissions withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "acceptedAt":
                if (value instanceof Date) {
                    setAcceptedAt(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"acceptedAt\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "acceptedBy":
                if (value instanceof String) {
                    setAcceptedBy(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"acceptedBy\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "approvedAt":
                if (value instanceof Date) {
                    setApprovedAt(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"approvedAt\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "approvedBy":
                if (value instanceof String) {
                    setApprovedBy(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"approvedBy\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "mayAccept":
                if (value instanceof Boolean) {
                    setMayAccept(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"mayAccept\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "mayApprove":
                if (value instanceof Boolean) {
                    setMayApprove(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"mayApprove\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "mayReadData":
                if (value instanceof Boolean) {
                    setMayReadData(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"mayReadData\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "mayUnaccept":
                if (value instanceof Boolean) {
                    setMayUnaccept(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"mayUnaccept\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "mayUnapprove":
                if (value instanceof Boolean) {
                    setMayUnapprove(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"mayUnapprove\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "state":
                if (value instanceof String) {
                    setState(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"state\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "acceptedAt":
                return getAcceptedAt();
            case "acceptedBy":
                return getAcceptedBy();
            case "approvedAt":
                return getApprovedAt();
            case "approvedBy":
                return getApprovedBy();
            case "mayAccept":
                return getMayAccept();
            case "mayApprove":
                return getMayApprove();
            case "mayReadData":
                return getMayReadData();
            case "mayUnaccept":
                return getMayUnaccept();
            case "mayUnapprove":
                return getMayUnapprove();
            case "state":
                return getState();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, DataApprovalPermissions.NOT_FOUND_VALUE);
        if (DataApprovalPermissions.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public DataApprovalPermissions with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DataApprovalPermissions.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("acceptedAt");
        sb.append('=');
        sb.append(((this.acceptedAt == null)?"<null>":this.acceptedAt));
        sb.append(',');
        sb.append("acceptedBy");
        sb.append('=');
        sb.append(((this.acceptedBy == null)?"<null>":this.acceptedBy));
        sb.append(',');
        sb.append("approvedAt");
        sb.append('=');
        sb.append(((this.approvedAt == null)?"<null>":this.approvedAt));
        sb.append(',');
        sb.append("approvedBy");
        sb.append('=');
        sb.append(((this.approvedBy == null)?"<null>":this.approvedBy));
        sb.append(',');
        sb.append("mayAccept");
        sb.append('=');
        sb.append(((this.mayAccept == null)?"<null>":this.mayAccept));
        sb.append(',');
        sb.append("mayApprove");
        sb.append('=');
        sb.append(((this.mayApprove == null)?"<null>":this.mayApprove));
        sb.append(',');
        sb.append("mayReadData");
        sb.append('=');
        sb.append(((this.mayReadData == null)?"<null>":this.mayReadData));
        sb.append(',');
        sb.append("mayUnaccept");
        sb.append('=');
        sb.append(((this.mayUnaccept == null)?"<null>":this.mayUnaccept));
        sb.append(',');
        sb.append("mayUnapprove");
        sb.append('=');
        sb.append(((this.mayUnapprove == null)?"<null>":this.mayUnapprove));
        sb.append(',');
        sb.append("state");
        sb.append('=');
        sb.append(((this.state == null)?"<null>":this.state));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.mayUnaccept == null)? 0 :this.mayUnaccept.hashCode()));
        result = ((result* 31)+((this.approvedBy == null)? 0 :this.approvedBy.hashCode()));
        result = ((result* 31)+((this.approvedAt == null)? 0 :this.approvedAt.hashCode()));
        result = ((result* 31)+((this.mayReadData == null)? 0 :this.mayReadData.hashCode()));
        result = ((result* 31)+((this.mayUnapprove == null)? 0 :this.mayUnapprove.hashCode()));
        result = ((result* 31)+((this.acceptedBy == null)? 0 :this.acceptedBy.hashCode()));
        result = ((result* 31)+((this.state == null)? 0 :this.state.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.mayApprove == null)? 0 :this.mayApprove.hashCode()));
        result = ((result* 31)+((this.mayAccept == null)? 0 :this.mayAccept.hashCode()));
        result = ((result* 31)+((this.acceptedAt == null)? 0 :this.acceptedAt.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof DataApprovalPermissions) == false) {
            return false;
        }
        DataApprovalPermissions rhs = ((DataApprovalPermissions) other);
        return ((((((((((((this.mayUnaccept == rhs.mayUnaccept)||((this.mayUnaccept!= null)&&this.mayUnaccept.equals(rhs.mayUnaccept)))&&((this.approvedBy == rhs.approvedBy)||((this.approvedBy!= null)&&this.approvedBy.equals(rhs.approvedBy))))&&((this.approvedAt == rhs.approvedAt)||((this.approvedAt!= null)&&this.approvedAt.equals(rhs.approvedAt))))&&((this.mayReadData == rhs.mayReadData)||((this.mayReadData!= null)&&this.mayReadData.equals(rhs.mayReadData))))&&((this.mayUnapprove == rhs.mayUnapprove)||((this.mayUnapprove!= null)&&this.mayUnapprove.equals(rhs.mayUnapprove))))&&((this.acceptedBy == rhs.acceptedBy)||((this.acceptedBy!= null)&&this.acceptedBy.equals(rhs.acceptedBy))))&&((this.state == rhs.state)||((this.state!= null)&&this.state.equals(rhs.state))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.mayApprove == rhs.mayApprove)||((this.mayApprove!= null)&&this.mayApprove.equals(rhs.mayApprove))))&&((this.mayAccept == rhs.mayAccept)||((this.mayAccept!= null)&&this.mayAccept.equals(rhs.mayAccept))))&&((this.acceptedAt == rhs.acceptedAt)||((this.acceptedAt!= null)&&this.acceptedAt.equals(rhs.acceptedAt))));
    }

}
