
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "attribute",
    "completed",
    "dataSet",
    "orgUnit",
    "period"
})
@Generated("jsonschema2pojo")
public class DataSetCompletionDto implements Serializable
{

    @JsonProperty("attribute")
    private DataValueCategoryDto attribute;
    @JsonProperty("completed")
    private Boolean completed;
    @JsonProperty("dataSet")
    private String dataSet;
    @JsonProperty("orgUnit")
    private String orgUnit;
    @JsonProperty("period")
    private String period;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 5636283076096929771L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DataSetCompletionDto() {
    }

    /**
     * 
     * @param source
     */
    public DataSetCompletionDto(DataSetCompletionDto source) {
        super();
        this.attribute = source.attribute;
        this.completed = source.completed;
        this.dataSet = source.dataSet;
        this.orgUnit = source.orgUnit;
        this.period = source.period;
    }

    /**
     * 
     * @param period
     * @param orgUnit
     * @param attribute
     * @param completed
     * @param dataSet
     */
    public DataSetCompletionDto(DataValueCategoryDto attribute, Boolean completed, String dataSet, String orgUnit, String period) {
        super();
        this.attribute = attribute;
        this.completed = completed;
        this.dataSet = dataSet;
        this.orgUnit = orgUnit;
        this.period = period;
    }

    @JsonProperty("attribute")
    public Optional<DataValueCategoryDto> getAttribute() {
        return Optional.ofNullable(attribute);
    }

    @JsonProperty("attribute")
    public void setAttribute(DataValueCategoryDto attribute) {
        this.attribute = attribute;
    }

    public DataSetCompletionDto withAttribute(DataValueCategoryDto attribute) {
        this.attribute = attribute;
        return this;
    }

    @JsonProperty("completed")
    public Optional<Boolean> getCompleted() {
        return Optional.ofNullable(completed);
    }

    @JsonProperty("completed")
    public void setCompleted(Boolean completed) {
        this.completed = completed;
    }

    public DataSetCompletionDto withCompleted(Boolean completed) {
        this.completed = completed;
        return this;
    }

    @JsonProperty("dataSet")
    public Optional<String> getDataSet() {
        return Optional.ofNullable(dataSet);
    }

    @JsonProperty("dataSet")
    public void setDataSet(String dataSet) {
        this.dataSet = dataSet;
    }

    public DataSetCompletionDto withDataSet(String dataSet) {
        this.dataSet = dataSet;
        return this;
    }

    @JsonProperty("orgUnit")
    public Optional<String> getOrgUnit() {
        return Optional.ofNullable(orgUnit);
    }

    @JsonProperty("orgUnit")
    public void setOrgUnit(String orgUnit) {
        this.orgUnit = orgUnit;
    }

    public DataSetCompletionDto withOrgUnit(String orgUnit) {
        this.orgUnit = orgUnit;
        return this;
    }

    @JsonProperty("period")
    public Optional<String> getPeriod() {
        return Optional.ofNullable(period);
    }

    @JsonProperty("period")
    public void setPeriod(String period) {
        this.period = period;
    }

    public DataSetCompletionDto withPeriod(String period) {
        this.period = period;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public DataSetCompletionDto withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "attribute":
                if (value instanceof DataValueCategoryDto) {
                    setAttribute(((DataValueCategoryDto) value));
                } else {
                    throw new IllegalArgumentException(("property \"attribute\" is of type \"org.hisp.dhis.api.model.v40_0.DataValueCategoryDto\", but got "+ value.getClass().toString()));
                }
                return true;
            case "completed":
                if (value instanceof Boolean) {
                    setCompleted(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"completed\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataSet":
                if (value instanceof String) {
                    setDataSet(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataSet\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "orgUnit":
                if (value instanceof String) {
                    setOrgUnit(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"orgUnit\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "period":
                if (value instanceof String) {
                    setPeriod(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"period\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "attribute":
                return getAttribute();
            case "completed":
                return getCompleted();
            case "dataSet":
                return getDataSet();
            case "orgUnit":
                return getOrgUnit();
            case "period":
                return getPeriod();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, DataSetCompletionDto.NOT_FOUND_VALUE);
        if (DataSetCompletionDto.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public DataSetCompletionDto with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DataSetCompletionDto.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("attribute");
        sb.append('=');
        sb.append(((this.attribute == null)?"<null>":this.attribute));
        sb.append(',');
        sb.append("completed");
        sb.append('=');
        sb.append(((this.completed == null)?"<null>":this.completed));
        sb.append(',');
        sb.append("dataSet");
        sb.append('=');
        sb.append(((this.dataSet == null)?"<null>":this.dataSet));
        sb.append(',');
        sb.append("orgUnit");
        sb.append('=');
        sb.append(((this.orgUnit == null)?"<null>":this.orgUnit));
        sb.append(',');
        sb.append("period");
        sb.append('=');
        sb.append(((this.period == null)?"<null>":this.period));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.period == null)? 0 :this.period.hashCode()));
        result = ((result* 31)+((this.orgUnit == null)? 0 :this.orgUnit.hashCode()));
        result = ((result* 31)+((this.attribute == null)? 0 :this.attribute.hashCode()));
        result = ((result* 31)+((this.completed == null)? 0 :this.completed.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.dataSet == null)? 0 :this.dataSet.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof DataSetCompletionDto) == false) {
            return false;
        }
        DataSetCompletionDto rhs = ((DataSetCompletionDto) other);
        return (((((((this.period == rhs.period)||((this.period!= null)&&this.period.equals(rhs.period)))&&((this.orgUnit == rhs.orgUnit)||((this.orgUnit!= null)&&this.orgUnit.equals(rhs.orgUnit))))&&((this.attribute == rhs.attribute)||((this.attribute!= null)&&this.attribute.equals(rhs.attribute))))&&((this.completed == rhs.completed)||((this.completed!= null)&&this.completed.equals(rhs.completed))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.dataSet == rhs.dataSet)||((this.dataSet!= null)&&this.dataSet.equals(rhs.dataSet))));
    }

}
