
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "attributeOptionCombo",
    "auditType",
    "categoryOptionCombo",
    "created",
    "dataElement",
    "modifiedBy",
    "orgUnit",
    "period",
    "value"
})
@Generated("jsonschema2pojo")
public class DataValueAuditDto implements Serializable
{

    /**
     * A UID for an CategoryOptionCombo object  
     * (Java name `org.hisp.dhis.category.CategoryOptionCombo`)
     * 
     */
    @JsonProperty("attributeOptionCombo")
    @JsonPropertyDescription("A UID for an CategoryOptionCombo object  \n(Java name `org.hisp.dhis.category.CategoryOptionCombo`)")
    private String attributeOptionCombo;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("auditType")
    private DataValueAuditDto.AuditType auditType;
    /**
     * A UID for an CategoryOptionCombo object  
     * (Java name `org.hisp.dhis.category.CategoryOptionCombo`)
     * 
     */
    @JsonProperty("categoryOptionCombo")
    @JsonPropertyDescription("A UID for an CategoryOptionCombo object  \n(Java name `org.hisp.dhis.category.CategoryOptionCombo`)")
    private String categoryOptionCombo;
    @JsonProperty("created")
    private Date created;
    /**
     * A UID for an DataElement object  
     * (Java name `org.hisp.dhis.dataelement.DataElement`)
     * 
     */
    @JsonProperty("dataElement")
    @JsonPropertyDescription("A UID for an DataElement object  \n(Java name `org.hisp.dhis.dataelement.DataElement`)")
    private String dataElement;
    @JsonProperty("modifiedBy")
    private String modifiedBy;
    /**
     * A UID for an OrganisationUnit object  
     * (Java name `org.hisp.dhis.organisationunit.OrganisationUnit`)
     * 
     */
    @JsonProperty("orgUnit")
    @JsonPropertyDescription("A UID for an OrganisationUnit object  \n(Java name `org.hisp.dhis.organisationunit.OrganisationUnit`)")
    private String orgUnit;
    @JsonProperty("period")
    private String period;
    @JsonProperty("value")
    private String value;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 6410934056902790709L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DataValueAuditDto() {
    }

    /**
     * 
     * @param source
     */
    public DataValueAuditDto(DataValueAuditDto source) {
        super();
        this.attributeOptionCombo = source.attributeOptionCombo;
        this.auditType = source.auditType;
        this.categoryOptionCombo = source.categoryOptionCombo;
        this.created = source.created;
        this.dataElement = source.dataElement;
        this.modifiedBy = source.modifiedBy;
        this.orgUnit = source.orgUnit;
        this.period = source.period;
        this.value = source.value;
    }

    /**
     * 
     * @param period
     * @param created
     * @param attributeOptionCombo
     * @param orgUnit
     * @param categoryOptionCombo
     * @param modifiedBy
     * @param auditType
     * @param dataElement
     * @param value
     */
    public DataValueAuditDto(String attributeOptionCombo, DataValueAuditDto.AuditType auditType, String categoryOptionCombo, Date created, String dataElement, String modifiedBy, String orgUnit, String period, String value) {
        super();
        this.attributeOptionCombo = attributeOptionCombo;
        this.auditType = auditType;
        this.categoryOptionCombo = categoryOptionCombo;
        this.created = created;
        this.dataElement = dataElement;
        this.modifiedBy = modifiedBy;
        this.orgUnit = orgUnit;
        this.period = period;
        this.value = value;
    }

    /**
     * A UID for an CategoryOptionCombo object  
     * (Java name `org.hisp.dhis.category.CategoryOptionCombo`)
     * 
     */
    @JsonProperty("attributeOptionCombo")
    public Optional<String> getAttributeOptionCombo() {
        return Optional.ofNullable(attributeOptionCombo);
    }

    /**
     * A UID for an CategoryOptionCombo object  
     * (Java name `org.hisp.dhis.category.CategoryOptionCombo`)
     * 
     */
    @JsonProperty("attributeOptionCombo")
    public void setAttributeOptionCombo(String attributeOptionCombo) {
        this.attributeOptionCombo = attributeOptionCombo;
    }

    public DataValueAuditDto withAttributeOptionCombo(String attributeOptionCombo) {
        this.attributeOptionCombo = attributeOptionCombo;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("auditType")
    public DataValueAuditDto.AuditType getAuditType() {
        return auditType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("auditType")
    public void setAuditType(DataValueAuditDto.AuditType auditType) {
        this.auditType = auditType;
    }

    public DataValueAuditDto withAuditType(DataValueAuditDto.AuditType auditType) {
        this.auditType = auditType;
        return this;
    }

    /**
     * A UID for an CategoryOptionCombo object  
     * (Java name `org.hisp.dhis.category.CategoryOptionCombo`)
     * 
     */
    @JsonProperty("categoryOptionCombo")
    public Optional<String> getCategoryOptionCombo() {
        return Optional.ofNullable(categoryOptionCombo);
    }

    /**
     * A UID for an CategoryOptionCombo object  
     * (Java name `org.hisp.dhis.category.CategoryOptionCombo`)
     * 
     */
    @JsonProperty("categoryOptionCombo")
    public void setCategoryOptionCombo(String categoryOptionCombo) {
        this.categoryOptionCombo = categoryOptionCombo;
    }

    public DataValueAuditDto withCategoryOptionCombo(String categoryOptionCombo) {
        this.categoryOptionCombo = categoryOptionCombo;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public DataValueAuditDto withCreated(Date created) {
        this.created = created;
        return this;
    }

    /**
     * A UID for an DataElement object  
     * (Java name `org.hisp.dhis.dataelement.DataElement`)
     * 
     */
    @JsonProperty("dataElement")
    public Optional<String> getDataElement() {
        return Optional.ofNullable(dataElement);
    }

    /**
     * A UID for an DataElement object  
     * (Java name `org.hisp.dhis.dataelement.DataElement`)
     * 
     */
    @JsonProperty("dataElement")
    public void setDataElement(String dataElement) {
        this.dataElement = dataElement;
    }

    public DataValueAuditDto withDataElement(String dataElement) {
        this.dataElement = dataElement;
        return this;
    }

    @JsonProperty("modifiedBy")
    public Optional<String> getModifiedBy() {
        return Optional.ofNullable(modifiedBy);
    }

    @JsonProperty("modifiedBy")
    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public DataValueAuditDto withModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
        return this;
    }

    /**
     * A UID for an OrganisationUnit object  
     * (Java name `org.hisp.dhis.organisationunit.OrganisationUnit`)
     * 
     */
    @JsonProperty("orgUnit")
    public Optional<String> getOrgUnit() {
        return Optional.ofNullable(orgUnit);
    }

    /**
     * A UID for an OrganisationUnit object  
     * (Java name `org.hisp.dhis.organisationunit.OrganisationUnit`)
     * 
     */
    @JsonProperty("orgUnit")
    public void setOrgUnit(String orgUnit) {
        this.orgUnit = orgUnit;
    }

    public DataValueAuditDto withOrgUnit(String orgUnit) {
        this.orgUnit = orgUnit;
        return this;
    }

    @JsonProperty("period")
    public Optional<String> getPeriod() {
        return Optional.ofNullable(period);
    }

    @JsonProperty("period")
    public void setPeriod(String period) {
        this.period = period;
    }

    public DataValueAuditDto withPeriod(String period) {
        this.period = period;
        return this;
    }

    @JsonProperty("value")
    public Optional<String> getValue() {
        return Optional.ofNullable(value);
    }

    @JsonProperty("value")
    public void setValue(String value) {
        this.value = value;
    }

    public DataValueAuditDto withValue(String value) {
        this.value = value;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public DataValueAuditDto withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "attributeOptionCombo":
                if (value instanceof String) {
                    setAttributeOptionCombo(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeOptionCombo\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "auditType":
                if (value instanceof DataValueAuditDto.AuditType) {
                    setAuditType(((DataValueAuditDto.AuditType) value));
                } else {
                    throw new IllegalArgumentException(("property \"auditType\" is of type \"org.hisp.dhis.api.model.v40_0.DataValueAuditDto.AuditType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "categoryOptionCombo":
                if (value instanceof String) {
                    setCategoryOptionCombo(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"categoryOptionCombo\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "created":
                if (value instanceof Date) {
                    setCreated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataElement":
                if (value instanceof String) {
                    setDataElement(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataElement\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "modifiedBy":
                if (value instanceof String) {
                    setModifiedBy(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"modifiedBy\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "orgUnit":
                if (value instanceof String) {
                    setOrgUnit(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"orgUnit\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "period":
                if (value instanceof String) {
                    setPeriod(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"period\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "value":
                if (value instanceof String) {
                    setValue(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"value\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "attributeOptionCombo":
                return getAttributeOptionCombo();
            case "auditType":
                return getAuditType();
            case "categoryOptionCombo":
                return getCategoryOptionCombo();
            case "created":
                return getCreated();
            case "dataElement":
                return getDataElement();
            case "modifiedBy":
                return getModifiedBy();
            case "orgUnit":
                return getOrgUnit();
            case "period":
                return getPeriod();
            case "value":
                return getValue();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, DataValueAuditDto.NOT_FOUND_VALUE);
        if (DataValueAuditDto.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public DataValueAuditDto with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DataValueAuditDto.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("attributeOptionCombo");
        sb.append('=');
        sb.append(((this.attributeOptionCombo == null)?"<null>":this.attributeOptionCombo));
        sb.append(',');
        sb.append("auditType");
        sb.append('=');
        sb.append(((this.auditType == null)?"<null>":this.auditType));
        sb.append(',');
        sb.append("categoryOptionCombo");
        sb.append('=');
        sb.append(((this.categoryOptionCombo == null)?"<null>":this.categoryOptionCombo));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("dataElement");
        sb.append('=');
        sb.append(((this.dataElement == null)?"<null>":this.dataElement));
        sb.append(',');
        sb.append("modifiedBy");
        sb.append('=');
        sb.append(((this.modifiedBy == null)?"<null>":this.modifiedBy));
        sb.append(',');
        sb.append("orgUnit");
        sb.append('=');
        sb.append(((this.orgUnit == null)?"<null>":this.orgUnit));
        sb.append(',');
        sb.append("period");
        sb.append('=');
        sb.append(((this.period == null)?"<null>":this.period));
        sb.append(',');
        sb.append("value");
        sb.append('=');
        sb.append(((this.value == null)?"<null>":this.value));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.period == null)? 0 :this.period.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.attributeOptionCombo == null)? 0 :this.attributeOptionCombo.hashCode()));
        result = ((result* 31)+((this.orgUnit == null)? 0 :this.orgUnit.hashCode()));
        result = ((result* 31)+((this.categoryOptionCombo == null)? 0 :this.categoryOptionCombo.hashCode()));
        result = ((result* 31)+((this.modifiedBy == null)? 0 :this.modifiedBy.hashCode()));
        result = ((result* 31)+((this.auditType == null)? 0 :this.auditType.hashCode()));
        result = ((result* 31)+((this.dataElement == null)? 0 :this.dataElement.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.value == null)? 0 :this.value.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof DataValueAuditDto) == false) {
            return false;
        }
        DataValueAuditDto rhs = ((DataValueAuditDto) other);
        return (((((((((((this.period == rhs.period)||((this.period!= null)&&this.period.equals(rhs.period)))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.attributeOptionCombo == rhs.attributeOptionCombo)||((this.attributeOptionCombo!= null)&&this.attributeOptionCombo.equals(rhs.attributeOptionCombo))))&&((this.orgUnit == rhs.orgUnit)||((this.orgUnit!= null)&&this.orgUnit.equals(rhs.orgUnit))))&&((this.categoryOptionCombo == rhs.categoryOptionCombo)||((this.categoryOptionCombo!= null)&&this.categoryOptionCombo.equals(rhs.categoryOptionCombo))))&&((this.modifiedBy == rhs.modifiedBy)||((this.modifiedBy!= null)&&this.modifiedBy.equals(rhs.modifiedBy))))&&((this.auditType == rhs.auditType)||((this.auditType!= null)&&this.auditType.equals(rhs.auditType))))&&((this.dataElement == rhs.dataElement)||((this.dataElement!= null)&&this.dataElement.equals(rhs.dataElement))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.value == rhs.value)||((this.value!= null)&&this.value.equals(rhs.value))));
    }

    @Generated("jsonschema2pojo")
    public enum AuditType {

        CREATE("CREATE"),
        UPDATE("UPDATE"),
        DELETE("DELETE"),
        READ("READ"),
        SEARCH("SEARCH");
        private final String value;
        private final static Map<String, DataValueAuditDto.AuditType> CONSTANTS = new HashMap<String, DataValueAuditDto.AuditType>();

        static {
            for (DataValueAuditDto.AuditType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        AuditType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DataValueAuditDto.AuditType fromValue(String value) {
            DataValueAuditDto.AuditType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
