
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "attribute",
    "attributeOptionCombo",
    "categoryOptionCombo",
    "dataElement",
    "followup",
    "orgUnit",
    "period"
})
@Generated("jsonschema2pojo")
public class DataValueFollowUpRequest implements Serializable
{

    @JsonProperty("attribute")
    private DataValueCategoryDto attribute;
    /**
     * A UID for an CategoryOptionCombo object  
     * (Java name `org.hisp.dhis.category.CategoryOptionCombo`)
     * 
     */
    @JsonProperty("attributeOptionCombo")
    @JsonPropertyDescription("A UID for an CategoryOptionCombo object  \n(Java name `org.hisp.dhis.category.CategoryOptionCombo`)")
    private String attributeOptionCombo;
    /**
     * A UID for an CategoryOptionCombo object  
     * (Java name `org.hisp.dhis.category.CategoryOptionCombo`)
     * 
     */
    @JsonProperty("categoryOptionCombo")
    @JsonPropertyDescription("A UID for an CategoryOptionCombo object  \n(Java name `org.hisp.dhis.category.CategoryOptionCombo`)")
    private String categoryOptionCombo;
    /**
     * A UID for an DataSet object  
     * (Java name `org.hisp.dhis.dataset.DataSet`)
     * 
     */
    @JsonProperty("dataElement")
    @JsonPropertyDescription("A UID for an DataSet object  \n(Java name `org.hisp.dhis.dataset.DataSet`)")
    private String dataElement;
    @JsonProperty("followup")
    private Boolean followup;
    /**
     * A UID for an OrganisationUnit object  
     * (Java name `org.hisp.dhis.organisationunit.OrganisationUnit`)
     * 
     */
    @JsonProperty("orgUnit")
    @JsonPropertyDescription("A UID for an OrganisationUnit object  \n(Java name `org.hisp.dhis.organisationunit.OrganisationUnit`)")
    private String orgUnit;
    @JsonProperty("period")
    private String period;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -1009362075758564913L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DataValueFollowUpRequest() {
    }

    /**
     * 
     * @param source
     */
    public DataValueFollowUpRequest(DataValueFollowUpRequest source) {
        super();
        this.attribute = source.attribute;
        this.attributeOptionCombo = source.attributeOptionCombo;
        this.categoryOptionCombo = source.categoryOptionCombo;
        this.dataElement = source.dataElement;
        this.followup = source.followup;
        this.orgUnit = source.orgUnit;
        this.period = source.period;
    }

    /**
     * 
     * @param followup
     * @param period
     * @param attributeOptionCombo
     * @param orgUnit
     * @param categoryOptionCombo
     * @param attribute
     * @param dataElement
     */
    public DataValueFollowUpRequest(DataValueCategoryDto attribute, String attributeOptionCombo, String categoryOptionCombo, String dataElement, Boolean followup, String orgUnit, String period) {
        super();
        this.attribute = attribute;
        this.attributeOptionCombo = attributeOptionCombo;
        this.categoryOptionCombo = categoryOptionCombo;
        this.dataElement = dataElement;
        this.followup = followup;
        this.orgUnit = orgUnit;
        this.period = period;
    }

    @JsonProperty("attribute")
    public Optional<DataValueCategoryDto> getAttribute() {
        return Optional.ofNullable(attribute);
    }

    @JsonProperty("attribute")
    public void setAttribute(DataValueCategoryDto attribute) {
        this.attribute = attribute;
    }

    public DataValueFollowUpRequest withAttribute(DataValueCategoryDto attribute) {
        this.attribute = attribute;
        return this;
    }

    /**
     * A UID for an CategoryOptionCombo object  
     * (Java name `org.hisp.dhis.category.CategoryOptionCombo`)
     * 
     */
    @JsonProperty("attributeOptionCombo")
    public Optional<String> getAttributeOptionCombo() {
        return Optional.ofNullable(attributeOptionCombo);
    }

    /**
     * A UID for an CategoryOptionCombo object  
     * (Java name `org.hisp.dhis.category.CategoryOptionCombo`)
     * 
     */
    @JsonProperty("attributeOptionCombo")
    public void setAttributeOptionCombo(String attributeOptionCombo) {
        this.attributeOptionCombo = attributeOptionCombo;
    }

    public DataValueFollowUpRequest withAttributeOptionCombo(String attributeOptionCombo) {
        this.attributeOptionCombo = attributeOptionCombo;
        return this;
    }

    /**
     * A UID for an CategoryOptionCombo object  
     * (Java name `org.hisp.dhis.category.CategoryOptionCombo`)
     * 
     */
    @JsonProperty("categoryOptionCombo")
    public Optional<String> getCategoryOptionCombo() {
        return Optional.ofNullable(categoryOptionCombo);
    }

    /**
     * A UID for an CategoryOptionCombo object  
     * (Java name `org.hisp.dhis.category.CategoryOptionCombo`)
     * 
     */
    @JsonProperty("categoryOptionCombo")
    public void setCategoryOptionCombo(String categoryOptionCombo) {
        this.categoryOptionCombo = categoryOptionCombo;
    }

    public DataValueFollowUpRequest withCategoryOptionCombo(String categoryOptionCombo) {
        this.categoryOptionCombo = categoryOptionCombo;
        return this;
    }

    /**
     * A UID for an DataSet object  
     * (Java name `org.hisp.dhis.dataset.DataSet`)
     * 
     */
    @JsonProperty("dataElement")
    public Optional<String> getDataElement() {
        return Optional.ofNullable(dataElement);
    }

    /**
     * A UID for an DataSet object  
     * (Java name `org.hisp.dhis.dataset.DataSet`)
     * 
     */
    @JsonProperty("dataElement")
    public void setDataElement(String dataElement) {
        this.dataElement = dataElement;
    }

    public DataValueFollowUpRequest withDataElement(String dataElement) {
        this.dataElement = dataElement;
        return this;
    }

    @JsonProperty("followup")
    public Optional<Boolean> getFollowup() {
        return Optional.ofNullable(followup);
    }

    @JsonProperty("followup")
    public void setFollowup(Boolean followup) {
        this.followup = followup;
    }

    public DataValueFollowUpRequest withFollowup(Boolean followup) {
        this.followup = followup;
        return this;
    }

    /**
     * A UID for an OrganisationUnit object  
     * (Java name `org.hisp.dhis.organisationunit.OrganisationUnit`)
     * 
     */
    @JsonProperty("orgUnit")
    public Optional<String> getOrgUnit() {
        return Optional.ofNullable(orgUnit);
    }

    /**
     * A UID for an OrganisationUnit object  
     * (Java name `org.hisp.dhis.organisationunit.OrganisationUnit`)
     * 
     */
    @JsonProperty("orgUnit")
    public void setOrgUnit(String orgUnit) {
        this.orgUnit = orgUnit;
    }

    public DataValueFollowUpRequest withOrgUnit(String orgUnit) {
        this.orgUnit = orgUnit;
        return this;
    }

    @JsonProperty("period")
    public Optional<String> getPeriod() {
        return Optional.ofNullable(period);
    }

    @JsonProperty("period")
    public void setPeriod(String period) {
        this.period = period;
    }

    public DataValueFollowUpRequest withPeriod(String period) {
        this.period = period;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public DataValueFollowUpRequest withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "attribute":
                if (value instanceof DataValueCategoryDto) {
                    setAttribute(((DataValueCategoryDto) value));
                } else {
                    throw new IllegalArgumentException(("property \"attribute\" is of type \"org.hisp.dhis.api.model.v40_0.DataValueCategoryDto\", but got "+ value.getClass().toString()));
                }
                return true;
            case "attributeOptionCombo":
                if (value instanceof String) {
                    setAttributeOptionCombo(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeOptionCombo\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "categoryOptionCombo":
                if (value instanceof String) {
                    setCategoryOptionCombo(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"categoryOptionCombo\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataElement":
                if (value instanceof String) {
                    setDataElement(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataElement\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "followup":
                if (value instanceof Boolean) {
                    setFollowup(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"followup\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "orgUnit":
                if (value instanceof String) {
                    setOrgUnit(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"orgUnit\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "period":
                if (value instanceof String) {
                    setPeriod(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"period\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "attribute":
                return getAttribute();
            case "attributeOptionCombo":
                return getAttributeOptionCombo();
            case "categoryOptionCombo":
                return getCategoryOptionCombo();
            case "dataElement":
                return getDataElement();
            case "followup":
                return getFollowup();
            case "orgUnit":
                return getOrgUnit();
            case "period":
                return getPeriod();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, DataValueFollowUpRequest.NOT_FOUND_VALUE);
        if (DataValueFollowUpRequest.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public DataValueFollowUpRequest with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DataValueFollowUpRequest.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("attribute");
        sb.append('=');
        sb.append(((this.attribute == null)?"<null>":this.attribute));
        sb.append(',');
        sb.append("attributeOptionCombo");
        sb.append('=');
        sb.append(((this.attributeOptionCombo == null)?"<null>":this.attributeOptionCombo));
        sb.append(',');
        sb.append("categoryOptionCombo");
        sb.append('=');
        sb.append(((this.categoryOptionCombo == null)?"<null>":this.categoryOptionCombo));
        sb.append(',');
        sb.append("dataElement");
        sb.append('=');
        sb.append(((this.dataElement == null)?"<null>":this.dataElement));
        sb.append(',');
        sb.append("followup");
        sb.append('=');
        sb.append(((this.followup == null)?"<null>":this.followup));
        sb.append(',');
        sb.append("orgUnit");
        sb.append('=');
        sb.append(((this.orgUnit == null)?"<null>":this.orgUnit));
        sb.append(',');
        sb.append("period");
        sb.append('=');
        sb.append(((this.period == null)?"<null>":this.period));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.followup == null)? 0 :this.followup.hashCode()));
        result = ((result* 31)+((this.period == null)? 0 :this.period.hashCode()));
        result = ((result* 31)+((this.attributeOptionCombo == null)? 0 :this.attributeOptionCombo.hashCode()));
        result = ((result* 31)+((this.orgUnit == null)? 0 :this.orgUnit.hashCode()));
        result = ((result* 31)+((this.categoryOptionCombo == null)? 0 :this.categoryOptionCombo.hashCode()));
        result = ((result* 31)+((this.attribute == null)? 0 :this.attribute.hashCode()));
        result = ((result* 31)+((this.dataElement == null)? 0 :this.dataElement.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof DataValueFollowUpRequest) == false) {
            return false;
        }
        DataValueFollowUpRequest rhs = ((DataValueFollowUpRequest) other);
        return (((((((((this.followup == rhs.followup)||((this.followup!= null)&&this.followup.equals(rhs.followup)))&&((this.period == rhs.period)||((this.period!= null)&&this.period.equals(rhs.period))))&&((this.attributeOptionCombo == rhs.attributeOptionCombo)||((this.attributeOptionCombo!= null)&&this.attributeOptionCombo.equals(rhs.attributeOptionCombo))))&&((this.orgUnit == rhs.orgUnit)||((this.orgUnit!= null)&&this.orgUnit.equals(rhs.orgUnit))))&&((this.categoryOptionCombo == rhs.categoryOptionCombo)||((this.categoryOptionCombo!= null)&&this.categoryOptionCombo.equals(rhs.categoryOptionCombo))))&&((this.attribute == rhs.attribute)||((this.attribute!= null)&&this.attribute.equals(rhs.attribute))))&&((this.dataElement == rhs.dataElement)||((this.dataElement!= null)&&this.dataElement.equals(rhs.dataElement))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))));
    }

}
